/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.core.contentinfo.service.impl;

import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_AudioSchema;
import com.sobey.bsp.schema.SCMS_SiteSchema;
import com.sobey.bsp.vms.interfaces.media.FileItem;
import com.sobey.cms.core.contentinfo.service.AudioService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class AudioServiceImpl
implements AudioService {
    public void saveAudio(Transaction trans, Map params, boolean autoPublish) throws Exception {
        String addUser = (String)params.get("addUser");
        Date createTime = (Date)params.get("createTime");
        String contentId = (String)params.get("contentId");
        String contentSourceId = (String)params.get("contentSourceId");
        List fileitemList = (List)params.get("fileitem");
        List catalogInfo = (List)params.get("catalogInfo");
        String bitrate = "";
        for (Map map : catalogInfo) {
            String siteId = (String)map.get("siteId");
            SCMS_SiteSchema scms_siteSchema = new SCMS_SiteSchema();
            scms_siteSchema.setId(siteId);
            scms_siteSchema.fill();
            String prop2 = scms_siteSchema.getProp2();
            JSONObject prop2JSONObject = JSONObject.fromObject((Object)prop2);
            JSONArray audioJSONArray = prop2JSONObject.getJSONArray("audio");
            for (int i = 0; i < fileitemList.size(); ++i) {
                FileItem fileitem = (FileItem)fileitemList.get(i);
                String fileTypeID = fileitem.getFileTypeID();
                long length = Long.parseLong(fileitem.getFileLength());
                if (!"mp3".equals(fileTypeID.split("_")[2])) continue;
                bitrate = this.getBitrate(audioJSONArray, fileTypeID);
                SCMS_AudioSchema scms_audioSchema = this.builderScms_audioSchema(addUser, createTime, contentId, contentSourceId, bitrate, siteId, fileitem, fileTypeID, length);
                trans.add((Schema)scms_audioSchema, 1);
            }
        }
    }

    private SCMS_AudioSchema builderScms_audioSchema(String addUser, Date createTime, String contentId, String contentSourceId, String bitrate, String siteId, FileItem fileitem, String fileTypeID, long length) {
        SCMS_AudioSchema scms_audioSchema = new SCMS_AudioSchema();
        scms_audioSchema.setContentSourceId(contentSourceId);
        scms_audioSchema.setSiteId(Long.valueOf(Long.parseLong(siteId)));
        scms_audioSchema.setAddUser(addUser == null ? "" : addUser);
        scms_audioSchema.setAddTime(createTime);
        scms_audioSchema.setFileUrl("/vod/".substring(0, "/vod/".length() - 1) + fileitem.getFileURL());
        scms_audioSchema.setAudioInfoId(Long.valueOf(Long.parseLong(contentId)));
        scms_audioSchema.setSuffix("mp3");
        scms_audioSchema.setClip("001");
        scms_audioSchema.setID(Long.valueOf(NoUtil.getMaxID((String)"AudioID")));
        scms_audioSchema.setDuration(Long.valueOf(length));
        scms_audioSchema.setBitrate(bitrate);
        scms_audioSchema.setFileTypeId(fileTypeID);
        return scms_audioSchema;
    }

    private String getBitrate(JSONArray audioJSONArray, String fileTypeID) {
        if (StringUtil.isEmpty((String)fileTypeID)) {
            return null;
        }
        if (!"mp3".equals(fileTypeID.split("_")[2])) {
            return null;
        }
        String bitrate = null;
        for (int j = 0; j < audioJSONArray.size(); ++j) {
            String setFormat = audioJSONArray.getJSONObject(j).getString("format");
            if (!fileTypeID.equalsIgnoreCase(setFormat)) continue;
            bitrate = audioJSONArray.getJSONObject(j).getString("alias");
            break;
        }
        return bitrate;
    }
}

