/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.core.contentinfo.service.impl;

import com.chinamcloud.common.storage.util.PathUtil;
import com.chinamcloud.vms.util.PathCommonUtil;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.cms.site.SiteDefaultUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.schema.SCMS_CatalogSchema;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.bsp.schema.SCMS_SiteSchema;
import com.sobey.bsp.vms.interfaces.media.FileItem;
import com.sobey.bsp.vms.interfaces.media.KeyFrameItem;
import com.sobey.bsp.vms.interfaces.media.SrcFileItem;
import com.sobey.cms.core.contentinfo.service.ContentinfoService;
import com.sobey.scms.contentinfo.interfaces.util.ContentUtil;
import com.sobey.scms.search.ContentSearchMediator;
import com.sobey.scms.trasncode.MPCCall;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.axis.utils.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentinfoServiceImpl
implements ContentinfoService {
    private static final Logger log = LoggerFactory.getLogger(ContentinfoServiceImpl.class);

    public Map saveContentinfo(Transaction trans, Map paramsMap, boolean autoPublish, boolean isUpdate) throws Exception {
        FileItem[] mp4FileItem;
        List formatNames;
        List fileUrlList;
        String[] formats;
        List catalogInfoList = (List)paramsMap.get("catalogInfo");
        Map catalogInfoMap = (Map)catalogInfoList.get(0);
        String siteId = (String)catalogInfoMap.get("siteId");
        SCMS_SiteSchema scms_siteSchema = new SCMS_SiteSchema();
        scms_siteSchema.setId(Long.valueOf(Long.parseLong(siteId)));
        if (!scms_siteSchema.fill()) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("status", "0");
            return returnMap;
        }
        String title = (String)paramsMap.get("title");
        String fileType = (String)paramsMap.get("fileType");
        String contentSourceId = (String)paramsMap.get("contentSourceId");
        List fileitemList = (List)paramsMap.get("fileitem");
        String mediaPathType = (String)paramsMap.get("mediaPathType");
        int storageType = Integer.parseInt(paramsMap.get("storageType").toString());
        String mp4Json = "";
        String tsJson = "";
        String flvJson = "";
        String styleTypes = "";
        long videoLength = 0L;
        List mp4FileitemList = this.getFileItemByFileType(fileitemList, "mp4");
        List tsFileitemList = this.getFileItemByFileType(fileitemList, "ts");
        List flvFileitemList = this.getFileItemByFileType(fileitemList, "flv");
        JSONObject bitratesJSONObject = new JSONObject();
        String prefix = "/vod/";
        JSONObject prop2JsonObject = JSONObject.fromObject((Object)scms_siteSchema.getProp2());
        if (String.valueOf(1).equals(fileType)) {
            if (CollectionUtils.isNotEmpty((Collection)flvFileitemList)) {
                styleTypes = styleTypes + "1,";
                videoLength = this.getVideoLength((FileItem)flvFileitemList.get(0));
                formats = this.builderFormatArray(flvFileitemList);
                FileItem[] flvFileItem = this.builderFileItemsArray(flvFileitemList);
                this.getOrderFormatsAndFileItem(formats, flvFileItem);
                fileUrlList = this.getFileUrlList(formats, flvFileItem, true);
                JSONArray pcVideoJSONArray = prop2JsonObject.getJSONArray("flvVideo");
                formatNames = this.builderFormatNameList(formats, pcVideoJSONArray, "name");
                List flvBitrate = this.builderFormatNameList(formats, pcVideoJSONArray, "alias");
                bitratesJSONObject.put((Object)"flvBitrates", (Object)flvBitrate);
                flvJson = this.builderPlayUrlByPC(title, videoLength, prefix, fileUrlList, formatNames);
            }
            if (CollectionUtils.isNotEmpty((Collection)tsFileitemList)) {
                styleTypes = styleTypes + "2,";
                videoLength = this.getVideoLength((FileItem)tsFileitemList.get(0));
                formats = this.builderFormatArray(tsFileitemList);
                FileItem[] tsFileItem = this.builderFileItemsArray(tsFileitemList);
                this.getOrderFormatsAndFileItem(formats, tsFileItem);
                fileUrlList = this.getFileUrlList(formats, tsFileItem, false);
                JSONArray iosVideoJsonArray = prop2JsonObject.getJSONArray("tsVideo");
                formatNames = this.builderFormatNameList(formats, iosVideoJsonArray, "name");
                List tsBitrate = this.builderFormatNameList(formats, iosVideoJsonArray, "alias");
                bitratesJSONObject.put((Object)"mp4Bitrates", (Object)tsBitrate);
                bitratesJSONObject.put((Object)"tsBitrates", (Object)tsBitrate);
                tsJson = this.builderPlayUrlByIOS(title, videoLength, prefix, fileUrlList, formatNames);
            }
            if (CollectionUtils.isNotEmpty((Collection)mp4FileitemList)) {
                styleTypes = styleTypes + "3,";
                videoLength = this.getVideoLength((FileItem)mp4FileitemList.get(0));
                formats = this.builderFormatArray(mp4FileitemList);
                mp4FileItem = this.builderFileItemsArray(mp4FileitemList);
                this.getOrderFormatsAndFileItem(formats, mp4FileItem);
                JSONArray androidVideoJsonArray = prop2JsonObject.getJSONArray("mp4Video");
                List formatNames2 = this.builderFormatNameList(formats, androidVideoJsonArray, "name");
                List mp4Bitrate = this.builderFormatNameList(formats, androidVideoJsonArray, "alias");
                bitratesJSONObject.put((Object)"mp4Bitrates", (Object)mp4Bitrate);
                List fileUrlList2 = this.getFileUrlList(formats, mp4FileItem, false);
                mp4Json = this.builderPlayByAndroid(title, videoLength, prefix, fileUrlList2, formatNames2);
            }
        } else if (String.valueOf(2).equals(fileType) && CollectionUtils.isNotEmpty((Collection)mp4FileitemList)) {
            styleTypes = styleTypes + "1,2,3,";
            videoLength = this.getVideoLength((FileItem)mp4FileitemList.get(0));
            formats = this.builderFormatArray(mp4FileitemList);
            mp4FileItem = this.builderFileItemsArray(mp4FileitemList);
            this.getOrderFormatsAndFileItem(formats, mp4FileItem);
            fileUrlList = this.getFileUrlList(formats, mp4FileItem, true);
            JSONArray allVideoJSONArray = prop2JsonObject.getJSONArray("mp4Video");
            formatNames = this.builderFormatNameList(formats, allVideoJSONArray, "name");
            List mp4Bitrate = this.builderFormatNameList(formats, allVideoJSONArray, "alias");
            bitratesJSONObject.put((Object)"flvBitrates", (Object)mp4Bitrate);
            bitratesJSONObject.put((Object)"tsBitrates", (Object)mp4Bitrate);
            bitratesJSONObject.put((Object)"mp4Bitrates", (Object)mp4Bitrate);
            flvJson = mp4Json = this.builderPlayUrlByPC(title, videoLength, prefix, fileUrlList, formatNames);
            tsJson = mp4Json;
        }
        String isSourceVideo = this.getSourceVideo(paramsMap);
        String catalogName = this.getCatalogName((String)paramsMap.get("catalogPath"));
        styleTypes = this.getStyleType(styleTypes);
        List srcFileitemList = (List)paramsMap.get("srcFileItem");
        String sourceContentPath = this.getSourceContentPath(srcFileitemList);
        String imageDatePath = (String)paramsMap.get("imageDatePath");
        List keyFrameItemList = (List)paramsMap.get("keyFrameItem");
        String keyFrame = this.getKeyFrame(imageDatePath, contentSourceId, keyFrameItemList, storageType);
        HashMap returnMap = new HashMap();
        for (Map stringObjectMap : catalogInfoList) {
            String siteid = (String)stringObjectMap.get("siteId");
            SCMS_ContentinfoSchema scms_contentinfoSchema = this.builderScms_contentinfoSchema(autoPublish, siteId, paramsMap, isSourceVideo, mp4Json, tsJson, flvJson, styleTypes, videoLength, bitratesJSONObject, prefix, catalogName, stringObjectMap, siteid, sourceContentPath, keyFrame);
            if (isUpdate) {
                this.updateVideoUrl(scms_contentinfoSchema);
                trans.add((Schema)scms_contentinfoSchema, 2);
            } else {
                trans.add((Schema)scms_contentinfoSchema, 1);
            }
            this.builderReturnMap(autoPublish, mp4Json, tsJson, flvJson, returnMap, siteid);
        }
        return returnMap;
    }

    private List<FileItem> getFileItemByFileType(List<FileItem> fileitemList, String fileType) {
        ArrayList<FileItem> resultFileitemList = new ArrayList<FileItem>();
        for (int i = 0; i < fileitemList.size(); ++i) {
            String fileTypeId = fileitemList.get(i).getFileTypeID();
            if (!StringUtil.isNotEmpty((String)fileTypeId) || !fileType.equalsIgnoreCase(fileTypeId.split("_")[2])) continue;
            resultFileitemList.add(fileitemList.get(i));
        }
        return resultFileitemList;
    }

    private List<String> builderFormatNameList(String[] formats, JSONArray videoJSONArray, String key) {
        ArrayList<String> stringList = new ArrayList<String>();
        if (videoJSONArray == null) {
            return stringList;
        }
        for (int k = 0; k < formats.length; ++k) {
            String format = formats[k];
            for (int i = 0; i < videoJSONArray.size(); ++i) {
                JSONObject bitItem = videoJSONArray.getJSONObject(i);
                if (!format.equalsIgnoreCase(bitItem.getString("format"))) continue;
                stringList.add(bitItem.getString(key));
            }
        }
        return stringList;
    }

    private String builderPlayByAndroid(String title, long videoLength, String prefix, List<String> fileUrlList, List<String> formatNames) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"urls", (Object)this.getFileUrlJsonArray(fileUrlList));
        jsonObject.put((Object)"title", (Object)title);
        jsonObject.put((Object)"sourceType", (Object)"mp4");
        jsonObject.put((Object)"duration", (Object)(videoLength / 1000L));
        jsonObject.put((Object)"host", (Object)prefix);
        jsonObject.put((Object)"formats", formatNames);
        return jsonObject.toString();
    }

    private String builderPlayUrlByIOS(String title, long videoLength, String prefix, List<String> fileUrlList, List<String> formatNames) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"title", (Object)title);
        jsonObject.put((Object)"duration", (Object)(videoLength / 1000L));
        jsonObject.put((Object)"host", (Object)prefix);
        jsonObject.put((Object)"urls", (Object)this.getFileUrlJsonArray(fileUrlList));
        jsonObject.put((Object)"formats", formatNames);
        return jsonObject.toString();
    }

    private String builderPlayUrlByPC(String title, long videoLength, String prefix, List<String> fileUrlList, List<String> formatNames) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"urls", (Object)this.getFileUrlJsonArray(fileUrlList));
        jsonObject.put((Object)"title", (Object)title);
        jsonObject.put((Object)"sourceType", (Object)"mp4");
        jsonObject.put((Object)"duration", (Object)(videoLength / 1000L));
        jsonObject.put((Object)"host", (Object)prefix);
        jsonObject.put((Object)"formats", formatNames);
        return jsonObject.toString();
    }

    private long getVideoLength(FileItem fileItem) {
        long videoLength = 0L;
        if (!StringUtils.isEmpty((String)fileItem.getFileLength())) {
            videoLength = Long.parseLong(fileItem.getFileLength());
        }
        return videoLength;
    }

    private String[] builderFormatArray(List<FileItem> fileItemList) {
        String[] formats = new String[fileItemList.size()];
        for (int i = 0; i < fileItemList.size(); ++i) {
            formats[i] = fileItemList.get(i).getFileTypeID();
        }
        return formats;
    }

    private FileItem[] builderFileItemsArray(List<FileItem> fileItemList) {
        FileItem[] fileItems = new FileItem[fileItemList.size()];
        for (int i = 0; i < fileItemList.size(); ++i) {
            fileItems[i] = fileItemList.get(i);
        }
        return fileItems;
    }

    private String getStyleType(String styleTypes) {
        if (StringUtil.isNotEmpty((String)styleTypes)) {
            styleTypes = styleTypes.substring(0, styleTypes.length() - 1);
        }
        return styleTypes;
    }

    private void builderReturnMap(boolean autoPublish, String mp4Json, String tsJson, String flvJson, Map returnMap, String siteid) {
        returnMap.put("statusFlag", this.getStatusFlag(autoPublish, siteid));
        returnMap.put("flvJson", flvJson);
        returnMap.put("tsJson", tsJson);
        returnMap.put("mp4Json", mp4Json);
        returnMap.put("status", "1");
    }

    private String getSourceVideo(Map paramsMap) {
        String isSourceVideo = (String)paramsMap.get("isSourceVideo");
        if (StringUtil.isEmpty((String)isSourceVideo)) {
            isSourceVideo = "0";
        }
        return isSourceVideo;
    }

    private SCMS_ContentinfoSchema builderScms_contentinfoSchema(boolean autoPublish, String siteId, Map paramsMap, String isSourceVideo, String mp4Json, String tsJson, String flvJson, String styleTypes, long videoLength, JSONObject bitrates, String prefix, String catalogName, Map<String, Object> stringObjectMap, String siteid, String sourceContentPath, String keyFrame) {
        String contentSourceId = (String)paramsMap.get("contentSourceId");
        int mediaFromType = (Integer)paramsMap.get("mediaFromType");
        Date createTime = (Date)paramsMap.get("createTime");
        SCMS_ContentinfoSchema scms_contentinfoSchema = new SCMS_ContentinfoSchema();
        scms_contentinfoSchema.setTsPlayUrl(tsJson);
        scms_contentinfoSchema.setMp4PlayUrl(mp4Json);
        scms_contentinfoSchema.setStyleTypes(styleTypes);
        scms_contentinfoSchema.setContentPath(prefix);
        scms_contentinfoSchema.setSoftLinkDir((String)paramsMap.get("softLinkDir"));
        scms_contentinfoSchema.setBitrates(bitrates.toString());
        scms_contentinfoSchema.setContentID(Long.valueOf(Long.parseLong((String)paramsMap.get("contentId"))));
        scms_contentinfoSchema.setContentSourceId(contentSourceId);
        scms_contentinfoSchema.setTitle((String)paramsMap.get("title"));
        scms_contentinfoSchema.setIsSourceVideo(Integer.valueOf(Integer.parseInt(isSourceVideo)));
        scms_contentinfoSchema.setSubTitle((String)paramsMap.get("subTitle"));
        scms_contentinfoSchema.setCreateTime(createTime);
        scms_contentinfoSchema.setModifyTime(createTime);
        scms_contentinfoSchema.setPlayTime((Date)paramsMap.get("firstPlayTime"));
        scms_contentinfoSchema.setMediaPathType(Integer.valueOf(Integer.parseInt((String)paramsMap.get("mediaPathType"))));
        scms_contentinfoSchema.setSourceSystemID(Integer.valueOf(mediaFromType));
        scms_contentinfoSchema.setCustom((String)paramsMap.get("customParam"));
        scms_contentinfoSchema.setCreatorName(this.getCreatorName((String)paramsMap.get("addUser"), mediaFromType));
        scms_contentinfoSchema.setSourceSystemName(flvJson);
        scms_contentinfoSchema.setSiteid(Long.valueOf(Long.parseLong(siteid)));
        scms_contentinfoSchema.setStatus(this.getStatus(autoPublish, siteid));
        scms_contentinfoSchema.setPublishDate(autoPublish ? createTime : null);
        scms_contentinfoSchema.setDescription((String)paramsMap.get("description"));
        scms_contentinfoSchema.setTag((String)paramsMap.get("keywords"));
        scms_contentinfoSchema.setProgramLength(String.valueOf(videoLength));
        scms_contentinfoSchema.setSiteid(Long.valueOf(siteId));
        if (StringUtil.isNotEmpty((String)keyFrame)) {
            scms_contentinfoSchema.setKeyFrame(keyFrame);
        }
        scms_contentinfoSchema.setCatalogid((String)stringObjectMap.get("catalogId"));
        scms_contentinfoSchema.setPath(sourceContentPath);
        scms_contentinfoSchema.setCatalogInnerCode((String)stringObjectMap.get("catalogInnerCode"));
        scms_contentinfoSchema.setClassifyType(ContentUtil.getClassifyTypeByCatalogName((String)catalogName));
        return scms_contentinfoSchema;
    }

    private String getStatusFlag(boolean autoPublish, String siteid) {
        if (autoPublish) {
            return "1";
        }
        String workflowid = SiteUtil.getWorkFlowID((String)siteid);
        if (StringUtil.isEmpty((String)workflowid) || "0".equals(workflowid) || "-1".equals(workflowid)) {
            return "0";
        }
        return "-1";
    }

    private Long getStatus(boolean autoPublish, String siteid) {
        if (autoPublish) {
            return 1L;
        }
        String workflowid = SiteUtil.getWorkFlowID((String)siteid);
        if (StringUtil.isEmpty((String)workflowid) || "0".equals(workflowid) || "-1".equals(workflowid)) {
            return 0L;
        }
        return -1L;
    }

    private JSONArray getFileUrlJsonArray(List<String> fileUrlList) {
        JSONArray fileUrlJsonArray = new JSONArray();
        for (String url : fileUrlList) {
            if (StringUtil.isNotEmpty((String)url)) {
                if (url.indexOf("/vod/") >= 0) {
                    url = url.substring(url.indexOf("/vod/") + "/vod/".length());
                } else if (url.indexOf("/") == 0) {
                    url = url.substring(1);
                }
            }
            fileUrlJsonArray.add((Object)url);
        }
        return fileUrlJsonArray;
    }

    private List<String> getFileUrlList(String[] formats, FileItem[] fileItems, boolean replace) {
        ArrayList<String> fileUrlList = new ArrayList<String>();
        for (int i = 0; i < formats.length; ++i) {
            String fileUrl = fileItems[i].getFileURL();
            if (StringUtil.isNotEmpty((String)fileUrl)) {
                fileUrl = StringUtil.replaceAllToSlant((String)(replace ? fileUrl.replace("\\", "/") : fileUrl));
            }
            fileUrlList.add(fileUrl);
        }
        return fileUrlList;
    }

    private String getKeyFrame(String dateDir, String contentSourceId, List<KeyFrameItem> keyFrameItemList, int storageType) {
        String keyFrame = "";
        if (CollectionUtils.isNotEmpty(keyFrameItemList)) {
            KeyFrameItem keyFrameItem = keyFrameItemList.get(0);
            String imagePath = keyFrameItem.getKeyFramePath().split(";")[0];
            boolean isCopy = PathCommonUtil.judgmentIsCopy((String)imagePath, (int)storageType);
            keyFrame = PathCommonUtil.builderImageDatabaseStoragePath((String)contentSourceId, (String)dateDir, (int)0, (String)imagePath, (boolean)isCopy, (int)storageType);
        }
        return keyFrame;
    }

    private void getOrderFormatsAndFileItem(String[] formats, FileItem[] oldFileItem) {
        for (int i = 0; i < formats.length; ++i) {
            for (int j = 0; j < formats.length; ++j) {
                String[] formatOf_j;
                int formatOf_j_num;
                String[] formatOf_i = formats[i].split("_");
                int formatOf_i_num = Integer.parseInt(formatOf_i[1].substring(0, formatOf_i[1].length() - 1));
                if (formatOf_i_num <= (formatOf_j_num = Integer.parseInt((formatOf_j = formats[j].split("_"))[1].substring(0, formatOf_j[1].length() - 1)))) continue;
                String temp = formats[j];
                formats[j] = formats[i];
                formats[i] = temp;
                FileItem fileItem = oldFileItem[j];
                oldFileItem[j] = oldFileItem[i];
                oldFileItem[i] = fileItem;
            }
        }
    }

    public Map saveContentinfoByTransgroupId(Transaction transaction, Map params) throws Exception {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String title = (String)params.get("title");
        String transgroupId = (String)params.get("transgroupId");
        String catalogName = this.getCatalogName((String)params.get("catalogPath"));
        List catalogInfoMap = (List)params.get("catalogInfo");
        for (Map stringObjectMap : catalogInfoMap) {
            String siteId = (String)stringObjectMap.get("siteId");
            if ("0".equals(transgroupId)) {
                SCMS_CatalogSchema scms_catalogSchema = new SCMS_CatalogSchema();
                scms_catalogSchema.setID(Long.valueOf((String)stringObjectMap.get("catalogId")).longValue());
                if (scms_catalogSchema.fill()) {
                    if (StringUtil.isNotEmpty((String)String.valueOf(scms_catalogSchema.getTransCodeId()))) {
                        transgroupId = String.valueOf(scms_catalogSchema.getTransCodeId());
                    } else {
                        SiteDefaultUtil.getDefalutTransCodeId((Long)Long.parseLong(siteId), (int)5);
                    }
                }
            }
            title = ContentUtil.getTitle((String)title, (int)5, (int)0);
            SCMS_ContentinfoSchema scms_contentinfoSchema = this.builderScms_contentinfoSchema(params, title, transgroupId, catalogName, stringObjectMap, siteId);
            transaction.add((Schema)scms_contentinfoSchema, 1);
            if (transaction.commit()) {
                returnMap.put("status", "1");
                String realmname = SiteUtil.getAlias((String)siteId);
                String sourceHost = PathUtil.builderPathEndSlash((String[])new String[]{Config.getValue((String)"winVideoUploadDir"), realmname});
                String videoPath = StringUtil.replaceAllToBack_Slant((String)(sourceHost + scms_contentinfoSchema.getPath()));
                ContentSearchMediator.publishVideo2Search((String)String.valueOf(scms_contentinfoSchema.getContentID()), (String)realmname, (long)Long.parseLong(siteId));
                MPCCall.generateXml((String)videoPath, (String)String.valueOf(scms_contentinfoSchema.getTranscodeid()), (String)scms_contentinfoSchema.getContentSourceId(), (String)scms_contentinfoSchema.getTitle(), (long)Long.parseLong(siteId), (String)"", (String)"", (String)"2");
                continue;
            }
            returnMap.put("status", "0");
        }
        return returnMap;
    }

    private String getCatalogName(String catalogPath) {
        return catalogPath.split("@")[1];
    }

    private SCMS_ContentinfoSchema builderScms_contentinfoSchema(Map params, String title, String transgroupId, String catalogName, Map<String, Object> stringObjectMap, String siteid) {
        String contentSourceId = (String)params.get("contentSourceId");
        List srcFileitemList = (List)params.get("srcFileItem");
        String mediaPathType = (String)params.get("mediaPathType");
        int mediaFromType = (Integer)params.get("mediaFromType");
        SCMS_ContentinfoSchema scms_contentinfoSchema = new SCMS_ContentinfoSchema();
        scms_contentinfoSchema.setContentID(Long.valueOf(Long.parseLong((String)params.get("contentId"))));
        scms_contentinfoSchema.setContentSourceId(contentSourceId);
        scms_contentinfoSchema.setTitle(title);
        scms_contentinfoSchema.setSubTitle((String)params.get("subTitle"));
        scms_contentinfoSchema.setCreateTime(new Date());
        scms_contentinfoSchema.setDescription((String)params.get("description"));
        scms_contentinfoSchema.setModifyTime(new Date());
        scms_contentinfoSchema.setClassifyType(ContentUtil.getClassifyTypeByCatalogName((String)catalogName));
        scms_contentinfoSchema.setCreatorName(this.getCreatorName((String)params.get("addUser"), mediaFromType));
        scms_contentinfoSchema.setPath(this.getSourceContentPath(srcFileitemList));
        scms_contentinfoSchema.setSourceSystemID(Integer.valueOf(mediaFromType));
        scms_contentinfoSchema.setSourceSystemName("");
        scms_contentinfoSchema.setTranscodeid(Integer.valueOf(Integer.parseInt(transgroupId)));
        scms_contentinfoSchema.setIsSourceVideo(Integer.valueOf(0));
        scms_contentinfoSchema.setStatus(Long.valueOf(2L));
        scms_contentinfoSchema.setPlayTime((Date)params.get("firstPlayTime"));
        scms_contentinfoSchema.setTag((String)params.get("keywords"));
        scms_contentinfoSchema.setSiteid(Long.valueOf(Long.parseLong(siteid)));
        scms_contentinfoSchema.setKeyFrame("");
        scms_contentinfoSchema.setMediaPathType(Integer.valueOf(1));
        scms_contentinfoSchema.setCatalogid((String)stringObjectMap.get("catalogId"));
        scms_contentinfoSchema.setCatalogInnerCode((String)stringObjectMap.get("catalogInnerCode"));
        scms_contentinfoSchema.setCustom((String)params.get("customParam"));
        return scms_contentinfoSchema;
    }

    private String getSourceContentPath(List<SrcFileItem> srcFileItemList) {
        String sourceContentPath = "";
        if (CollectionUtils.isNotEmpty(srcFileItemList) && StringUtil.isNotEmpty((String)srcFileItemList.get(0).getFileName())) {
            String srcFileUrl = srcFileItemList.get(0).getFileName();
            LogUtil.info((Object)("\u8fd4\u56de\u6e90\u6587\u4ef6\u5730\u57401:" + srcFileUrl));
            srcFileUrl = StringUtil.replaceAllToSlant((String)srcFileUrl);
            LogUtil.info((Object)("\u8fd4\u56de\u6e90\u6587\u4ef6\u5730\u57402:" + srcFileUrl));
            int index = srcFileUrl.indexOf("/source/storage");
            LogUtil.info((Object)("\u8fd4\u56de\u6e90\u6587\u4ef6\u7d22\u5f15:" + index));
            sourceContentPath = index > -1 ? srcFileUrl.substring(srcFileUrl.indexOf("/source/storage")) : StringUtil.replaceAllToSlant((String)("/source/storage/" + srcFileUrl));
        }
        return sourceContentPath;
    }

    private String getCreatorName(String addUser, int mediaFromType) {
        if (StringUtil.isNotEmpty((String)addUser)) {
            return addUser;
        }
        return ContentUtil.getSourceNameByMediaFrom((int)mediaFromType);
    }

    private void updateVideoUrl(SCMS_ContentinfoSchema contentinfoSchema) {
        SCMS_ContentinfoSchema oldContent = new SCMS_ContentinfoSchema();
        oldContent.setContentID(contentinfoSchema.getContentID());
        oldContent.fill();
        String sourceSystemNameOld = oldContent.getSourceSystemName();
        String sourceSystemNameNew = contentinfoSchema.getSourceSystemName();
        try {
            JSONObject sourceSystemNameJO = JSONObject.fromObject((Object)sourceSystemNameOld);
            JSONObject sourceSystemNameJONew = JSONObject.fromObject((Object)sourceSystemNameNew);
            JSONArray urlsJA = sourceSystemNameJO.getJSONArray("urls");
            JSONArray urlsJANew = sourceSystemNameJONew.getJSONArray("urls");
            urlsJA.addAll((Collection)urlsJANew);
            sourceSystemNameJONew.put((Object)"urls", (Object)urlsJA);
            JSONArray formatsJA = sourceSystemNameJO.getJSONArray("formats");
            JSONArray formatsJANew = sourceSystemNameJONew.getJSONArray("formats");
            formatsJA.addAll((Collection)formatsJANew);
            sourceSystemNameJONew.put((Object)"formats", (Object)formatsJA);
            contentinfoSchema.setSourceSystemName(sourceSystemNameJONew.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u66f4\u65b0sourceSystemName\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
        }
        String tsPlayUrlOld = oldContent.getTsPlayUrl();
        String tsPlayUrlNoew = contentinfoSchema.getTsPlayUrl();
        try {
            JSONObject tsPlayUrlJO = JSONObject.fromObject((Object)tsPlayUrlOld);
            JSONObject tsPlayUrlJONew = JSONObject.fromObject((Object)tsPlayUrlNoew);
            JSONArray urlsJA = tsPlayUrlJO.getJSONArray("urls");
            JSONArray urlsJANew = tsPlayUrlJONew.getJSONArray("urls");
            urlsJA.addAll((Collection)urlsJANew);
            tsPlayUrlJONew.put((Object)"urls", (Object)urlsJA);
            JSONArray formatsJA = tsPlayUrlJO.getJSONArray("formats");
            JSONArray formatsJANew = tsPlayUrlJONew.getJSONArray("formats");
            formatsJA.addAll((Collection)formatsJANew);
            tsPlayUrlJONew.put((Object)"formats", (Object)formatsJA);
            contentinfoSchema.setTsPlayUrl(tsPlayUrlJONew.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u66f4\u65b0tsPlayUrl\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
        }
        String mp4PlayUrlOld = oldContent.getMp4PlayUrl();
        String mp4PlayUrlNoew = contentinfoSchema.getMp4PlayUrl();
        try {
            JSONObject mp4PlayUrlJO = JSONObject.fromObject((Object)mp4PlayUrlOld);
            JSONObject mp4PlayUrlJONew = JSONObject.fromObject((Object)mp4PlayUrlNoew);
            JSONArray urlsJA = mp4PlayUrlJO.getJSONArray("urls");
            JSONArray urlsJANew = mp4PlayUrlJONew.getJSONArray("urls");
            urlsJA.addAll((Collection)urlsJANew);
            mp4PlayUrlJONew.put((Object)"urls", (Object)urlsJA);
            JSONArray formatsJA = mp4PlayUrlJO.getJSONArray("formats");
            JSONArray formatsJANew = mp4PlayUrlJONew.getJSONArray("formats");
            formatsJA.addAll((Collection)formatsJANew);
            mp4PlayUrlJONew.put((Object)"formats", (Object)formatsJA);
            contentinfoSchema.setMp4PlayUrl(mp4PlayUrlJONew.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u66f4\u65b0mp4PlayUrl\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
        }
        if (StringUtil.isEmpty((String)contentinfoSchema.getKeyFrame())) {
            contentinfoSchema.setKeyFrame(oldContent.getKeyFrame());
        }
    }
}

