/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.core.contentinfo.service.impl;

import com.chinamcloud.common.storage.util.FileStorageUtil;
import com.chinamcloud.common.storage.util.PathUtil;
import com.chinamcloud.vms.util.PathCommonUtil;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_ImageInfoSchema;
import com.sobey.bsp.vms.interfaces.media.KeyFrameItem;
import com.sobey.cms.core.contentinfo.service.ImageService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageServiceImpl
implements ImageService {
    private static final Logger log = LoggerFactory.getLogger(ImageServiceImpl.class);

    public Transaction saveImage(Transaction transaction, Map params) throws Exception {
        String contentSourceId = (String)params.get("contentSourceId");
        List keyFrameItemList = (List)params.get("keyFrameItem");
        String dateDir = (String)params.get("imageDatePath");
        String imagePathType = (String)params.get("imagePathType");
        List catalogInfo = (List)params.get("catalogInfo");
        String linuxImageDir = Config.getValue((String)"linuxImageDir");
        String contentId = (String)params.get("contentId");
        int storageType = Integer.parseInt(params.get("storageType").toString());
        for (Map map : catalogInfo) {
            String alias = SiteUtil.getAlias((String)((String)map.get("siteId")));
            int imageNumber = 0;
            for (KeyFrameItem keyFrameItem : keyFrameItemList) {
                String keyFramePath = keyFrameItem.getKeyFramePath();
                String[] imagePaths = null;
                if (StringUtil.isNotEmpty((String)keyFramePath)) {
                    imagePaths = keyFramePath.split(";");
                }
                if (imagePaths == null || imagePaths.length <= 0) continue;
                String imagePath = imagePaths[0];
                boolean isCopy = PathCommonUtil.judgmentIsCopy((String)imagePath, (int)storageType);
                String databaseStoragePath = PathCommonUtil.builderImageDatabaseStoragePath((String)contentSourceId, (String)dateDir, (int)imageNumber, (String)imagePath, (boolean)isCopy, (int)storageType);
                SCMS_ImageInfoSchema scms_imageInfoSchema = this.builderScms_imageInfoSchema(contentSourceId, contentId, databaseStoragePath);
                transaction.add((Schema)scms_imageInfoSchema, 1);
                ++imageNumber;
                if (!isCopy) continue;
                String localStorageParentPath = PathUtil.builderPath((String[])new String[]{linuxImageDir, alias, databaseStoragePath});
                String imageSourcePath = this.getImageSourcePath(imagePathType, linuxImageDir, alias, imagePath);
                FileStorageUtil.copyFile((String)imageSourcePath, (String)localStorageParentPath);
            }
        }
        return transaction;
    }

    private String getImageSourcePath(String imagePathType, String linuxImageDir, String alias, String imagePath) {
        if ("1".equals(imagePathType)) {
            return PathUtil.builderPath((String[])new String[]{linuxImageDir, alias, "/outImport/", imagePath});
        }
        return imagePath;
    }

    private SCMS_ImageInfoSchema builderScms_imageInfoSchema(String contentSourceId, String contentId, String url) {
        SCMS_ImageInfoSchema scms_imageInfoSchema = new SCMS_ImageInfoSchema();
        Long imageId = NoUtil.getMaxID((String)"ImageInfoID");
        scms_imageInfoSchema.setId(imageId);
        scms_imageInfoSchema.setUrl(url);
        scms_imageInfoSchema.setContentId(Long.valueOf(Long.parseLong(contentId)));
        scms_imageInfoSchema.setContentSourceId(contentSourceId);
        scms_imageInfoSchema.setMediaType(Integer.valueOf(5));
        return scms_imageInfoSchema;
    }
}

