/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.core.contentinfo.service.impl;

import com.chinamcloud.common.storage.util.PathUtil;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.SizeUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_SiteSchema;
import com.sobey.bsp.schema.SCMS_VideoSchema;
import com.sobey.bsp.vms.interfaces.media.FileItem;
import com.sobey.bsp.vms.interfaces.media.Item;
import com.sobey.cms.core.contentinfo.service.VideoService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class VideoServiceImpl
implements VideoService {
    private static Logger logger = Logger.getLogger(VideoServiceImpl.class);

    public void saveVideo(Transaction trans, Map params, boolean autoPublish) throws Exception {
        String typeID = (String)params.get("typeID");
        String addUser = (String)params.get("addUser");
        Date createTime = (Date)params.get("createTime");
        String contentId = (String)params.get("contentId");
        String contentSourceId = (String)params.get("contentSourceId");
        List fileitemList = (List)params.get("fileitem");
        String fileType = (String)params.get("fileType");
        List catalogInfo = (List)params.get("catalogInfo");
        long second = 0L;
        for (Map map : catalogInfo) {
            String siteId = (String)map.get("siteId");
            String catalogIds = (String)map.get("catalogId");
            SCMS_SiteSchema scms_siteSchema = new SCMS_SiteSchema();
            scms_siteSchema.setId(siteId);
            scms_siteSchema.fill();
            String prop2 = scms_siteSchema.getProp2();
            JSONObject prop2JSONObject = JSONObject.fromObject((Object)prop2);
            JSONArray mp4JSONArray = prop2JSONObject.getJSONArray("mp4Video");
            JSONArray flvJSONArray = prop2JSONObject.getJSONArray("flvVideo");
            JSONArray tsJSONArray = prop2JSONObject.getJSONArray("tsVideo");
            String bitrate = "";
            for (int i = 0; i < fileitemList.size(); ++i) {
                FileItem fileitem = (FileItem)fileitemList.get(i);
                String format = fileitem.getFileTypeID();
                if (!"flv".equals(format.split("_")[2]) && !"ts".equals(format.split("_")[2]) && !"mp4".equals(format.split("_")[2])) continue;
                SCMS_VideoSchema scms_videoSchema = new SCMS_VideoSchema();
                scms_videoSchema.setStyleType(Integer.valueOf(this.getStyleType(format, fileType)));
                scms_videoSchema.setSuffix(this.getSuffix(format));
                scms_videoSchema.setSiteID(Long.parseLong(siteId));
                if (!StringUtils.isEmpty((String)fileitem.getFileLength())) {
                    second = Long.parseLong(fileitem.getFileLength());
                }
                scms_videoSchema.setProgramLength(second + "");
                scms_videoSchema.setAddUser(addUser == null ? "" : addUser);
                scms_videoSchema.setAddTime(createTime);
                scms_videoSchema.setContentSourceId(contentSourceId);
                String filePath = null;
                String fileURL = fileitem.getFileURL();
                filePath = fileURL.indexOf("/vod/") >= 0 ? fileURL.substring(fileURL.indexOf("/vod/")) : PathUtil.builderPath((String[])new String[]{"/vod/", fileitem.getFileURL()});
                scms_videoSchema.setSrcFileName(filePath);
                scms_videoSchema.setFileName(filePath);
                scms_videoSchema.setOrderFlag(new Date().getTime());
                scms_videoSchema.setContentId(Long.valueOf(Long.parseLong(contentId)));
                scms_videoSchema.setFileTypeId(format);
                bitrate = this.getBitrate(mp4JSONArray, flvJSONArray, tsJSONArray, format);
                scms_videoSchema.setBitrate(bitrate);
                String filelength = fileitem.getFileLength();
                int size = 0;
                if (StringUtil.isNotEmpty((String)filelength)) {
                    size = Integer.parseInt(filelength);
                }
                scms_videoSchema.setFileSize(SizeUtil.getSize((long)size));
                scms_videoSchema.setIsOriginal("N");
                if (params.get("slices") != null && !params.get("slices").equals("") && ((Boolean)params.get("slices")).booleanValue()) {
                    for (Item item : fileitem.getSlices()) {
                        SCMS_VideoSchema bean = (SCMS_VideoSchema)scms_videoSchema.clone();
                        bean.setID(NoUtil.getMaxID((String)"VideoID"));
                        bean.setProp1(item.getNumber());
                        bean.setProp2(second + "");
                        bean.setProp3(item.getSize());
                        bean.setSrcFileName(filePath);
                        bean.setProgramLength(String.valueOf(second));
                        trans.add((Schema)bean, 1);
                    }
                    continue;
                }
                scms_videoSchema.setID(NoUtil.getMaxID((String)"VideoID"));
                scms_videoSchema.setProp1("001");
                scms_videoSchema.setProp2(second + "");
                scms_videoSchema.setProp3(SizeUtil.getSize((long)size));
                trans.add((Schema)scms_videoSchema, 1);
            }
        }
    }

    private String getBitrate(JSONArray mp4JSONArray, JSONArray flvJSONArray, JSONArray tsJSONArray, String format) {
        String bitrate = null;
        String styleType = format.split("_")[2];
        if ("ts".equals(styleType)) {
            bitrate = this.getBitrate(tsJSONArray, format);
        } else if ("mp4".equals(styleType)) {
            bitrate = this.getBitrate(mp4JSONArray, format);
        } else if ("flv".equals(styleType)) {
            bitrate = this.getBitrate(flvJSONArray, format);
        }
        return bitrate;
    }

    private String getBitrate(JSONArray jsonArray, String format) {
        String bitrate = null;
        for (int j = 0; j < jsonArray.size(); ++j) {
            String setFormat = jsonArray.getJSONObject(j).getString("format");
            if (!format.equalsIgnoreCase(setFormat)) continue;
            bitrate = jsonArray.getJSONObject(j).getString("alias");
            break;
        }
        return bitrate;
    }

    private String getSuffix(String format) {
        String styleType = format.split("_")[2];
        if ("ts".equals(styleType)) {
            return "ts";
        }
        if ("mp4".equals(styleType)) {
            return "mp4";
        }
        if ("flv".equals(styleType)) {
            return "flv";
        }
        return null;
    }

    private int getStyleType(String format, String fileType) {
        String styleType = format.split("_")[2];
        if ("ts".equals(styleType)) {
            return 2;
        }
        if ("mp4".equals(styleType)) {
            if (String.valueOf(1).equals(fileType)) {
                return 3;
            }
            return 1;
        }
        if ("flv".equals(styleType)) {
            return 1;
        }
        return -1;
    }
}

