/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.core.param;

import com.sobey.bsp.vms.interfaces.media.FileItem;
import com.sobey.bsp.vms.interfaces.media.KeyFrameItem;
import com.sobey.cms.core.param.AttributeItem;
import com.sobey.cms.core.param.BetwixtUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CMSContentInfo {
    private String contentID;
    private String typeID;
    private List<AttributeItem> entityData = new ArrayList();
    private List<KeyFrameItem> keyFrame = new ArrayList();
    private List<FileItem> contentFile = new ArrayList();

    public Map<String, String> getAttributeMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (AttributeItem ai : this.entityData) {
            String v = ai.getValue();
            if (v == null) {
                v = "";
            }
            map.put(ai.getItemCode().toLowerCase(), v);
        }
        return map;
    }

    public void addEntityData(AttributeItem o) {
        this.entityData.add(o);
    }

    public void addKeyFrame(KeyFrameItem o) {
        this.keyFrame.add(o);
    }

    public void addContentFile(FileItem o) {
        this.contentFile.add(o);
    }

    public static CMSContentInfo fromXml(String xml) throws IOException {
        for (char a = 'A'; a < 'Z'; a = (char)(a + '\u0001')) {
            xml = xml.replaceAll("<" + a, "<" + (char)(a + 32));
            xml = xml.replaceAll("</" + a, "</" + (char)(a + 32));
        }
        xml = xml.replaceAll("cMSSCMS_Contentinfo", "CMSSCMS_Contentinfo");
        xml = xml.replaceAll("keyFrameItem", "keyFrame");
        xml = xml.replaceAll("fileItem", "contentFile");
        xml = xml.replaceAll("attributeItem", "entityData");
        return (CMSContentInfo)BetwixtUtil.xml2obj(CMSContentInfo.class, (String)xml);
    }

    public String toXml() {
        return null;
    }

    public String getContentID() {
        return this.contentID;
    }

    public void setContentID(String contentID) {
        this.contentID = contentID;
    }

    public String getTypeID() {
        return this.typeID;
    }

    public void setTypeID(String typeID) {
        this.typeID = typeID;
    }

    public List<AttributeItem> getEntityData() {
        return this.entityData;
    }

    public void setEntityData(List<AttributeItem> entityData) {
        this.entityData = entityData;
    }

    public List<KeyFrameItem> getKeyFrame() {
        return this.keyFrame;
    }

    public void setKeyFrame(List<KeyFrameItem> keyFrame) {
        this.keyFrame = keyFrame;
    }

    public List<FileItem> getContentFile() {
        return this.contentFile;
    }

    public void setContentFile(List<FileItem> contentFile) {
        this.contentFile = contentFile;
    }
}

