/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.core.param.service.imp;

import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.utility.DateUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_AccountSchema;
import com.sobey.bsp.schema.SCMS_AccountSet;
import com.sobey.bsp.schema.SCMS_AudioInfoSchema;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.bsp.schema.SCMS_ContentinfoSet;
import com.sobey.bsp.util.StringsUtil;
import com.sobey.bsp.vms.interfaces.media.AttributeItem;
import com.sobey.bsp.vms.interfaces.media.CMSContentInfo;
import com.sobey.bsp.vms.interfaces.media.FileItem;
import com.sobey.cms.core.param.service.ParamMapService;
import com.sobey.cms.core.param.service.imp.ParamServiceImpl;
import com.sobey.cms.util.InterfacesMethod;
import com.sobey.scms.contentinfo.interfaces.util.ContentUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamMapServiceImpl
implements ParamMapService {
    private static final Logger log = LoggerFactory.getLogger(ParamMapServiceImpl.class);

    public boolean putParamMapValue(Map<String, Object> paramMap, CMSContentInfo contentInfo, int mediaType) throws Exception {
        List paramList;
        ParamServiceImpl paramService;
        SCMS_ContentinfoSet set;
        boolean isRepeat = false;
        String contentSourceId = contentInfo.getContentID();
        String title = "";
        String subTitle = "";
        String catalogPath = "";
        String addUser = "";
        String description = "";
        String keywords = "";
        String imageDatePath = "";
        String contentId = "";
        Date firstPlayTime = null;
        String fileType = "1";
        String mediaPathType = "1";
        String softLinkDir = "";
        String transgroupId = "";
        String isSourceVideo = "";
        String partnerToken = "";
        int mediaFromType = 4;
        String imagePathType = "0";
        String mediaFrom = "";
        boolean autoPublish = false;
        String catalogId = "";
        String customParam = "{}";
        Date createTime = new Date();
        String tenantId = "";
        int internalStorageType = 1;
        for (AttributeItem attritem : contentInfo.getEntityData()) {
            if ("PartnerToken".equals(attritem.getItemCode())) {
                partnerToken = attritem.getValue();
            }
            if ("Name".equals(attritem.getItemCode())) {
                title = attritem.getValue();
            }
            if ("SubTitle".equals(attritem.getItemCode())) {
                subTitle = attritem.getValue();
            }
            if ("PgmType".equals(attritem.getItemCode())) {
                catalogPath = attritem.getValue();
            }
            if ("KeyWords".equals(attritem.getItemCode())) {
                String string = keywords = attritem.getValue() == null ? "" : attritem.getValue();
            }
            if ("SoftLinkDir".equals(attritem.getItemCode()) && StringUtil.isNotEmpty((String)attritem.getValue())) {
                softLinkDir = attritem.getValue();
            }
            if ("PgmNote".equals(attritem.getItemCode()) && StringUtil.isNotEmpty((String)attritem.getValue())) {
                description = attritem.getValue();
            }
            if ("DocProvider".equals(attritem.getItemCode()) || "CreatorName".equals(attritem.getItemCode())) {
                String string = addUser = attritem.getValue() == null ? "" : attritem.getValue();
            }
            if ("CreateDate".equals(attritem.getItemCode())) {
                createTime = new Date();
            }
            if ("PublishedType".equals(attritem.getItemCode()) || "AutoPublish".equals(attritem.getItemCode())) {
                autoPublish = "1".equals(attritem.getValue());
            }
            if (("FileType".equals(attritem.getItemCode()) || "contentFileType".equals(attritem.getItemCode())) && StringUtil.isNotEmpty((String)attritem.getValue())) {
                fileType = attritem.getValue();
            }
            if ("FirstPlayTime".equals(attritem.getItemCode())) {
                firstPlayTime = DateUtil.parseDateTime((String)attritem.getValue());
            }
            if ("MediaPathType".equals(attritem.getItemCode()) && StringUtil.isNotEmpty((String)attritem.getValue())) {
                mediaPathType = attritem.getValue();
            }
            if ("ImagePathType".equals(attritem.getItemCode()) && StringUtil.isNotEmpty((String)attritem.getValue())) {
                imagePathType = attritem.getValue();
            }
            if ("MediaFromType".equals(attritem.getItemCode()) && StringUtil.isNotEmpty((String)attritem.getValue())) {
                mediaFromType = Integer.parseInt(attritem.getValue());
            }
            if ("TransgroupId".equals(attritem.getItemCode()) && StringUtil.isNotEmpty((String)attritem.getValue())) {
                transgroupId = attritem.getValue();
            }
            if ("MediaFrom".equals(attritem.getItemCode()) && StringUtil.isNotEmpty((String)attritem.getValue())) {
                mediaFrom = attritem.getValue();
            }
            if ("isSourceVideo".equals(attritem.getItemCode()) && StringUtil.isNotEmpty((String)attritem.getValue())) {
                isSourceVideo = attritem.getValue();
            }
            if ("CatalogId".equals(attritem.getItemCode()) && StringUtil.isNotEmpty((String)attritem.getValue())) {
                catalogId = attritem.getValue();
            }
            if ("CustomParam".equals(attritem.getItemCode()) && StringUtil.isNotEmpty((String)attritem.getValue())) {
                customParam = attritem.getValue();
            }
            if ("tenantid".equals(attritem.getItemCode()) && StringUtil.isNotEmpty((String)attritem.getValue())) {
                tenantId = attritem.getValue();
            }
            if (!"storageType".equals(attritem.getItemCode()) || !StringUtil.isNotEmpty((String)attritem.getValue()) || 2 != Integer.parseInt(attritem.getValue())) continue;
            internalStorageType = 2;
        }
        DBConnPool.setCurrent((DBConnConfig)DBConnConfig.getDefaultDBConnConfigInstance());
        long siteId = 0L;
        if (StringUtil.isNotEmpty((String)tenantId)) {
            SCMS_AccountSchema schema = new SCMS_AccountSchema();
            schema.setTenantId(tenantId);
            SCMS_AccountSet account = schema.query();
            if (account == null || account.size() < 1) {
                log.info("\n-----------\u627e\u4e0d\u5230\u5bf9\u5e94tenantid\u4e3a:" + tenantId + "\u7684\u79df\u6237\uff0c\u8bf7\u6838\u5bf9\u540e\u518d\u5165\u5e93");
                throw new RuntimeException();
            }
            siteId = account.get(0).getId();
            DBConnPool.setDBConnPool((Long)siteId);
        } else if (StringUtil.isNotEmpty((String)partnerToken)) {
            String result = InterfacesMethod.getSiteIdByToken((String)partnerToken);
            if (!"false".equals(result)) {
                siteId = Long.parseLong(InterfacesMethod.getSiteIdByToken((String)partnerToken));
                DBConnPool.setDBConnPool((Long)siteId);
            }
        } else {
            String siteName = catalogPath.substring(0, catalogPath.indexOf("@"));
            SCMS_AccountSchema schema = new SCMS_AccountSchema();
            schema.setName(siteName);
            SCMS_AccountSet account = schema.query();
            if (account == null || account.size() < 1) {
                log.info("\n-----------\u627e\u4e0d\u5230\u5bf9\u5e94:" + siteName + "\u7684\u79df\u6237\uff0c\u8bf7\u6838\u5bf9\u540e\u518d\u5165\u5e93");
                throw new RuntimeException();
            }
            siteId = account.get(0).getId();
            DBConnPool.setDBConnPool((Long)siteId);
        }
        if (5 == mediaType) {
            SCMS_ContentinfoSchema contentinfoSchema = new SCMS_ContentinfoSchema();
            contentinfoSchema.setContentSourceId(contentSourceId);
            set = contentinfoSchema.query();
            if (set != null && set.size() > 0) {
                contentId = String.valueOf(set.get(0).getContentID());
                isRepeat = true;
            } else {
                contentId = String.valueOf(NoUtil.getMaxID((String)"ContentID"));
            }
        } else if (6 == mediaType) {
            SCMS_AudioInfoSchema audioInfoSchema = new SCMS_AudioInfoSchema();
            audioInfoSchema.setContentSourceId(contentSourceId);
            set = audioInfoSchema.query();
            if (set != null && set.size() > 0) {
                contentId = String.valueOf(set.get(0).getId());
                isRepeat = true;
            } else {
                contentId = String.valueOf(NoUtil.getMaxID((String)"AudioInfoID"));
            }
        }
        imageDatePath = DateUtil.toString((Date)createTime, (String)"/yyyy/MM/dd/");
        if (StringUtil.isNotEmpty((String)title) && title.length() > 90) {
            title = title.substring(0, 90);
        }
        if (StringUtil.isNotEmpty((String)keywords) && keywords.length() > 100) {
            keywords = keywords.substring(0, 100);
        }
        if (StringUtil.isNotEmpty((String)description) && description.length() > 490) {
            description = description.substring(0, 490) + "...";
        }
        title = StringsUtil.esSpecialNumeric((String)title);
        title = ContentUtil.getTitle((String)title, (int)mediaType, (int)0);
        paramMap.put("partnerToken", partnerToken);
        paramMap.put("title", title);
        paramMap.put("siteId", siteId);
        paramMap.put("typeID", contentInfo.getTypeID());
        paramMap.put("subTitle", subTitle);
        paramMap.put("autoPublish", autoPublish);
        paramMap.put("mediaPathType", mediaPathType);
        paramMap.put("imagePathType", imagePathType);
        paramMap.put("catalogPath", catalogPath);
        paramMap.put("addUser", addUser);
        paramMap.put("createTime", createTime);
        paramMap.put("description", description);
        paramMap.put("keywords", keywords);
        paramMap.put("fileType", fileType);
        paramMap.put("softLinkDir", softLinkDir);
        paramMap.put("contentSourceId", contentInfo.getContentID());
        paramMap.put("imageDatePath", imageDatePath);
        paramMap.put("contentId", contentId);
        paramMap.put("firstPlayTime", firstPlayTime);
        paramMap.put("mediaFromType", mediaFromType);
        paramMap.put("transgroupId", transgroupId);
        paramMap.put("mediaFrom", mediaFrom);
        paramMap.put("isSourceVideo", isSourceVideo);
        paramMap.put("customParam", customParam);
        paramMap.put("storageType", internalStorageType);
        if (!contentInfo.getContentFile().isEmpty()) {
            if (!((FileItem)contentInfo.getContentFile().get(0)).getSlices().isEmpty()) {
                paramMap.put("slices", true);
            } else {
                paramMap.put("slices", false);
            }
        }
        paramMap.put("keyFrameItem", contentInfo.getKeyFrame());
        paramMap.put("fileitem", contentInfo.getContentFile());
        paramMap.put("srcFileItem", contentInfo.getSrcContentFile());
        if (StringUtil.isNotEmpty((String)catalogId)) {
            paramService = new ParamServiceImpl();
            paramList = paramService.getCatalogPath(catalogId, mediaType, siteId);
            paramMap.put("catalogInfo", paramList);
        } else {
            paramService = new ParamServiceImpl();
            paramList = paramService.handlerCatalogPath(catalogPath, mediaType, siteId);
            paramMap.put("catalogInfo", paramList);
        }
        return isRepeat;
    }
}

