/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.core.param.service.imp;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.cms.site.SetPrivUtil;
import com.sobey.bsp.cms.site.SiteDefaultUtil;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.InterfacesManage;
import com.sobey.bsp.platform.Priv;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.plugin.util.UUIDGenerator;
import com.sobey.bsp.schema.SCMS_CatalogSchema;
import com.sobey.cms.core.param.service.ParamService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis.utils.StringUtils;

public class ParamServiceImpl
implements ParamService {
    public List<Map<String, Object>> handlerCatalogPath(String catalogPath, int type, long siteId) throws Exception {
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>();
        HashMap<String, String> m = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)catalogPath) || catalogPath.indexOf("@") == -1) {
            m.put("siteId", String.valueOf(siteId));
            m.put("catalogId", SiteDefaultUtil.getDefalutCatalogId((Long)siteId, (int)type));
            SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
            catalog.setID(SiteDefaultUtil.getDefalutCatalogId((Long)siteId, (int)type));
            catalog.fill();
            m.put("catalogInnerCode", catalog.getInnerCode());
        } else {
            String[] catalogPaths = catalogPath.split("@");
            if (catalogPaths.length > 1 && catalogPaths.length <= 7) {
                this.selectCatalog(siteId, type, catalogPaths, 1, 0L, catalogPaths.length, m);
            } else {
                m.put("siteId", String.valueOf(siteId));
                m.put("catalogId", SiteDefaultUtil.getDefalutCatalogId((Long)siteId, (int)type));
                SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
                catalog.setID(SiteDefaultUtil.getDefalutCatalogId((Long)siteId, (int)type));
                catalog.fill();
                m.put("catalogInnerCode", catalog.getInnerCode());
            }
        }
        paramList.add(m);
        return paramList;
    }

    private void selectCatalog(long siteId, int type, String[] catalogName, int treelevel, long parentid, int catalogLength, Map<String, Object> m) {
        String sql = "select name,siteId,id,parentid,treelevel,InnerCode from SCMS_Catalog where type=" + type + " and name='" + catalogName[treelevel] + "' and treelevel=" + treelevel + " and parentid=" + parentid;
        DataTable dt = new QueryBuilder(sql).executeDataTable();
        if (dt != null && dt.getRowCount() > 0) {
            long catalogId = dt.getLong(0, "id");
            long parentId = dt.getLong(0, "parentid");
            int level = dt.getInt(0, "treelevel");
            String name = dt.getString(0, "name");
            String innerCode = dt.getString(0, "InnerCode");
            if (level < catalogLength - 1) {
                this.selectCatalog(siteId, type, catalogName, treelevel + 1, catalogId, catalogLength, m);
            } else {
                m.put("siteId", String.valueOf(siteId));
                m.put("catalogId", String.valueOf(catalogId));
                m.put("catalogInnerCode", innerCode);
            }
        } else {
            this.addcatalog(siteId, type, catalogName, treelevel, parentid, catalogLength, m);
        }
    }

    private void addcatalog(long siteId, int type, String[] catalogName, int treelevel, long parentid, int catalogLength, Map<String, Object> m) {
        if (StringUtil.isEmpty((String)catalogName[treelevel])) {
            m.put("siteId", String.valueOf(siteId));
            m.put("catalogId", SiteDefaultUtil.getDefalutCatalogId((Long)siteId, (int)type));
            SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
            catalog.setID(SiteDefaultUtil.getDefalutCatalogId((Long)siteId, (int)type));
            catalog.fill();
            m.put("catalogInnerCode", catalog.getInnerCode());
        } else {
            Transaction trans = new Transaction();
            SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
            long catalogId = NoUtil.getMaxID((String)"CatalogID");
            String innerCode = "";
            catalog.setID(catalogId);
            catalog.setSiteID(siteId);
            catalog.setParentID(parentid);
            catalog.setTreeLevel((long)treelevel);
            if (0L == parentid) {
                innerCode = NoUtil.getMaxNo((String)"CatalogInnerCode", (int)6);
                catalog.setInnerCode(innerCode);
            } else {
                SCMS_CatalogSchema pCatalog = new SCMS_CatalogSchema();
                pCatalog.setID(parentid);
                pCatalog.fill();
                innerCode = NoUtil.getMaxNo((String)"CatalogInnerCode", (String)pCatalog.getInnerCode(), (int)6);
                catalog.setInnerCode(innerCode);
                pCatalog.setChildCount(pCatalog.getChildCount() + 1L);
                trans.add((Schema)pCatalog, 2);
            }
            catalog.setName(catalogName[treelevel]);
            catalog.setURL(" ");
            catalog.setAlias(SiteUtil.getAlias((long)siteId));
            catalog.setType((long)type);
            catalog.setListNameRule("");
            catalog.setDetailNameRule("");
            catalog.setChildCount(0L);
            catalog.setIsLeaf(1L);
            catalog.setTotal(0L);
            catalog.setOrderFlag(catalogId);
            catalog.setLogo("");
            catalog.setListPageSize(10L);
            catalog.setPublishFlag("Y");
            catalog.setHitCount(0L);
            catalog.setMeta_Keywords("");
            catalog.setMeta_Description("");
            catalog.setOrderColumn("");
            catalog.setAddUser(SiteUtil.getSiteUserName((String)String.valueOf(siteId)));
            catalog.setAddTime(new Date());
            UUIDGenerator uuid = new UUIDGenerator();
            String columnId = uuid.generate();
            catalog.setFakeID(columnId);
            trans.add((Schema)catalog, 1);
            if (catalog.getType() == 5L) {
                SetPrivUtil.setCatalogPriv((Transaction)trans, (String)catalog.getInnerCode(), (String)"video", (Mapx)Priv.VIDEO_MAP, (String)"admin");
            } else if (catalog.getType() == 7L) {
                SetPrivUtil.setCatalogPriv((Transaction)trans, (String)catalog.getInnerCode(), (String)"series", (Mapx)Priv.SERIES_MAP, (String)"admin");
            } else if (catalog.getType() == 6L) {
                SetPrivUtil.setCatalogPriv((Transaction)trans, (String)catalog.getInnerCode(), (String)"audio", (Mapx)Priv.AUDIO_MAP, (String)"admin");
            }
            if (trans.commit()) {
                if (catalog.getType() == 5L) {
                    InterfacesManage.savePushCatalog((long)catalogId);
                }
                if (catalogLength - 1 > treelevel) {
                    this.addcatalog(siteId, type, catalogName, treelevel + 1, catalogId, catalogLength, m);
                } else {
                    m.put("siteId", String.valueOf(siteId));
                    m.put("catalogId", String.valueOf(catalogId));
                    m.put("catalogInnerCode", innerCode);
                }
            } else {
                m.put("status", 0);
            }
        }
    }

    public List<Map<String, Object>> getCatalogPath(String catalogId, int type, long siteId) throws Exception {
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>();
        HashMap<String, String> m = new HashMap<String, String>();
        SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
        catalog.setID(catalogId);
        if (catalog.fill()) {
            m.put("siteId", String.valueOf(siteId));
            m.put("catalogId", String.valueOf(catalog.getID()));
            m.put("catalogInnerCode", catalog.getInnerCode());
        } else {
            m.put("siteId", String.valueOf(siteId));
            m.put("catalogId", SiteDefaultUtil.getDefalutCatalogId((Long)siteId, (int)type));
            SCMS_CatalogSchema deCatalog = new SCMS_CatalogSchema();
            deCatalog.setID(SiteDefaultUtil.getDefalutCatalogId((Long)siteId, (int)type));
            deCatalog.fill();
            m.put("catalogInnerCode", deCatalog.getInnerCode());
        }
        paramList.add(m);
        return paramList;
    }
}

