/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.cztv;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.cms.cztv.CZTV;
import com.sobey.cms.cztv.MediaFile;
import com.sobey.cms.cztv.MpcFileMove;
import com.sobey.cms.cztv.move.TempTableUtil;
import com.sobey.cms.util.InterfacesMethod;
import com.sobey.cms.util.InterfacesUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;

public class LetvImportServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String responseUrl = "http://localhost:8080/vms-cms/services/mpcFileMoveCallBack?wsdl";
    private String letvWinPath = "Z:\\";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DBConnPool.setCurrent((DBConnConfig)DBConnConfig.getDefaultDBConnConfigInstance());
        this.responseUrl = Config.getValue((String)"letv.mpcFileMove.resUrl");
        this.letvWinPath = Config.getValue((String)"letv.winPath");
        String content = "";
        String sCurrentLine = "";
        JSONObject result = new JSONObject();
        JSONObject jo = null;
        try {
            ServletInputStream l_urlStream = request.getInputStream();
            BufferedReader l_reader = new BufferedReader(new InputStreamReader((InputStream)l_urlStream, "UTF-8"));
            while ((sCurrentLine = l_reader.readLine()) != null) {
                content = content + sCurrentLine;
            }
            content = StringEscapeUtils.unescapeJava((String)content);
            jo = JSONObject.fromObject((Object)content);
            System.out.println("\u4e50\u89c6\u4e91\u89c6\u9891\u53d1\u9001\u7684JSON\u683c\u5f0f\u6570\u636e\u4e3a------------" + content + "--------");
            String token = jo.getString("partnerToken");
            if (StringUtil.isNotEmpty((String)token)) {
                String siteId = InterfacesMethod.getSiteIdByToken((String)token);
                if ("false".equals(siteId)) {
                    result.put((Object)"status", (Object)0);
                    result.put((Object)"message", (Object)"\u60a8\u8f93\u5165\u7684partnerToken\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684partnerToken\u503c\uff01");
                    result.put((Object)"partnerCode", (Object)"sobeyVMS");
                    result.put((Object)"cmsId", jo.get("cmsId"));
                } else {
                    DBConnPool.setDBConnPool((Long)Long.parseLong(siteId));
                    String contentSourceId = this.getGUID();
                    int categoryId = jo.getInt("catalogId");
                    DBConnPool.setDBConnPool((Long)Long.parseLong(siteId));
                    Date now = new Date();
                    TempTableUtil.add((String)contentSourceId, (String)content, (int)0, (int)1, (int)1, (int)categoryId, (Date)now);
                    JSONObject vodAddress = jo.getJSONObject("vodAddress");
                    JSONArray urls = vodAddress.getJSONArray("urls");
                    ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>();
                    for (int i = 0; i < urls.size(); ++i) {
                        String filePath = urls.getString(i);
                        String sourcePath = this.letvWinPath + StringUtil.replaceAllToBack_Slant((String)filePath);
                        String winVideoUploadDir = Config.getValue((String)"winVideoUploadDir");
                        SimpleDateFormat format = new SimpleDateFormat("\\yyyy\\MM\\dd\\");
                        String winPath = StringUtil.replaceAllToBack_Slant((String)(winVideoUploadDir + SiteUtil.getAlias((String)siteId) + "/source/storage" + format.format(new Date()) + contentSourceId + "\\"));
                        String name = new Date().getTime() + filePath.substring(filePath.lastIndexOf("."));
                        MediaFile mediaFile = new MediaFile(sourcePath, winPath + name);
                        mediaFiles.add(mediaFile);
                    }
                    CZTV cztv = new CZTV();
                    String requestID = this.getGUID();
                    cztv.setRequestID(requestID);
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    cztv.setRequestTime(format.format(new Date()));
                    cztv.setResponseUrl(this.responseUrl);
                    cztv.setSiteId(siteId);
                    cztv.setTitle(jo.getString("title"));
                    cztv.setMediaFiles(mediaFiles);
                    cztv.setReqXmlPath("1111");
                    cztv.setContentId(contentSourceId);
                    System.out.println("requestID==============\u300b" + requestID);
                    MpcFileMove mpcFileMove = new MpcFileMove();
                    String resp = mpcFileMove.move(cztv);
                    System.out.println("==============\u300b" + resp);
                    result.put((Object)"id", (Object)contentSourceId);
                    result.put((Object)"status", (Object)1);
                    result.put((Object)"message", (Object)"ok");
                    result.put((Object)"partnerCode", (Object)"sobeyVMS");
                    result.put((Object)"cmsId", jo.get("cmsId"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put((Object)"status", (Object)0);
            result.put((Object)"message", (Object)"\u63a5\u6536\u6570\u636e\u5931\u8d25");
            result.put((Object)"partnerCode", (Object)"sobeyVMS");
            if (jo != null && jo.has("cmsId")) {
                result.put((Object)"cmsId", jo.get("cmsId"));
            }
            result.put((Object)"cmsId", (Object)0);
        }
        InterfacesUtil.writeJson((String)result.toString(), (HttpServletResponse)response);
    }

    private String getGUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public String response(int status) {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\"?>");
        buf.append("<MPCWebCmd><CommandType>Rtn_AddTask</CommandType>");
        buf.append("<Rtn_AddTask>");
        buf.append("<MPC_Status><Status>" + status + "</Status><Remark>it is succeed get dispatch status</Remark>");
        buf.append("</MPC_Status></Rtn_AddTask></MPCWebCmd>");
        return buf.toString();
    }
}

