/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.cztv;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.utility.FileUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.cms.cztv.CZTV;
import com.sobey.cms.cztv.MediaFile;
import com.sobey.cms.cztv.MpcFileMove;
import com.sobey.cms.util.InterfacesMethod;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class TMImportServlet {
    private String responseUrl = "http://localhost:8080/vms-cms/services/mpcFileMoveCallBack?wsdl";
    private String tvmWinPath = "Z:\\";
    private String tvmLinPath = "/video/video.cztv.com/10.1.99.90/";
    private String[] videoFormats = new String[]{"MP4ZJTV900", "MP4ZJTV", "MP4"};

    public String mpccommit(String msg, String param) {
        int status = 1;
        try {
            DBConnPool.setCurrent((DBConnConfig)DBConnConfig.getDefaultDBConnConfigInstance());
            String token = Config.getValue((String)"vms.appkey");
            this.responseUrl = Config.getValue((String)"tvm.mpcFileMove.resUrl");
            this.tvmWinPath = Config.getValue((String)"tvm.winPath");
            this.tvmLinPath = Config.getValue((String)"tvm.linPath");
            if (StringUtil.isNotEmpty((String)token) && StringUtil.isNotEmpty((String)msg)) {
                String siteId = InterfacesMethod.getSiteIdByToken((String)token);
                DBConnPool.setDBConnPool((Long)Long.parseLong(siteId));
                Document mpcDoc = DocumentHelper.parseText((String)msg);
                List mpcMediaFiles = mpcDoc.selectNodes("MPCWebCmd//AddTask//MPC//Content//AddTask//MediaFile");
                for (int j = 0; j < mpcMediaFiles.size(); ++j) {
                    Node mpcMediaFile = (Node)mpcMediaFiles.get(j);
                    String xmlFilePath = mpcMediaFile.selectSingleNode("FileName").getText();
                    System.out.println("\u626b\u63cf\u7a0b\u5e8f\u8fd4\u56de\u7edd\u5bf9\u8def\u5f84=======\u300b" + xmlFilePath);
                    xmlFilePath = this.tvmLinPath + StringUtil.replaceAllToSlant((String)xmlFilePath.replace(this.tvmWinPath, ""));
                    String xml = FileUtil.readText((String)xmlFilePath);
                    if (StringUtil.isEmpty((String)xml)) {
                        status = 0;
                        continue;
                    }
                    String contentId = this.getGUID();
                    Document doc = DocumentHelper.parseText((String)xml);
                    Element rootElement = doc.getRootElement();
                    String title = rootElement.elementText("title");
                    Element assetFiles = rootElement.element("AssetFiles");
                    List files = assetFiles.elements("file");
                    ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>();
                    for (int i = 0; i < files.size(); ++i) {
                        Element file = (Element)files.get(i);
                        String fileFormat = file.elementText("fileFormat");
                        String filePath = file.elementText("filePath");
                        String sourcePath = this.tvmWinPath + StringUtil.replaceAllToBack_Slant((String)filePath) + ".done";
                        String winVideoUploadDir = Config.getValue((String)"winVideoUploadDir");
                        SimpleDateFormat format = new SimpleDateFormat("\\yyyy\\MM\\dd\\");
                        String winPath = winVideoUploadDir + SiteUtil.getAlias((String)siteId) + "/source/storage" + format.format(new Date()) + contentId + "\\";
                        winPath = StringUtil.replaceAllToBack_Slant((String)winPath);
                        String fileName = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.length());
                        String affix = filePath.substring(filePath.lastIndexOf("."), filePath.length());
                        if ("NTS".equals(fileFormat)) {
                            winPath = winPath + fileName;
                        } else {
                            if (!"JPG".equals(fileFormat)) continue;
                            winPath = winPath + "defaultKeyFrame" + affix;
                        }
                        MediaFile mediaFile = new MediaFile(sourcePath, winPath);
                        mediaFiles.add(mediaFile);
                    }
                    CZTV cztv = new CZTV();
                    String requestID = this.getGUID();
                    cztv.setRequestID(requestID);
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    cztv.setRequestTime(format.format(new Date()));
                    cztv.setResponseUrl(this.responseUrl);
                    cztv.setSiteId(siteId);
                    cztv.setTitle(title);
                    cztv.setMediaFiles(mediaFiles);
                    cztv.setReqXmlPath(xmlFilePath);
                    cztv.setContentId(contentId);
                    MpcFileMove mpcFileMove = new MpcFileMove();
                    String response = mpcFileMove.move(cztv);
                    System.out.println("==============\u300b" + response);
                }
            } else {
                status = 0;
            }
        }
        catch (Exception e) {
            status = 0;
            e.printStackTrace();
        }
        return this.response(status);
    }

    private String getGUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public String response(int status) {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\"?>");
        buf.append("<MPCWebCmd><CommandType>Rtn_AddTask</CommandType>");
        buf.append("<Rtn_AddTask>");
        buf.append("<MPC_Status><Status>" + status + "</Status><Remark>it is succeed get dispatch status</Remark>");
        buf.append("</MPC_Status></Rtn_AddTask></MPCWebCmd>");
        return buf.toString();
    }
}

