/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.cztv;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/*
 * Exception performing whole class analysis ignored.
 */
public class VerifyPasswordCZTV {
    private static byte[][] split(byte[] src, int n) {
        byte[] r;
        byte[] l;
        if (src.length <= n) {
            l = src;
            r = new byte[]{};
        } else {
            l = new byte[n];
            r = new byte[src.length - n];
            System.arraycopy(src, 0, l, 0, n);
            System.arraycopy(src, n, r, 0, r.length);
        }
        byte[][] lr = new byte[][]{l, r};
        return lr;
    }

    public static boolean verifyPassword(String digest, String password) {
        String alg = null;
        int size = 0;
        if (digest.regionMatches(true, 0, "{SHA}", 0, 5)) {
            digest = digest.substring(5);
            alg = "SHA1";
            size = 20;
        } else if (digest.regionMatches(true, 0, "{SSHA}", 0, 6)) {
            digest = digest.substring(6);
            alg = "SHA1";
            size = 20;
        } else if (digest.regionMatches(true, 0, "{MD5}", 0, 5)) {
            digest = digest.substring(5);
            alg = "MD5";
            size = 16;
        } else if (digest.regionMatches(true, 0, "{SMD5}", 0, 6)) {
            digest = digest.substring(6);
            alg = "MD5";
            size = 16;
        }
        try {
            MessageDigest mDigest = MessageDigest.getInstance(alg);
            if (mDigest == null) {
                return false;
            }
            BASE64Encoder enc = new BASE64Encoder();
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] decodeBase64 = decoder.decodeBuffer(digest);
            byte[][] hs = VerifyPasswordCZTV.split((byte[])decodeBase64, (int)size);
            byte[] hash = hs[0];
            byte[] salt = hs[1];
            mDigest.reset();
            mDigest.update(password.getBytes());
            mDigest.update(salt);
            byte[] pwhash = mDigest.digest();
            return MessageDigest.isEqual(hash, pwhash);
        }
        catch (NoSuchAlgorithmException nsae) {
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String shaDecoder(String password) {
        try {
            String alg = "SHA1";
            MessageDigest mDigest = MessageDigest.getInstance(alg);
            if (mDigest == null) {
                return null;
            }
            BASE64Encoder enc = new BASE64Encoder();
            BASE64Decoder decoder = new BASE64Decoder();
            mDigest.reset();
            mDigest.update(password.getBytes());
            byte[] pwhash = mDigest.digest();
            String shaDecoder = enc.encode(pwhash);
            return "{SHA}" + shaDecoder;
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
    }
}

