/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.cztv.img;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.Application;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.platform.pub.OrderUtil;
import com.sobey.bsp.schema.SCMS_AudioInfoSchema;
import com.sobey.bsp.schema.SCMS_CatalogSchema;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.bsp.schema.SCMS_ImageSchema;
import com.sobey.bsp.schema.SCMS_SeriesSchema;
import com.sobey.bsp.util.ImageHelper;
import com.sobey.cms.util.InterfacesMethod;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class CZTVKeyFrameUpload
extends HttpServlet {
    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DBConnPool.setCurrent((DBConnConfig)DBConnConfig.getDefaultDBConnConfigInstance());
        DiskFileItemFactory fac = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fac);
        upload.setHeaderEncoding("UTF-8");
        String token = request.getParameter("partnerToken");
        String contentId = request.getParameter("contentId");
        String mediaType = request.getParameter("mediaType");
        Long siteId = 0L;
        JSONObject imageInfo = new JSONObject();
        try {
            siteId = !StringUtil.isEmpty((String)token) ? Long.valueOf(Long.parseLong(InterfacesMethod.getSiteIdByToken((String)token))) : Long.valueOf(Long.parseLong(request.getParameter("siteid")));
            DBConnPool.setDBConnPool((Long)siteId);
            Date date = new Date();
            String contentSourceId = "";
            Long imgNum = null;
            if (StringUtil.isNotEmpty((String)mediaType) && 5 == Integer.parseInt(mediaType)) {
                SCMS_ContentinfoSchema contentinfo = new SCMS_ContentinfoSchema();
                contentinfo.setContentID(contentId);
                contentinfo.fill();
                date = contentinfo.getCreateTime();
                contentSourceId = contentinfo.getContentSourceId();
                imgNum = contentinfo.getImgNum();
                if (imgNum == null || imgNum == 0L) {
                    imgNum = 8L;
                }
                contentinfo.setImgNum(Long.valueOf(imgNum + 1L));
                Transaction tran = new Transaction();
                tran.add((Schema)contentinfo, 2);
                tran.commit();
            } else if (StringUtil.isNotEmpty((String)mediaType) && 6 == Integer.parseInt(mediaType)) {
                SCMS_AudioInfoSchema audioinfo = new SCMS_AudioInfoSchema();
                audioinfo.setId(Long.valueOf(Long.parseLong(contentId)));
                audioinfo.fill();
                date = audioinfo.getCreateTime();
                contentSourceId = audioinfo.getContentSourceId();
            } else if (StringUtil.isNotEmpty((String)mediaType) && 7 == Integer.parseInt(mediaType)) {
                SCMS_SeriesSchema series = new SCMS_SeriesSchema();
                series.setSeriesid(Long.valueOf(Long.parseLong(contentId)));
                series.fill();
                date = series.getCreatetime();
                contentSourceId = series.getSeriessourceid();
            } else {
                date = new Date();
                contentSourceId = "";
            }
            SimpleDateFormat sdf = new SimpleDateFormat("/yyyy/MM/dd/");
            String dateDir = sdf.format(date);
            String filePath = StringUtil.replaceAllToSlant((String)(Config.getValue((String)"linuxImageDir") + SiteUtil.getAlias((long)siteId) + "/upload/Image/default/" + dateDir + contentSourceId + "/"));
            File f = new File(filePath);
            if (!f.exists()) {
                f.mkdirs();
            }
            List fileList = upload.parseRequest(request);
            Iterator it = fileList.iterator();
            String name = "";
            String filename = "";
            String extName = "";
            String imageid = "";
            String imgName = "";
            while (it.hasNext()) {
                FileItem item = (FileItem)it.next();
                if (item.isFormField()) continue;
                long size = item.getSize();
                filename = name = item.getName();
                if (StringUtil.isEmpty((String)name)) continue;
                if (name.lastIndexOf(".") >= 0) {
                    extName = name.substring(name.lastIndexOf("."));
                }
                File file = null;
                do {
                    name = UUID.randomUUID().toString();
                } while ((file = new File(filePath + name + extName)).exists());
                File saveFile = new File(filePath + name + extName);
                try {
                    item.write(saveFile);
                    BufferedImage img = ImageIO.read(saveFile);
                    Raster ra = img.getData();
                    Rectangle rect = ra.getBounds();
                    int width = rect.width;
                    int height = rect.height;
                    imgName = imgNum + "_640_400" + extName;
                    if ((double)width * 1.0 / 640.0 > (double)height * 1.0 / 400.0) {
                        ImageHelper.zoomImage((String)(filePath + name + extName), (String)(filePath + name + extName), (int)((int)Math.ceil((double)width * (400.0 / (double)height))), (int)400);
                    } else if ((double)width * 1.0 / 640.0 < (double)height * 1.0 / 400.0) {
                        ImageHelper.zoomImage((String)(filePath + name + extName), (String)(filePath + name + extName), (int)640, (int)((int)Math.ceil((double)height * (640.0 / (double)width))));
                    } else {
                        ImageHelper.zoomImage((String)(filePath + name + extName), (String)(filePath + name + extName), (int)640, (int)400);
                    }
                    ImageHelper.cutCenterImage((String)(filePath + name + extName), (String)(filePath + imgName), (int)640, (int)400);
                    File oldImgFile = new File(filePath + name + extName);
                    oldImgFile.delete();
                    File newImg = new File(filePath + imgName);
                    long length = 0L;
                    if (newImg.exists() && newImg.isFile()) {
                        length = newImg.length();
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("path", "/upload/Image/default/" + dateDir + contentSourceId);
                    map.put("name", imgName);
                    map.put("filename", imgName);
                    map.put("ext", imgName.substring(imgName.lastIndexOf(".") + 1));
                    map.put("size", String.valueOf(length));
                    map.put("siteid", String.valueOf(siteId));
                    imageid = this.doSaveKeyFrame(request, response, map);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            BufferedImage img = ImageIO.read(new File(filePath + name + extName));
            Raster ra = img.getData();
            Rectangle rect = ra.getBounds();
            String priviewUrl = (filePath + name + extName).replace(StringUtil.replaceAllToSlant((String)Config.getValue((String)"linuxImageDir")), "/image/");
            imageInfo.put((Object)"width", (Object)rect.width);
            imageInfo.put((Object)"height", (Object)rect.height);
            imageInfo.put((Object)"imageId", (Object)imageid);
            imageInfo.put((Object)"imageUrl", (Object)priviewUrl);
            imageInfo.put((Object)"fileName", (Object)filename);
            imageInfo.put((Object)"imgSource", (Object)(priviewUrl + "@" + rect.width + "_" + rect.height));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        response.getWriter().print(imageInfo.toString());
    }

    public String doSaveKeyFrame(HttpServletRequest request, HttpServletResponse response, Map<String, String> map) {
        Transaction trans = new Transaction();
        long siteID = Long.parseLong(map.get("siteid"));
        DBConnPool.setDBConnPool((Long)siteID);
        long imageID = NoUtil.getMaxID((String)"ImageID");
        SCMS_ImageSchema image = new SCMS_ImageSchema();
        SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
        String catalogId = request.getParameter("CatalogID");
        String path = map.get("path");
        String fileName = map.get("filename");
        String ext = map.get("ext");
        String fileSize = Long.parseLong(map.get("size")) / 1000L + " KB";
        String innerCode = "";
        if (StringUtil.isEmpty((String)catalogId) && StringUtil.isEmpty((String)(catalogId = new QueryBuilder("select ID from SCMS_Catalog  where type='4' and Name ='\u9ed8\u8ba4\u56fe\u7247'  and siteid=?", siteID).executeString()))) {
            catalogId = NoUtil.getMaxID((String)"CatalogID") + "";
            catalog.setID(catalogId);
            catalog.setParentID(0L);
            catalog.setName("\u9ed8\u8ba4\u56fe\u7247");
            catalog.setType(4L);
            catalog.setInnerCode("000001");
            catalog.setSiteID(siteID);
            catalog.setAlias(Application.getCurrentSiteAlias());
            catalog.setTreeLevel(0L);
            catalog.setChildCount(0L);
            catalog.setIsLeaf(0L);
            catalog.setTotal(0L);
            catalog.setOrderFlag(0L);
            catalog.setPublishFlag("");
            catalog.setAddTime(new Date());
            catalog.setAddUser("admin");
            catalog.insert();
        }
        catalog.setID(catalogId);
        if (catalog.fill()) {
            innerCode = catalog.getInnerCode();
        }
        image.setID(imageID);
        image.setName(map.get("name"));
        image.setOldName(map.get("name"));
        image.setSiteID(siteID);
        image.setCatalogID(Long.parseLong(catalogId));
        image.setCatalogInnerCode(innerCode);
        image.setBranchInnerCode(catalog.getBranchInnerCode());
        image.setPath(path);
        image.setFileName(fileName);
        image.setSrcFileName(fileName);
        image.setSuffix(ext);
        image.setWidth(0L);
        image.setHeight(0L);
        image.setCount(0L);
        image.setOrderFlag(OrderUtil.getDefaultOrder());
        image.setFileSize(fileSize);
        image.setHitCount(0L);
        image.setStickTime(0L);
        image.setInfo("");
        image.setAuthor("");
        image.setSystem("CMS");
        image.setAddTime(new Date());
        image.setAddUser(StringUtil.isEmpty((String)User.getUserName()) ? "admin" : User.getUserName());
        image.setModifyTime(new Date());
        image.setModifyUser(StringUtil.isEmpty((String)User.getUserName()) ? "admin" : User.getUserName());
        trans.add((Schema)image, 1);
        trans.commit();
        return String.valueOf(imageID);
    }

    public void init() throws ServletException {
    }
}

