/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.cztv.move;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.utility.DateUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.schema.SCMS_SiteSchema;
import com.sobey.cms.cztv.MediaFile;
import com.sobey.cms.cztv.VelocityUtil;
import com.sobey.cms.cztv.move.CZTVDataMove;
import com.sobey.cms.cztv.move.TempTableUtil;
import com.sobey.cms.util.InterfacesMethod;
import com.sobey.scms.trasncode.util.TransCodeSendMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;

public class DataMoveService
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        resp.setCharacterEncoding("UTF-8");
        String jsonStr = "";
        String sCurrentLine = "";
        String contentSourceId = this.getGUID();
        int status = 1;
        String message = "";
        int cmsId = 0;
        try {
            ServletInputStream l_urlStream = req.getInputStream();
            BufferedReader l_reader = new BufferedReader(new InputStreamReader((InputStream)l_urlStream, "UTF-8"));
            while ((sCurrentLine = l_reader.readLine()) != null) {
                jsonStr = jsonStr + sCurrentLine;
            }
            System.out.println("\u6536\u5230\u6587\u4ef6\u8fc1\u79fb\u62a5\u6587=========\u300b" + jsonStr);
            String responseUrl = Config.getValue((String)"cztv.dataMove.resUrl");
            String winSourceVideo = Config.getValue((String)"cztv.dataMove.winSourceVideo");
            String winVideoDir = Config.getValue((String)"winVideoDir");
            String winImageDir = Config.getValue((String)"winImageDir");
            jsonStr = StringEscapeUtils.unescapeJava((String)jsonStr);
            System.out.println("\u8f6c\u6362\u7f16\u7801\u683c\u5f0f\u540e\u7684json\u5b57\u7b26\u4e32=========\u300b" + jsonStr);
            new JSONObject();
            JSONObject jo = JSONObject.fromObject((Object)jsonStr);
            String token = jo.getString("partnerToken");
            cmsId = jo.getInt("cmsId");
            if (StringUtil.isNotEmpty((String)token)) {
                DBConnPool.setCurrent((DBConnConfig)DBConnConfig.getDefaultDBConnConfigInstance());
                String siteId = InterfacesMethod.getSiteIdByToken((String)token);
                if ("false".equals(siteId)) {
                    status = 0;
                    message = "\u60a8\u8f93\u5165\u7684partnerToken\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684partnerToken\u503c\uff01";
                } else {
                    int categoryId = jo.getInt("catalogId");
                    DBConnPool.setDBConnPool((Long)Long.parseLong(siteId));
                    Date now = new Date();
                    TempTableUtil.add((String)contentSourceId, (String)jsonStr, (int)0, (int)1, (int)2, (int)categoryId, (Date)now);
                    String title = jo.getString("title");
                    JSONArray urlsJa = jo.getJSONObject("vodAddress").getJSONArray("urls");
                    JSONArray formats = jo.getJSONObject("vodAddress").getJSONArray("formats");
                    ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>();
                    SimpleDateFormat format = new SimpleDateFormat("\\yyyy\\MM\\dd\\");
                    String dateStr = format.format(now);
                    SCMS_SiteSchema site = new SCMS_SiteSchema();
                    site.setId(siteId);
                    site.fill();
                    String prop2 = site.getProp2();
                    for (int i = 0; i < urlsJa.size(); ++i) {
                        String videoUrl = urlsJa.getString(i);
                        videoUrl = winSourceVideo + "\\" + videoUrl;
                        String sourceVideoUrl = StringUtil.replaceAllToBack_Slant((String)videoUrl);
                        String targetVideoUrl = winVideoDir + SiteUtil.getAlias((String)siteId) + "/vod/" + dateStr + contentSourceId + "\\";
                        targetVideoUrl = StringUtil.replaceAllToBack_Slant((String)targetVideoUrl);
                        String videoFormat = formats.getString(i);
                        String fileName = "";
                        JSONArray mp4Ja = JSONObject.fromObject((Object)prop2).getJSONArray("mp4Video");
                        for (int j = 0; j < mp4Ja.size(); ++j) {
                            JSONObject mp4Jo = mp4Ja.getJSONObject(j);
                            String name = mp4Jo.getString("name");
                            if (!name.equals(videoFormat)) continue;
                            fileName = mp4Jo.getString("format") + ".mp4";
                            break;
                        }
                        if (StringUtil.isEmpty((String)fileName)) continue;
                        targetVideoUrl = targetVideoUrl + fileName;
                        MediaFile mediaFile = new MediaFile(sourceVideoUrl, targetVideoUrl);
                        mediaFiles.add(mediaFile);
                    }
                    CZTVDataMove move = new CZTVDataMove();
                    move.setTitle(title);
                    move.setSiteId(siteId);
                    move.setResponseUrl(responseUrl);
                    move.setRequestTime(DateUtil.toDateTimeString((Date)new Date()));
                    move.setRequestID(contentSourceId);
                    move.setMediaFiles(mediaFiles);
                    String targetImgUrl = winImageDir + "\\" + SiteUtil.getAlias((String)siteId) + "/upload/Image/default/" + dateStr + contentSourceId + "\\";
                    targetImgUrl = StringUtil.replaceAllToBack_Slant((String)targetImgUrl);
                    move.setImagePath(targetImgUrl);
                    move.setContentSourceId(contentSourceId);
                    String responseStr = this.toMpc(move);
                    Document doc = DocumentHelper.parseText((String)responseStr);
                    String statusMpc = doc.selectSingleNode("MPCWebCmd//Rtn_AddTask//MPC_Status//Status").getText();
                    if ("1".equals(statusMpc)) {
                        TempTableUtil.update((String)contentSourceId, (int)0, (int)2);
                        status = 1;
                        message = "mpc\u63a5\u6536\u4efb\u52a1\u6210\u529f\uff01";
                    } else {
                        TempTableUtil.update((String)contentSourceId, (int)1, (int)2);
                        status = 0;
                        message = "mpc\u63a5\u6536\u4efb\u52a1\u5931\u8d25\uff01";
                    }
                    System.out.println("cztv\u6570\u636e\u8fc1\u79fb\uff0cmpc\u540c\u6b65\u8fd4\u56de\u503c" + responseStr);
                }
            } else {
                status = 0;
                message = "partnerToken\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684partnerToken\u503c\uff01";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            status = 0;
            message = "cztv\u6570\u636e\u8fc1\u79fb\u51fa\u73b0\u5f02\u5e38" + e.getMessage();
            TempTableUtil.update((String)contentSourceId, (int)1, (int)1);
        }
        JSONObject jo = new JSONObject();
        jo.put((Object)"id", (Object)contentSourceId);
        jo.put((Object)"partnerCode", (Object)"sobeyVMS");
        jo.put((Object)"status", (Object)status);
        jo.put((Object)"message", (Object)message);
        jo.put((Object)"cmsId", (Object)cmsId);
        ServletOutputStream stream = resp.getOutputStream();
        stream.write(jo.toString().getBytes("UTF-8"));
        stream.flush();
        stream.close();
    }

    public String toMpc(CZTVDataMove move) throws Exception {
        VelocityUtil util = new VelocityUtil();
        String requestXml = util.getRequestXml("mpc-dataMove.vm", "move", (Object)move);
        System.out.println(new Date().getTime() + "\u6570\u636e\u8fc1\u79fb\u53d1\u5f80MPC\u6587\u4ef6\u7684\u62a5\u6587=======\u300b" + requestXml);
        String response = TransCodeSendMessage.sendMessage((String)requestXml, (String)"");
        return response;
    }

    private String getGUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }
}

