/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.interfaces;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.schema.SCMS_AccountSchema;
import com.sobey.bsp.schema.SCMS_AccountSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;

public class BlUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String allowOrigin = "*";
    private String allowMethods = "PUT,POST,GET,DELETE";

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Access-Control-Allow-Origin", "*");
        String callback = request.getParameter("callback");
        String uploadType = request.getParameter("type");
        String tenantID = request.getParameter("TenantID");
        JSONObject jo = new JSONObject();
        try {
            DBConnConfig defaultdcc = DBConnConfig.getDefaultDBConnConfigInstance();
            DBConnPool.setCurrent((DBConnConfig)defaultdcc);
            SCMS_AccountSchema schema = new SCMS_AccountSchema();
            schema.setTenantId(tenantID);
            SCMS_AccountSet set = schema.query();
            if (set == null || set.size() < 1) {
                jo.put((Object)"state", (Object)"false");
                jo.put((Object)"message", (Object)("\u672a\u627e\u5230\u79df\u6237[" + tenantID + "]\u5bf9\u5e94\u7ad9\u70b9\u4fe1\u606f\uff0c\u4e0a\u4f20\u89c6\u9891\u5931\u8d25"));
                return;
            }
            long siteId = set.get(0).getId();
            if (StringUtil.isEmpty((String)uploadType)) {
                uploadType = "video";
            }
            JSONArray dataArray = new JSONArray();
            DBConnPool.setDBConnPool((Long)siteId);
            String siteDomain = SiteUtil.getAlias((long)siteId);
            if (StringUtil.isNotEmpty((String)uploadType) && "video".equals(uploadType)) {
                DiskFileItemFactory fac = new DiskFileItemFactory();
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fac);
                upload.setSizeMax(-1073741824L);
                upload.setHeaderEncoding("UTF-8");
                List fileList = upload.parseRequest(request);
                for (FileItem item : fileList) {
                    if (item.isFormField()) continue;
                    String filename = item.getName();
                    String linuxVideoUploadDir = Config.getValue((String)"linuxVideoUploadDir");
                    SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
                    String timeDir = format.format(new Date());
                    String pathFile = linuxVideoUploadDir + siteDomain + "/source/web/" + timeDir + "/";
                    File file = new File(pathFile);
                    if (!file.exists()) {
                        file.mkdirs();
                        file.setExecutable(true);
                        file.setReadable(true);
                        file.setWritable(true);
                    }
                    String name = new Date().getTime() + filename.substring(filename.lastIndexOf("."));
                    long start = System.currentTimeMillis();
                    BufferedInputStream inputStream = new BufferedInputStream(new DataInputStream(item.getInputStream()));
                    BufferedOutputStream dstream = new BufferedOutputStream(new DataOutputStream(new FileOutputStream(new File(pathFile + name))));
                    byte[] b = new byte[1024];
                    int length = -1;
                    while ((length = inputStream.read(b)) != -1) {
                        dstream.write(b, 0, length);
                    }
                    dstream.flush();
                    dstream.close();
                    inputStream.close();
                    long end = System.currentTimeMillis();
                    String path = siteDomain + "/source/web/" + timeDir + "/" + name;
                    JSONObject items = new JSONObject();
                    items.put((Object)"url", (Object)path);
                    items.put((Object)"filename", (Object)filename);
                    items.put((Object)"path", (Object)(pathFile + name));
                    items.put((Object)"time", (Object)(end - start));
                    dataArray.add((Object)items);
                }
                jo.put((Object)"data", (Object)dataArray);
                jo.put((Object)"state", (Object)"true");
            }
        }
        catch (Exception e) {
            jo.put((Object)"state", (Object)"false");
            jo.put((Object)"message", (Object)"\u4e0a\u4f20\u89c6\u9891\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef\uff0c\u4e0a\u4f20\u5931\u8d25");
        }
        String result = jo.toString();
        if (StringUtil.isNotEmpty((String)callback)) {
            result = callback + "(" + jo.toString() + ")";
        }
        this.writeJson(result, response);
    }

    protected void writeJson(String str, HttpServletResponse response) {
        if (StringUtils.isEmpty((String)str)) {
            str = "";
        }
        try {
            PrintWriter out = response.getWriter();
            out.write(str);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

