/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.interfaces;

import com.sobey.bsp.cms.site.MpcTranscode;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.cms.interfaces.mpc.util.MPCResponseXML;
import java.util.Collection;
import java.util.List;
import javax.jws.WebService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
public class MPCMixService {
    private static final Logger log = LoggerFactory.getLogger(MPCMixService.class);

    public String Commit(String msg) {
        log.info(" ------------mpc\u5408\u6210\u56de\u8c03\u53c2\u6570:" + msg);
        try {
            Document document = DocumentHelper.parseText((String)msg);
            int responseStatus = this.getResponseStatus(document);
            if (256 != responseStatus && responseStatus != 8 && responseStatus != 2048) {
                return null;
            }
            String siteId = this.getSiteId(document);
            int businessType = this.getBusinessType(document);
            String contentSourceId = this.getContentSourceId(document);
            List mediaFile = document.selectNodes("//MPCNotify//MediaFile");
            String backUploadUrl = this.getBackUploadUrl(mediaFile);
            DBConnPool.setDBConnPool((Long)Long.parseLong(siteId));
            String status = "0";
            boolean isSuccess = this.getBusinessResult(responseStatus);
            if (MpcTranscode.mpcMixCallBack((boolean)isSuccess, (String)contentSourceId, (String)backUploadUrl, (long)Long.parseLong(siteId), (int)businessType)) {
                status = "1";
            }
            MPCResponseXML mpcResponseXML = new MPCResponseXML();
            return mpcResponseXML.responseXml(status);
        }
        catch (Exception e) {
            log.error("MPC\u56de\u8c03\u5904\u7406\u9047\u5230\u5f02\u5e38:", (Throwable)e);
            return "MPC\u5408\u6210\u5931\u8d25";
        }
    }

    private int getResponseStatus(Document document) {
        int responseStatus = 0;
        Node NotifyEventNode = document.selectSingleNode("//MPCNotify//NotifyEvent");
        if (null != NotifyEventNode) {
            responseStatus = Integer.parseInt(NotifyEventNode.getText());
        }
        return responseStatus;
    }

    private String getSiteId(Document document) {
        String siteId = null;
        Node siteNode = document.selectSingleNode("//MPCNotify//TaskInfo//Data//siteid");
        if (null != siteNode) {
            siteId = siteNode.getText();
        }
        return siteId;
    }

    private int getBusinessType(Document document) {
        int businessType = 0;
        Node businessTypeNode = document.selectSingleNode("//MPCNotify//TaskInfo//Data//businessType");
        if (null != businessTypeNode && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{businessTypeNode.getText()})) {
            businessType = Integer.parseInt(businessTypeNode.getText());
        }
        return businessType;
    }

    private String getContentSourceId(Document document) {
        String contentSourceId = null;
        Node taskGUIDNode = document.selectSingleNode("//MPCNotify//TaskGUID");
        if (null != taskGUIDNode) {
            contentSourceId = taskGUIDNode.getText();
        }
        return contentSourceId;
    }

    private boolean getBusinessResult(int responseStatus) {
        boolean isSuccess = false;
        if (256 == responseStatus) {
            isSuccess = true;
        }
        return isSuccess;
    }

    private String getBackUploadUrl(List mediaFile) {
        if (CollectionUtils.isEmpty((Collection)mediaFile)) {
            return null;
        }
        for (int i = 0; i < mediaFile.size(); ++i) {
            Node node = (Node)mediaFile.get(i);
            String groupType = node.selectSingleNode("GroupType").getText();
            String mediaType = node.selectSingleNode("MediaType").getText();
            if (!"RealOut".equals(groupType) || !"Media".equals(mediaType)) continue;
            return node.selectSingleNode("FileName").getText();
        }
        return null;
    }
}

