/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.interfaces;

import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.DataRow;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_ContentInfoLogSchema;
import com.sobey.bsp.schema.SCMS_PushloginfoSchema;
import com.sobey.bsp.schema.SCMS_PushstatusSchema;
import java.util.Date;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPCMoveBackService {
    private static final Logger log = LoggerFactory.getLogger(MPCMoveBackService.class);

    public void Commit(String msg) {
        try {
            log.info("\u6536\u5230\u89c6\u9891\u56de\u8fc1MPC\u56de\u8c03\u62a5\u6587" + msg);
            Document document = DocumentHelper.parseText((String)msg);
            int status = Integer.parseInt(document.selectSingleNode("MPC//Content//MPCNotify//NotifyEvent").getText());
            String contentInfoLogId = document.selectSingleNode("MPC//Content//MPCNotify//TaskInfo//Data//contentInfoLogID").getText();
            Long siteId = Long.parseLong(document.selectSingleNode("MPC//Content//MPCNotify//TaskInfo//Data//siteid").getText());
            DBConnPool.setDBConnPool((Long)siteId);
            SCMS_ContentInfoLogSchema scmsContentInfoLogSchema = this.updateActionDetail(status, contentInfoLogId);
            this.recordPushLogIfRequired(scmsContentInfoLogSchema.getContentId(), status);
        }
        catch (DocumentException e) {
            log.error("\u6536\u5230\u89c6\u9891\u56de\u8fc1MPC\u56de\u8c03\u62a5\u6587\u9047\u5230\u5f02\u5e38", (Throwable)e);
        }
    }

    private SCMS_ContentInfoLogSchema updateActionDetail(int status, String contentInfoLogId) {
        SCMS_ContentInfoLogSchema scmsContentInfoLogSchema = new SCMS_ContentInfoLogSchema();
        scmsContentInfoLogSchema.setID(contentInfoLogId);
        scmsContentInfoLogSchema.fill();
        scmsContentInfoLogSchema.setActionDetail(this.getMessage(status));
        Transaction transaction = new Transaction();
        transaction.update((Schema)scmsContentInfoLogSchema);
        transaction.commit();
        return scmsContentInfoLogSchema;
    }

    private void recordPushLogIfRequired(long contentId, int status) {
        QueryBuilder pushLogInfoQueryBuilder = new QueryBuilder("select ContentID,InterfacesID, Operation, status,partnerCode,endTime  from scms_pushloginfo where contentId =" + contentId + " and partnerCode=" + "'VideoBack'");
        DataTable pushLogInfoDataTable = pushLogInfoQueryBuilder.executeDataTable();
        if (pushLogInfoDataTable == null || pushLogInfoDataTable.getRowCount() == 0) {
            return;
        }
        String message = this.getMessage(status);
        Integer backStatus = this.getBackStatus(status);
        for (int i = 0; i < pushLogInfoDataTable.getRowCount(); ++i) {
            Transaction transaction = new Transaction();
            DataRow dataRow = pushLogInfoDataTable.get(i);
            SCMS_PushloginfoSchema scmsPushloginfoSchema = this.buildScmsPushLogInfoSchema(message, backStatus, dataRow);
            transaction.add((Schema)scmsPushloginfoSchema, 1);
            SCMS_PushstatusSchema scmsPushstatusSchema = this.buildScmsPushStatusSchema(backStatus, dataRow);
            transaction.add((Schema)scmsPushstatusSchema, 1);
            transaction.commit();
        }
    }

    private Integer getBackStatus(int status) {
        Integer backStatus = null;
        backStatus = 1 == status ? Integer.valueOf(2) : (256 == status ? Integer.valueOf(1) : Integer.valueOf(0));
        return backStatus;
    }

    private String getMessage(int status) {
        String message = null;
        message = 1 == status ? "MPC\u5df2\u5f00\u59cb\u505a\u56de\u8fc1\u4efb\u52a1!" : (256 == status ? "\u56de\u8fc1\u4efb\u52a1\u5904\u7406\u6210\u529f!" : "MPC\u505a\u56de\u8fc1\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38!");
        return message;
    }

    private SCMS_PushstatusSchema buildScmsPushStatusSchema(Integer backStatus, DataRow dataRow) {
        long pushStatusID = NoUtil.getMaxID((String)"PushStatusID");
        SCMS_PushstatusSchema scmsPushstatusSchema = new SCMS_PushstatusSchema();
        scmsPushstatusSchema.setId(Long.valueOf(pushStatusID));
        scmsPushstatusSchema.setContentID(Long.valueOf(dataRow.getLong("ContentID")));
        scmsPushstatusSchema.setInterfacesID(Long.valueOf(dataRow.getLong("InterfacesID")));
        scmsPushstatusSchema.setStatus(backStatus);
        scmsPushstatusSchema.setOperation(dataRow.getString("Operation"));
        scmsPushstatusSchema.setPushTime(new Date());
        return scmsPushstatusSchema;
    }

    private SCMS_PushloginfoSchema buildScmsPushLogInfoSchema(String message, Integer backStatus, DataRow dataRow) {
        long pushLogInfoID = NoUtil.getMaxID((String)"PushLogInfoID");
        SCMS_PushloginfoSchema scmsPushloginfoSchema = new SCMS_PushloginfoSchema();
        scmsPushloginfoSchema.setId(Long.valueOf(pushLogInfoID));
        scmsPushloginfoSchema.setInterfacesid(Long.valueOf(dataRow.getLong("InterfacesID")));
        scmsPushloginfoSchema.setContentid(Long.valueOf(dataRow.getLong("ContentID")));
        scmsPushloginfoSchema.setOperation(dataRow.getString("Operation"));
        scmsPushloginfoSchema.setStatus(backStatus);
        scmsPushloginfoSchema.setMessage(message);
        scmsPushloginfoSchema.setPartnerCode(dataRow.getString("partnerCode"));
        scmsPushloginfoSchema.setBeginTime(dataRow.getDate("endTime"));
        scmsPushloginfoSchema.setEndTime(new Date());
        scmsPushloginfoSchema.setPushNum(Integer.valueOf(1));
        return scmsPushloginfoSchema;
    }
}

