/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.interfaces;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.cms.site.SiteDefaultUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.UserLog;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_CatalogSchema;
import com.sobey.bsp.schema.SCMS_ContentInfoLogSchema;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.bsp.util.StringsUtil;
import com.sobey.cms.interfaces.MakingTranscodeUploadServlet;
import com.sobey.scms.contentinfo.interfaces.impl.CatalogInterfaceImpl;
import com.sobey.scms.contentinfo.interfaces.util.ContentUtil;
import com.sobey.scms.search.ContentSearchMediator;
import com.sobey.scms.trasncode.MPCCall;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class MakingTranscodeUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        String uploadType = request.getParameter("type");
        String siteId = request.getParameter("siteid");
        String isPublish = request.getParameter("isPublish");
        if (StringUtil.isEmpty((String)isPublish)) {
            isPublish = "0";
        }
        JSONObject jo = new JSONObject();
        try {
            String contentinfo = request.getParameter("contentinfo");
            if (StringUtil.isNotEmpty((String)contentinfo)) {
                contentinfo = new String(contentinfo.getBytes("iso8859-1"), "UTF-8");
            }
            if (StringUtil.isNotEmpty((String)siteId)) {
                DBConnPool.setDBConnPool((Long)Long.parseLong(siteId));
                String siteDomain = SiteUtil.getAlias((String)siteId);
                if (StringUtil.isNotEmpty((String)uploadType) && "video".equals(uploadType)) {
                    DiskFileItemFactory fac = new DiskFileItemFactory();
                    ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fac);
                    upload.setSizeMax(-1073741824L);
                    upload.setHeaderEncoding("UTF-8");
                    List fileList = upload.parseRequest(request);
                    for (FileItem item : fileList) {
                        if (item.isFormField()) continue;
                        String filename = item.getName();
                        String linuxVideoUploadDir = Config.getValue((String)"linuxVideoUploadDir");
                        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
                        String timeDir = format.format(new Date());
                        String pathFile = linuxVideoUploadDir + siteDomain + "/source/web/" + timeDir + "/";
                        File file = new File(pathFile);
                        if (!file.exists()) {
                            file.mkdirs();
                            file.setExecutable(true);
                            file.setReadable(true);
                            file.setWritable(true);
                        }
                        String name = new Date().getTime() + filename.substring(filename.lastIndexOf("."));
                        long start = System.currentTimeMillis();
                        BufferedInputStream inputStream = new BufferedInputStream(new DataInputStream(item.getInputStream()));
                        BufferedOutputStream dstream = new BufferedOutputStream(new DataOutputStream(new FileOutputStream(new File(pathFile + name))));
                        byte[] b = new byte[1024];
                        int length = -1;
                        while ((length = inputStream.read(b)) != -1) {
                            dstream.write(b, 0, length);
                        }
                        dstream.flush();
                        dstream.close();
                        inputStream.close();
                        String path = "/source/web/" + timeDir + "/" + name;
                        long end = System.currentTimeMillis() - start;
                        String contentSourceId = UUID.randomUUID().toString().replaceAll("-", "");
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("path", path);
                        map.put("fileName", filename);
                        map.put("siteId", siteId);
                        map.put("siteName", SiteUtil.getAlias((String)siteId));
                        map.put("isPublish", isPublish);
                        map.put("contentSourceId", contentSourceId);
                        map.put("contentinfo", contentinfo);
                        TransCodeThread thread = new TransCodeThread(this, map);
                        thread.start();
                        jo.put((Object)"backUploadUrl", (Object)path);
                        jo.put((Object)"fileName", (Object)filename);
                        jo.put((Object)"id", (Object)contentSourceId);
                        jo.put((Object)"status", (Object)1);
                        jo.put((Object)"message", (Object)"\u4e0a\u4f20\u89c6\u9891\u6210\u529f");
                        System.out.println("+++++++++++time=" + end);
                    }
                }
            } else {
                jo.put((Object)"status", (Object)0);
                jo.put((Object)"message", (Object)"\u4e0a\u4f20\u53c2\u6570siteid\u4e3a\u7a7a\uff0c\u4e0a\u4f20\u89c6\u9891\u5931\u8d25");
            }
        }
        catch (Exception e) {
            jo.put((Object)"status", (Object)0);
            jo.put((Object)"message", (Object)"\u4e0a\u4f20\u89c6\u9891\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef\uff0c\u4e0a\u4f20\u5931\u8d25");
        }
        response.getWriter().print(jo.toString());
    }

    public void makingTransCodeMethod(Map map) {
        Transaction transaction = new Transaction();
        String name = (String)map.get("fileName");
        String isPublish = (String)map.get("isPublish");
        long siteId = Long.parseLong((String)map.get("siteId"));
        String alias = (String)map.get("siteName");
        DBConnPool.setDBConnPool((Long)siteId);
        String username = "\u62cd\u5ba2\u4e0a\u4f20";
        String winVideoUploadDir = Config.getValue((String)"winVideoUploadDir");
        try {
            String description;
            String path = (String)map.get("path");
            String videourl = StringUtil.replaceAllToBack_Slant((String)(winVideoUploadDir + SiteUtil.getAlias((long)siteId) + "/" + path));
            String dataInfo = (String)map.get("contentinfo");
            JSONObject jo = JSONObject.fromObject((Object)dataInfo);
            String transcodeid = jo.has("transcodeGroup") ? jo.getString("transcodeGroup") : "0";
            String catalogId = jo.has("catalogId") ? jo.getString("catalogId") : SiteDefaultUtil.getDefalutCatalogId((Long)siteId, (int)5);
            String tag = jo.has("tags") ? jo.getString("tags") : "";
            String string = description = jo.has("description") ? jo.getString("description") : "";
            if ((StringUtil.isEmpty((String)transcodeid) || "0".equals(transcodeid)) && StringUtil.isNotEmpty((String)catalogId)) {
                SCMS_CatalogSchema sc = new SCMS_CatalogSchema();
                sc.setID(Long.valueOf(catalogId).longValue());
                sc.fill();
                if (null != sc.getTransCodeId() && StringUtil.isNotEmpty((String)String.valueOf(sc.getTransCodeId()))) {
                    transcodeid = String.valueOf(sc.getTransCodeId());
                } else {
                    SiteDefaultUtil.getDefalutTransCodeId((Long)siteId, (int)5);
                }
            }
            if (name.indexOf(".") != -1) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            name = jo.has("title") && StringUtil.isNotEmpty((String)jo.getString("title")) ? jo.getString("title") : name;
            Date now = new Date();
            String contentSourceId = (String)map.get("contentSourceId");
            if (name.length() > 90) {
                name = name.substring(0, 90);
            }
            name = StringsUtil.esSpecialNumeric((String)name);
            name = ContentUtil.getTitle((String)name, (int)5, (int)0);
            Long contentId = NoUtil.getMaxID((String)"ContentID");
            SCMS_ContentinfoSchema contentinfo = new SCMS_ContentinfoSchema();
            contentinfo.setContentID(contentId);
            contentinfo.setContentSourceId(contentSourceId);
            contentinfo.setTitle(name);
            contentinfo.setCreateTime(now);
            contentinfo.setDescription(description);
            contentinfo.setModifyTime(now);
            contentinfo.setCreatorName(username);
            contentinfo.setPath(path);
            contentinfo.setIsSourceVideo(Integer.valueOf(0));
            contentinfo.setMediaPathType(Integer.valueOf(1));
            contentinfo.setSourceSystemID(Integer.valueOf(1));
            contentinfo.setSourceSystemName(transcodeid);
            contentinfo.setTranscodeid(Integer.valueOf(Integer.parseInt(transcodeid)));
            contentinfo.setIsSourceVideo(Integer.valueOf(0));
            contentinfo.setIsPublish(Integer.valueOf(isPublish == null ? 0 : Integer.parseInt(isPublish)));
            contentinfo.setStatus(Long.valueOf(2L));
            contentinfo.setTag(tag);
            contentinfo.setProgramLength("");
            contentinfo.setSiteid(Long.valueOf(siteId));
            contentinfo.setKeyFrame("");
            contentinfo.setCatalogid(catalogId);
            CatalogInterfaceImpl catalog = new CatalogInterfaceImpl();
            contentinfo.setCatalogInnerCode(catalog.getCatalogInnerCode(Long.parseLong(catalogId)));
            SCMS_ContentInfoLogSchema log = new SCMS_ContentInfoLogSchema();
            log.setID(NoUtil.getMaxID((String)"ContentInfoLogId"));
            log.setAction("INSERT");
            log.setContentId(contentId.longValue());
            log.setActionDetail("\u89c6\u9891HTTP\u4e0a\u4f20\u5165\u5e93");
            log.setAddTime(now);
            log.setAddUser(username);
            transaction.add((Schema)log, 1);
            transaction.add((Schema)contentinfo, 1);
            if (transaction.commit()) {
                UserLog.log((String)"Video", (String)"CreateVideo", (String)("\u89c6\u9891" + name + "\u5165\u5e93\u6210\u529f"), (String)"\u62cd\u5ba2\u4e0a\u4f20", (String)username);
                ContentSearchMediator.publishVideo2Search((String)String.valueOf(contentId), (String)alias, (long)siteId);
                MPCCall.generateXml((String)videourl, (String)transcodeid, (String)contentSourceId, (String)name, (long)siteId, (String)"", (String)"");
            } else {
                UserLog.log((String)"Video", (String)"CreateVideo", (String)("\u89c6\u9891" + name + "\u5165\u5e93\u5931\u8d25"), (String)"\u62cd\u5ba2\u4e0a\u4f20", (String)username);
            }
            transaction.clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            transaction.clear();
            UserLog.log((String)"Video", (String)"CreateVideo", (String)("\u89c6\u9891" + name + "\u5165\u5e93\u5931\u8d25"), (String)"\u62cd\u5ba2\u4e0a\u4f20", (String)username);
        }
    }
}

