/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.interfaces;

import com.sobey.bsp.framework.SiteConfig;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_AccountSchema;
import com.sobey.bsp.schema.SCMS_AccountSet;
import com.sobey.bsp.schema.SCMS_ContentInfoLogSchema;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.bsp.util.StringsUtil;
import com.sobey.cms.interfaces.sonInterfaces.impl.AudioInterfaceImpl;
import com.sobey.cms.interfaces.sonInterfaces.impl.CatalogInterfaceImpl;
import com.sobey.cms.interfaces.sonInterfaces.impl.ChannelInterfaceImpl;
import com.sobey.cms.interfaces.sonInterfaces.impl.CmstopInterfaceImpl;
import com.sobey.cms.interfaces.sonInterfaces.impl.PlayerInterfaceImpl;
import com.sobey.cms.interfaces.sonInterfaces.impl.SeriesInterfaceImpl;
import com.sobey.cms.interfaces.sonInterfaces.impl.SiteCommonInterfaceImpl;
import com.sobey.cms.interfaces.sonInterfaces.impl.VideoInterfaceImpl;
import com.sobey.cms.interfaces.sonInterfaces.impl.VirChannelInterfaceImpl;
import com.sobey.cms.util.InterfacesMethod;
import com.sobey.cms.util.InterfacesUtil;
import com.sobey.scms.contentinfo.DemandAudioLib;
import com.sobey.scms.contentinfo.DemandVideoLib;
import com.sobey.scms.contentinfo.DemandVideoUtil;
import com.sobey.scms.contentinfo.interfaces.util.ContentUtil;
import com.sobey.scms.recycle.AssignmentLib;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class ServiceInterfaceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public JSONObject doCheckPermission(HttpServletRequest request, HttpServletResponse response) {
        JSONObject resultJo = new JSONObject();
        resultJo.put((Object)"code", (Object)0);
        resultJo.put((Object)"message", (Object)"\u8bf7\u6c42\u6743\u9650\u6821\u9a8c\u5931\u8d25");
        try {
            request.setCharacterEncoding("UTF-8");
            response.setCharacterEncoding("UTF-8");
            String siteId = "";
            String token = request.getParameter("partnerToken");
            String tenantid = request.getParameter("tenantid");
            String type = request.getParameter("type");
            if ("cmstop".equals(type)) {
                token = request.getParameter("authkey");
            }
            if (StringUtil.isNotEmpty((String)token)) {
                DBConnPool.setCurrent((DBConnConfig)DBConnConfig.getDefaultDBConnConfigInstance());
                siteId = InterfacesMethod.getSiteIdByToken((String)token);
                if ("false".equals(siteId)) {
                    resultJo.put((Object)"message", (Object)"\u60a8\u8f93\u5165\u7684partnerToken\u503c\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684partnerToken\u503c\uff01");
                    throw new RuntimeException();
                }
                DBConnPool.setDBConnPool((Long)Long.parseLong(siteId));
                if (!InterfacesMethod.isUserAuthenticated((String)token)) {
                    resultJo.put((Object)"message", (Object)"\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u63a5\u53e3\u6216\u8005\u8be5\u63a5\u53e3\u5df2\u7ecf\u88ab\u505c\u7528! ");
                    throw new RuntimeException();
                }
            } else if (StringUtil.isNotEmpty((String)tenantid)) {
                DBConnConfig defaultdcc = DBConnConfig.getDefaultDBConnConfigInstance();
                DBConnPool.setCurrent((DBConnConfig)defaultdcc);
                SCMS_AccountSchema schema = new SCMS_AccountSchema();
                schema.setTenantId(tenantid);
                SCMS_AccountSet set = schema.query();
                if (set == null || set.size() < 1) {
                    resultJo.put((Object)"message", (Object)("\u6821\u9a8c\u5931\u8d25\uff0c\u65e0\u6cd5\u627e\u5230\u79df\u6237[" + tenantid + "]\u5bf9\u5e94\u7684\u7ad9\u70b9"));
                    throw new RuntimeException();
                }
                siteId = set.get(0).getId() + "";
            } else {
                resultJo.put((Object)"message", (Object)"partnerToken \u6216\u8005 tenantid \u4e0d\u80fd\u90fd\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
                throw new RuntimeException();
            }
            resultJo.put((Object)"siteId", (Object)siteId);
            resultJo.put((Object)"token", (Object)token);
            resultJo.put((Object)"code", (Object)1);
            resultJo.put((Object)"message", (Object)"OK");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultJo;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String callback = request.getParameter("callback");
        JSONObject checkJo = this.doCheckPermission(request, response);
        if (checkJo.getInt("code") == 0) {
            if (StringUtil.isNotEmpty((String)callback)) {
                InterfacesUtil.writeJson((String)(callback + "(" + checkJo.getString("message") + ")"), (HttpServletResponse)response);
            } else {
                InterfacesUtil.writeJson((String)checkJo.getString("message"), (HttpServletResponse)response);
            }
            return;
        }
        String token = "";
        if (checkJo.has("token")) {
            token = checkJo.getString("token");
        }
        String siteId = checkJo.getString("siteId");
        String type = request.getParameter("type");
        String result = "";
        DBConnConfig defaultdcc = DBConnConfig.getDefaultDBConnConfigInstance();
        DBConnPool.setCurrent((DBConnConfig)defaultdcc);
        Map map = InterfacesMethod.checkExpiredTime((String)siteId);
        result = (String)map.get("finalResult");
        if (StringUtil.isEmpty((String)result)) {
            if ("cmstop".equals(type)) {
                DBConnPool.setDBConnPool((Long)Long.parseLong(siteId));
                String doMethod = request.getParameter("do");
                result = this.doActionCmstop(request, siteId, doMethod, map);
            } else {
                String method = request.getParameter("method");
                if (!"getAccountList".equalsIgnoreCase(method)) {
                    DBConnPool.setDBConnPool((Long)Long.parseLong(siteId));
                } else {
                    DBConnPool.setCurrent((DBConnConfig)defaultdcc);
                }
                result = this.doAction(request, siteId, method, token);
            }
        }
        if (StringUtil.isNotEmpty((String)callback)) {
            InterfacesUtil.writeJson((String)(callback + "(" + result + ")"), (HttpServletResponse)response);
        } else {
            InterfacesUtil.writeJson((String)result, (HttpServletResponse)response);
        }
    }

    private String doActionCmstop(HttpServletRequest request, String siteId, String doMethod, Map map) {
        String result = "";
        if ("get_category".equalsIgnoreCase(doMethod)) {
            CmstopInterfaceImpl cmstop = new CmstopInterfaceImpl();
            result = cmstop.get_category(request);
        } else if ("get_video".equalsIgnoreCase(doMethod)) {
            CmstopInterfaceImpl cmstop = new CmstopInterfaceImpl();
            result = cmstop.get_video(request);
        } else if ("get_live".equalsIgnoreCase(doMethod)) {
            CmstopInterfaceImpl cmstop = new CmstopInterfaceImpl();
            result = cmstop.get_live(request, (String)map.get("userName"), siteId);
        }
        return result;
    }

    private String doAction(HttpServletRequest request, String siteId, String method, String token) {
        String result = "";
        if ("authenticate".equalsIgnoreCase(method)) {
            SiteCommonInterfaceImpl sci = new SiteCommonInterfaceImpl();
            result = sci.authenticate(token);
        } else if ("getAccountList".equalsIgnoreCase(method)) {
            SiteCommonInterfaceImpl sci = new SiteCommonInterfaceImpl();
            result = sci.getAccountList(request);
        } else if ("getCatalogList".equalsIgnoreCase(method)) {
            CatalogInterfaceImpl cii = new CatalogInterfaceImpl();
            result = cii.getCatalogList(request);
        } else if ("getVideoList".equalsIgnoreCase(method)) {
            VideoInterfaceImpl video = new VideoInterfaceImpl();
            result = video.getVideoList(request, siteId);
        } else if ("getChannelList".equalsIgnoreCase(method)) {
            ChannelInterfaceImpl channel = new ChannelInterfaceImpl();
            result = channel.getChannelList(request, siteId);
        } else if ("getChannelById".equalsIgnoreCase(method)) {
            ChannelInterfaceImpl channel = new ChannelInterfaceImpl();
            result = channel.getChannelById(request, siteId);
        } else if ("getSeriesList".equalsIgnoreCase(method)) {
            SeriesInterfaceImpl series = new SeriesInterfaceImpl();
            result = series.getSeriesList(request, siteId);
        } else if ("getSeriesById".equalsIgnoreCase(method)) {
            SeriesInterfaceImpl series = new SeriesInterfaceImpl();
            result = series.getSeriesById(request, siteId);
        } else if ("getVideoById".equalsIgnoreCase(method)) {
            VideoInterfaceImpl video = new VideoInterfaceImpl();
            result = video.getVideoById(request, siteId);
        } else if ("getSeriesInfo".equalsIgnoreCase(method)) {
            SeriesInterfaceImpl series = new SeriesInterfaceImpl();
            result = series.getSeriesInfo(request);
        } else if ("getAudioList".equalsIgnoreCase(method)) {
            AudioInterfaceImpl audio = new AudioInterfaceImpl();
            result = audio.getAudioList(request, siteId);
        } else if ("getAudioById".equalsIgnoreCase(method)) {
            AudioInterfaceImpl audio = new AudioInterfaceImpl();
            result = audio.getAudioById(request, siteId);
        } else if ("getChannelActList".equalsIgnoreCase(method)) {
            ChannelInterfaceImpl channel = new ChannelInterfaceImpl();
            result = channel.getChannelActList(request, siteId);
        } else if ("getVirChannelList".equalsIgnoreCase(method)) {
            VirChannelInterfaceImpl virChannel = new VirChannelInterfaceImpl();
            result = virChannel.getVirChannelList(request, siteId);
        } else if ("getVirChannelById".equalsIgnoreCase(method)) {
            VirChannelInterfaceImpl virChannel = new VirChannelInterfaceImpl();
            result = virChannel.getVirChannelById(request, siteId);
        } else if ("getVirChannelActList".equalsIgnoreCase(method)) {
            VirChannelInterfaceImpl virChannel = new VirChannelInterfaceImpl();
            result = virChannel.getVirChannelActList(request, siteId);
        } else if ("deleteDataByIds".equalsIgnoreCase(method)) {
            result = this.deleteDataByIds(request);
        } else if ("getSiteInfo".equalsIgnoreCase(method)) {
            SiteCommonInterfaceImpl sci = new SiteCommonInterfaceImpl();
            result = sci.getSiteInfo();
        } else if ("getTranscode".equalsIgnoreCase(method)) {
            SiteCommonInterfaceImpl sci = new SiteCommonInterfaceImpl();
            result = sci.getTranscode(request);
        } else if ("updateDataById".equalsIgnoreCase(method)) {
            result = this.updateDataById(request, siteId);
        } else if ("getCountByIds".equalsIgnoreCase(method)) {
            result = this.getCountByIds(request, siteId);
        } else if ("getPlayerList".equalsIgnoreCase(method)) {
            PlayerInterfaceImpl player = new PlayerInterfaceImpl();
            result = player.getPlayerList(request, siteId);
        } else if ("getPlayerListNotPage".equals(method)) {
            PlayerInterfaceImpl player = new PlayerInterfaceImpl();
            result = player.getPlayerListNotPage(request, siteId);
        } else if ("getPlayerById".equalsIgnoreCase(method)) {
            PlayerInterfaceImpl player = new PlayerInterfaceImpl();
            result = player.getPlayerById(request, siteId);
        } else if ("updateVideoById".equalsIgnoreCase(method)) {
            result = this.updateVideoById(request, siteId);
        }
        return result;
    }

    private String updateVideoById(HttpServletRequest request, String siteid) {
        String finalResult = "faile";
        String title = request.getParameter("title");
        String desc = request.getParameter("description");
        String contentsourceid = request.getParameter("videoId");
        String[] contentIds = new String[1];
        if (StringUtil.isNotEmpty((String)contentsourceid)) {
            Transaction tran = new Transaction();
            SCMS_ContentinfoSchema contentinfo = new SCMS_ContentinfoSchema();
            contentinfo.setContentSourceId(contentsourceid);
            if (contentinfo.query() == null || contentinfo.query().size() < 1) {
                finalResult = "\u60a8\u8f93\u5165\u7684videoId\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684videoId";
                return "\u60a8\u8f93\u5165\u7684videoId\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684videoId";
            }
            contentinfo = contentinfo.query().get(0);
            contentIds[0] = contentinfo.getContentID().toString();
            String sourceSystemName = ContentUtil.updateTitleForJson((String)title, (long)contentinfo.getStatus(), (String)contentinfo.getSourceSystemName());
            String tsPlayUrl = ContentUtil.updateTitleForJson((String)title, (long)contentinfo.getStatus(), (String)contentinfo.getTsPlayUrl());
            String mp4PlayUrl = ContentUtil.updateTitleForJson((String)title, (long)contentinfo.getStatus(), (String)contentinfo.getMp4PlayUrl());
            contentinfo.setTitle(title);
            contentinfo.setDescription(desc);
            contentinfo.setSourceSystemName(sourceSystemName);
            contentinfo.setTsPlayUrl(tsPlayUrl);
            contentinfo.setModifyTime(new Date());
            contentinfo.setModifyUser(User.getUserName());
            tran.add((Schema)contentinfo, 2);
            if (tran.commit()) {
                try {
                    SCMS_ContentInfoLogSchema log = new SCMS_ContentInfoLogSchema();
                    log.setID(NoUtil.getMaxID((String)"ContentInfoLogId"));
                    log.setContentId(contentinfo.getContentID().longValue());
                    log.setAction("UPDATE");
                    log.setActionDetail("\u62cd\u5ba2\u66f4\u6539\u89c6\u9891\u6807\u9898");
                    log.setAddTime(new Date());
                    log.setAddUser("admin");
                    tran.add((Schema)log, 1);
                    if (tran.commit()) {
                        DemandVideoLib.generateStaticVideoFile((String)String.valueOf(contentinfo.getStatus()), (String[])contentIds, (String)siteid, (String)sourceSystemName, (String)tsPlayUrl, (String)mp4PlayUrl, null);
                        finalResult = "success";
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            finalResult = "\u60a8\u8f93\u5165\u7684videoId\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684videoId";
        }
        return finalResult;
    }

    private String getCountByIds(HttpServletRequest request, String siteId) {
        String finalResult = "";
        String sourceIds = request.getParameter("sourceIds");
        JSONObject resultJson = new JSONObject();
        try {
            if (StringUtil.isEmpty((String)sourceIds)) {
                finalResult = "\u5220\u9664\u7684\u5143\u6570\u636eID\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\uff01";
                return finalResult;
            }
            String playCountTag = (String)SiteConfig.getValue((Long)Long.parseLong(siteId), (Object)"playCountTag");
            if (StringUtil.isEmpty((String)playCountTag) || !"1".equals(playCountTag)) {
                finalResult = "\u8be5\u7ad9\u70b9\u6ca1\u6709\u5f00\u542f\u7edf\u8ba1\u7edf\u8ba1\u529f\u80fd\uff0c\u65e0\u6cd5\u67e5\u8be2\u64ad\u653e\u6b21\u6570\uff01";
                return finalResult;
            }
            JSONArray mediaJa = new JSONArray();
            String[] contentSourceIds = sourceIds.split(",");
            for (int i = 0; i < contentSourceIds.length; ++i) {
                if (!StringUtil.isNotEmpty((String)contentSourceIds[i])) continue;
                long hitCount = DemandVideoUtil.getVideoHitCount((long)Long.parseLong(siteId), (String)contentSourceIds[i]);
                JSONObject jo = new JSONObject();
                jo.put((Object)"id", (Object)contentSourceIds[i]);
                jo.put((Object)"hitCount", (Object)hitCount);
                mediaJa.add((Object)jo);
            }
            resultJson.put((Object)"video", (Object)mediaJa);
            finalResult = resultJson.toString();
        }
        catch (Exception e) {
            finalResult = "\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u4e0d\u80fd\u83b7\u53d6\u64ad\u653e\u6b21\u6570\uff01";
        }
        return finalResult;
    }

    private String updateDataById(HttpServletRequest request, String siteId) {
        String finalResult = "";
        String sourceType = request.getParameter("sourceType");
        String sourceId = request.getParameter("sourceId");
        String sourceTitle = request.getParameter("sourceTitle");
        if (StringUtil.isEmpty((String)sourceId)) {
            finalResult = "\u66f4\u65b0\u7684\u5143\u6570\u636esourceId\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\uff01";
            return finalResult;
        }
        if (StringUtil.isEmpty((String)sourceType)) {
            finalResult = "\u66f4\u65b0\u7684\u5143\u6570\u636esourceType\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\uff01";
            return finalResult;
        }
        if (StringUtil.isEmpty((String)sourceTitle)) {
            finalResult = "\u6807\u9898\u4e0d\u80fd\u6539\u4e3a\u7a7a\u503c,\u8bf7\u68c0\u67e5\u4f20\u5165\u7684sourceTitle\u53c2\u6570\uff01";
            return finalResult;
        }
        JSONObject resultJson = new JSONObject();
        sourceTitle = StringsUtil.esSpecialNumeric((String)sourceTitle);
        Transaction trans = new Transaction();
        String[] contentIds = new String[1];
        String sql = "";
        try {
            String sourceSystemName = "";
            String tsPlayUrl = "";
            String mp4PlayUrl = "";
            long status = 0L;
            if ("5".equals(sourceType)) {
                String selectSql = "select sourcesystemname,tsPlayUrl,mp4PlayUrl,status,contentId from scms_contentinfo where contentsourceid='" + sourceId + "'";
                DataTable dt = new QueryBuilder(selectSql).executeDataTable();
                if (dt != null && dt.getRowCount() > 0) {
                    sourceSystemName = dt.getString(0, "sourceSystemName");
                    tsPlayUrl = dt.getString(0, "tsPlayUrl");
                    mp4PlayUrl = dt.getString(0, "mp4PlayUrl");
                    status = dt.getLong(0, "status");
                    contentIds[0] = dt.getString(0, "contentId");
                    sourceSystemName = ContentUtil.updateTitleForJson((String)sourceTitle, (long)status, (String)sourceSystemName);
                    tsPlayUrl = ContentUtil.updateTitleForJson((String)sourceTitle, (long)status, (String)tsPlayUrl);
                    mp4PlayUrl = ContentUtil.updateTitleForJson((String)sourceTitle, (long)status, (String)mp4PlayUrl);
                }
                sql = "update scms_contentinfo  set title='" + sourceTitle + "', sourceSystemName='" + sourceSystemName + "' where contentsourceid='" + sourceId + "'";
            } else if ("6".equals(sourceType)) {
                String selectSql = "select playUrl,status,id from scms_audioinfo where contentsourceid='" + sourceId + "'";
                DataTable dt = new QueryBuilder(selectSql).executeDataTable();
                if (dt != null && dt.getRowCount() > 0) {
                    sourceSystemName = dt.getString(0, "playUrl");
                    status = dt.getLong(0, "status");
                    contentIds[0] = dt.getString(0, "contentId");
                    sourceSystemName = ContentUtil.updateTitleForJson((String)sourceTitle, (long)status, (String)sourceSystemName);
                }
                sql = "update scms_audioinfo  set title='" + sourceTitle + "', playUrl='" + sourceSystemName + "' where contentsourceid='" + sourceId + "'";
            } else if ("7".equals(sourceType)) {
                sql = "update scms_series  set title='" + sourceTitle + "' where seriessourceid='" + sourceId + "'";
            }
            trans.add(new QueryBuilder(sql));
            if (trans.commit()) {
                if ("5".equals(sourceType)) {
                    DemandVideoLib.generateStaticVideoFile((String)String.valueOf(status), (String[])contentIds, (String)siteId, (String)sourceSystemName, (String)tsPlayUrl, (String)mp4PlayUrl, null);
                } else if ("6".equals(sourceType)) {
                    DemandAudioLib.writeStaticFile((String)String.valueOf(status), (String[])contentIds, (long)Long.parseLong(siteId), (String)sourceSystemName);
                }
                resultJson.put((Object)"status", (Object)1);
                resultJson.put((Object)"message", (Object)"\u66f4\u65b0\u6210\u529f");
            } else {
                resultJson.put((Object)"status", (Object)0);
                resultJson.put((Object)"message", (Object)"\u66f4\u65b0\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            resultJson.put((Object)"status", (Object)0);
            resultJson.put((Object)"message", (Object)"\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u4e0d\u80fd\u66f4\u65b0\u6807\u9898\uff01");
        }
        finalResult = resultJson.toString();
        return finalResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String deleteDataByIds(HttpServletRequest r) {
        String finalResult = "";
        JSONObject resultJson = new JSONObject();
        String sourceIDs = r.getParameter("sourceIDs");
        String sourceType = r.getParameter("sourceType");
        String delType = r.getParameter("delType");
        int delFlag = 0;
        Map map = new HashMap();
        if (StringUtil.isEmpty((String)delType)) {
            delType = "0";
        }
        if (StringUtil.isEmpty((String)sourceIDs)) {
            resultJson.put((Object)"status", (Object)0);
            resultJson.put((Object)"message", (Object)"\u5220\u9664\u7684\u5143\u6570\u636eID\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\uff01");
            finalResult = resultJson.toString();
            return finalResult;
        }
        Transaction trans = new Transaction();
        try {
            if ("0".equals(delType)) {
                int status;
                if ("5".equals(sourceType)) {
                    map = InterfacesMethod.deleteVideo((Transaction)trans, (String)sourceIDs);
                }
                if ("6".equals(sourceType)) {
                    map = InterfacesMethod.deleteAudio((Transaction)trans, (String)sourceIDs);
                }
                if ("7".equals(sourceType)) {
                    map = InterfacesMethod.deleteSeries((Transaction)trans, (String)sourceIDs);
                }
                if (1 == (status = ((Integer)map.get("status")).intValue())) {
                    if (trans.commit()) {
                        delFlag = 1;
                        if ("5".equals(sourceType)) {
                            AssignmentLib.deleteVideoFile((String)((String)map.get("siteId")), map);
                        }
                        if ("6".equals(sourceType)) {
                            AssignmentLib.deleteAudioFile((String)((String)map.get("siteId")), map);
                        }
                    } else {
                        delFlag = 0;
                    }
                } else {
                    delFlag = 2;
                }
            }
        }
        catch (Exception e) {
            if (delFlag != 1) {
                delFlag = 0;
            }
            e.printStackTrace();
        }
        finally {
            if (delFlag == 0) {
                resultJson.put((Object)"status", (Object)0);
                resultJson.put((Object)"message", (Object)"\u5220\u9664\u5931\u8d25");
            } else if (delFlag == 1) {
                resultJson.put((Object)"status", (Object)1);
                resultJson.put((Object)"message", (Object)"\u5220\u9664\u6210\u529f");
            } else if (delFlag == 2) {
                resultJson.put((Object)"status", (Object)0);
                resultJson.put((Object)"message", (Object)"\u89c6\u9891\u5df2\u7ecf\u4e0d\u5b58\u5728\u4e86\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u4e86");
            }
            finalResult = resultJson.toString();
        }
        return finalResult;
    }
}

