/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.interfaces.push.util;

import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.InterfacesCache;
import com.sobey.bsp.schema.SCMS_Interfaces_manageSchema;
import com.sobey.cms.interfaces.callBack.impl.AllInterfaceImpl;
import com.sobey.cms.interfaces.callBack.impl.ChinaCacheInterfaceImpl;
import com.sobey.cms.interfaces.callBack.impl.LetvInterfaceImpl;
import java.util.ArrayList;

public class QueueUtil {
    public static boolean flag = false;
    public String siteId = "";

    private QueueUtil(String siteId) {
        this.siteId = siteId;
        DBConnPool.setDBConnPool((Long)Long.parseLong(this.siteId));
    }

    public static QueueUtil initQueue(String siteId) {
        if (!flag && StringUtil.isNotEmpty((String)siteId)) {
            flag = true;
            return new QueueUtil(siteId);
        }
        return null;
    }

    public void callBackFromDB() {
        try {
            while (flag) {
                String sql = "SELECT id, message, partnerCode, endTime FROM scms_pushqueue where status=1 order by weight desc limit 10";
                QueryBuilder qb = new QueryBuilder(sql);
                DataTable dt = qb.executeDataTable();
                if (dt != null && dt.getRowCount() > 0) {
                    ArrayList<String> delQueues = new ArrayList<String>();
                    ArrayList<String> updateQueues = new ArrayList<String>();
                    for (int i = 0; i < dt.getRowCount(); ++i) {
                        String message = dt.getString(i, "message");
                        String partnerCode = dt.getString(i, "partnerCode");
                        boolean callBack = false;
                        try {
                            AllInterfaceImpl call;
                            SCMS_Interfaces_manageSchema interfacesSchema = InterfacesCache.getInterfacesSchema((Long)Long.parseLong(this.siteId), (String)partnerCode);
                            int isStandardAgreement = interfacesSchema.getIsStandardAgreement();
                            if (isStandardAgreement == 0) {
                                if ("ChinaCache".equals(partnerCode)) {
                                    call = new ChinaCacheInterfaceImpl();
                                    callBack = call.callBack(message, Long.valueOf(Long.parseLong(this.siteId)), "ChinaCache");
                                } else if ("Letv".equals(partnerCode)) {
                                    call = new LetvInterfaceImpl();
                                    callBack = call.callBack(message, Long.valueOf(Long.parseLong(this.siteId)), "Letv");
                                }
                            } else {
                                call = new AllInterfaceImpl();
                                callBack = call.callBack(message, Long.valueOf(Long.parseLong(this.siteId)), partnerCode);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            callBack = false;
                        }
                        String queueId = dt.getString(i, "id");
                        if (callBack) {
                            delQueues.add(queueId);
                            continue;
                        }
                        updateQueues.add(queueId);
                    }
                    Transaction tran = new Transaction();
                    String delQueuesStr = StringUtil.listToString(delQueues);
                    String updateQueuesStr = StringUtil.listToString(updateQueues);
                    if (StringUtil.isNotEmpty((String)delQueuesStr)) {
                        String delSql = "delete from scms_pushqueue where id in (" + delQueuesStr + ")";
                        QueryBuilder delQb = new QueryBuilder(delSql);
                        tran.add(delQb);
                    }
                    if (StringUtil.isNotEmpty((String)updateQueuesStr)) {
                        String updateSql = "update scms_pushqueue set status=0 where id in (" + updateQueuesStr + ")";
                        QueryBuilder updateQb = new QueryBuilder(updateSql);
                        tran.add(updateQb);
                    }
                    tran.commit();
                    continue;
                }
                flag = false;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            flag = false;
        }
    }
}

