/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.interfaces.sonInterfaces.Data;

import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.cms.util.NewInterfacesMethod;
import java.text.SimpleDateFormat;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class SeriesInterfaceData {
    public String getSeriesListData(String siteId, String getAllData, String sortField, String sort, String pageSize, String pageNum, String status, String startTime, String endTime, String keywords, String innerCodeString, String catalogIdString) {
        JSONObject resultJson = new JSONObject();
        DataTable dt = null;
        QueryBuilder qb = null;
        QueryBuilder countQb = null;
        String countsql = "";
        String sql = "";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if ("0".equals(getAllData)) {
            sql = "select C.SiteID,C.content,C.description, C.total,C.producingArea,C.shootTime,C.director,C.mainPlayer, C.keyFrame,C.seriesid,C.CatalogId,C.SeriesSourceId,C.STATUS,C.publishDate,C.TITLE,C.TAG,C.CREATETIME,C.CREATOR,C.Download,C.OrderFlag,'' as status,'' as ContentType,'' as ImageSource,'' as SeriesIcon,C.TopFlag,'' as TopFlag2,'' as HotContent from SCMS_SERIES C   where 1=1";
            countsql = "select count(C.SERIESID) from SCMS_SERIES C   where 1=1";
            if (!"-2".equalsIgnoreCase(status)) {
                sql = sql + " and C.STATUS=" + status;
                countsql = countsql + " and C.STATUS=" + status;
            }
            if (StringUtil.isNotEmpty((String)startTime)) {
                sql = sql + " and C.PublishDate>?";
                countsql = countsql + " and C.PublishDate>?";
            }
            if (StringUtil.isNotEmpty((String)endTime)) {
                sql = sql + " and C.PublishDate<? ";
                countsql = countsql + " and C.PublishDate<? ";
            }
            if (StringUtil.isNotEmpty((String)catalogIdString)) {
                sql = sql + " and C.catalogid = ? ";
                countsql = countsql + " and C.catalogid =?";
            }
            sql = sql + " and C.title like ? ORDER BY C." + sortField + " " + sort;
            countsql = countsql + " and C.title like ?";
            countQb = new QueryBuilder(countsql);
            qb = new QueryBuilder(sql);
            if (StringUtil.isNotEmpty((String)startTime)) {
                qb.add((Object)startTime);
                countQb.add((Object)startTime);
            }
            if (StringUtil.isNotEmpty((String)endTime)) {
                qb.add((Object)endTime);
                countQb.add((Object)endTime);
            }
            if (StringUtil.isNotEmpty((String)catalogIdString)) {
                qb.add((Object)catalogIdString);
                countQb.add((Object)catalogIdString);
            }
            qb.add((Object)("%" + keywords + "%"));
            countQb.add((Object)("%" + keywords + "%"));
        } else {
            sql = "select C.SiteID, C.content,C.description,C.total,C.producingArea,C.shootTime,C.director,C.mainPlayer, C.keyFrame,C.seriesid,C.CatalogId,C.SeriesSourceId,C.STATUS,C.publishDate,C.TITLE,C.TAG,C.CREATETIME,C.CREATOR,C.Download,C.OrderFlag,'' as status,'' as ContentType,'' as ImageSource,'' as SeriesIcon,C.TopFlag,'' as TopFlag2,'' as HotContent from SCMS_SERIES C INNER JOIN SCMS_CATALOG CC on C.Catalogid=CC.id where 1=1";
            countsql = "select count(C.SERIESID) from SCMS_SERIES C INNER JOIN SCMS_CATALOG CC on C.Catalogid=CC.id where 1=1";
            if (!"-2".equalsIgnoreCase(status)) {
                sql = sql + " and C.STATUS=" + status;
                countsql = countsql + " and C.STATUS=" + status;
            }
            if (StringUtil.isNotEmpty((String)startTime)) {
                sql = sql + " and C.PublishDate>?";
                countsql = countsql + " and C.PublishDate>?";
            }
            if (StringUtil.isNotEmpty((String)endTime)) {
                sql = sql + " and C.PublishDate<? ";
                countsql = countsql + " and C.PublishDate<? ";
            }
            if (StringUtil.isNotEmpty((String)innerCodeString)) {
                sql = sql + " and CC.innercode like ? ";
                countsql = countsql + " and CC.innercode like ?";
            }
            sql = sql + " and C.title like ? ORDER BY C." + sortField + " " + sort;
            countsql = countsql + " and C.title like ?";
            qb = new QueryBuilder(sql);
            countQb = new QueryBuilder(countsql);
            if (StringUtil.isNotEmpty((String)startTime)) {
                qb.add((Object)startTime);
                countQb.add((Object)startTime);
            }
            if (StringUtil.isNotEmpty((String)endTime)) {
                qb.add((Object)endTime);
                countQb.add((Object)endTime);
            }
            if (StringUtil.isNotEmpty((String)innerCodeString)) {
                qb.add((Object)(innerCodeString + "%"));
                countQb.add((Object)(innerCodeString + "%"));
            }
            qb.add((Object)("%" + keywords + "%"));
            countQb.add((Object)("%" + keywords + "%"));
        }
        dt = StringUtils.isEmpty((String)pageSize) || "0".equals(pageSize) || StringUtils.isEmpty((String)pageNum) || "0".equals(pageNum) ? qb.executeDataTable() : qb.executePagedDataTable(Integer.parseInt(pageSize), Integer.parseInt(pageNum) - 1);
        Long total = countQb.executeLong();
        JSONArray mediaJa = new JSONArray();
        for (int i = 0; i < dt.getRowCount(); ++i) {
            JSONObject jo = new JSONObject();
            String seriesid = dt.getString(i, "SeriesSourceId");
            String seriesSummary = dt.getString(i, "content");
            String description = dt.getString(i, "description");
            String title = dt.getString(i, "TITLE");
            String createTime = dt.getString(i, "CREATETIME");
            status = dt.getString(i, "STATUS");
            String catalogId = dt.getString(i, "CATALOGID");
            String publishedTime = dt.getString(i, "PublishDate");
            String keyFrame = dt.getString(i, "keyFrame");
            String seriesTotal = dt.getString(i, "total");
            String producingArea = dt.getString(i, "producingArea");
            String shootTime = dt.getString(i, "shootTime");
            String director = dt.getString(i, "director");
            String mainPlayer = dt.getString(i, "mainPlayer");
            NewInterfacesMethod newIm = new NewInterfacesMethod();
            String imagePath = newIm.getKeyFramesPath(siteId, keyFrame);
            jo.put((Object)"id", (Object)seriesid);
            jo.put((Object)"title", (Object)title);
            jo.put((Object)"createTime", (Object)createTime);
            jo.put((Object)"publishedTime", (Object)publishedTime);
            jo.put((Object)"status", (Object)status);
            jo.put((Object)"catalogId", (Object)catalogId);
            jo.put((Object)"seriesTotal", (Object)seriesTotal);
            jo.put((Object)"seriesSummary", (Object)seriesSummary);
            jo.put((Object)"imagePath", (Object)imagePath);
            jo.put((Object)"description", (Object)description);
            jo.put((Object)"shootTime", (Object)shootTime);
            jo.put((Object)"producingArea", (Object)producingArea);
            jo.put((Object)"director", (Object)director);
            jo.put((Object)"mainPlayer", (Object)mainPlayer);
            mediaJa.add((Object)jo);
        }
        resultJson.put((Object)"video", (Object)mediaJa);
        resultJson.put((Object)"total", (Object)String.valueOf(total));
        resultJson.put((Object)"pageNum", (Object)pageNum);
        resultJson.put((Object)"pageSize", (Object)pageSize);
        if (Integer.parseInt(pageSize) == 0) {
            resultJson.put((Object)"pageTotal", (Object)0);
        } else if (total.intValue() % Integer.parseInt(pageSize) == 0) {
            resultJson.put((Object)"pageTotal", (Object)(total.intValue() / Integer.parseInt(pageSize) + ""));
        } else {
            resultJson.put((Object)"pageTotal", (Object)(total.intValue() / Integer.parseInt(pageSize) + 1 + ""));
        }
        resultJson.put((Object)"sort", (Object)sort);
        resultJson.put((Object)"sortField", (Object)sortField);
        return resultJson.toString();
    }

    public String getSeriesByIdData(String siteId, String seriesSourceIdsString) {
        JSONObject resultJson = new JSONObject();
        String sql = "select C.SiteID,C.content,C.description, C.total,C.producingArea,C.shootTime,C.director,C.mainPlayer, C.keyFrame,C.seriesid,C.CatalogId,C.SeriesSourceId,C.STATUS,C.publishDate,C.TITLE,C.TAG,C.CREATETIME,C.CREATOR,C.Download,C.OrderFlag,'' as status,'' as ContentType,'' as ImageSource,'' as SeriesIcon,C.TopFlag,'' as TopFlag2,'' as HotContent from SCMS_SERIES C   where C.status=1 and C.seriesSourceId in ('" + seriesSourceIdsString + "'" + ")";
        DataTable dt = new QueryBuilder(sql).executeDataTable();
        JSONArray mediaJa = new JSONArray();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (dt != null && dt.getRowCount() > 0) {
            long total = dt.getRowCount();
            for (int i = 0; i < dt.getRowCount(); ++i) {
                JSONObject jo = new JSONObject();
                String seriesid = dt.getString(i, "SeriesSourceId");
                String seriesSummary = dt.getString(i, "content");
                String description = dt.getString(i, "description");
                String title = dt.getString(i, "TITLE");
                String createTime = dt.getString(i, "CREATETIME");
                String status = dt.getString(i, "STATUS");
                String catalogId = dt.getString(i, "CATALOGID");
                String publishedTime = dt.getString(i, "PublishDate");
                String keyFrame = dt.getString(i, "keyFrame");
                String seriesTotal = dt.getString(i, "total");
                String producingArea = dt.getString(i, "producingArea");
                String shootTime = dt.getString(i, "shootTime");
                String director = dt.getString(i, "director");
                String mainPlayer = dt.getString(i, "mainPlayer");
                NewInterfacesMethod newIm = new NewInterfacesMethod();
                String imagePath = newIm.getKeyFramesPath(siteId, keyFrame);
                jo.put((Object)"id", (Object)seriesid);
                jo.put((Object)"title", (Object)title);
                jo.put((Object)"createTime", (Object)createTime);
                jo.put((Object)"publishedTime", (Object)publishedTime);
                jo.put((Object)"status", (Object)status);
                jo.put((Object)"catalogId", (Object)catalogId);
                jo.put((Object)"seriesTotal", (Object)seriesTotal);
                jo.put((Object)"seriesSummary", (Object)seriesSummary);
                jo.put((Object)"imagePath", (Object)imagePath);
                jo.put((Object)"description", (Object)description);
                jo.put((Object)"shootTime", (Object)shootTime);
                jo.put((Object)"producingArea", (Object)producingArea);
                jo.put((Object)"director", (Object)director);
                jo.put((Object)"mainPlayer", (Object)mainPlayer);
                mediaJa.add((Object)jo);
            }
            resultJson.put((Object)"total", (Object)String.valueOf(total));
        }
        resultJson.put((Object)"video", (Object)mediaJa);
        return resultJson.toString();
    }

    public String getSeriesInfoData(String seriesSourceId, String sortField, String sort, String pageSize, String pageNum) {
        JSONObject resultJson = new JSONObject();
        DataTable dt = new QueryBuilder("select Siteid,seriesinfo from scms_series where seriesSourceId='" + seriesSourceId + "'").executeDataTable();
        JSONArray mediaJa = new JSONArray();
        if (dt != null && dt.getRowCount() > 0) {
            String seriesinfo = dt.getString(0, "seriesinfo");
            String siteId = dt.getString(0, "siteId");
            JSONArray ja = JSONArray.fromObject((Object)seriesinfo);
            Long total = ja.size();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            NewInterfacesMethod newIm = new NewInterfacesMethod();
            if ("ASC".equals(sort.toUpperCase())) {
                int startCount = Integer.parseInt(pageSize) * (Integer.parseInt(pageNum) - 1);
                int endCount = Integer.parseInt(pageSize) * Integer.parseInt(pageNum);
                if (endCount > ja.size()) {
                    endCount = ja.size();
                }
                for (int i = startCount; i < endCount; ++i) {
                    String contentId = ja.getJSONObject(i).getString("contentId");
                    SCMS_ContentinfoSchema contentinfo = new SCMS_ContentinfoSchema();
                    contentinfo.setContentID(contentId);
                    if (!contentinfo.fill()) continue;
                    if (contentinfo.getStatus() != 1L) {
                        total = total - 1L;
                        continue;
                    }
                    String imagePath = newIm.getKeyFramesPath(String.valueOf(siteId), contentinfo.getKeyFrame());
                    JSONObject jo = new JSONObject();
                    jo.put((Object)"id", (Object)contentinfo.getContentSourceId());
                    jo.put((Object)"title", (Object)contentinfo.getTitle());
                    jo.put((Object)"tag", (Object)contentinfo.getTag());
                    jo.put((Object)"programLength", (Object)(Long.parseLong(contentinfo.getProgramLength()) / 1000L + ""));
                    jo.put((Object)"createTime", (Object)contentinfo.getCreateTime().toString());
                    jo.put((Object)"part", (Object)ja.getJSONObject(i).getString("partId"));
                    String dateString = format.format(contentinfo.getCreateTime());
                    JSONArray playerArray = newIm.generateVodCodeList(String.valueOf(siteId), contentinfo.getContentSourceId(), 5, 5, dateString);
                    jo.put((Object)"playerCodeList", (Object)playerArray);
                    String styletypes = contentinfo.getStyleTypes();
                    JSONObject vodAddress = new JSONObject();
                    if (StringUtil.isNotEmpty((String)styletypes) && styletypes.contains(String.valueOf(1))) {
                        vodAddress = newIm.getPlayUrl(String.valueOf(contentinfo.getStatus()), contentinfo.getSourceSystemName(), siteId, 5, contentinfo.getMediaPathType().intValue());
                    }
                    jo.put((Object)"vodAddress", (Object)vodAddress);
                    JSONObject tsAddress = new JSONObject();
                    if (StringUtil.isNotEmpty((String)styletypes) && styletypes.contains(String.valueOf(2))) {
                        tsAddress = newIm.getTsPlayUrl(String.valueOf(contentinfo.getStatus()), contentinfo.getTsPlayUrl(), siteId, 5, contentinfo.getMediaPathType().intValue());
                    }
                    jo.put((Object)"tsAddress", (Object)tsAddress);
                    JSONObject mp4Address = new JSONObject();
                    if (StringUtil.isNotEmpty((String)styletypes) && styletypes.contains(String.valueOf(3))) {
                        mp4Address = newIm.getMp4PlayUrl(String.valueOf(contentinfo.getStatus()), contentinfo.getMp4PlayUrl(), siteId, 5, contentinfo.getMediaPathType().intValue());
                    }
                    jo.put((Object)"mp4Address", (Object)mp4Address);
                    jo.put((Object)"status", (Object)contentinfo.getStatus().toString());
                    jo.put((Object)"publishedTime", (Object)(null == contentinfo.getPublishDate() ? "" : contentinfo.getPublishDate().toString()));
                    jo.put((Object)"catalogId", (Object)contentinfo.getCatalogid());
                    jo.put((Object)"imagePath", (Object)imagePath);
                    mediaJa.add((Object)jo);
                }
            } else {
                int startCount = ja.size() - (Integer.parseInt(pageSize) * (Integer.parseInt(pageNum) - 1) + 1);
                int endCount = ja.size() - (Integer.parseInt(pageSize) * Integer.parseInt(pageNum) + 1);
                if (endCount < 0) {
                    endCount = 0;
                }
                for (int i = startCount; i >= endCount; --i) {
                    String contentId = ja.getJSONObject(i).getString("contentId");
                    SCMS_ContentinfoSchema contentinfo = new SCMS_ContentinfoSchema();
                    contentinfo.setContentID(contentId);
                    if (!contentinfo.fill()) continue;
                    if (contentinfo.getStatus() != 1L) {
                        total = total - 1L;
                        continue;
                    }
                    String imagePath = newIm.getKeyFramesPath(String.valueOf(siteId), contentinfo.getKeyFrame());
                    JSONObject jo = new JSONObject();
                    jo.put((Object)"id", (Object)contentinfo.getContentSourceId());
                    jo.put((Object)"title", (Object)contentinfo.getTitle());
                    jo.put((Object)"tag", (Object)contentinfo.getTag());
                    jo.put((Object)"programLength", (Object)(Long.parseLong(contentinfo.getProgramLength()) / 1000L + ""));
                    jo.put((Object)"createTime", (Object)contentinfo.getCreateTime().toString());
                    jo.put((Object)"part", (Object)ja.getJSONObject(i).getString("partId"));
                    String dateString = format.format(contentinfo.getCreateTime());
                    JSONArray playerArray = newIm.generateVodCodeList(String.valueOf(siteId), contentinfo.getContentSourceId(), 5, 5, dateString);
                    jo.put((Object)"playerCodeList", (Object)playerArray);
                    String styletypes = contentinfo.getStyleTypes();
                    JSONObject vodAddress = new JSONObject();
                    if (StringUtil.isNotEmpty((String)styletypes) && styletypes.contains(String.valueOf(1))) {
                        vodAddress = newIm.getPlayUrl(String.valueOf(contentinfo.getStatus()), contentinfo.getSourceSystemName(), siteId, 5, contentinfo.getMediaPathType().intValue());
                    }
                    jo.put((Object)"vodAddress", (Object)vodAddress);
                    JSONObject tsAddress = new JSONObject();
                    if (StringUtil.isNotEmpty((String)styletypes) && styletypes.contains(String.valueOf(2))) {
                        tsAddress = newIm.getTsPlayUrl(String.valueOf(contentinfo.getStatus()), contentinfo.getTsPlayUrl(), siteId, 5, contentinfo.getMediaPathType().intValue());
                    }
                    jo.put((Object)"tsAddress", (Object)tsAddress);
                    JSONObject mp4Address = new JSONObject();
                    if (StringUtil.isNotEmpty((String)styletypes) && styletypes.contains(String.valueOf(3))) {
                        mp4Address = newIm.getMp4PlayUrl(String.valueOf(contentinfo.getStatus()), contentinfo.getMp4PlayUrl(), siteId, 5, contentinfo.getMediaPathType().intValue());
                    }
                    jo.put((Object)"mp4Address", (Object)mp4Address);
                    jo.put((Object)"status", (Object)contentinfo.getStatus().toString());
                    jo.put((Object)"publishedTime", (Object)(null == contentinfo.getPublishDate() ? "" : contentinfo.getPublishDate().toString()));
                    jo.put((Object)"catalogId", (Object)contentinfo.getCatalogid());
                    jo.put((Object)"imagePath", (Object)imagePath);
                    mediaJa.add((Object)jo);
                }
            }
            resultJson.put((Object)"video", (Object)mediaJa);
            resultJson.put((Object)"total", (Object)String.valueOf(total));
            resultJson.put((Object)"pageNum", (Object)pageNum);
            resultJson.put((Object)"pageSize", (Object)pageSize);
            if (Integer.parseInt(pageSize) == 0) {
                resultJson.put((Object)"pageTotal", (Object)0);
            } else if (total.intValue() % Integer.parseInt(pageSize) == 0) {
                resultJson.put((Object)"pageTotal", (Object)(total.intValue() / Integer.parseInt(pageSize) + ""));
            } else {
                resultJson.put((Object)"pageTotal", (Object)(total.intValue() / Integer.parseInt(pageSize) + 1 + ""));
            }
            resultJson.put((Object)"sort", (Object)sort);
            resultJson.put((Object)"sortField", (Object)sortField);
        }
        return resultJson.toString();
    }
}

