/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.interfaces.sonInterfaces.Data;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.common.util.FormatDateUtil;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.cms.util.NewInterfacesMethod;
import com.sobey.scms.contentinfo.interfaces.util.ContentUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class VideoInterfaceData {
    public String getVideoListDataByInfo(String siteId, String getAllData, String sortField, String sort, String pageSize, String pageNum, String status, String sourceFlag, String modifyFlag, String startTime, String endTime, String keywords, String innerCodeString, String catalogIdString, List<Long> catalogList) {
        StringBuilder caidsb;
        String modifyTime;
        long dateTime;
        Date date;
        JSONObject resultJson = new JSONObject();
        DataTable dt = null;
        QueryBuilder qb = null;
        QueryBuilder countQb = null;
        String countsql = "";
        String sql = "";
        sql = "SELECT C.sourceMediaInfo,C.custom,C.classifyType,C.styletypes, C.isSourceVideo, C.mediaPathType, C.programLength,C.OUTPOINT,C.INPOINT, C.TSPLAYURL,C.MP4PLAYURL,C.SUBTITLE,C.Description,C.playTime,C.PATH,C.SITEID, C.keyFrame,C.CatalogId,C.ContentSourceId,C.STATUS,C.PublishDate,C.CONTENTID,C.TITLE,C.TAG,C.CREATETIME,C.CREATORNAME,C.SOURCESYSTEMID,C.SOURCESYSTEMNAME from SCMS_CONTENTINFO C where 1=1 and C.isSourceVideo=0 ";
        countsql = "SELECT COUNT(C.CONTENTID) FROM SCMS_CONTENTINFO C   WHERE 1=1 and C.isSourceVideo=0 ";
        if ("0".equals(getAllData)) {
            if (!"-2".equalsIgnoreCase(status)) {
                sql = sql + " and C.STATUS in (" + status + ")";
                countsql = countsql + " and C.STATUS in (" + status + ")";
            }
            if ("true".equals(modifyFlag)) {
                date = new Date();
                String format = "yyyy-MM-dd HH:mm:ss";
                dateTime = date.getTime() - 1800000L;
                modifyTime = FormatDateUtil.format2Date((long)dateTime, (String)format);
                sql = sql + " and C.modifyTime>'" + modifyTime + "'";
                countsql = countsql + " and C.modifyTime>'" + modifyTime + "'";
            } else {
                if (StringUtil.isNotEmpty((String)startTime)) {
                    sql = sql + " and C.PublishDate>?";
                    countsql = countsql + " and C.PublishDate>?";
                }
                if (StringUtil.isNotEmpty((String)endTime)) {
                    sql = sql + " and C.PublishDate<? ";
                    countsql = countsql + " and C.PublishDate<? ";
                }
            }
            if (StringUtil.isNotEmpty((String)catalogIdString)) {
                sql = sql + " and C.catalogid = ? ";
                countsql = countsql + " and C.catalogid =?";
            } else if (!catalogList.isEmpty()) {
                caidsb = new StringBuilder();
                for (int i = 0; i < catalogList.size(); ++i) {
                    caidsb.append(catalogList.get(i));
                    if (i == catalogList.size() - 1) continue;
                    caidsb.append(",");
                }
                sql = sql + " and C.catalogid in (" + caidsb.toString() + ") ";
                countsql = countsql + " and C.catalogid in (" + caidsb.toString() + ") ";
            }
            sql = sql + " and C.title like ? ORDER BY C." + sortField + " " + sort;
            countsql = countsql + " and C.title like ?";
            countQb = new QueryBuilder(countsql);
            qb = new QueryBuilder(sql);
            if (!"true".equals(modifyFlag)) {
                if (StringUtil.isNotEmpty((String)startTime)) {
                    qb.add((Object)startTime);
                    countQb.add((Object)startTime);
                }
                if (StringUtil.isNotEmpty((String)endTime)) {
                    qb.add((Object)endTime);
                    countQb.add((Object)endTime);
                }
            }
            if (StringUtil.isNotEmpty((String)catalogIdString)) {
                qb.add((Object)catalogIdString);
                countQb.add((Object)catalogIdString);
            }
            qb.add((Object)("%" + keywords + "%"));
            countQb.add((Object)("%" + keywords + "%"));
        } else {
            if (!"-2".equalsIgnoreCase(status)) {
                sql = sql + " and C.STATUS in (" + status + ")";
                countsql = countsql + " and C.STATUS in (" + status + ")";
            }
            if ("true".equals(modifyFlag)) {
                date = new Date();
                String format = "yyyy-MM-dd HH:mm:ss";
                dateTime = date.getTime() - 1800000L;
                modifyTime = FormatDateUtil.format2Date((long)dateTime, (String)format);
                sql = sql + " and C.modifyTime>'" + modifyTime + "'";
                countsql = countsql + " and C.modifyTime>'" + modifyTime + "'";
            } else {
                if (StringUtil.isNotEmpty((String)startTime)) {
                    sql = sql + " and C.PublishDate>?";
                    countsql = countsql + " and C.PublishDate>?";
                }
                if (StringUtil.isNotEmpty((String)endTime)) {
                    sql = sql + " and C.PublishDate<? ";
                    countsql = countsql + " and C.PublishDate<? ";
                }
            }
            if (StringUtil.isNotEmpty((String)innerCodeString)) {
                sql = sql + " and C.CatalogInnerCode like ? ";
                countsql = countsql + " and C.CatalogInnerCode like ?";
            } else if (!catalogList.isEmpty()) {
                caidsb = new StringBuilder();
                for (int i = 0; i < catalogList.size(); ++i) {
                    caidsb.append(catalogList.get(i));
                    if (i == catalogList.size() - 1) continue;
                    caidsb.append(",");
                }
                sql = sql + " and C.catalogid in (" + caidsb.toString() + ") ";
                countsql = countsql + " and C.catalogid in (" + caidsb.toString() + ") ";
            }
            sql = sql + " and C.title like ? ORDER BY C." + sortField + " " + sort;
            countsql = countsql + " and C.title like ?";
            qb = new QueryBuilder(sql);
            countQb = new QueryBuilder(countsql);
            if (!"true".equals(modifyFlag)) {
                if (StringUtil.isNotEmpty((String)startTime)) {
                    qb.add((Object)startTime);
                    countQb.add((Object)startTime);
                }
                if (StringUtil.isNotEmpty((String)endTime)) {
                    qb.add((Object)endTime);
                    countQb.add((Object)endTime);
                }
            }
            if (StringUtil.isNotEmpty((String)innerCodeString)) {
                qb.add((Object)(innerCodeString + "%"));
                countQb.add((Object)(innerCodeString + "%"));
            }
            qb.add((Object)("%" + keywords + "%"));
            countQb.add((Object)("%" + keywords + "%"));
        }
        dt = StringUtils.isEmpty((String)pageSize) || "0".equals(pageSize) || StringUtils.isEmpty((String)pageNum) || "0".equals(pageNum) ? qb.executeDataTable() : qb.executePagedDataTable(Integer.parseInt(pageSize), Integer.parseInt(pageNum) - 1);
        String videoSourceDir = SiteUtil.getWinVideoUploadDir((String)siteId);
        Long total = countQb.executeLong();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        DataTable playerDt = new QueryBuilder("SELECT  GUID,EMBED FROM SCMS_PLAYER WHERE  TYPE=5 and DefaultFlag=1").executeDataTable();
        JSONArray mediaJa = new JSONArray();
        for (int i = 0; i < dt.getRowCount(); ++i) {
            JSONObject jo = new JSONObject();
            Long programLength = dt.getLong(i, "programLength");
            String id = dt.getString(i, "contentSourceId");
            String title = dt.getString(i, "title");
            String subTitle = dt.getString(i, "subTitle");
            String createTime = dt.getString(i, "createTime");
            status = dt.getString(i, "status");
            String catalogId = dt.getString(i, "catalogId");
            String sourceSystemID = dt.getString(i, "SourceSystemID");
            String tag = dt.getString(i, "TAG");
            String contentid = dt.getString(i, "contentId");
            String keyFrame = dt.getString(i, "keyFrame");
            String publishedTime = dt.getString(i, "PublishDate");
            String description = dt.getString(i, "Description");
            String playTime = dt.getString(i, "playTime");
            String dateString = format.format(dt.getDate(i, "createtime"));
            String playUrl = dt.getString(i, "sourcesystemname");
            String tsPlayUrl = dt.getString(i, "tsPlayUrl");
            String mp4PlayUrl = dt.getString(i, "mp4PlayUrl");
            String styletypes = dt.getString(i, "styletypes");
            int mediaPathType = dt.getInt(i, "mediaPathType");
            int classifyType = dt.getInt(i, "classifyType");
            String custom = dt.getString(i, "custom");
            String sourceMediaInfo = dt.getString(i, "sourceMediaInfo");
            NewInterfacesMethod newIm = new NewInterfacesMethod();
            String imagePath = newIm.getKeyFramesPath(siteId, keyFrame);
            JSONObject customJo = null;
            if (StringUtil.isNotEmpty((String)custom)) {
                customJo = JSONObject.fromObject((Object)custom);
            }
            jo.put((Object)"custom", (Object)customJo);
            JSONArray playerArray = newIm.generateVodCodeList(siteId, id, 5, 5, dateString);
            JSONObject vodAddress = new JSONObject();
            if (StringUtil.isNotEmpty((String)styletypes) && styletypes.contains(String.valueOf(1))) {
                vodAddress = newIm.getPlayUrl(status, playUrl, siteId, 5, mediaPathType);
            }
            jo.put((Object)"vodAddress", (Object)vodAddress);
            JSONObject tsAddress = new JSONObject();
            if (StringUtil.isNotEmpty((String)styletypes) && styletypes.contains(String.valueOf(2))) {
                tsAddress = newIm.getTsPlayUrl(status, tsPlayUrl, siteId, 5, mediaPathType);
            }
            jo.put((Object)"tsAddress", (Object)tsAddress);
            JSONObject mp4Address = new JSONObject();
            if (StringUtil.isNotEmpty((String)styletypes) && styletypes.contains(String.valueOf(3))) {
                mp4Address = newIm.getMp4PlayUrl(status, mp4PlayUrl, siteId, 5, mediaPathType);
            }
            jo.put((Object)"mp4Address", (Object)mp4Address);
            if ("true".equals(sourceFlag)) {
                String path = dt.getString(i, "path");
                String inpoint = dt.getString(i, "inpoint");
                String outpoint = dt.getString(i, "outpoint");
                String sourceUrl = videoSourceDir + path;
                String sourcePath = SiteUtil.getAlias((String)siteId) + "/" + path;
                jo.put((Object)"sourceUrl", (Object)StringUtil.replaceAllToBack_Slant((String)sourceUrl));
                jo.put((Object)"sourcePath", (Object)StringUtil.replaceAllToBack_Slant((String)sourcePath));
                if (StringUtil.isEmpty((String)inpoint)) {
                    inpoint = "0";
                }
                if (StringUtil.isEmpty((String)outpoint)) {
                    outpoint = "-1";
                }
                jo.put((Object)"inpoint", (Object)inpoint);
                jo.put((Object)"outpoint", (Object)outpoint);
            }
            String interfacesTypes = newIm.getInterfacesTypes(contentid);
            String shareSwfUrl = ContentUtil.getPlaySwfUrl((String)id, (int)5, (String)dateString, (Long)Long.parseLong(siteId));
            String shareEmbedUrl = "";
            if (playerDt != null && playerDt.getRowCount() > 0) {
                shareEmbedUrl = ContentUtil.getPlayerEmbedCode((String)id, (int)5, (String)dateString, (Long)Long.parseLong(siteId), (String)playerDt.getString(0, "embed"), (String)playerDt.getString(0, "GUID"));
            }
            if (StringUtil.isNotEmpty((String)sourceMediaInfo)) {
                jo.put((Object)"sourceMediaInfo", (Object)JSONObject.fromObject((Object)sourceMediaInfo));
            } else {
                jo.put((Object)"sourceMediaInfo", null);
            }
            jo.put((Object)"shareSwfUrl", (Object)shareSwfUrl);
            jo.put((Object)"shareEmbedUrl", (Object)shareEmbedUrl);
            jo.put((Object)"id", (Object)id);
            jo.put((Object)"interfacesTypes", (Object)interfacesTypes);
            jo.put((Object)"programLength", (Object)(programLength == null ? "0" : String.valueOf(programLength / 1000L)));
            jo.put((Object)"duration", (Object)programLength);
            jo.put((Object)"classifyType", (Object)classifyType);
            jo.put((Object)"title", (Object)title);
            jo.put((Object)"subTitle", (Object)subTitle);
            jo.put((Object)"tag", (Object)tag);
            jo.put((Object)"description", (Object)description);
            jo.put((Object)"createTime", (Object)createTime);
            jo.put((Object)"status", (Object)status);
            jo.put((Object)"playTime", (Object)playTime);
            jo.put((Object)"sourceFrom", (Object)sourceSystemID);
            jo.put((Object)"catalogId", (Object)catalogId);
            jo.put((Object)"publishedTime", (Object)publishedTime);
            jo.put((Object)"imagePath", (Object)imagePath);
            jo.put((Object)"playerCodeList", (Object)playerArray);
            mediaJa.add((Object)jo);
        }
        resultJson.put((Object)"video", (Object)mediaJa);
        resultJson.put((Object)"total", (Object)String.valueOf(total));
        resultJson.put((Object)"pageNum", (Object)pageNum);
        resultJson.put((Object)"pageSize", (Object)pageSize);
        if (Integer.parseInt(pageSize) == 0) {
            resultJson.put((Object)"pageTotal", (Object)0);
        } else if (total.intValue() % Integer.parseInt(pageSize) == 0) {
            resultJson.put((Object)"pageTotal", (Object)(total.intValue() / Integer.parseInt(pageSize) + ""));
        } else {
            resultJson.put((Object)"pageTotal", (Object)(total.intValue() / Integer.parseInt(pageSize) + 1 + ""));
        }
        resultJson.put((Object)"sort", (Object)sort);
        resultJson.put((Object)"sortField", (Object)sortField);
        return resultJson.toString();
    }

    public String getVideoInfoByInfo(String siteId, String sourceFlag, String videoIdsString) {
        JSONObject resultJson = new JSONObject();
        DataTable dt = null;
        String sql = "select C.sourceMediaInfo,C.custom,C.classifyType,C.styletypes, C.mediaPathType, C.programLength,C.OUTPOINT,C.INPOINT, C.TSPLAYURL,C.MP4PLAYURL,C.SUBTITLE,C.Description,C.playTime,C.path,C.SourceSystemID,C.siteId,C.keyFrame,C.contentid,C.CatalogId,C.ContentSourceId,C.STATUS,C.publishDate,C.CONTENTID,C.TITLE,C.TAG,C.CREATETIME,C.CREATORNAME,C.SOURCESYSTEMID,C.SOURCESYSTEMNAME from SCMS_CONTENTINFO C   where  C.contentsourceid in (" + videoIdsString + ")";
        dt = new QueryBuilder(sql).executeDataTable();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        DataTable playerDt = new QueryBuilder("SELECT  GUID,EMBED FROM SCMS_PLAYER WHERE  TYPE=5 and DefaultFlag=1").executeDataTable();
        String videoSourceDir = SiteUtil.getWinVideoUploadDir((String)siteId);
        JSONArray mediaJa = new JSONArray();
        if (dt != null && dt.getRowCount() > 0) {
            long total = dt.getRowCount();
            for (int i = 0; i < dt.getRowCount(); ++i) {
                JSONObject jo = new JSONObject();
                Long programLength = dt.getLong(i, "programLength");
                String id = dt.getString(i, "ContentSourceId");
                String title = dt.getString(i, "TITLE");
                String subTitle = dt.getString(i, "subTitle");
                String createTime = dt.getString(i, "CREATETIME");
                String catalogId = dt.getString(i, "catalogId");
                String sourceSystemID = dt.getString(i, "SourceSystemID");
                String tag = dt.getString(i, "TAG");
                String contentid = dt.getString(i, "contentId");
                String keyFrames = dt.getString(i, "keyFrame");
                String publishedTime = dt.getString(i, "PublishDate");
                String description = dt.getString(i, "Description");
                String playTime = dt.getString(i, "playTime");
                String playUrl = dt.getString(i, "sourcesystemname");
                String status = dt.getString(i, "STATUS");
                String dateString = format.format(dt.getDate(i, "createtime"));
                String tsPlayUrl = dt.getString(i, "tsplayurl");
                String mp4PlayUrl = dt.getString(i, "mp4playurl");
                String styletypes = dt.getString(i, "styletypes");
                int mediaPathType = dt.getInt(i, "mediaPathType");
                int classifyType = dt.getInt(i, "classifyType");
                String custom = dt.getString(i, "custom");
                String sourceMediaInfo = dt.getString(i, "sourceMediaInfo");
                NewInterfacesMethod newIm = new NewInterfacesMethod();
                String imagePath = newIm.getKeyFramesPath(siteId, keyFrames);
                JSONArray playerArray = newIm.generateVodCodeList(siteId, id, 5, 5, dateString);
                JSONObject customJo = null;
                if (StringUtil.isNotEmpty((String)custom)) {
                    customJo = JSONObject.fromObject((Object)custom);
                }
                jo.put((Object)"custom", (Object)customJo);
                JSONObject vodAddress = new JSONObject();
                if (StringUtil.isNotEmpty((String)styletypes) && styletypes.contains(String.valueOf(1))) {
                    vodAddress = newIm.getPlayUrl(status, playUrl, siteId, 5, mediaPathType);
                }
                jo.put((Object)"vodAddress", (Object)vodAddress);
                JSONObject tsAddress = new JSONObject();
                if (StringUtil.isNotEmpty((String)styletypes) && styletypes.contains(String.valueOf(2))) {
                    tsAddress = newIm.getTsPlayUrl(status, tsPlayUrl, siteId, 5, mediaPathType);
                }
                jo.put((Object)"tsAddress", (Object)tsAddress);
                JSONObject mp4Address = new JSONObject();
                if (StringUtil.isNotEmpty((String)styletypes) && styletypes.contains(String.valueOf(3))) {
                    mp4Address = newIm.getMp4PlayUrl(status, mp4PlayUrl, siteId, 5, mediaPathType);
                }
                jo.put((Object)"mp4Address", (Object)mp4Address);
                if ("true".equals(sourceFlag)) {
                    String path = dt.getString(i, "path");
                    String inpoint = dt.getString(i, "inpoint");
                    String outpoint = dt.getString(i, "outpoint");
                    String sourceUrl = videoSourceDir + path;
                    String sourcePath = SiteUtil.getAlias((String)siteId) + "/" + path;
                    jo.put((Object)"sourceUrl", (Object)StringUtil.replaceAllToBack_Slant((String)sourceUrl));
                    jo.put((Object)"sourcePath", (Object)StringUtil.replaceAllToBack_Slant((String)sourcePath));
                    if (StringUtil.isEmpty((String)inpoint)) {
                        inpoint = "0";
                    }
                    if (StringUtil.isEmpty((String)outpoint)) {
                        outpoint = "-1";
                    }
                    jo.put((Object)"inpoint", (Object)inpoint);
                    jo.put((Object)"outpoint", (Object)outpoint);
                }
                String interfacesTypes = newIm.getInterfacesTypes(contentid);
                jo.put((Object)"id", (Object)id);
                String shareSwfUrl = ContentUtil.getPlaySwfUrl((String)id, (int)5, (String)dateString, (Long)Long.parseLong(siteId));
                String shareEmbedUrl = "";
                if (playerDt != null && playerDt.getRowCount() > 0) {
                    shareEmbedUrl = ContentUtil.getPlayerEmbedCode((String)id, (int)5, (String)dateString, (Long)Long.parseLong(siteId), (String)playerDt.getString(0, "embed"), (String)playerDt.getString(0, "GUID"));
                }
                if (StringUtil.isNotEmpty((String)sourceMediaInfo)) {
                    jo.put((Object)"sourceMediaInfo", (Object)JSONObject.fromObject((Object)sourceMediaInfo));
                } else {
                    jo.put((Object)"sourceMediaInfo", null);
                }
                jo.put((Object)"shareSwfUrl", (Object)shareSwfUrl);
                jo.put((Object)"shareEmbedUrl", (Object)shareEmbedUrl);
                jo.put((Object)"interfacesTypes", (Object)interfacesTypes);
                jo.put((Object)"programLength", (Object)(programLength == null ? "0" : String.valueOf(programLength / 1000L)));
                jo.put((Object)"duration", (Object)programLength);
                jo.put((Object)"classifyType", (Object)classifyType);
                jo.put((Object)"title", (Object)title);
                jo.put((Object)"subTitle", (Object)subTitle);
                jo.put((Object)"tag", (Object)tag);
                jo.put((Object)"description", (Object)description);
                jo.put((Object)"createTime", (Object)createTime);
                jo.put((Object)"status", (Object)status);
                jo.put((Object)"playTime", (Object)playTime);
                jo.put((Object)"sourceFrom", (Object)sourceSystemID);
                jo.put((Object)"catalogId", (Object)catalogId);
                jo.put((Object)"publishedTime", (Object)publishedTime);
                jo.put((Object)"imagePath", (Object)imagePath);
                jo.put((Object)"playerCodeList", (Object)playerArray);
                mediaJa.add((Object)jo);
            }
            resultJson.put((Object)"total", (Object)String.valueOf(total));
        }
        resultJson.put((Object)"video", (Object)mediaJa);
        return resultJson.toString();
    }
}

