/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.interfaces.sonInterfaces.impl;

import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.schema.SCMS_AudioInfoSchema;
import com.sobey.bsp.schema.SCMS_CatalogSchema;
import com.sobey.bsp.schema.SCMS_Interfaces_manageSchema;
import com.sobey.cms.interfaces.sonInterfaces.AudioInterface;
import com.sobey.cms.interfaces.sonInterfaces.Data.AudioInterfaceData;
import com.sobey.cms.util.InterfacesMethod;
import com.sobey.cms.util.NewInterfacesMethod;
import com.sobey.scms.contentinfo.interfaces.util.ContentUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class AudioInterfaceImpl
implements AudioInterface {
    public String getAudioById(HttpServletRequest request, String siteId) {
        String finalResult = "";
        try {
            String contentSourceId = request.getParameter("audioId");
            String sourceFlag = request.getParameter("sourceFlag");
            if (StringUtil.isEmpty((String)sourceFlag)) {
                sourceFlag = "false";
            }
            String audioSourceIdsString = "";
            if (!StringUtil.isNotEmpty((String)contentSourceId)) {
                finalResult = "\u60a8\u8f93\u5165\u7684audioId\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684audioId";
                return finalResult;
            }
            String[] contentSourceIds = contentSourceId.split(",");
            audioSourceIdsString = InterfacesMethod.getIdsString((String[])contentSourceIds);
            AudioInterfaceData aid = new AudioInterfaceData();
            finalResult = aid.getAudioInfoByInfo(siteId, sourceFlag, audioSourceIdsString);
        }
        catch (Exception e) {
            e.printStackTrace();
            finalResult = "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u97f3\u9891\u4fe1\u606f";
        }
        return finalResult;
    }

    public String getAudioList(HttpServletRequest r, String siteId) {
        String finalResult = "";
        try {
            String keywords;
            String catalogPath = r.getParameter("catalogPath");
            String catalogStyle = r.getParameter("catalogStyle");
            String getAllData = r.getParameter("getAllData");
            String sortField = r.getParameter("sortField");
            String sort = r.getParameter("sort");
            String pageSize = r.getParameter("pageSize");
            String pageNum = r.getParameter("pageNum");
            String status = r.getParameter("status");
            String sourceFlag = r.getParameter("sourceFlag");
            String modifyFlag = r.getParameter("modifyFlag");
            String startTime = r.getParameter("startTime");
            String endTime = r.getParameter("endTime");
            if (StringUtil.isEmpty((String)sortField)) {
                sortField = "PublishDate";
            }
            if (StringUtil.isEmpty((String)sort)) {
                sort = "DESC";
            }
            if (StringUtil.isEmpty((String)catalogStyle)) {
                catalogStyle = "0";
            }
            if (StringUtil.isEmpty((String)getAllData)) {
                getAllData = "0";
            }
            if (StringUtil.isEmpty((String)pageSize)) {
                pageSize = "10";
            }
            if (StringUtil.isEmpty((String)pageNum)) {
                pageNum = "1";
            }
            if (StringUtil.isEmpty((String)status)) {
                status = "1";
            }
            if (StringUtil.isEmpty((String)sourceFlag)) {
                sourceFlag = "false";
            }
            if (StringUtil.isEmpty((String)modifyFlag)) {
                modifyFlag = "false";
            }
            keywords = (keywords = r.getParameter("keywords")) == null ? "" : keywords.trim();
            int catalogType = 6;
            DataTable InnerCodeDT = null;
            String innerCodeString = "";
            String catalogIdString = "";
            String sql = "";
            if (StringUtil.isEmpty((String)catalogPath)) {
                finalResult = "\u8f93\u5165\u7684\u680f\u76ee\u8def\u5f84\u4e0d\u6b63\u786e\uff0c\u8bf7\u6838\u5bf9catalogPath\u53c2\u6570";
                return finalResult;
            }
            if ("1".equals(catalogStyle) && !InterfacesMethod.checkIsInteger((String)catalogPath)) {
                finalResult = "\u5f53catalogStyle\u503c\u4e3a1\u65f6\uff0ccatalogPath\u5e94\u8be5\u4e3a0\u6216\u8005\u6b63\u6574\u6570\uff01";
                return finalResult;
            }
            if (StringUtil.isNotEmpty((String)(sql = InterfacesMethod.getCatalogSql((String)catalogPath, (String)catalogStyle, (int)catalogType, (String)sql)))) {
                InnerCodeDT = new QueryBuilder(sql).executeDataTable();
                if (InnerCodeDT == null || InnerCodeDT.getRowCount() == 0) {
                    finalResult = "\u60a8\u67e5\u8be2\u7684\u680f\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u60a8\u91cd\u65b0\u8f93\u5165\uff01";
                    return finalResult;
                }
                innerCodeString = InnerCodeDT.getString(0, "innercode");
                catalogIdString = InnerCodeDT.getString(0, "id");
            }
            AudioInterfaceData aid = new AudioInterfaceData();
            finalResult = aid.getAudioListDataByInfo(siteId, getAllData, sortField, sort, pageSize, pageNum, status, sourceFlag, modifyFlag, startTime, endTime, keywords, innerCodeString, catalogIdString);
        }
        catch (Exception e) {
            e.printStackTrace();
            finalResult = "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u97f3\u9891\u5217\u8868\u4fe1\u606f";
        }
        return finalResult;
    }

    public String getJSONbyAudioInfo(SCMS_AudioInfoSchema audioInfo, long pushStatus, SCMS_Interfaces_manageSchema interfaces) throws Exception {
        JSONObject jo = new JSONObject();
        String audioId = String.valueOf(audioInfo.getId());
        String siteId = String.valueOf(audioInfo.getSiteid());
        String contentSourceId = audioInfo.getContentSourceId();
        Integer classifyType = Integer.parseInt(StringUtil.isNotEmpty((String)String.valueOf(audioInfo.getClassifyType())) ? "0" : String.valueOf(audioInfo.getClassifyType()));
        long catalogId = audioInfo.getCatalogId();
        String title = audioInfo.getTitle();
        String subTitle = audioInfo.getSubTitle();
        String tag = audioInfo.getTag();
        Date createDate = audioInfo.getCreateTime();
        Date publishedDate = audioInfo.getPublishDate();
        Date playDate = audioInfo.getPlayTime();
        String description = audioInfo.getDescription();
        String playUrl = audioInfo.getPlayUrl();
        Integer sourceSystemID = audioInfo.getFromStyle();
        String madeFrom = ContentUtil.getSourceNameByMediaFrom((int)sourceSystemID);
        String customParamStr = audioInfo.getCustom();
        Long programLength = audioInfo.getDuration();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat formatString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = format.format(createDate);
        String createTime = formatString.format(createDate);
        String publishedTime = "";
        String playTime = "";
        if (publishedDate != null) {
            publishedTime = formatString.format(publishedDate);
        }
        if (playDate != null) {
            playTime = formatString.format(playDate);
        }
        String keyFrame = audioInfo.getKeyFrame();
        InterfacesMethod im = new InterfacesMethod();
        NewInterfacesMethod newIm = new NewInterfacesMethod();
        JSONArray allKeyFrames = newIm.getAllKeyFrames(audioId, keyFrame, siteId);
        JSONArray playerCodeList = newIm.getVodCodeJSONArray(siteId, contentSourceId, 5, 5, dateString);
        JSONArray ja = new JSONArray();
        ja = im.getCatalogPathAndIds(ja, catalogId);
        String catalogTree = ja.toString();
        SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
        catalog.setID(catalogId);
        String interfacesTypes = im.getInterfacesCDNTypes(audioId);
        JSONObject playURL = newIm.getPlayUrl(String.valueOf(pushStatus), playUrl, siteId, 6, 1);
        JSONArray ftpUrls = newIm.getFtpAudioAddress(playUrl, interfaces);
        playURL.put((Object)"ftpUrls", (Object)ftpUrls);
        jo.put((Object)"id", (Object)contentSourceId);
        jo.put((Object)"classifyType", (Object)classifyType);
        jo.put((Object)"catalogId", (Object)catalogId);
        jo.put((Object)"catalogTree", (Object)catalogTree);
        jo.put((Object)"createTime", (Object)createTime);
        jo.put((Object)"description", (Object)description);
        jo.put((Object)"madeFrom", (Object)madeFrom);
        jo.put((Object)"imageList", (Object)allKeyFrames.toString());
        jo.put((Object)"interfacesTypes", (Object)interfacesTypes);
        jo.put((Object)"playerCodeList", (Object)playerCodeList);
        jo.put((Object)"programLength", (Object)(programLength / 1000L));
        jo.put((Object)"publishTime", (Object)publishedTime);
        jo.put((Object)"status", (Object)pushStatus);
        jo.put((Object)"subTitle", (Object)subTitle);
        jo.put((Object)"tag", (Object)tag);
        jo.put((Object)"title", (Object)title);
        jo.put((Object)"playTime", (Object)playTime);
        jo.put((Object)"playURL", (Object)playURL);
        if (StringUtil.isEmpty((String)customParamStr)) {
            customParamStr = "{}";
        }
        JSONObject customParam = JSONObject.fromObject((Object)customParamStr);
        jo.put((Object)"customParam", (Object)customParam);
        return jo.toString();
    }
}

