/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.interfaces.sonInterfaces.impl;

import com.sobey.bsp.framework.common.util.FormatDateUtil;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.cms.interfaces.sonInterfaces.CmstopInterface;
import com.sobey.cms.util.InterfacesMethod;
import com.sobey.cms.util.NewInterfacesMethod;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class CmstopInterfaceImpl
implements CmstopInterface {
    public String get_category(HttpServletRequest request) {
        String result = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            String catid = request.getParameter("catid");
            ArrayList dataList = new ArrayList();
            DataTable dt = null;
            if (StringUtil.isNotEmpty((String)catid)) {
                dt = new QueryBuilder("select id,name,childCount from scms_catalog where parentid=" + catid + "").executeDataTable();
            } else if (StringUtil.isEmpty((String)catid) || catid.equals("0") || catid.equals("-1")) {
                dt = new QueryBuilder("select id,name,childCount from scms_catalog where  type=5 and parentid=0").executeDataTable();
            }
            if (dt == null || dt.getRowCount() == 0) {
                map.put("state", false);
                map.put("error", "\u6ca1\u6709\u6570\u636e");
                result = JSONObject.fromObject(map).toString();
                return result;
            }
            for (int i = 0; i < dt.getRowCount(); ++i) {
                boolean hasChildren = dt.getInt(i, "childCount") != 0;
                HashMap<String, Object> catalogMap = new HashMap<String, Object>();
                catalogMap.put("catid", dt.getString(i, "id"));
                catalogMap.put("name", dt.getString(i, "name"));
                catalogMap.put("hasChildren", hasChildren);
                dataList.add(catalogMap);
            }
            map.put("state", true);
            map.put("data", dataList);
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("state", false);
            map.put("error", "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u680f\u76ee\u5217\u8868");
        }
        result = JSONObject.fromObject(map).toString();
        return result;
    }

    public String get_video(HttpServletRequest request) {
        String result = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            String catalogid = request.getParameter("catid");
            String created = request.getParameter("created");
            String keyword = request.getParameter("keyword");
            String sortField = request.getParameter("sortField");
            String sort = request.getParameter("sort");
            if (StringUtil.isEmpty((String)sortField)) {
                sortField = "PublishDate";
            }
            if (StringUtil.isEmpty((String)sort)) {
                sort = "DESC";
            }
            int pagesize = StringUtil.isNotEmpty((String)request.getParameter("pagesize")) ? Integer.parseInt(request.getParameter("pagesize")) : 0;
            int pagenum = StringUtil.isNotEmpty((String)request.getParameter("page")) ? Integer.parseInt(request.getParameter("page")) : 0;
            ArrayList dataList = new ArrayList();
            DataTable dt = null;
            String queryCondition = "";
            String sql = "";
            String catInfo = "";
            Long total = 0L;
            QueryBuilder qb = new QueryBuilder();
            if (StringUtil.isNotEmpty((String)keyword)) {
                queryCondition = queryCondition + " and C.title like '%" + keyword.trim() + "%'";
            }
            if (StringUtil.isNotEmpty((String)created)) {
                queryCondition = queryCondition + " and C.PublishDate";
                if (created.contains("-")) {
                    if (created.contains(",")) {
                        String createdTime = "";
                        if (created.startsWith(",")) {
                            createdTime = created.substring(created.indexOf(",") + 1);
                            queryCondition = queryCondition + " < '" + createdTime + "'";
                        } else if (created.endsWith(",")) {
                            createdTime = created.substring(0, created.indexOf(","));
                            queryCondition = queryCondition + " > '" + createdTime + "'";
                        } else {
                            String[] createdTimes = created.split(",");
                            queryCondition = queryCondition + " > '" + createdTimes[0] + "' " + "and C.PublishDate < '" + createdTimes[1] + "'";
                        }
                    } else {
                        queryCondition = created.contains(":") ? queryCondition + " = '" + created + "'" : queryCondition + " like '%" + created + "%'";
                    }
                } else {
                    Long currentDateMillis = new Date().getTime();
                    Long pastDateMillis = Long.parseLong(created) * 86400000L;
                    String format = "yyyy-MM-dd HH:mm:ss";
                    String currentDate = FormatDateUtil.format2Date((long)currentDateMillis, (String)format);
                    String pastDate = FormatDateUtil.format2Date((long)(currentDateMillis - pastDateMillis), (String)format);
                    queryCondition = queryCondition + " > '" + pastDate + "' " + "and C.PublishDate < '" + currentDate + "'";
                }
            }
            queryCondition = queryCondition + " ORDER BY C." + sortField + " " + sort;
            if (StringUtil.isNotEmpty((String)catalogid)) {
                qb.setSQL("select C.SUBTITLE,C.Description,C.playTime,C.ContentId,C.catalogid,C.title,C.tag,C.createTime,C.publishDate, C.programLength,C.contentSourceId,C.siteid,C.keyFrame from SCMS_CONTENTINFO C   where  C.status=1 and C.catalogid in (" + catalogid + ") " + queryCondition + "");
                total = new QueryBuilder("select count(*) from SCMS_CONTENTINFO C   where C.status=1 and  C.catalogid in (" + catalogid + ") " + queryCondition + "").executeLong();
            } else if (StringUtil.isEmpty((String)catalogid) || catalogid.equals("0") || catalogid.equals("-1")) {
                qb.setSQL("select C.SUBTITLE,C.Description,C.playTime,C.ContentId,C.catalogid,C.title,C.tag,C.createTime,C.publishDate, C.programLength,C.contentSourceId,C.siteid,C.keyFrame from SCMS_CONTENTINFO C   where  C.status=1 " + queryCondition + "");
                total = new QueryBuilder("select count(*) from SCMS_CONTENTINFO C   where  C.status=1 " + queryCondition + "").executeLong();
            }
            dt = 0 == pagesize || 0 == pagenum ? qb.executeDataTable() : qb.executePagedDataTable(pagesize, pagenum - 1);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            for (int i = 0; i < dt.getRowCount(); ++i) {
                HashMap<String, String> videoMap = new HashMap<String, String>();
                String subTitle = dt.getString(i, "subTitle");
                String catalogId = dt.getString(i, "catalogId");
                String description = dt.getString(i, "Description");
                String playTime = dt.getString(i, "playTime");
                String contentSourceid = dt.getString(i, "contentSourceId");
                String siteId = dt.getString(i, "siteid");
                long programLength = dt.getLong(i, "programLength") / 1000L;
                String keyFrame = dt.getString(i, "keyFrame");
                String dateString = format.format(dt.getDate(i, "createtime"));
                String playerCode = InterfacesMethod.generateVodCode((String)siteId, (String)contentSourceid, (int)5, (int)5, (String)dateString);
                long published = StringUtil.isNotEmpty((String)dt.getString(i, "publishDate")) ? FormatDateUtil.date2Long((String)dt.getString(i, "publishDate")) : 0L;
                long createdTime = StringUtil.isNotEmpty((String)dt.getString(i, "createTime")) ? FormatDateUtil.date2Long((String)dt.getString(i, "createTime")) : 0L;
                String imagePath = new NewInterfacesMethod().getKeyFramesPath(siteId, keyFrame);
                videoMap.put("subTitle", subTitle);
                videoMap.put("description", description);
                videoMap.put("playTime", playTime);
                videoMap.put("thumb", imagePath);
                videoMap.put("playerparams", contentSourceid);
                videoMap.put("playercode", playerCode);
                videoMap.put("playcount", "0");
                videoMap.put("time", programLength + "");
                videoMap.put("published", published + "");
                videoMap.put("created", createdTime + "");
                videoMap.put("tags", dt.getString(i, "tag"));
                videoMap.put("title", dt.getString(i, "title"));
                videoMap.put("catid", dt.getString(i, "catalogid"));
                videoMap.put("vid", dt.getString(i, "ContentId"));
                dataList.add(videoMap);
            }
            map.put("state", true);
            map.put("total", total);
            map.put("pagesize", pagesize);
            map.put("pagenum", pagenum);
            map.put("data", dataList);
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("state", false);
            map.put("error", "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u680f\u76ee\u5217\u8868");
        }
        result = JSONObject.fromObject(map).toString();
        return result;
    }

    public String get_live(HttpServletRequest request, String email, String siteId) {
        String result = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            DataTable dt = new QueryBuilder("select id, name, mediaType from scms_channels where status=1").executeDataTable();
            JSONArray dataList = new JSONArray();
            for (int i = 0; i < dt.getRowCount(); ++i) {
                JSONObject jo = new JSONObject();
                String channelId = dt.getString(i, "id");
                String mediaType = dt.getString(i, "mediaType");
                String playerCode = "";
                playerCode = String.valueOf(8).equals(mediaType) ? "<![CDATA[" + NewInterfacesMethod.generateLiveCode((String)channelId, (int)8) + "]]>" : "<![CDATA[" + NewInterfacesMethod.generateLiveCode((String)channelId, (int)15) + "]]>";
                JSONObject channel = new JSONObject();
                JSONArray liveAddress = NewInterfacesMethod.getChannelFormatInfo((String)channelId, (String)"", (long)Long.parseLong(siteId), (int)Integer.parseInt(mediaType));
                channel.put((Object)"liveAddress", (Object)liveAddress);
                jo.put((Object)"channelname", (Object)dt.getString(i, "name"));
                jo.put((Object)"channelid", (Object)dt.getString(i, "id"));
                jo.put((Object)"playercode", (Object)playerCode);
                jo.put((Object)"playerparams", (Object)dt.getString(i, "id"));
                jo.put((Object)"video", (Object)channel);
                dataList.add((Object)jo);
            }
            map.put("state", true);
            map.put("data", dataList);
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("state", false);
            map.put("error", "\u64cd\u4f5c\u6570\u636e\u5e93\u51fa\u9519");
        }
        result = JSONObject.fromObject(map).toString();
        return result;
    }
}

