/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.interfaces.sonInterfaces.impl;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.DateUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.UserLog;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_ContentInfoLogSchema;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.bsp.schema.SCMS_Site_ColumnSchema;
import com.sobey.bsp.schema.SCMS_Site_ColumnSet;
import com.sobey.bsp.vms.interfaces.media.AttributeItem;
import com.sobey.bsp.vms.interfaces.media.CMSContentInfo;
import com.sobey.bsp.vms.interfaces.media.InterfacesInfo;
import com.sobey.bsp.vms.interfaces.media.SrcFileItem;
import com.sobey.cms.core.param.service.imp.ParamServiceImpl;
import com.sobey.cms.interfaces.sonInterfaces.MainImportContentInterface;
import com.sobey.cms.util.InterfacesMethod;
import com.sobey.scms.contentinfo.DemandDefaultLib;
import com.sobey.scms.contentinfo.interfaces.util.ContentUtil;
import com.sobey.scms.search.ContentSearchMediator;
import com.sobey.scms.trasncode.MPCCall;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class MainImportContentInterfaceImpl
implements MainImportContentInterface {
    public String saveContentInfoAndTransCode(CMSContentInfo contentInfo) {
        try {
            QueryBuilder qb;
            SCMS_Site_ColumnSchema siteColumn;
            SCMS_Site_ColumnSet siteColumnSet;
            String typeID = contentInfo.getTypeID();
            String contentSourceId = contentInfo.getContentID();
            String title = "";
            String subTitle = "";
            String catalogPath = "";
            String addUser = "";
            String producer = "";
            String cameraMan = "";
            String description = "";
            String keywords = "";
            Date firstPlayTime = null;
            String producingArea = "";
            String shootTime = null;
            String director = "";
            String shootAddress = "";
            String fileType = "1";
            String mediaPathType = "1";
            String softLinkDir = "";
            String partnerToken = "";
            int autoPublish = 0;
            int mediaFromType = 8;
            int materialType = 1;
            for (AttributeItem attritem : contentInfo.getEntityData()) {
                if ("PartnerToken".equals(attritem.getItemCode())) {
                    partnerToken = attritem.getValue();
                }
                if ("Name".equals(attritem.getItemCode())) {
                    title = attritem.getValue();
                }
                if ("SubTitle".equals(attritem.getItemCode())) {
                    subTitle = attritem.getValue();
                }
                if ("PgmType".equals(attritem.getItemCode())) {
                    catalogPath = attritem.getValue();
                }
                if ("KeyWords".equals(attritem.getItemCode())) {
                    String string = keywords = attritem.getValue() == null ? "" : attritem.getValue();
                }
                if ("SoftLinkDir".equals(attritem.getItemCode()) && StringUtil.isNotEmpty((String)attritem.getValue())) {
                    softLinkDir = attritem.getValue();
                }
                if ("PgmNote".equals(attritem.getItemCode()) && StringUtil.isNotEmpty((String)attritem.getValue())) {
                    description = attritem.getValue();
                }
                if ("DocProvider".equals(attritem.getItemCode()) || "CreatorName".equals(attritem.getItemCode())) {
                    String string = addUser = attritem.getValue() == null ? "" : attritem.getValue();
                }
                if ("AutoPublish".equals(attritem.getItemCode())) {
                    autoPublish = "0".equals(attritem.getValue()) ? 0 : 1;
                }
                if ("contentFileType".equals(attritem.getItemCode()) && StringUtil.isNotEmpty((String)attritem.getValue())) {
                    fileType = attritem.getValue();
                }
                if ("FirstPlayTime".equals(attritem.getItemCode())) {
                    firstPlayTime = DateUtil.parse((String)attritem.getValue());
                }
                if ("ShootPlace".equals(attritem.getItemCode())) {
                    shootAddress = attritem.getValue();
                }
                if ("ProducingArea".equals(attritem.getItemCode())) {
                    producingArea = attritem.getValue();
                }
                if ("ShootTime".equals(attritem.getItemCode())) {
                    shootTime = attritem.getValue();
                }
                if ("Director".equals(attritem.getItemCode())) {
                    director = attritem.getValue();
                }
                if ("Producer".equals(attritem.getItemCode())) {
                    producer = attritem.getValue();
                }
                if ("CameraMan".equals(attritem.getItemCode())) {
                    cameraMan = attritem.getValue();
                }
                if ("MaterialType".equals(attritem.getItemCode()) && StringUtil.isNotEmpty((String)attritem.getValue())) {
                    materialType = Integer.parseInt(attritem.getValue());
                }
                if ("MediaPathType".equals(attritem.getItemCode()) && StringUtil.isNotEmpty((String)attritem.getValue())) {
                    mediaPathType = attritem.getValue();
                }
                if (!"MediaFromType".equals(attritem.getItemCode()) || !StringUtil.isNotEmpty((String)attritem.getValue())) continue;
                mediaFromType = Integer.parseInt(attritem.getValue());
            }
            DBConnPool.setCurrent((DBConnConfig)DBConnConfig.getDefaultDBConnConfigInstance());
            String siteId = InterfacesMethod.getSiteIdByToken((String)partnerToken);
            DBConnPool.setDBConnPool((Long)Long.parseLong(siteId));
            Transaction trans = new Transaction();
            if (StringUtil.isNotEmpty((String)title) && title.length() > 90) {
                title = title.substring(0, 90);
            }
            if (StringUtil.isNotEmpty((String)keywords) && keywords.length() > 100) {
                keywords = keywords.substring(0, 100);
            }
            if (StringUtil.isNotEmpty((String)description) && description.length() > 490) {
                description = description.substring(0, 490) + "...";
            }
            List srcFileitemList = contentInfo.getSrcContentFile();
            InterfacesInfo interfaceInfo = contentInfo.getInterfacesInfo();
            JSONObject jo = new JSONObject();
            if (null != interfaceInfo) {
                jo.put((Object)"mainInterfaceURL", (Object)interfaceInfo.getMainInterfaceURL());
                jo.put((Object)"mainServiceURL", (Object)interfaceInfo.getMainServiceURL());
                jo.put((Object)"messageID", (Object)interfaceInfo.getMessageID());
                jo.put((Object)"materialGuid", (Object)interfaceInfo.getMaterialGuid());
            }
            String sourceContentPath = "";
            if (srcFileitemList != null && srcFileitemList.size() > 0 && StringUtil.isNotEmpty((String)((SrcFileItem)srcFileitemList.get(0)).getFileName())) {
                String srcFileUrl = ((SrcFileItem)srcFileitemList.get(0)).getFileName();
                sourceContentPath = StringUtil.replaceAllToSlant((String)srcFileUrl);
            }
            String transcodeId = DemandDefaultLib.getDefaultTranscode((Integer)5);
            String mTranscodeId = Config.getValue((String)"Material.TransCodeId");
            if (1 != materialType || StringUtil.isNotEmpty((String)mTranscodeId)) {
                transcodeId = mTranscodeId;
            }
            ParamServiceImpl paramService = new ParamServiceImpl();
            List paramList = paramService.handlerCatalogPath(catalogPath, 5, Long.parseLong(siteId));
            String catalogId = (String)((Map)paramList.get(0)).get("catalogId");
            String catalogInnerCode = (String)((Map)paramList.get(0)).get("catalogInnerCode");
            Date now = new Date();
            Long contentId = NoUtil.getMaxID((String)"ContentID");
            SCMS_ContentinfoSchema contentinfo = new SCMS_ContentinfoSchema();
            contentinfo.setContentID(contentId);
            contentinfo.setContentSourceId(contentSourceId);
            contentinfo.setTitle(title);
            contentinfo.setSubTitle(subTitle);
            contentinfo.setCreateTime(now);
            contentinfo.setModifyTime(now);
            contentinfo.setIsPublish(Integer.valueOf(autoPublish));
            contentinfo.setPlayTime(firstPlayTime);
            contentinfo.setDescription(description);
            contentinfo.setMediaPathType(Integer.valueOf(1));
            contentinfo.setIsSourceVideo(Integer.valueOf(1));
            contentinfo.setSourceSystemID(Integer.valueOf(mediaFromType));
            if (StringUtil.isNotEmpty((String)addUser)) {
                contentinfo.setCreatorName(addUser);
            } else {
                contentinfo.setCreatorName(ContentUtil.getSourceNameByMediaFrom((int)mediaFromType));
            }
            contentinfo.setSourceSystemName(transcodeId);
            contentinfo.setTranscodeid(Integer.valueOf(Integer.parseInt(transcodeId)));
            contentinfo.setStatus(Long.valueOf(2L));
            contentinfo.setTag(keywords);
            String winDir = StringUtil.replaceAllToBack_Slant((String)(Config.getValue((String)"winVideoUploadDir") + SiteUtil.getAlias((String)siteId)));
            String path = StringUtil.replaceAllToSlant((String)StringUtil.replaceAllToSlant((String)sourceContentPath).substring(winDir.length()));
            contentinfo.setPath(path);
            contentinfo.setProgramLength("");
            contentinfo.setSiteid(Long.valueOf(Long.parseLong(siteId)));
            contentinfo.setKeyFrame("");
            contentinfo.setCatalogid(catalogId);
            contentinfo.setCatalogInnerCode(catalogInnerCode);
            InterfacesMethod im = new InterfacesMethod();
            JSONArray ja = new JSONArray();
            ja = im.getCatalogPathAndIds(ja, Long.parseLong(catalogId));
            String fristCatalogName = ((JSONObject)ja.get(0)).getString("catalogName");
            if (StringUtil.isNotEmpty((String)fristCatalogName) && (siteColumnSet = (siteColumn = new SCMS_Site_ColumnSchema()).query(qb = new QueryBuilder("where Name='" + fristCatalogName + "'"))) != null && siteColumnSet.size() > 0) {
                siteColumn = siteColumnSet.get(0);
                contentinfo.setClassifyType(siteColumn.getNumFlag().toString());
            }
            SCMS_ContentInfoLogSchema log = new SCMS_ContentInfoLogSchema();
            log.setID(NoUtil.getMaxID((String)"ContentInfoLogId"));
            log.setAction("INSERT");
            log.setContentId(contentId.longValue());
            log.setActionDetail("\u89c6\u9891\u4e3b\u5e72\u8fc1\u79fb\u5165\u5e93");
            log.setAddTime(now);
            log.setAddUser("\u4e3b\u5e72\u5a92\u8d44");
            trans.add((Schema)log, 1);
            trans.add((Schema)contentinfo, 1);
            if (trans.commit()) {
                UserLog.log((String)"Video", (String)"CreateVideo", (String)("\u4e3b\u5e72\u89c6\u9891" + title + "\u5165\u5e93\u6210\u529f"), (String)"\u4e3b\u5e72", (String)"\u4e3b\u5e72");
                ContentSearchMediator.publishVideo2Search((String)String.valueOf(contentId), (String)SiteUtil.getAlias((String)siteId), (long)Long.parseLong(siteId));
                MPCCall.generateXml((String)StringUtil.replaceAllToSlant((String)sourceContentPath), (String)transcodeId, (String)contentSourceId, (String)title, (long)Long.parseLong(siteId), (String)"", (String)"");
                if (SiteUtil.isSupportPlayCount((long)Long.parseLong(siteId))) {
                    // empty if block
                }
            } else {
                UserLog.log((String)"Video", (String)"CreateVideo", (String)("\u89c6\u9891" + title + "\u5165\u5e93\u5931\u8d25"), (String)"\u4e3b\u5e72", (String)"\u4e3b\u5e72");
                return "1";
            }
            trans.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "1";
        }
        return "0";
    }
}

