/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.interfaces.sonInterfaces.impl;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.utility.Filter;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.bsp.schema.SCMS_Interfaces_manageSchema;
import com.sobey.cms.interfaces.sonInterfaces.Data.VideoInterfaceData;
import com.sobey.cms.interfaces.sonInterfaces.VideoInterface;
import com.sobey.cms.util.InterfacesMethod;
import com.sobey.cms.util.NewInterfacesMethod;
import com.sobey.scms.contentinfo.interfaces.util.ContentUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class VideoInterfaceImpl
implements VideoInterface {
    public String getJSONbyContentinfo(SCMS_ContentinfoSchema contentinfo, long pushStatus, SCMS_Interfaces_manageSchema interfaces) throws Exception {
        String finalResult = "";
        JSONObject jo = new JSONObject();
        String contentId = String.valueOf(contentinfo.getContentID());
        String siteId = String.valueOf(contentinfo.getSiteid());
        String contentSourceId = contentinfo.getContentSourceId();
        Integer classifyType = Integer.parseInt(StringUtil.isEmpty((String)contentinfo.getClassifyType()) ? "0" : contentinfo.getClassifyType());
        long catalogId = Long.parseLong(contentinfo.getCatalogid());
        String title = contentinfo.getTitle();
        String subTitle = contentinfo.getSubTitle();
        String tag = contentinfo.getTag();
        Date createDate = contentinfo.getCreateTime();
        Date publishedDate = contentinfo.getPublishDate();
        Date playDate = contentinfo.getPlayTime();
        String description = contentinfo.getDescription();
        String playUrl = contentinfo.getSourceSystemName();
        String tsPlayUrl = contentinfo.getTsPlayUrl();
        String mp4PlayUrl = contentinfo.getMp4PlayUrl();
        Integer sourceSystemID = contentinfo.getSourceSystemID();
        String customParamStr = contentinfo.getCustom();
        String styletypes = contentinfo.getStyleTypes();
        Integer mediaPathType = contentinfo.getMediaPathType();
        Long programLength = Long.parseLong(contentinfo.getProgramLength());
        String sourceMediaInfo = contentinfo.getSourceMediaInfo();
        String username = contentinfo.getCreatorName();
        String realName = ContentUtil.getRealNameBySourceSystemID((int)sourceSystemID, (String)username);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat formatString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = format.format(createDate);
        String createTime = formatString.format(createDate);
        String publishedTime = "";
        String playTime = "";
        if (publishedDate != null) {
            publishedTime = formatString.format(publishedDate);
        }
        if (playDate != null) {
            playTime = formatString.format(playDate);
        }
        String keyFrame = contentinfo.getKeyFrame();
        InterfacesMethod im = new InterfacesMethod();
        NewInterfacesMethod newIm = new NewInterfacesMethod();
        JSONArray allKeyFrames = newIm.getAllKeyFrames(contentId, keyFrame, siteId);
        JSONArray playerCodeList = newIm.getVodCodeJSONArray(siteId, contentSourceId, 5, 5, dateString);
        JSONObject vodAddress = new JSONObject();
        if (StringUtil.isNotEmpty((String)styletypes) && styletypes.contains(String.valueOf(1))) {
            vodAddress = newIm.getPlayUrl(String.valueOf(pushStatus), playUrl, siteId, 5, mediaPathType.intValue());
            JSONArray ftpUrls = newIm.getFtpVodAddress(playUrl, interfaces);
            vodAddress.put((Object)"ftpUrls", (Object)ftpUrls);
        }
        jo.put((Object)"vodAddress", (Object)vodAddress);
        JSONObject tsAddress = new JSONObject();
        if (StringUtil.isNotEmpty((String)styletypes) && styletypes.contains(String.valueOf(2))) {
            tsAddress = newIm.getTsPlayUrl(String.valueOf(pushStatus), tsPlayUrl, siteId, 5, mediaPathType.intValue());
        }
        jo.put((Object)"tsAddress", (Object)tsAddress);
        JSONObject mp4Address = new JSONObject();
        if (StringUtil.isNotEmpty((String)styletypes) && styletypes.contains(String.valueOf(3))) {
            mp4Address = newIm.getMp4PlayUrl(String.valueOf(pushStatus), mp4PlayUrl, siteId, 5, mediaPathType.intValue());
        }
        jo.put((Object)"mp4Address", (Object)mp4Address);
        JSONArray ja = new JSONArray();
        ja = im.getCatalogPathAndIds(ja, catalogId);
        String catalogTree = ja.toString();
        String interfacesTypes = im.getInterfacesCDNTypes(contentId);
        jo.put((Object)"id", (Object)contentSourceId);
        jo.put((Object)"classifyType", (Object)classifyType);
        jo.put((Object)"siteId", (Object)siteId);
        jo.put((Object)"alias", (Object)SiteUtil.getAlias((String)siteId));
        jo.put((Object)"sourceFrom", (Object)sourceSystemID);
        jo.put((Object)"catalogId", (Object)catalogId);
        jo.put((Object)"catalogTree", (Object)catalogTree);
        jo.put((Object)"createTime", (Object)createTime);
        jo.put((Object)"description", (Object)description);
        jo.put((Object)"imageList", (Object)allKeyFrames.toString());
        jo.put((Object)"interfacesTypes", (Object)interfacesTypes);
        jo.put((Object)"playerCodeList", (Object)playerCodeList);
        jo.put((Object)"programLength", (Object)(programLength / 1000L));
        jo.put((Object)"publishTime", (Object)publishedTime);
        jo.put((Object)"status", (Object)pushStatus);
        jo.put((Object)"subTitle", (Object)subTitle);
        jo.put((Object)"tag", (Object)tag);
        jo.put((Object)"title", (Object)title);
        jo.put((Object)"playTime", (Object)playTime);
        if (StringUtil.isNotEmpty((String)sourceMediaInfo)) {
            jo.put((Object)"sourceMediaInfo", (Object)JSONObject.fromObject((Object)sourceMediaInfo));
        } else {
            jo.put((Object)"sourceMediaInfo", null);
        }
        jo.put((Object)"user_name", (Object)realName);
        if (StringUtil.isEmpty((String)customParamStr)) {
            customParamStr = "{}";
        }
        JSONObject customParam = JSONObject.fromObject((Object)customParamStr);
        jo.put((Object)"customParam", (Object)customParam);
        if (jo == null) {
            throw new Exception("\u672a\u627e\u5230\u8be5\u89c6\u9891\u4fe1\u606f!");
        }
        finalResult = jo.toString();
        return finalResult;
    }

    public String getVideoById(HttpServletRequest request, String siteId) {
        String finalResult = "";
        try {
            String videoIds = request.getParameter("videoId");
            String sourceFlag = request.getParameter("sourceFlag");
            if (StringUtil.isEmpty((String)sourceFlag)) {
                sourceFlag = "false";
            }
            String videoIdsString = "";
            if (!StringUtil.isNotEmpty((String)videoIds)) {
                finalResult = "\u60a8\u8f93\u5165\u7684videoId\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684videoId";
                return finalResult;
            }
            String[] contentSourceIds = videoIds.split(",");
            videoIdsString = NewInterfacesMethod.getIdsString((String[])contentSourceIds);
            VideoInterfaceData vid = new VideoInterfaceData();
            finalResult = vid.getVideoInfoByInfo(siteId, sourceFlag, videoIdsString);
        }
        catch (Exception e) {
            e.printStackTrace();
            finalResult = "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u89c6\u9891\u4fe1\u606f";
        }
        return finalResult;
    }

    public String getVideoList(HttpServletRequest r, String siteId) {
        String finalResult = "";
        try {
            String keywords;
            String catalogPath = r.getParameter("catalogPath");
            String catalogStyle = r.getParameter("catalogStyle");
            String getAllData = r.getParameter("getAllData");
            String sortField = r.getParameter("sortField");
            String sort = r.getParameter("sort");
            String pageSize = r.getParameter("pageSize");
            String pageNum = r.getParameter("pageNum");
            String status = r.getParameter("status");
            String sourceFlag = r.getParameter("sourceFlag");
            String modifyFlag = r.getParameter("modifyFlag");
            String startTime = r.getParameter("startTime");
            String endTime = r.getParameter("endTime");
            String userName = r.getParameter("userName");
            ArrayList<Long> catalogList = new ArrayList<Long>();
            if (StringUtil.isEmpty((String)sortField)) {
                sortField = "PublishDate";
            }
            if (StringUtil.isEmpty((String)sort)) {
                sort = "DESC";
            }
            if (StringUtil.isEmpty((String)catalogStyle)) {
                catalogStyle = "0";
            }
            if (StringUtil.isEmpty((String)getAllData)) {
                getAllData = "0";
            }
            if (StringUtil.isEmpty((String)pageSize)) {
                pageSize = "10";
            }
            if (StringUtil.isEmpty((String)pageNum)) {
                pageNum = "1";
            }
            if (StringUtil.isEmpty((String)status)) {
                status = "1";
            }
            if (StringUtil.isEmpty((String)sourceFlag)) {
                sourceFlag = "false";
            }
            if (StringUtil.isEmpty((String)modifyFlag)) {
                modifyFlag = "false";
            }
            keywords = (keywords = r.getParameter("keywords")) == null ? "" : keywords.trim();
            DataTable InnerCodeDT = null;
            String innerCodeString = "";
            String catalogIdString = "";
            String catalogSql = "";
            int catalogType = 5;
            if (StringUtil.isEmpty((String)catalogPath)) {
                finalResult = "\u8f93\u5165\u7684\u680f\u76ee\u8def\u5f84\u4e0d\u6b63\u786e\uff0c\u8bf7\u6838\u5bf9catalogPath\u53c2\u6570";
                return finalResult;
            }
            if ("1".equals(catalogStyle) && !InterfacesMethod.checkIsInteger((String)catalogPath)) {
                finalResult = "\u5f53catalogStyle\u503c\u4e3a1\u65f6\uff0ccatalogPath\u5e94\u8be5\u4e3a0\u6216\u8005\u6b63\u6574\u6570\uff01";
                return finalResult;
            }
            if (StringUtil.isNotEmpty((String)(catalogSql = InterfacesMethod.getCatalogSql((String)catalogPath, (String)catalogStyle, (int)catalogType, (String)catalogSql)))) {
                InnerCodeDT = new QueryBuilder(catalogSql).executeDataTable();
                if (InnerCodeDT == null || InnerCodeDT.getRowCount() == 0) {
                    finalResult = "\u60a8\u67e5\u8be2\u7684\u680f\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u60a8\u91cd\u65b0\u8f93\u5165\uff01";
                    return finalResult;
                }
                innerCodeString = InnerCodeDT.getString(0, "innercode");
                catalogIdString = InnerCodeDT.getString(0, "id");
            }
            if (StringUtil.isNotEmpty((String)userName)) {
                DataTable catalogDT = new QueryBuilder("select * from SCMS_Catalog where type=5").executeDataTable();
                catalogDT = catalogDT.filter((Filter)new /* Unavailable Anonymous Inner Class!! */);
                for (int dtIndex = 0; dtIndex < catalogDT.getRowCount(); ++dtIndex) {
                    catalogList.add(catalogDT.getLong(dtIndex, "ID"));
                }
            }
            VideoInterfaceData vid = new VideoInterfaceData();
            finalResult = vid.getVideoListDataByInfo(siteId, getAllData, sortField, sort, pageSize, pageNum, status, sourceFlag, modifyFlag, startTime, endTime, keywords, innerCodeString, catalogIdString, catalogList);
        }
        catch (Exception e) {
            e.printStackTrace();
            finalResult = "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u89c6\u9891\u4fe1\u606f";
        }
        return finalResult;
    }
}

