/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.interfaces.sonInterfaces.impl;

import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.plugin.util.DateUtil;
import com.sobey.bsp.schema.SCMS_VirtualChannelConfigSchema;
import com.sobey.bsp.schema.SCMS_VirtualChannelConfigSet;
import com.sobey.cms.interfaces.sonInterfaces.VirChannelInterface;
import com.sobey.cms.util.NewInterfacesMethod;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class VirChannelInterfaceImpl
implements VirChannelInterface {
    public String getVirChannelList(HttpServletRequest request, String siteId) {
        String result = "";
        String isRepeat = request.getParameter("isRepeat");
        isRepeat = StringUtil.isNotEmpty((String)isRepeat) ? isRepeat.toUpperCase() : "1";
        String sortField = request.getParameter("sortField");
        String sort = request.getParameter("sort");
        if (StringUtil.isEmpty((String)sortField)) {
            sortField = "PublishDate";
        }
        if (StringUtil.isEmpty((String)sort)) {
            sort = "DESC";
        }
        try {
            String queryString = "select C.imgurl,C.id,C.name,C.info,C.publishdate,C.expiretime,C.isRepeat from scms_virtualchannel C  where C.ispublish=1  ";
            if (isRepeat != null && !"".equals(isRepeat)) {
                queryString = queryString + " and C.isRepeat=" + isRepeat;
            }
            queryString = queryString + " group by C.id";
            queryString = queryString + " ORDER BY " + sortField + " " + sort;
            DataTable dt = new QueryBuilder(queryString).executeDataTable();
            JSONArray ja = new JSONArray();
            for (int i = 0; dt != null && i < dt.getRowCount(); ++i) {
                String id = dt.getString(i, "ID");
                String name = dt.getString(i, "Name");
                String summary = dt.getString(i, "Info");
                String imageURL = dt.getString(i, "imgurl");
                String channelImgUrl = NewInterfacesMethod.getChannelImageURL((Long)Long.parseLong(siteId), (String)imageURL);
                String player = "<![CDATA[" + NewInterfacesMethod.generateLiveCode((String)id, (int)16) + "]]>";
                JSONObject jo = new JSONObject();
                jo.put((Object)"id", (Object)id);
                jo.put((Object)"name", (Object)name);
                jo.put((Object)"summary", (Object)summary);
                jo.put((Object)"channelImgUrl", (Object)channelImgUrl);
                jo.put((Object)"playerCode", (Object)player);
                NewInterfacesMethod newIm = new NewInterfacesMethod();
                JSONArray playerArray = newIm.generateLiveCodeList(siteId, id, 16);
                jo.put((Object)"playerCodeList", (Object)playerArray);
                ja.add((Object)jo);
            }
            result = ja.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u865a\u62df\u76f4\u64ad\u5217\u8868";
        }
        return result;
    }

    public String getVirChannelById(HttpServletRequest request, String siteId) {
        String result = "";
        String virChannelId = request.getParameter("virChannelId");
        try {
            virChannelId = "('" + virChannelId.replaceAll(",", "','") + "')";
            String queryString = "select C.imgurl,C.id,C.name,C.info,C.publishdate,C.expiretime,C.isRepeat from scms_virtualchannel C  where C.ispublish=1 and C.id in " + virChannelId;
            DataTable dt = new QueryBuilder(queryString).executeDataTable();
            JSONArray ja = new JSONArray();
            for (int i = 0; dt != null && i < dt.getRowCount(); ++i) {
                String id = dt.getString(i, "ID");
                String name = dt.getString(i, "Name");
                String summary = dt.getString(i, "Info");
                String imageURL = dt.getString(i, "imgurl");
                String player = "<![CDATA[" + NewInterfacesMethod.generateLiveCode((String)id, (int)16) + "]]>";
                String channelImgUrl = NewInterfacesMethod.getChannelImageURL((Long)Long.parseLong(siteId), (String)imageURL);
                JSONObject jo = new JSONObject();
                jo.put((Object)"id", (Object)id);
                jo.put((Object)"name", (Object)name);
                jo.put((Object)"summary", (Object)summary);
                jo.put((Object)"channelImgUrl", (Object)channelImgUrl);
                jo.put((Object)"playerCode", (Object)player);
                NewInterfacesMethod newIm = new NewInterfacesMethod();
                JSONArray playerArray = newIm.generateLiveCodeList(siteId, id, 16);
                jo.put((Object)"playerCodeList", (Object)playerArray);
                ja.add((Object)jo);
            }
            result = ja.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u83b7\u53d6\u865a\u62df\u76f4\u64ad\u5217\u8868";
        }
        return result;
    }

    public String getVirChannelActList(HttpServletRequest request, String siteId) {
        String date = "";
        String virChannelId = request.getParameter("virChannelId");
        String startDate = request.getParameter("startDate");
        String endDate = request.getParameter("endDate");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        JSONArray playBill = new JSONArray();
        try {
            if (StringUtil.isEmpty((String)virChannelId)) {
                String finalResult = "\u60a8\u8f93\u5165\u7684virChannelId\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684virChannelId";
                return finalResult;
            }
            if (StringUtil.isEmpty((String)startDate)) {
                String finalResult = "\u60a8\u8f93\u5165\u7684startDate\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5f00\u59cb\u65f6\u95f4";
                return finalResult;
            }
            long endCount = 0L;
            if (!StringUtil.isEmpty((String)endDate)) {
                endCount = (format.parse(endDate).getTime() - format.parse(startDate).getTime()) / 1000L / 24L / 60L / 60L;
            }
            JSONObject obj = new JSONObject();
            int j = 0;
            while ((long)j <= endCount) {
                JSONArray ja = new JSONArray();
                date = format.format(DateUtil.addDay((Date)format.parse(startDate), (int)j));
                SCMS_VirtualChannelConfigSchema virtualList = new SCMS_VirtualChannelConfigSchema();
                QueryBuilder qb = new QueryBuilder();
                qb.setSQL("where vid='" + virChannelId + "' " + " and date like '%" + date + "%' " + " order by id");
                SCMS_VirtualChannelConfigSet virtualSet = virtualList.query(qb);
                JSONObject jo = new JSONObject();
                if (virtualSet != null && !virtualSet.isEmpty()) {
                    for (int i = 0; i < virtualSet.size(); ++i) {
                        virtualList = virtualSet.get(i);
                        String startTime = virtualList.getStarttime();
                        String endTime = virtualList.getEndtime();
                        jo.put((Object)"name", (Object)virtualList.getContent());
                        jo.put((Object)"type", (Object)virtualList.getType());
                        jo.put((Object)"videoId", (Object)virtualList.getCid());
                        jo.put((Object)"length", (Object)virtualList.getProgramlength());
                        jo.put((Object)"id", (Object)virtualList.getId());
                        jo.put((Object)"startTime", (Object)startTime);
                        jo.put((Object)"endTime", (Object)endTime);
                        ja.add((Object)jo);
                    }
                    obj.put((Object)"date", (Object)date);
                    obj.put((Object)"playBill", (Object)ja);
                    playBill.add((Object)obj);
                }
                ++j;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return playBill.toString();
    }
}

