/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.interfaces.tool;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_ChannelRecordSchema;
import com.sobey.bsp.threadmanager.ChannelRecordThread;
import com.sobey.bsp.threadmanager.ThreadPoolManager;
import com.sobey.bsp.threadmanager.ThreadTask;
import com.sobey.cms.interfaces.tool.util.ChannelRecordLogUtil;
import com.sobey.cms.util.InterfacesMethod;
import com.sobey.cms.util.InterfacesUtil;
import com.sobey.scms.contentinfo.interfaces.impl.ScreenshotImageInterfaceImpl;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelRecordCutServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ChannelRecordCutServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        String data = request.getParameter("data");
        JSONObject result = new JSONObject();
        try {
            log.info("\u76f4\u64ad\u62c6\u6761\u63a5\u6536\u5230\u7684\u6570\u636e\u4e3a:{}", (Object)data);
            new JSONObject();
            JSONObject jsonObject = JSONObject.fromObject((Object)data);
            String partnerToken = jsonObject.getString("partnerToken");
            Transaction transaction = new Transaction();
            DBConnPool.setCurrent((DBConnConfig)DBConnConfig.getDefaultDBConnConfigInstance());
            String siteId = InterfacesMethod.getSiteIdByToken((String)partnerToken);
            DBConnPool.setDBConnPool((Long)Long.parseLong(siteId));
            String userName = this.getUserName(jsonObject, siteId);
            SCMS_ChannelRecordSchema scmsChannelRecordSchema = this.buildScmsChannelRecordSchema(jsonObject, siteId, userName);
            transaction.add((Schema)scmsChannelRecordSchema, 1);
            ChannelRecordLogUtil.addLog((Transaction)transaction, (Long)scmsChannelRecordSchema.getId(), (String)"\u65b0\u5efa\u6536\u5f55\u8ba1\u5212", (String)userName, (String)"INSERT");
            if (transaction.commit()) {
                ChannelRecordThread channelRecordThread = new ChannelRecordThread(scmsChannelRecordSchema);
                ThreadPoolManager.getInstance().addTask((ThreadTask)channelRecordThread);
                result.put((Object)"status", (Object)"true");
                result.put((Object)"message", (Object)"\u6536\u5f55\u8ba1\u5212\u65b0\u589e\u6210\u529f\uff01");
                InterfacesUtil.writeResponse((String)result.toString(), (HttpServletResponse)response);
                return;
            }
        }
        catch (Exception e) {
            log.error("\u76f4\u64ad\u62c6\u6761\u5904\u7406\u8fc7\u7a0b\u4e2d\u9047\u5230\u5f02\u5e38", (Throwable)e);
            result.put((Object)"status", (Object)"false");
            result.put((Object)"message", (Object)"\u6536\u5f55\u8ba1\u5212\u65b0\u589e\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5!");
            InterfacesUtil.writeResponse((String)result.toString(), (HttpServletResponse)response);
        }
    }

    private JSONArray getImageUrlJSONArray(String siteId, JSONArray images, String contentSourceId) throws Exception {
        ScreenshotImageInterfaceImpl screenshotImageInterface = new ScreenshotImageInterfaceImpl();
        JSONArray imageUrlJSONArray = new JSONArray();
        for (int i = 0; i < images.size(); ++i) {
            JSONObject imageUrlJSONObject = screenshotImageInterface.saveScreenshotImage(contentSourceId, Long.parseLong(siteId), 5, images.getString(i), 9 + i);
            imageUrlJSONArray.add((Object)imageUrlJSONObject);
        }
        return imageUrlJSONArray;
    }

    private String getUserName(JSONObject jsonObject, String siteId) {
        String userName = jsonObject.getString("userName");
        if (StringUtil.isEmpty((String)userName)) {
            userName = SiteUtil.getSiteIdByEmail((String)siteId);
        }
        return userName;
    }

    private SCMS_ChannelRecordSchema buildScmsChannelRecordSchema(JSONObject jsonObject, String siteId, String userName) throws Exception {
        String contentSourceId = UUID.randomUUID().toString().replaceAll("-", "");
        JSONArray images = jsonObject.getJSONArray("images");
        JSONArray imageUrlJSONArray = this.getImageUrlJSONArray(siteId, images, contentSourceId);
        jsonObject.put((Object)"images", (Object)imageUrlJSONArray);
        String catalogId = jsonObject.getString("catalogId");
        String cid = jsonObject.getString("cid");
        String title = jsonObject.getString("title");
        SCMS_ChannelRecordSchema scmsChannelRecordSchema = new SCMS_ChannelRecordSchema();
        scmsChannelRecordSchema.setId(Long.valueOf(NoUtil.getMaxID((String)"ChannelRecordID")));
        scmsChannelRecordSchema.setTitle(title);
        scmsChannelRecordSchema.setContentSourceId(contentSourceId);
        scmsChannelRecordSchema.setStatus(Integer.valueOf(9));
        scmsChannelRecordSchema.setChannelId(cid);
        scmsChannelRecordSchema.setInfo(jsonObject.toString());
        scmsChannelRecordSchema.setCreateUser(userName);
        scmsChannelRecordSchema.setCreateTime(new Date());
        scmsChannelRecordSchema.setModifyUser(userName);
        scmsChannelRecordSchema.setModifyTime(new Date());
        scmsChannelRecordSchema.setFilePath("");
        scmsChannelRecordSchema.setSiteId(Long.valueOf(Long.parseLong(siteId)));
        scmsChannelRecordSchema.setCatalogid(Long.valueOf(Long.parseLong(catalogId)));
        return scmsChannelRecordSchema;
    }
}

