/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.interfaces.tool.impl;

import com.sobey.bsp.cms.pub.PubFun;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.SiteConfig;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.utility.Filter;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.schema.SCMS_CatalogSchema;
import com.sobey.cms.interfaces.tool.interfaces.ToolEditCutInterface;
import com.sobey.cms.util.NewInterfacesMethod;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class ToolEditCutInterfaceImpl
implements ToolEditCutInterface {
    public String getCatalogList(JSONObject parameter) {
        String mediaType = parameter.getString("mediaType");
        String userName = parameter.getString("userName");
        String result = "";
        try {
            JSONArray catalog = this.getCatalogListByParentId(Integer.parseInt(mediaType), userName, 0L);
            result = catalog.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private JSONArray getCatalogListByParentId(int mediaType, String userName, long parentId) throws Exception {
        String sql = "select id,name,innercode from scms_Catalog where type=" + mediaType + " and parentId=" + parentId;
        DataTable dt = new QueryBuilder(sql).executeDataTable();
        JSONArray children = new JSONArray();
        if (dt != null && dt.getRowCount() > 0) {
            dt = dt.filter((Filter)new /* Unavailable Anonymous Inner Class!! */);
            for (int i = 0; i < dt.getRowCount(); ++i) {
                JSONObject catalog = new JSONObject();
                long id = dt.getLong(i, "id");
                String name = dt.getString(i, "name");
                catalog.put((Object)"id", (Object)String.valueOf(id));
                catalog.put((Object)"name", (Object)name);
                catalog.put((Object)"children", (Object)this.getCatalogListByParentId(mediaType, userName, id));
                children.add((Object)catalog);
            }
        }
        return children;
    }

    public String getTransCode(JSONObject parameter) {
        int mediaType = Integer.parseInt(parameter.getString("mediaType"));
        String userName = parameter.getString("userName");
        String result = "";
        try {
            JSONArray ja = new JSONArray();
            String Tsql = "select tid,id,name,groupType from scms_transcodegroup";
            if (mediaType != 0) {
                Tsql = "select tid,id,name,groupType from scms_transcodegroup where groupType=" + mediaType;
            }
            QueryBuilder Tqb = new QueryBuilder(Tsql);
            DataTable Tdt = Tqb.executeDataTable();
            String menuid = new QueryBuilder("select id from scms_menu where name='\u8f6c\u7801\u8bbe\u7f6e' ").executeString();
            String menuId = menuid + "-";
            String rolecode = PubFun.getRoleCodeByUserName((String)userName);
            if (Tdt != null && Tdt.getRowCount() > 0) {
                Tdt = Tdt.filter((Filter)new /* Unavailable Anonymous Inner Class!! */);
                for (int i = 0; i < Tdt.getRowCount(); ++i) {
                    JSONObject jo = new JSONObject();
                    jo.put((Object)"id", (Object)Tdt.getString(i, "id"));
                    jo.put((Object)"title", (Object)Tdt.getString(i, "name"));
                    jo.put((Object)"mediaType", (Object)Tdt.getString(i, "groupType"));
                    jo.put((Object)"alias", (Object)Tdt.getString(i, "name"));
                    String parentId = Tdt.getString(i, "tid");
                    String codeSql = "select id,name,alias,TranscodeType from scms_transcode where id in (" + parentId + ")";
                    QueryBuilder codeQb = new QueryBuilder(codeSql);
                    DataTable codeDt = codeQb.executeDataTable();
                    JSONArray jay = new JSONArray();
                    if (codeDt != null && codeDt.getRowCount() > 0) {
                        for (int j = 0; j < codeDt.getRowCount(); ++j) {
                            JSONObject jobj = new JSONObject();
                            jobj.put((Object)"formatId", (Object)codeDt.getString(j, "id"));
                            jobj.put((Object)"formatAlias", (Object)codeDt.getString(j, "name"));
                            jobj.put((Object)"formatname", (Object)codeDt.getString(j, "alias"));
                            jobj.put((Object)"formattype", (Object)codeDt.getString(j, "TranscodeType"));
                            jay.add((Object)jobj);
                        }
                    }
                    jo.put((Object)"codes", (Object)jay);
                    ja.add((Object)jo);
                }
            }
            result = ja.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getAudioList(JSONObject parameter, String siteId) {
        String result = "";
        String isExistSource = "1";
        String sortField = "PublishDate";
        String sort = "DESC";
        String pageSize = "10";
        String pageNum = "1";
        String keywords = "";
        String catalogId = parameter.getString("catalogId");
        if (parameter.has("sortField") && StringUtil.isNotEmpty((String)parameter.getString("sortField"))) {
            sortField = parameter.getString("sortField");
        }
        if (parameter.has("sort") && StringUtil.isNotEmpty((String)parameter.getString("sort"))) {
            sort = parameter.getString("sort");
        }
        if (parameter.has("rowNum") && StringUtil.isNotEmpty((String)parameter.getString("rowNum"))) {
            pageSize = parameter.getString("rowNum");
        }
        if (parameter.has("currentPage") && StringUtil.isNotEmpty((String)parameter.getString("currentPage"))) {
            pageNum = parameter.getString("currentPage");
        }
        if (parameter.has("keywords") && StringUtil.isNotEmpty((String)parameter.getString("keywords"))) {
            keywords = parameter.getString("keywords");
        }
        if (parameter.has("isExistSource") && StringUtil.isNotEmpty((String)parameter.getString("isExistSource"))) {
            isExistSource = parameter.getString("isExistSource");
        }
        SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
        catalog.setID(catalogId);
        String catalogInnerCode = "";
        if (catalog.fill()) {
            catalogInnerCode = catalog.getInnerCode();
        }
        String sql = "select C.ContentSourceId,C.PlayUrl,C.Title,C.duration ,C.KeyFrame,C.status,C.catalogid,C.path,C.createtime from scms_audioinfo C where C.path is not null and C.STATUS in (0,1) ";
        String countsql = "select count(C.id) from scms_audioinfo C   where C.path is not null and  C.STATUS in (0,1) ";
        if ("0".equals(isExistSource)) {
            sql = "select C.ContentSourceId,C.PlayUrl,C.Title,C.duration ,C.KeyFrame,C.status,C.catalogid,C.path,C.createtime from scms_audioinfo C where C.STATUS in (0,1) ";
            countsql = "select count(C.id) from scms_audioinfo C   where  C.STATUS in (0,1) ";
        }
        if (StringUtil.isNotEmpty((String)catalogInnerCode)) {
            sql = sql + " and C.CatalogInnerCode like ? ";
            countsql = countsql + " and C.CatalogInnerCode like ?";
        }
        if (StringUtil.isNotEmpty((String)keywords)) {
            sql = sql + " and C.title like ?  ";
            countsql = countsql + " and C.title like ? ";
        }
        sql = sql + " ORDER BY C." + sortField + " " + sort;
        QueryBuilder qb = new QueryBuilder(sql);
        QueryBuilder countQb = new QueryBuilder(countsql);
        if (StringUtil.isNotEmpty((String)catalogInnerCode)) {
            qb.add((Object)(catalogInnerCode + "%"));
            countQb.add((Object)(catalogInnerCode + "%"));
        }
        if (StringUtil.isNotEmpty((String)keywords)) {
            qb.add((Object)("%" + keywords + "%"));
            countQb.add((Object)("%" + keywords + "%"));
        }
        JSONObject resultJson = new JSONObject();
        DataTable dt = qb.executePagedDataTable(Integer.parseInt(pageSize), Integer.parseInt(pageNum) - 1);
        Long total = countQb.executeLong();
        String videoSourceDir = SiteUtil.getWinVideoUploadDir((String)siteId);
        JSONArray mediaJa = new JSONArray();
        for (int i = 0; i < dt.getRowCount(); ++i) {
            JSONObject jo = new JSONObject();
            String id = dt.getString(i, "ContentSourceId");
            String title = dt.getString(i, "title");
            String playUrl = dt.getString(i, "PlayUrl");
            Long programLength = dt.getLong(i, "duration");
            String status = dt.getString(i, "status");
            String keyFrame = dt.getString(i, "KeyFrame");
            String sourceUrl = dt.getString(i, "path");
            String createTime = dt.getString(i, "createTime");
            NewInterfacesMethod newIm = new NewInterfacesMethod();
            String imagePath = newIm.getKeyFramesPath(siteId, keyFrame);
            String getOnePlayUrl = NewInterfacesMethod.getOnePlayUrl((String)playUrl, (String)siteId, (int)6);
            String sourcePath = videoSourceDir + sourceUrl;
            jo.put((Object)"path", (Object)StringUtil.replaceAllToBack_Slant((String)sourcePath));
            jo.put((Object)"id", (Object)id);
            jo.put((Object)"title", (Object)title);
            jo.put((Object)"sourceType", (Object)"2");
            jo.put((Object)"programLength", (Object)(programLength == null ? "0" : String.valueOf((double)programLength.longValue() / 1000.0)));
            jo.put((Object)"createTime", (Object)createTime);
            jo.put((Object)"status", (Object)status);
            jo.put((Object)"sourceurl", (Object)getOnePlayUrl);
            jo.put((Object)"keyFrameurl", (Object)imagePath);
            mediaJa.add((Object)jo);
        }
        resultJson.put((Object)"data", (Object)mediaJa);
        resultJson.put((Object)"totalrecords", (Object)String.valueOf(total));
        resultJson.put((Object)"currentpage", (Object)pageNum);
        resultJson.put((Object)"rownum", (Object)pageSize);
        if (Integer.parseInt(pageSize) == 0) {
            resultJson.put((Object)"totalpages", (Object)0);
        } else if (total.intValue() % Integer.parseInt(pageSize) == 0) {
            resultJson.put((Object)"totalpages", (Object)(total.intValue() / Integer.parseInt(pageSize) + ""));
        } else {
            resultJson.put((Object)"totalpages", (Object)(total.intValue() / Integer.parseInt(pageSize) + 1 + ""));
        }
        resultJson.put((Object)"sort", (Object)sort);
        resultJson.put((Object)"sortField", (Object)sortField);
        result = resultJson.toString();
        return result;
    }

    public String getChannelList(JSONObject parameter, String siteId) {
        String result = "";
        try {
            QueryBuilder Tqb;
            DataTable Tdt;
            String userName = parameter.getString("userName");
            String channelIds = "";
            String RoleCode = PubFun.getRoleCodeByUserName((String)userName);
            String roleSql = "select * from scms_privilege where OwnerType='R' and Owner='" + RoleCode + "' and PrivType='channel'";
            DataTable roleDt = new QueryBuilder(roleSql).executeDataTable();
            if (roleDt != null && roleDt.getRowCount() > 0) {
                for (int i = 0; i < roleDt.getRowCount(); ++i) {
                    channelIds = channelIds + "'" + roleDt.getString(i, "id") + "',";
                }
                channelIds = channelIds.substring(0, channelIds.length() - 1);
            }
            JSONArray ja = new JSONArray();
            String Tsql = "SELECT  c.streamSource,c.id as liveStreamId ,cs.id, cs.name,cs.imageUrl, c.Fullurl FROM scms_channelconfig c,scms_channels cs WHERE c.quickCutFlag=1 and cs.Id=c.Cid AND c.quickCutFlag=1 ";
            if (StringUtil.isNotEmpty((String)channelIds)) {
                Tsql = Tsql + " and cs.id in (" + channelIds + ")";
            }
            if ((Tdt = (Tqb = new QueryBuilder(Tsql)).executeDataTable()) != null && Tdt.getRowCount() > 0) {
                for (int i = 0; i < Tdt.getRowCount(); ++i) {
                    JSONObject jo = new JSONObject();
                    jo.put((Object)"id", (Object)Tdt.getString(i, "id"));
                    jo.put((Object)"name", (Object)Tdt.getString(i, "name"));
                    jo.put((Object)"liveStreamId", (Object)Tdt.getString(i, "liveStreamId"));
                    int streamSource = Tdt.getInt(i, "streamSource");
                    String fullUrl = Tdt.getString(i, "Fullurl");
                    if (2 == streamSource) {
                        jo.put((Object)"liveUrl", (Object)fullUrl);
                    } else {
                        jo.put((Object)"liveUrl", (Object)((String)SiteConfig.getValue((Long)Long.parseLong(siteId), (Object)"liveDeomltionDomain") + Tdt.getString(i, "Fullurl")));
                    }
                    String imageURL = Tdt.getString(i, "imageUrl");
                    if (StringUtil.isNotEmpty((String)imageURL)) {
                        String channelImgUrl = NewInterfacesMethod.getChannelImageURL((Long)Long.parseLong(siteId), (String)imageURL);
                        jo.put((Object)"iconUrl", (Object)channelImgUrl);
                    } else {
                        jo.put((Object)"iconUrl", (Object)"");
                    }
                    ja.add((Object)jo);
                }
            }
            result = ja.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getChannelActList(JSONObject parameter) {
        String result = "";
        JSONArray ja = new JSONArray();
        String channelId = parameter.getString("channelId");
        String startDate = parameter.getString("startDate");
        String endDate = parameter.getString("endDate");
        endDate = endDate + " 23:59:59";
        String sql = "SELECT  name,playtime,endTime FROM scms_actlist WHERE playtime>='" + startDate + "' AND playtime<='" + endDate + "' AND cid='" + channelId + "'ORDER BY playtime ASC;";
        QueryBuilder Tqb = new QueryBuilder(sql);
        DataTable Tdt = Tqb.executeDataTable();
        if (Tdt != null && Tdt.getRowCount() > 0) {
            for (int i = 0; i < Tdt.getRowCount(); ++i) {
                JSONObject jo = new JSONObject();
                jo.put((Object)"startTime", (Object)Tdt.getString(i, "playtime"));
                jo.put((Object)"name", (Object)Tdt.getString(i, "name"));
                jo.put((Object)"endTime", (Object)Tdt.getString(i, "endTime"));
                ja.add((Object)jo);
            }
        }
        result = ja.toString();
        return result;
    }

    public String getVideoList(JSONObject parameter, String siteId) {
        String result = "";
        String isExistSource = "1";
        String sortField = "PublishDate";
        String sort = "DESC";
        String pageSize = "10";
        String pageNum = "1";
        String keywords = "";
        String catalogId = parameter.getString("catalogId");
        if (parameter.has("sortField") && StringUtil.isNotEmpty((String)parameter.getString("sortField"))) {
            sortField = parameter.getString("sortField");
        }
        if (parameter.has("sort") && StringUtil.isNotEmpty((String)parameter.getString("sort"))) {
            sort = parameter.getString("sort");
        }
        if (parameter.has("rowNum") && StringUtil.isNotEmpty((String)parameter.getString("rowNum"))) {
            pageSize = parameter.getString("rowNum");
        }
        if (parameter.has("currentPage") && StringUtil.isNotEmpty((String)parameter.getString("currentPage"))) {
            pageNum = parameter.getString("currentPage");
        }
        if (parameter.has("keywords") && StringUtil.isNotEmpty((String)parameter.getString("keywords"))) {
            keywords = parameter.getString("keywords");
        }
        if (parameter.has("isExistSource") && StringUtil.isNotEmpty((String)parameter.getString("isExistSource"))) {
            isExistSource = parameter.getString("isExistSource");
        }
        SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
        catalog.setID(catalogId);
        String catalogInnerCode = "";
        if (catalog.fill()) {
            catalogInnerCode = catalog.getInnerCode();
        }
        String sql = "select C.ContentSourceId,C.sourceSystemName,C.Title,C.ProgramLength ,C.KeyFrame,C.status,C.catalogid,C.path,C.createtime from scms_contentinfo C where C.path is not null and C.STATUS in (0,1) ";
        String countsql = "select count(C.contentid) from scms_contentinfo C   where C.path is not null and  C.STATUS in (0,1) ";
        if ("0".equals(isExistSource)) {
            sql = "select C.ContentSourceId,C.sourceSystemName,C.Title,C.ProgramLength ,C.KeyFrame,C.status,C.catalogid,C.path,C.createtime from scms_contentinfo C where  C.STATUS in (0,1) ";
            countsql = "select count(C.contentid) from scms_contentinfo C   where  C.STATUS in (0,1) ";
        }
        if (StringUtil.isNotEmpty((String)catalogInnerCode)) {
            sql = sql + " and C.CatalogInnerCode like ? ";
            countsql = countsql + " and C.CatalogInnerCode like ?";
        }
        if (StringUtil.isNotEmpty((String)keywords)) {
            sql = sql + " and C.title like ?  ";
            countsql = countsql + " and C.title like ? ";
        }
        sql = sql + " ORDER BY C." + sortField + " " + sort;
        QueryBuilder qb = new QueryBuilder(sql);
        QueryBuilder countQb = new QueryBuilder(countsql);
        if (StringUtil.isNotEmpty((String)catalogInnerCode)) {
            qb.add((Object)(catalogInnerCode + "%"));
            countQb.add((Object)(catalogInnerCode + "%"));
        }
        if (StringUtil.isNotEmpty((String)keywords)) {
            qb.add((Object)("%" + keywords + "%"));
            countQb.add((Object)("%" + keywords + "%"));
        }
        JSONObject resultJson = new JSONObject();
        DataTable dt = qb.executePagedDataTable(Integer.parseInt(pageSize), Integer.parseInt(pageNum) - 1);
        Long total = countQb.executeLong();
        String videoSourceDir = SiteUtil.getWinVideoUploadDir((String)siteId);
        JSONArray mediaJa = new JSONArray();
        for (int i = 0; i < dt.getRowCount(); ++i) {
            JSONObject jo = new JSONObject();
            String id = dt.getString(i, "ContentSourceId");
            String title = dt.getString(i, "title");
            String playUrl = dt.getString(i, "sourceSystemName");
            Long programLength = dt.getLong(i, "ProgramLength");
            String status = dt.getString(i, "status");
            String keyFrame = dt.getString(i, "KeyFrame");
            String sourceUrl = dt.getString(i, "path");
            String createTime = dt.getString(i, "createTime");
            NewInterfacesMethod newIm = new NewInterfacesMethod();
            String imagePath = newIm.getKeyFramesPath(siteId, keyFrame);
            String getOnePlayUrl = NewInterfacesMethod.getOnePlayUrl((String)playUrl, (String)siteId, (int)5);
            if (StringUtil.isEmpty((String)sourceUrl)) continue;
            String sourcePath = videoSourceDir + sourceUrl;
            jo.put((Object)"path", (Object)StringUtil.replaceAllToBack_Slant((String)sourcePath));
            jo.put((Object)"id", (Object)id);
            jo.put((Object)"title", (Object)title);
            jo.put((Object)"sourceType", (Object)"1");
            jo.put((Object)"programLength", (Object)(programLength == null ? "0" : String.valueOf((double)programLength.longValue() / 1000.0)));
            jo.put((Object)"createTime", (Object)createTime);
            jo.put((Object)"status", (Object)status);
            jo.put((Object)"sourceurl", (Object)getOnePlayUrl);
            jo.put((Object)"keyFrameurl", (Object)imagePath);
            mediaJa.add((Object)jo);
        }
        resultJson.put((Object)"data", (Object)mediaJa);
        resultJson.put((Object)"totalrecords", (Object)String.valueOf(total));
        resultJson.put((Object)"currentpage", (Object)pageNum);
        resultJson.put((Object)"rownum", (Object)pageSize);
        if (Integer.parseInt(pageSize) == 0) {
            resultJson.put((Object)"totalpages", (Object)0);
        } else if (total.intValue() % Integer.parseInt(pageSize) == 0) {
            resultJson.put((Object)"totalpages", (Object)(total.intValue() / Integer.parseInt(pageSize) + ""));
        } else {
            resultJson.put((Object)"totalpages", (Object)(total.intValue() / Integer.parseInt(pageSize) + 1 + ""));
        }
        resultJson.put((Object)"sort", (Object)sort);
        resultJson.put((Object)"sortField", (Object)sortField);
        result = resultJson.toString();
        return result;
    }
}

