/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.util;

import com.google.common.collect.Lists;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.schema.SCMS_AccountSchema;
import com.sobey.bsp.schema.SCMS_CatalogSchema;
import com.sobey.bsp.util.StringsUtil;
import com.sobey.cms.media.PlayerCode;
import com.sobey.cms.media.PlayerCodeList;
import com.sobey.cms.util.PostHttpUtil;
import com.sobey.scms.player.PlayerConstant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;

public class InterfacesMethod {
    public static Map deleteVideo(Transaction trans, String videoIDs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] contentIds = null;
        String[] paths = null;
        String[] contentSourceIds = null;
        String[] srcFileNames = null;
        String contentIdSring = "";
        String siteId = "";
        String[] videoId = videoIDs.split(",");
        String contentSourceIdsString = "";
        for (int i = 0; i < videoId.length; ++i) {
            if (!StringUtil.isNotEmpty((String)videoId[i])) continue;
            contentSourceIdsString = contentSourceIdsString + ",'" + videoId[i] + "'";
        }
        if (StringUtil.isEmpty((String)contentSourceIdsString)) {
            map.put("status", 0);
            return map;
        }
        contentSourceIdsString = contentSourceIdsString.substring(1, contentSourceIdsString.length());
        String contentIdsSql = "select path,contentid,contentSourceId,siteId from scms_contentinfo where contentSourceId in (" + contentSourceIdsString + ")";
        DataTable dt = new QueryBuilder(contentIdsSql).executeDataTable();
        contentIds = new String[dt.getRowCount()];
        contentSourceIds = new String[dt.getRowCount()];
        paths = new String[dt.getRowCount()];
        for (int i = 0; i < dt.getRowCount(); ++i) {
            contentIds[i] = dt.getString(i, "contentid");
            contentSourceIds[i] = dt.getString(i, "contentSourceId");
            if (i == 0) {
                contentIdSring = dt.getString(i, "contentid");
                siteId = dt.getString(i, "siteId");
            } else {
                contentIdSring = contentIdSring + "," + dt.getString(i, "contentid");
            }
            paths[i] = dt.getString(i, "path");
        }
        if (StringUtil.isEmpty((String)contentIdSring)) {
            map.put("status", 0);
            return map;
        }
        String SrcFileNamesSql = "select srcFilename from scms_video where contentid in (" + contentIdSring + ")";
        DataTable dt1 = new QueryBuilder(SrcFileNamesSql).executeDataTable();
        srcFileNames = new String[dt1.getRowCount()];
        for (int i = 0; i < dt1.getRowCount(); ++i) {
            srcFileNames[i] = dt1.getString(i, "srcFileName");
        }
        String contentinfoDeleteSql = "delete from scms_contentinfo where contentid in (" + contentIdSring + ")";
        String contentinfoLogDeleteSql = "delete from scms_contentinfolog where contentid in (" + contentIdSring + ")";
        String recycleDeleteSql = "delete from scms_recycle where assignmentType=5 and contentid in (" + contentIdSring + ")";
        String videoDeleteSql = "delete from scms_video where contentid in (" + contentIdSring + ")";
        trans.add(new QueryBuilder(contentinfoDeleteSql));
        trans.add(new QueryBuilder(recycleDeleteSql));
        trans.add(new QueryBuilder(contentinfoLogDeleteSql));
        trans.add(new QueryBuilder(videoDeleteSql));
        map.put("status", 1);
        map.put("siteId", siteId);
        map.put("paths", paths);
        map.put("contentSourceIds", contentSourceIds);
        map.put("contentIds", contentIds);
        map.put("srcFileNames", srcFileNames);
        return map;
    }

    public static Map deleteAudio(Transaction transaction, String audioIDs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] contentIds = null;
        String[] paths = null;
        String[] contentSourceIds = null;
        Object fileUrls = null;
        String siteId = "";
        String[] audioId = audioIDs.split(",");
        String contentSourceIdsString = "";
        for (int i = 0; i < audioId.length; ++i) {
            if (!StringUtil.isNotEmpty((String)audioId[i])) continue;
            contentSourceIdsString = contentSourceIdsString + ",'" + audioId[i] + "'";
        }
        if (StringUtil.isEmpty((String)contentSourceIdsString)) {
            map.put("status", 0);
            return map;
        }
        contentSourceIdsString = contentSourceIdsString.substring(1, contentSourceIdsString.length());
        String contentIdsSql = "select path,ID,ContentSourceId,Siteid from scms_audioinfo where contentSourceId in (" + contentSourceIdsString + ")";
        DataTable dt = new QueryBuilder(contentIdsSql).executeDataTable();
        contentIds = new String[dt.getRowCount()];
        contentSourceIds = new String[dt.getRowCount()];
        paths = new String[dt.getRowCount()];
        String allAudioInfoId = "";
        for (int i = 0; i < dt.getRowCount(); ++i) {
            contentIds[i] = dt.getString(i, "id");
            contentSourceIds[i] = dt.getString(i, "contentSourceId");
            if (i == 0) {
                allAudioInfoId = dt.getString(i, "id");
                siteId = dt.getString(i, "siteId");
            } else {
                allAudioInfoId = allAudioInfoId + "," + dt.getString(i, "id");
            }
            paths[i] = dt.getString(i, "path");
        }
        if (StringUtil.isEmpty((String)allAudioInfoId)) {
            map.put("status", 0);
            return map;
        }
        String fileUrlSql = "select FileUrl from scms_audio where AudioInfoId in (" + allAudioInfoId + ")";
        DataTable dt1 = new QueryBuilder(fileUrlSql).executeDataTable();
        ArrayList fileUrlList = Lists.newArrayList();
        for (int i = 0; i < dt1.getRowCount(); ++i) {
            fileUrlList.add(dt1.getString(i, "FileUrl"));
        }
        String contentinfoDeleteSql = "delete from scms_audioinfo where id in (" + allAudioInfoId + ")";
        String contentinfoLogDeleteSql = "delete from scms_audioinfolog where contentid in (" + allAudioInfoId + ")";
        String recycleDeleteSql = "delete from scms_recycle where assignmentType=6 and contentid in (" + allAudioInfoId + ")";
        String audioDeleteSql = "delete from scms_audio where AudioInfoId in (" + allAudioInfoId + ")";
        transaction.add(new QueryBuilder(contentinfoDeleteSql));
        transaction.add(new QueryBuilder(recycleDeleteSql));
        transaction.add(new QueryBuilder(contentinfoLogDeleteSql));
        transaction.add(new QueryBuilder(audioDeleteSql));
        map.put("status", 1);
        map.put("siteId", siteId);
        map.put("paths", paths);
        map.put("contentSourceIds", contentSourceIds);
        map.put("contentIds", contentIds);
        map.put("fileUrlList", fileUrlList);
        return map;
    }

    public static Map deleteSeries(Transaction trans, String sourceIDs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] videoId = sourceIDs.split(",");
        String contentSourceIdsString = "";
        for (int i = 0; i < videoId.length; ++i) {
            if (!StringUtil.isNotEmpty((String)videoId[i])) continue;
            contentSourceIdsString = contentSourceIdsString + ",'" + videoId[i] + "'";
        }
        if (StringUtil.isEmpty((String)contentSourceIdsString)) {
            map.put("status", 0);
            return map;
        }
        contentSourceIdsString = contentSourceIdsString.substring(1, contentSourceIdsString.length());
        String siteId = "";
        String contentIdSring = "";
        String[] contentSourceIds = null;
        String[] contentIds = null;
        String contentSourcerIdsSql = "select seriesid,siteid,seriesSourceId from scms_series where seriesSourceId in (" + contentSourceIdsString + ")";
        DataTable dt = new QueryBuilder(contentSourcerIdsSql).executeDataTable();
        contentIds = new String[dt.getRowCount()];
        contentSourceIds = new String[dt.getRowCount()];
        for (int i = 0; i < dt.getRowCount(); ++i) {
            contentIds[i] = dt.getString(i, "contentid");
            contentSourceIds[i] = dt.getString(i, "seriesSourceId");
            if (i == 0) {
                contentIdSring = dt.getString(i, "seriesid");
                siteId = dt.getString(i, "siteId");
                continue;
            }
            contentIdSring = contentIdSring + "," + dt.getString(i, "seriesid");
        }
        String seriesDeleteSql = "delete from scms_series where seriesid in (" + contentIdSring + ")";
        String recycleDeleteSql = "delete from scms_recycle where assignmentType=7 and contentid in (" + contentIdSring + ")";
        String seriesInfoDeleteSql = "delete from scms_seriesinfolog where seriesid in (" + contentIdSring + ")";
        trans.add(new QueryBuilder(seriesDeleteSql));
        trans.add(new QueryBuilder(recycleDeleteSql));
        trans.add(new QueryBuilder(seriesInfoDeleteSql));
        map.put("status", 1);
        map.put("siteId", siteId);
        map.put("contentSourceIds", contentSourceIds);
        return map;
    }

    public static String getCatalogSql(String catalogPath, String catalogStyle, int catalogType, String sql) {
        if ("1".equals(catalogStyle)) {
            int catalogId = Integer.parseInt(catalogPath);
            if (catalogId > 0) {
                sql = "select innercode,id from SCMS_Catalog where type=" + catalogType + " and id=" + catalogId;
            }
        } else {
            String[] catalogPaths = catalogPath.split("@");
            if (catalogPaths.length > 1) {
                String inSql = "";
                String inString = "";
                sql = "select innercode,id from SCMS_Catalog where type=" + catalogType + " and name='" + catalogPaths[catalogPaths.length - 1] + "' and treelevel=" + (catalogPaths.length - 1);
                for (int i = catalogPaths.length - 2; i > 0; --i) {
                    inSql = inSql + " and parentid in (select id from SCMS_Catalog where name='" + catalogPaths[i] + "' and treelevel=" + i;
                    inString = inString + ")";
                }
                sql = sql + inSql + inString;
            }
        }
        return sql;
    }

    public PlayerCodeList generateVodCodeList(String siteId, String videoId, int styleType, int playerType, String dateString) {
        PlayerCodeList playerCodeList = new PlayerCodeList();
        ArrayList<PlayerCode> playerCodes = new ArrayList<PlayerCode>();
        DataTable dt = new QueryBuilder("select name,code,embed,defaultFlag from scms_player where type=" + playerType).executeDataTable();
        for (int i = 0; i < dt.getRowCount(); ++i) {
            PlayerCode code = new PlayerCode();
            String javascriptCode = (String)dt.get(i, "code");
            javascriptCode = styleType == 7 ? javascriptCode.replace(PlayerConstant.modelString[0], PlayerConstant.videoId[1] + videoId) : javascriptCode.replace(PlayerConstant.modelString[0], PlayerConstant.videoId[0] + videoId);
            StringsUtil su = new StringsUtil();
            javascriptCode = javascriptCode.replace(PlayerConstant.modelString[1], su.escape(videoId, siteId));
            javascriptCode = javascriptCode.replace(PlayerConstant.modelString[2], dateString);
            String name = (String)dt.get(i, "Name");
            String defaultFlag = dt.getString(i, "defaultFlag");
            code.setPlayerName(name);
            code.setDefaultFlag(defaultFlag);
            code.setPlayerCode("<![CDATA[" + javascriptCode + "]]>");
            playerCodes.add(code);
        }
        playerCodeList.setPlayer(playerCodes);
        return playerCodeList;
    }

    public static String generateVodCode(String siteId, String videoId, int styleType, int playerType, String dateString) {
        String javascriptCode = "";
        DataTable dt = new QueryBuilder("select name,code,embed,defaultFlag from scms_player where defaultFlag = 1 and type=" + playerType).executeDataTable();
        if (dt != null) {
            javascriptCode = (String)dt.get(0, "code");
            javascriptCode = styleType == 7 ? javascriptCode.replace(PlayerConstant.modelString[0], PlayerConstant.videoId[1] + videoId) : javascriptCode.replace(PlayerConstant.modelString[0], PlayerConstant.videoId[0] + videoId);
            StringsUtil su = new StringsUtil();
            javascriptCode = javascriptCode.replace(PlayerConstant.modelString[1], su.escape(videoId, siteId));
            javascriptCode = javascriptCode.replace(PlayerConstant.modelString[2], dateString);
        }
        return javascriptCode;
    }

    public static String getSiteName(String siteids) {
        if (StringUtil.isNotEmpty((String)siteids)) {
            DataTable dt = new QueryBuilder("select name from scms_site where id in (" + siteids + ")").executeDataTable();
            String siteNames = "";
            for (int i = 0; i < dt.getRowCount(); ++i) {
                String name = dt.getString(i, "name");
                siteNames = siteNames + name;
                if (i >= dt.getRowCount() - 1) continue;
                siteNames = siteNames + "@";
            }
            return siteNames;
        }
        return "";
    }

    public static boolean checkIsInteger(String catalogPath) {
        boolean result = false;
        if (catalogPath.matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$")) {
            result = true;
        }
        return result;
    }

    public static String getIdsString(String[] contentSourceIds) {
        String idsString = "'" + contentSourceIds[0] + "'";
        for (int i = 1; i < contentSourceIds.length; ++i) {
            idsString = idsString + ",'" + contentSourceIds[i] + "'";
        }
        return idsString;
    }

    public static String getSiteIdByToken(String token) {
        String finalResult = "";
        DataTable dt = new QueryBuilder("select tokens,siteId from scms_userdbconninfo where tokens like '%" + token + "%'").executeDataTable();
        finalResult = dt.getRowCount() == 0 ? "false" : dt.getString(0, "siteId");
        return finalResult;
    }

    public static Map checkExpiredTime(String siteId) {
        String finalResult = "";
        HashMap<String, String> map = new HashMap<String, String>();
        SCMS_AccountSchema account = new SCMS_AccountSchema();
        account.setId(Long.valueOf(Long.parseLong(siteId)));
        if (account.fill()) {
            map.put("userName", account.getEmail());
            long expireDate = account.getExpiredtime().getTime();
            if (new Date().getTime() > expireDate) {
                finalResult = "\u8be5\u7528\u6237\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u8054\u7cfbVMS\u4ea7\u54c1\u5546!";
            }
        } else {
            finalResult = "\u4e0d\u5b58\u5728\u6b64\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e\u4f60\u7684\u7528\u6237\u4fe1\u606f!";
        }
        map.put("finalResult", finalResult);
        return map;
    }

    public static boolean isUserAuthenticated(String token) {
        boolean isAuthenticated = false;
        if (StringUtil.isNotEmpty((String)token)) {
            DataTable dt = new QueryBuilder("select * from scms_partner_authenticate where token='" + token + "'").executeDataTable();
            if (dt == null || dt.getRowCount() == 0) {
                isAuthenticated = false;
            } else {
                String date = dt.getString(0, "expiredate");
                if (StringUtil.isEmpty((String)date)) {
                    isAuthenticated = false;
                } else {
                    String status = dt.getString(0, "status");
                    if (status.equals("1")) {
                        isAuthenticated = true;
                    } else if (status.equals("0")) {
                        isAuthenticated = false;
                    }
                }
            }
        }
        return isAuthenticated;
    }

    public String getInterfacesCDNTypes(String contentid) {
        String interfacesTypes = "";
        String sql = "SELECT interfacesid,partnerCode,Status FROM scms_pushloginfo where ContentID='" + contentid + "' and Operation='" + "VOD" + "'";
        QueryBuilder qb = new QueryBuilder(sql);
        DataTable dt = qb.executeDataTable();
        HashMap<Long, String> partnerCodes = new HashMap<Long, String>();
        if (dt != null && dt.getRowCount() > 0) {
            long interfacesid;
            int i;
            for (i = 0; i < dt.getRowCount(); ++i) {
                String partnerCode = dt.getString(i, "partnerCode");
                interfacesid = dt.getLong(i, "interfacesid");
                if (!"ChinaCache".equals(partnerCode) && !"FastWeb".equals(partnerCode) && !"Letv".equals(partnerCode)) continue;
                partnerCodes.put(interfacesid, partnerCode);
            }
            for (i = 0; i < dt.getRowCount(); ++i) {
                int status = dt.getInt(i, "Status");
                interfacesid = dt.getLong(i, "interfacesid");
                String partnerCode = dt.getString(i, "partnerCode");
                if (!"ChinaCache".equals(partnerCode) && !"FastWeb".equals(partnerCode) && !"Letv".equals(partnerCode) || 0 != status && 2 != status) continue;
                partnerCodes.remove(interfacesid);
            }
            for (Long key : partnerCodes.keySet()) {
                String partnerCode = (String)partnerCodes.get(key);
                if (StringUtil.isEmpty((String)interfacesTypes)) {
                    interfacesTypes = partnerCode;
                    continue;
                }
                interfacesTypes = interfacesTypes + "," + partnerCode;
            }
        }
        return interfacesTypes;
    }

    public Map getCatalogPathAndIds(Map map, String catalogId) throws Exception {
        SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
        catalog.setID(catalogId);
        if (catalog.fill()) {
            String catalogAllPath = (String)map.get("catalogAllPath");
            String catalogAllIds = (String)map.get("catalogAllIds");
            if ("0".equals(catalog.getParentID())) {
                catalogAllPath = catalog.getName() + "@" + catalogAllPath;
                catalogAllIds = catalog.getID() + "@" + catalogAllIds;
            } else {
                if (StringUtil.isEmpty((String)catalogAllPath) || StringUtil.isEmpty((String)catalogAllIds)) {
                    catalogAllPath = catalog.getName();
                    catalogAllIds = String.valueOf(catalog.getID());
                } else {
                    catalogAllPath = catalog.getName() + "@" + catalogAllPath;
                    catalogAllIds = catalog.getID() + "@" + catalogAllIds;
                }
                map.put("catalogAllPath", catalogAllPath);
                map.put("catalogAllIds", catalogAllIds);
                return this.getCatalogPathAndIds(map, String.valueOf(catalog.getParentID()));
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getMs3Passkey(Long siteId, boolean editFlag) {
        String message = "";
        long status = 0L;
        long passkey = -1L;
        JSONObject result = new JSONObject();
        try {
            Document doc;
            Node timekey;
            String httpUrl = SiteUtil.getDomainPreByKey((String)String.valueOf(siteId), (String)"videoDomain", (boolean)false) + "ess/gettimekey";
            if (editFlag) {
                httpUrl = SiteUtil.getDomainPreByKey((String)String.valueOf(siteId), (String)"videoEditDomain", (boolean)false) + "ess/gettimekey";
            }
            String keyXml = PostHttpUtil.sendGet((String)httpUrl, (String)"");
            System.out.print("\u8bf7\u6c42\u5730\u5740\uff1a" + httpUrl + "----\u8bf7\u6c42\u7ed3\u679c\uff1a" + keyXml);
            if (StringUtil.isNotEmpty((String)keyXml) && null != (timekey = (doc = DocumentHelper.parseText((String)keyXml)).selectSingleNode("//timekey"))) {
                int i;
                long publicKey = Long.parseLong(timekey.getText());
                String privateKey = Config.getValue((String)"ms3.privateKey");
                byte[] byteA = new byte[]{(byte)(publicKey & 0xFFL), (byte)(publicKey >> 8 & 0xFFL), (byte)(publicKey >> 16 & 0xFFL), (byte)(publicKey >>> 24)};
                byte[] byteB = privateKey.getBytes();
                byte[] byteAB = new byte[privateKey.getBytes().length + 4];
                for (i = 0; i < 4; ++i) {
                    byteAB[i] = byteA[i];
                }
                for (i = 0; i < byteB.length; ++i) {
                    byteAB[i + 4] = byteB[i];
                }
                int length = byteAB.length / 4 * 4;
                CRC32 crc = new CRC32();
                crc.update(byteAB, 0, length);
                passkey = crc.getValue();
                status = 1L;
                message = "\u83b7\u53d6passkey\u6210\u529f\uff01";
            }
        }
        catch (Exception e) {
            message = "\u8bbf\u95ee\u8be5\u63a5\u53e3passkey\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef\uff01";
        }
        finally {
            result.put((Object)"status", (Object)status);
            result.put((Object)"message", (Object)message);
            result.put((Object)"passkey", (Object)passkey);
        }
        return result;
    }

    public JSONArray getCatalogPathAndIds(JSONArray ja, long catalogId) {
        JSONArray ja2 = new JSONArray();
        try {
            JSONObject jo = new JSONObject();
            SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
            catalog.setID(catalogId);
            if (catalog.fill()) {
                jo.put((Object)"catalogId", (Object)catalog.getID());
                jo.put((Object)"catalogName", (Object)catalog.getName());
                jo.put((Object)"treeLevel", (Object)catalog.getTreeLevel());
                ja.add((Object)jo);
                if (!"0".equals(catalog.getParentID())) {
                    return this.getCatalogPathAndIds(ja, catalog.getParentID());
                }
            }
            for (int i = ja.size() - 1; i >= 0; --i) {
                ja2.add(ja.get(i));
            }
            return ja2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ja2;
        }
    }
}

