/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.cms.util;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.SiteConfig;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.schema.SCMS_AccountSchema;
import com.sobey.bsp.schema.SCMS_CatalogSchema;
import com.sobey.bsp.schema.SCMS_Interfaces_manageSchema;
import com.sobey.bsp.util.StringsUtil;
import com.sobey.scms.player.PlayerConstant;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class NewInterfacesMethod {
    public static String generateLiveCode(String channelId, int playerType) {
        DataTable dt = new QueryBuilder("select code,embed,guid,siteId from scms_player where defaultFlag = 1 and type=" + playerType).executeDataTable();
        String javascriptCode = (String)dt.get(0, "code");
        javascriptCode = javascriptCode.replace("@CHANNELID@", channelId);
        return javascriptCode;
    }

    public JSONArray generateLiveCodeList(String siteId, String channelId, int playerType) {
        JSONArray playerArray = new JSONArray();
        DataTable dt = new QueryBuilder("select name,code,embed,defaultFlag,staticFilePaths from scms_player where type=" + playerType).executeDataTable();
        for (int i = 0; i < dt.getRowCount(); ++i) {
            JSONObject code = new JSONObject();
            String javascriptCode = (String)dt.get(i, "code");
            javascriptCode = javascriptCode.replace("@CHANNELID@", channelId);
            String name = (String)dt.get(i, "Name");
            String defaultFlag = dt.getString(i, "defaultFlag");
            code.put((Object)"name", (Object)name);
            code.put((Object)"defaultFlag", (Object)defaultFlag);
            code.put((Object)"playerCode", (Object)("<![CDATA[" + javascriptCode + "]]>"));
            String str = dt.getString(i, "staticFilePaths");
            if (StringUtil.isNotEmpty((String)str)) {
                String staticFileDomain = SiteUtil.getStaticFileDomainBySiteId((long)Long.parseLong(siteId));
                String alias = SiteUtil.getAlias((String)siteId);
                JSONObject jo = JSONObject.fromObject((Object)str);
                Iterator it = jo.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String value = jo.getString(key);
                    jo.put((Object)key, (Object)(staticFileDomain + alias + "/" + value));
                }
                code.put((Object)"staticFilePaths", (Object)jo);
            } else {
                code.put((Object)"staticFilePaths", (Object)new JSONObject());
            }
            playerArray.add((Object)code);
        }
        return playerArray;
    }

    public static JSONArray getChannelFormatInfo(String channelId, String type, long siteId, int mediaType) {
        JSONArray result = new JSONArray();
        String queryString = "select streamSource, source,fileTypeId,formatinfo,fullurl,type from scms_channelconfig where showFlag=1 and cid = '" + channelId + "' ";
        if (type != null && !"".equals(type)) {
            queryString = queryString + " and type ='" + type + "'";
        }
        DataTable dt = new QueryBuilder(queryString).executeDataTable();
        JSONArray pcFormat = new JSONArray();
        JSONArray iosFormat = new JSONArray();
        JSONArray androidFormat = new JSONArray();
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String title = dt.getString(i, "formatinfo");
            String url = dt.getString(i, "fullurl");
            String liveStream = dt.getString(i, "source");
            String fileTypeId = dt.getString(i, "fileTypeId");
            String formattype = dt.getString(i, "type");
            int streamSource = dt.getInt(i, "streamSource");
            JSONObject jo = new JSONObject();
            jo.put((Object)"title", (Object)title);
            jo.put((Object)"fileTypeId", (Object)fileTypeId);
            jo.put((Object)"liveStream", (Object)liveStream);
            jo.put((Object)"streamSource", (Object)streamSource);
            if (1 == streamSource) {
                if (mediaType == 15) {
                    if ("PC".equalsIgnoreCase(formattype)) {
                        jo.put((Object)"url", (Object)(SiteConfig.getValue((Long)siteId, (Object)"audioLivePcDomain") + url));
                        pcFormat.add((Object)jo);
                        continue;
                    }
                    if ("ANDROID".equalsIgnoreCase(formattype)) {
                        jo.put((Object)"url", (Object)(SiteConfig.getValue((Long)siteId, (Object)"audioLiveAndroidDomain") + url));
                        androidFormat.add((Object)jo);
                        continue;
                    }
                    if (!"IOS".equalsIgnoreCase(formattype)) continue;
                    jo.put((Object)"url", (Object)(SiteConfig.getValue((Long)siteId, (Object)"audioLiveIosDomain") + url));
                    iosFormat.add((Object)jo);
                    continue;
                }
                if ("PC".equalsIgnoreCase(formattype)) {
                    jo.put((Object)"url", (Object)(SiteConfig.getValue((Long)siteId, (Object)"livePcDomain") + url));
                    pcFormat.add((Object)jo);
                    continue;
                }
                if ("ANDROID".equalsIgnoreCase(formattype)) {
                    jo.put((Object)"url", (Object)(SiteConfig.getValue((Long)siteId, (Object)"liveAndroidDomain") + url));
                    androidFormat.add((Object)jo);
                    continue;
                }
                if (!"IOS".equalsIgnoreCase(formattype)) continue;
                jo.put((Object)"url", (Object)(SiteConfig.getValue((Long)siteId, (Object)"liveIosDomain") + url));
                iosFormat.add((Object)jo);
                continue;
            }
            jo.put((Object)"url", (Object)url);
            if ("PC".equalsIgnoreCase(formattype)) {
                pcFormat.add((Object)jo);
                continue;
            }
            if ("ANDROID".equalsIgnoreCase(formattype)) {
                androidFormat.add((Object)jo);
                continue;
            }
            if (!"IOS".equalsIgnoreCase(formattype)) continue;
            iosFormat.add((Object)jo);
        }
        if (StringUtil.isNotEmpty((String)type)) {
            if ("PC".equalsIgnoreCase(type)) {
                JSONObject pcJO = new JSONObject();
                pcJO.put((Object)"type", (Object)type);
                pcJO.put((Object)"formats", (Object)pcFormat);
                result.add((Object)pcJO);
            } else if ("ANDROID".equalsIgnoreCase(type)) {
                JSONObject androidJO = new JSONObject();
                androidJO.put((Object)"type", (Object)type);
                androidJO.put((Object)"formats", (Object)androidFormat);
                result.add((Object)androidJO);
            } else if ("IOS".equalsIgnoreCase(type)) {
                JSONObject iosJO = new JSONObject();
                iosJO.put((Object)"type", (Object)type);
                iosJO.put((Object)"formats", (Object)iosFormat);
                result.add((Object)iosJO);
            }
        } else {
            if (pcFormat.size() > 0) {
                JSONObject pcJO = new JSONObject();
                pcJO.put((Object)"type", (Object)"PC");
                pcJO.put((Object)"formats", (Object)pcFormat);
                result.add((Object)pcJO);
            }
            if (androidFormat.size() > 0) {
                JSONObject androidJO = new JSONObject();
                androidJO.put((Object)"type", (Object)"ANDROID");
                androidJO.put((Object)"formats", (Object)androidFormat);
                result.add((Object)androidJO);
            }
            if (iosFormat.size() > 0) {
                JSONObject iosJO = new JSONObject();
                iosJO.put((Object)"type", (Object)"IOS");
                iosJO.put((Object)"formats", (Object)iosFormat);
                result.add((Object)iosJO);
            }
        }
        return result;
    }

    public static Map deleteVideo(Transaction trans, String videoIDs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] contentIds = null;
        String[] paths = null;
        String[] contentSourceIds = null;
        String[] srcFileNames = null;
        String contentIdSring = "";
        String siteId = "";
        String[] videoId = videoIDs.split(",");
        String contentSourceIdsString = "";
        for (int i = 0; i < videoId.length; ++i) {
            if (!StringUtil.isNotEmpty((String)videoId[i])) continue;
            contentSourceIdsString = contentSourceIdsString + ",'" + videoId[i] + "'";
        }
        if (StringUtil.isEmpty((String)contentSourceIdsString)) {
            map.put("status", 0);
            return map;
        }
        contentSourceIdsString = contentSourceIdsString.substring(1, contentSourceIdsString.length());
        String contentIdsSql = "select path,contentid,contentSourceId,siteId from scms_contentinfo where contentSourceId in (" + contentSourceIdsString + ")";
        DataTable dt = new QueryBuilder(contentIdsSql).executeDataTable();
        contentIds = new String[dt.getRowCount()];
        contentSourceIds = new String[dt.getRowCount()];
        paths = new String[dt.getRowCount()];
        for (int i = 0; i < dt.getRowCount(); ++i) {
            contentIds[i] = dt.getString(i, "contentid");
            contentSourceIds[i] = dt.getString(i, "contentSourceId");
            if (i == 0) {
                contentIdSring = dt.getString(i, "contentid");
                siteId = dt.getString(i, "siteId");
            } else {
                contentIdSring = contentIdSring + "," + dt.getString(i, "contentid");
            }
            paths[i] = dt.getString(i, "path");
        }
        if (StringUtil.isEmpty((String)contentIdSring)) {
            map.put("status", 0);
            return map;
        }
        String SrcFileNamesSql = "select srcFilename from scms_video where contentid in (" + contentIdSring + ")";
        DataTable dt1 = new QueryBuilder(SrcFileNamesSql).executeDataTable();
        srcFileNames = new String[dt1.getRowCount()];
        for (int i = 0; i < dt1.getRowCount(); ++i) {
            srcFileNames[i] = dt1.getString(i, "srcFileName");
        }
        String contentinfoDeleteSql = "delete from scms_contentinfo where contentid in (" + contentIdSring + ")";
        String contentinfoLogDeleteSql = "delete from scms_contentinfolog where contentid in (" + contentIdSring + ")";
        String recycleDeleteSql = "delete from scms_recycle where assignmentType=5 and contentid in (" + contentIdSring + ")";
        String videoDeleteSql = "delete from scms_video where contentid in (" + contentIdSring + ")";
        trans.add(new QueryBuilder(contentinfoDeleteSql));
        trans.add(new QueryBuilder(recycleDeleteSql));
        trans.add(new QueryBuilder(contentinfoLogDeleteSql));
        trans.add(new QueryBuilder(videoDeleteSql));
        map.put("status", 1);
        map.put("siteId", siteId);
        map.put("paths", paths);
        map.put("contentSourceIds", contentSourceIds);
        map.put("contentIds", contentIds);
        map.put("srcFileNames", srcFileNames);
        return map;
    }

    public static Map deleteAudio(Transaction trans, String audioIDs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] contentIds = null;
        String[] paths = null;
        String[] contentSourceIds = null;
        String[] srcFileNames = null;
        String contentIdSring = "";
        String siteId = "";
        String[] audioId = audioIDs.split(",");
        String contentSourceIdsString = "";
        for (int i = 0; i < audioId.length; ++i) {
            if (!StringUtil.isNotEmpty((String)audioId[i])) continue;
            contentSourceIdsString = contentSourceIdsString + ",'" + audioId[i] + "'";
        }
        if (StringUtil.isEmpty((String)contentSourceIdsString)) {
            map.put("status", 0);
            return map;
        }
        contentSourceIdsString = contentSourceIdsString.substring(1, contentSourceIdsString.length());
        String contentIdsSql = "select path,ID,ContentSourceId,Siteid from scms_audioinfo where contentSourceId in (" + contentSourceIdsString + ")";
        DataTable dt = new QueryBuilder(contentIdsSql).executeDataTable();
        contentIds = new String[dt.getRowCount()];
        contentSourceIds = new String[dt.getRowCount()];
        paths = new String[dt.getRowCount()];
        for (int i = 0; i < dt.getRowCount(); ++i) {
            contentIds[i] = dt.getString(i, "id");
            contentSourceIds[i] = dt.getString(i, "contentSourceId");
            if (i == 0) {
                contentIdSring = dt.getString(i, "id");
                siteId = dt.getString(i, "siteId");
            } else {
                contentIdSring = contentIdSring + "," + dt.getString(i, "id");
            }
            paths[i] = dt.getString(i, "path");
        }
        if (StringUtil.isEmpty((String)contentIdSring)) {
            map.put("status", 0);
            return map;
        }
        String SrcFileNamesSql = "select srcFilename from scms_audio where audiocontentid in (" + contentIdSring + ")";
        DataTable dt1 = new QueryBuilder(SrcFileNamesSql).executeDataTable();
        srcFileNames = new String[dt1.getRowCount()];
        for (int i = 0; i < dt1.getRowCount(); ++i) {
            srcFileNames[i] = dt1.getString(i, "srcFileName");
        }
        String contentinfoDeleteSql = "delete from scms_audioinfo where id in (" + contentIdSring + ")";
        String contentinfoLogDeleteSql = "delete from scms_audioinfolog where contentid in (" + contentIdSring + ")";
        String recycleDeleteSql = "delete from scms_recycle where assignmentType=6 and contentid in (" + contentIdSring + ")";
        String videoDeleteSql = "delete from scms_audio where audiocontentid in (" + contentIdSring + ")";
        trans.add(new QueryBuilder(contentinfoDeleteSql));
        trans.add(new QueryBuilder(recycleDeleteSql));
        trans.add(new QueryBuilder(contentinfoLogDeleteSql));
        trans.add(new QueryBuilder(videoDeleteSql));
        map.put("status", 1);
        map.put("siteId", siteId);
        map.put("paths", paths);
        map.put("contentSourceIds", contentSourceIds);
        map.put("contentIds", contentIds);
        map.put("srcFileNames", srcFileNames);
        return map;
    }

    public static Map deleteSeries(Transaction trans, String sourceIDs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] videoId = sourceIDs.split(",");
        String contentSourceIdsString = "";
        for (int i = 0; i < videoId.length; ++i) {
            if (!StringUtil.isNotEmpty((String)videoId[i])) continue;
            contentSourceIdsString = contentSourceIdsString + ",'" + videoId[i] + "'";
        }
        if (StringUtil.isEmpty((String)contentSourceIdsString)) {
            map.put("status", 0);
            return map;
        }
        contentSourceIdsString = contentSourceIdsString.substring(1, contentSourceIdsString.length());
        String siteId = "";
        String contentIdSring = "";
        String[] contentSourceIds = null;
        String[] contentIds = null;
        String contentSourcerIdsSql = "select seriesid,siteid,seriesSourceId from scms_series where seriesSourceId in (" + contentSourceIdsString + ")";
        DataTable dt = new QueryBuilder(contentSourcerIdsSql).executeDataTable();
        contentIds = new String[dt.getRowCount()];
        contentSourceIds = new String[dt.getRowCount()];
        for (int i = 0; i < dt.getRowCount(); ++i) {
            contentIds[i] = dt.getString(i, "contentid");
            contentSourceIds[i] = dt.getString(i, "seriesSourceId");
            if (i == 0) {
                contentIdSring = dt.getString(i, "seriesid");
                siteId = dt.getString(i, "siteId");
                continue;
            }
            contentIdSring = contentIdSring + "," + dt.getString(i, "seriesid");
        }
        String seriesDeleteSql = "delete from scms_series where seriesid in (" + contentIdSring + ")";
        String recycleDeleteSql = "delete from scms_recycle where assignmentType=7 and contentid in (" + contentIdSring + ")";
        String seriesInfoDeleteSql = "delete from scms_seriesinfolog where seriesid in (" + contentIdSring + ")";
        trans.add(new QueryBuilder(seriesDeleteSql));
        trans.add(new QueryBuilder(recycleDeleteSql));
        trans.add(new QueryBuilder(seriesInfoDeleteSql));
        map.put("status", 1);
        map.put("siteId", siteId);
        map.put("contentSourceIds", contentSourceIds);
        return map;
    }

    public static String getCatalogSql(String catalogPath, String catalogStyle, int catalogType, String sql) {
        if ("1".equals(catalogStyle)) {
            int catalogId = Integer.parseInt(catalogPath);
            if (catalogId > 0) {
                sql = "select innercode,id from SCMS_Catalog where type=" + catalogType + " and id=" + catalogId;
            }
        } else {
            String[] catalogPaths = catalogPath.split("@");
            if (catalogPaths.length > 1) {
                String inSql = "";
                String inString = "";
                sql = "select innercode,id from SCMS_Catalog where type=" + catalogType + " and name='" + catalogPaths[catalogPaths.length - 1] + "' and treelevel=" + (catalogPaths.length - 1);
                for (int i = catalogPaths.length - 2; i > 0; --i) {
                    inSql = inSql + " and parentid in (select id from SCMS_Catalog where name='" + catalogPaths[i] + "' and treelevel=" + i;
                    inString = inString + ")";
                }
                sql = sql + inSql + inString;
            }
        }
        return sql;
    }

    public JSONArray generateVodCodeList(String siteId, String videoId, int styleType, int playerType, String dateString) {
        JSONArray playerArray = new JSONArray();
        DataTable dt = new QueryBuilder("select name,code,embed,defaultFlag,staticFilePaths from scms_player where type=" + playerType).executeDataTable();
        for (int i = 0; i < dt.getRowCount(); ++i) {
            JSONObject code = new JSONObject();
            String javascriptCode = (String)dt.get(i, "code");
            javascriptCode = styleType == 7 ? javascriptCode.replace(PlayerConstant.modelString[0], PlayerConstant.videoId[1] + videoId) : javascriptCode.replace(PlayerConstant.modelString[0], PlayerConstant.videoId[0] + videoId);
            StringsUtil su = new StringsUtil();
            javascriptCode = javascriptCode.replace(PlayerConstant.modelString[1], su.escape(videoId, siteId));
            javascriptCode = javascriptCode.replace(PlayerConstant.modelString[2], dateString);
            String name = (String)dt.get(i, "Name");
            String defaultFlag = dt.getString(i, "defaultFlag");
            code.put((Object)"name", (Object)name);
            code.put((Object)"defaultFlag", (Object)defaultFlag);
            code.put((Object)"playerCode", (Object)("<![CDATA[" + javascriptCode + "]]>"));
            String str = dt.getString(i, "staticFilePaths");
            if (StringUtil.isNotEmpty((String)str)) {
                String staticFileDomain = SiteUtil.getStaticFileDomainBySiteId((long)Long.parseLong(siteId));
                String alias = SiteUtil.getAlias((String)siteId);
                JSONObject jo = JSONObject.fromObject((Object)str);
                Iterator it = jo.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String value = jo.getString(key);
                    jo.put((Object)key, (Object)(staticFileDomain + StringUtil.replaceAllToSlant((String)(alias + "/" + value))));
                }
                code.put((Object)"staticFilePaths", (Object)jo);
            } else {
                code.put((Object)"staticFilePaths", (Object)new JSONObject());
            }
            playerArray.add((Object)code);
        }
        return playerArray;
    }

    public JSONArray getVodCodeJSONArray(String siteId, String videoId, int styleType, int playerType, String dateString) {
        JSONArray playerCodes = new JSONArray();
        DataTable dt = new QueryBuilder("select name,code,embed,defaultFlag,staticFilePaths from scms_player where type=" + playerType).executeDataTable();
        for (int i = 0; i < dt.getRowCount(); ++i) {
            JSONObject code = new JSONObject();
            String javascriptCode = (String)dt.get(i, "code");
            javascriptCode = styleType == 7 ? javascriptCode.replace(PlayerConstant.modelString[0], PlayerConstant.videoId[1] + videoId) : javascriptCode.replace(PlayerConstant.modelString[0], PlayerConstant.videoId[0] + videoId);
            StringsUtil su = new StringsUtil();
            javascriptCode = javascriptCode.replace(PlayerConstant.modelString[1], su.escape(videoId, siteId));
            javascriptCode = javascriptCode.replace(PlayerConstant.modelString[2], dateString);
            String name = (String)dt.get(i, "Name");
            String defaultFlag = dt.getString(i, "defaultFlag");
            code.put((Object)"name", (Object)name);
            code.put((Object)"defaultFlag", (Object)defaultFlag);
            code.put((Object)"playerCode", (Object)javascriptCode);
            String str = dt.getString(i, "staticFilePaths");
            if (StringUtil.isNotEmpty((String)str)) {
                String staticFileDomain = SiteUtil.getStaticFileDomainBySiteId((long)Long.parseLong(siteId));
                String alias = SiteUtil.getAlias((String)siteId);
                JSONObject jo = JSONObject.fromObject((Object)str);
                Iterator it = jo.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String value = jo.getString(key);
                    jo.put((Object)key, (Object)(staticFileDomain + alias + "/" + value));
                }
                code.put((Object)"staticFilePaths", (Object)jo);
            } else {
                code.put((Object)"staticFilePaths", (Object)new JSONObject());
            }
            playerCodes.add((Object)code);
        }
        return playerCodes;
    }

    public static String generateVodCode(String siteId, String videoId, int styleType, int playerType, String dateString) {
        String javascriptCode = "";
        DataTable dt = new QueryBuilder("select name,code,embed,defaultFlag from scms_player where defaultFlag = 1 and type=" + playerType).executeDataTable();
        if (dt != null) {
            javascriptCode = (String)dt.get(0, "code");
            javascriptCode = styleType == 7 ? javascriptCode.replace(PlayerConstant.modelString[0], PlayerConstant.videoId[1] + videoId) : javascriptCode.replace(PlayerConstant.modelString[0], PlayerConstant.videoId[0] + videoId);
            StringsUtil su = new StringsUtil();
            javascriptCode = javascriptCode.replace(PlayerConstant.modelString[1], su.escape(videoId, siteId));
            javascriptCode = javascriptCode.replace(PlayerConstant.modelString[2], dateString);
        }
        return javascriptCode;
    }

    public static String getChannelImageURL(Long siteId, String channelImgUrl) {
        String siteAlias = SiteUtil.getAlias((long)siteId);
        if (StringUtil.isNotEmpty((String)channelImgUrl)) {
            channelImgUrl = SiteUtil.getImageDomainBySiteId((long)siteId) + StringUtil.replaceAllToSlant((String)(siteAlias + "/" + channelImgUrl));
        }
        return channelImgUrl;
    }

    public JSONObject getPlayUrl(String status, String playUrl, String siteId, int mediaType, int mediaPathType) {
        JSONObject playURL = null;
        if (!("2".equals(status) || "3".equals(status) || "7".equals(status) || "4".equals(status))) {
            playURL = 5 == mediaType ? NewInterfacesMethod.videoPlayUrl2Java((String)playUrl, (String)siteId, (int)mediaType, (int)mediaPathType) : NewInterfacesMethod.audioPlayUrl2Java((String)playUrl, (String)siteId, (int)mediaType, (int)mediaPathType);
        }
        return playURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject audioPlayUrl2Java(String playUrl, String siteId, int mediaType, int mediaPathType) {
        JSONObject result = new JSONObject();
        boolean playUrlflag = true;
        try {
            JSONObject playURL = JSONObject.fromObject((Object)playUrl);
            if (playURL != null) {
                playURL.put((Object)"subPath", (Object)(SiteUtil.getAlias((String)siteId) + playURL.getString("host")));
                playURL.put((Object)"host", (Object)(SiteUtil.getDomainPreByKey((String)siteId, (String)"audioDomain", (boolean)true) + playURL.getString("host")));
                if (playURL.has("formats")) {
                    JSONObject jo = new JSONObject();
                    jo.put((Object)"format", (Object)playURL.getJSONArray("formats"));
                    playURL.put((Object)"formats", (Object)jo);
                }
            }
            JSONObject urls = new JSONObject();
            urls.put((Object)"url", (Object)playURL.getJSONArray("clips").getJSONObject(0).getJSONArray("urls"));
            playURL.getJSONArray("clips").getJSONObject(0).put((Object)"urls", (Object)urls);
            JSONObject clips = new JSONObject();
            clips.put((Object)"clip", (Object)playURL.getJSONArray("clips"));
            playURL.put((Object)"clips", (Object)clips);
            result = playURL;
        }
        catch (Exception e) {
            e.printStackTrace();
            playUrlflag = false;
        }
        finally {
            if (playUrlflag) {
                result.put((Object)"isSuccess", (Object)"1");
                result.put((Object)"message", (Object)"\u64ad\u51faURL\u4fe1\u606f\u83b7\u53d6\u6210\u529f!");
            } else {
                result.put((Object)"isSuccess", (Object)"0");
                result.put((Object)"message", (Object)"\u64ad\u51faURL\u4fe1\u606f\u6682\u65f6\u4e0d\u53ef\u7528!");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject videoPlayUrl2Java(String playUrl, String siteId, int mediaType, int mediaPathType) {
        JSONObject jo = new JSONObject();
        boolean playUrlflag = true;
        try {
            jo = JSONObject.fromObject((Object)playUrl);
            if (jo != null) {
                JSONArray clips = new JSONArray();
                JSONObject clip = new JSONObject();
                clip.put((Object)"index", (Object)"001");
                clip.put((Object)"duration", (Object)jo.getString("duration"));
                clip.put((Object)"urls", (Object)jo.getJSONArray("urls"));
                clips.add((Object)clip);
                jo.put((Object)"clips", (Object)clips);
                jo.remove("urls");
                boolean aliasFlag = true;
                jo.put((Object)"subPath", (Object)(SiteUtil.getAlias((String)siteId) + jo.getString("host")));
                String host = jo.getString("host");
                jo.put((Object)"host", (Object)(SiteUtil.getDomainPreByKey((String)siteId, (String)"videoDomain", (boolean)aliasFlag) + host));
                jo.put((Object)"editHost", (Object)(SiteUtil.getDomainPreByKey((String)siteId, (String)"videoEditDomain", (boolean)aliasFlag) + host));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            playUrlflag = false;
        }
        finally {
            if (playUrlflag) {
                jo.put((Object)"isSuccess", (Object)"1");
                jo.put((Object)"message", (Object)"\u64ad\u51faURL\u4fe1\u606f\u83b7\u53d6\u6210\u529f!");
            } else {
                jo.put((Object)"isSuccess", (Object)"0");
                jo.put((Object)"message", (Object)"\u64ad\u51faURL\u4fe1\u606f\u6682\u65f6\u4e0d\u53ef\u7528!");
            }
        }
        return jo;
    }

    public JSONObject getTsPlayUrl(String status, String tsPlayUrl, String siteId, int mediaType, int mediaPathType) {
        JSONObject playURL = null;
        if (!("2".equals(status) || "3".equals(status) || "7".equals(status) || "4".equals(status))) {
            tsPlayUrl = tsPlayUrl.replace("&", "%26");
            playURL = NewInterfacesMethod.tsPlayUrl2Java((String)tsPlayUrl, (String)siteId, (int)mediaType, (int)mediaPathType);
        }
        return playURL;
    }

    public JSONObject getMp4PlayUrl(String status, String mp4PlayUrl, String siteId, int mediaType, int mediaPathType) {
        JSONObject playURL = null;
        if (!("2".equals(status) || "3".equals(status) || "7".equals(status) || "4".equals(status))) {
            mp4PlayUrl = mp4PlayUrl.replace("&", "%26");
            playURL = NewInterfacesMethod.mp4PlayUrl2Java((String)mp4PlayUrl, (String)siteId, (int)mediaType, (int)mediaPathType);
        }
        return playURL;
    }

    public static String getOnePlayUrl(String playUrl, String siteId, int mediaType) {
        String resultUrl = "";
        try {
            resultUrl = 6 == mediaType ? NewInterfacesMethod.audioOnePlayUrl((String)playUrl, (String)siteId, (int)mediaType) : NewInterfacesMethod.videoOnePlayUrl((String)playUrl, (String)siteId, (int)mediaType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultUrl;
    }

    public static String videoOnePlayUrl(String playUrl, String siteId, int mediaType) throws Exception {
        JSONObject jo = JSONObject.fromObject((Object)playUrl);
        String resultUrl = "";
        if (jo != null) {
            JSONArray urlArray = jo.getJSONArray("urls");
            String host = SiteUtil.getDomainPreByKey((String)siteId, (String)"videoEditDomain", (boolean)true) + jo.getString("host");
            String url = "";
            int i = 0;
            if (i < urlArray.size()) {
                url = urlArray.getString(0);
            }
            resultUrl = host + url;
        }
        return resultUrl;
    }

    public static String audioOnePlayUrl(String playUrl, String siteId, int mediaType) throws Exception {
        JSONObject jo = JSONObject.fromObject((Object)playUrl);
        String resultUrl = "";
        if (jo != null) {
            JSONArray clipsArray = jo.getJSONArray("clips");
            String host = SiteUtil.getDomainPreByKey((String)siteId, (String)"audioEditDomain", (boolean)true) + jo.getString("host");
            String url = "";
            int i = 0;
            if (i < clipsArray.size()) {
                JSONObject clipObj = clipsArray.getJSONObject(i);
                JSONArray urlArray = clipObj.getJSONArray("urls");
                url = urlArray.getString(0);
            }
            resultUrl = host + url;
        }
        return resultUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject mp4PlayUrl2Java(String mp4PlayUrl, String siteId, int mediaType, int mediaPathType) {
        JSONObject jo = new JSONObject();
        boolean playUrlflag = true;
        try {
            jo = JSONObject.fromObject((Object)mp4PlayUrl);
            if (jo != null) {
                JSONArray clips = new JSONArray();
                JSONObject clip = new JSONObject();
                clip.put((Object)"index", (Object)"001");
                clip.put((Object)"duration", (Object)jo.getString("duration"));
                clip.put((Object)"urls", (Object)jo.getJSONArray("urls"));
                clips.add((Object)clip);
                jo.put((Object)"clips", (Object)clips);
                jo.remove("urls");
                boolean aliasFlag = true;
                jo.put((Object)"subPath", (Object)(SiteUtil.getAlias((String)siteId) + jo.getString("host")));
                jo.put((Object)"host", (Object)(SiteUtil.getDomainPreByKey((String)siteId, (String)"videoAndroidDomain", (boolean)aliasFlag) + jo.getString("host")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            playUrlflag = false;
        }
        finally {
            if (playUrlflag) {
                jo.put((Object)"isSuccess", (Object)"1");
                jo.put((Object)"message", (Object)"\u64ad\u51faURL\u4fe1\u606f\u83b7\u53d6\u6210\u529f!");
            } else {
                jo.put((Object)"isSuccess", (Object)"0");
                jo.put((Object)"message", (Object)"\u64ad\u51faURL\u4fe1\u606f\u6682\u65f6\u4e0d\u53ef\u7528!");
            }
        }
        return jo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject tsPlayUrl2Java(String tsPlayUrl, String siteId, int mediaType, int mediaPathType) {
        JSONObject jo = new JSONObject();
        boolean playUrlflag = true;
        try {
            jo = JSONObject.fromObject((Object)tsPlayUrl);
            if (jo != null) {
                JSONArray clips = new JSONArray();
                JSONObject clip = new JSONObject();
                clip.put((Object)"index", (Object)"001");
                clip.put((Object)"duration", (Object)jo.getString("duration"));
                clip.put((Object)"urls", (Object)jo.getJSONArray("urls"));
                clips.add((Object)clip);
                jo.put((Object)"clips", (Object)clips);
                jo.remove("urls");
                boolean aliasFlag = true;
                jo.put((Object)"subPath", (Object)(SiteUtil.getAlias((String)siteId) + jo.getString("host")));
                jo.put((Object)"host", (Object)(SiteUtil.getDomainPreByKey((String)siteId, (String)"videoIosDomain", (boolean)aliasFlag) + jo.getString("host")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            playUrlflag = false;
        }
        finally {
            if (playUrlflag) {
                jo.put((Object)"isSuccess", (Object)"1");
                jo.put((Object)"message", (Object)"\u64ad\u51faURL\u4fe1\u606f\u83b7\u53d6\u6210\u529f!");
            } else {
                jo.put((Object)"isSuccess", (Object)"0");
                jo.put((Object)"message", (Object)"\u64ad\u51faURL\u4fe1\u606f\u6682\u65f6\u4e0d\u53ef\u7528!");
            }
        }
        return jo;
    }

    public static String getSiteName(String siteids) {
        if (StringUtil.isNotEmpty((String)siteids)) {
            DataTable dt = new QueryBuilder("select name from scms_site where id in (" + siteids + ")").executeDataTable();
            String siteNames = "";
            for (int i = 0; i < dt.getRowCount(); ++i) {
                String name = dt.getString(i, "name");
                siteNames = siteNames + name;
                if (i >= dt.getRowCount() - 1) continue;
                siteNames = siteNames + "@";
            }
            return siteNames;
        }
        return "";
    }

    public String getKeyFramesPath(String siteId, String keyFrame) {
        String imagePath = "";
        if (StringUtil.isNotEmpty((String)keyFrame)) {
            String ImagePre = SiteUtil.getImageDomainBySiteId((long)Long.parseLong(siteId));
            imagePath = ImagePre + StringUtil.replaceAllToSlant((String)(SiteUtil.getAlias((String)siteId) + "/" + keyFrame));
        }
        return imagePath;
    }

    public JSONArray getAllKeyFrames(String contentid, String keyFrame, String siteId) {
        JSONArray ja = new JSONArray();
        QueryBuilder qb = new QueryBuilder("select URL from scms_imageinfo where contentId = " + contentid);
        DataTable dt = qb.executeDataTable();
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String relaPath = dt.getString(i, "URL");
            if (!StringUtil.isNotEmpty((String)relaPath)) continue;
            JSONObject jo = new JSONObject();
            if (relaPath.equals(keyFrame)) {
                jo.put((Object)"defaultKeyFrame", (Object)1);
            } else {
                jo.put((Object)"defaultKeyFrame", (Object)0);
            }
            String imagePath = this.getKeyFramesPath(siteId, relaPath);
            jo.put((Object)"imagePath", (Object)imagePath);
            ja.add((Object)jo.toString());
        }
        return ja;
    }

    public static boolean checkIsInteger(String catalogPath) {
        boolean result = false;
        if (catalogPath.matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$")) {
            result = true;
        }
        return result;
    }

    public static String getIdsString(String[] contentSourceIds) {
        String idsString = "'" + contentSourceIds[0] + "'";
        for (int i = 1; i < contentSourceIds.length; ++i) {
            idsString = idsString + ",'" + contentSourceIds[i] + "'";
        }
        return idsString;
    }

    public static String getSiteIdByToken(String token) {
        String finalResult = "";
        DataTable dt = new QueryBuilder("select tokens,siteId from scms_userdbconninfo where tokens like '%" + token + "%'").executeDataTable();
        finalResult = dt.getRowCount() == 0 ? "false" : dt.getString(0, "siteId");
        return finalResult;
    }

    public static Map checkExpiredTime(String siteId) {
        String finalResult = "";
        HashMap<String, String> map = new HashMap<String, String>();
        SCMS_AccountSchema account = new SCMS_AccountSchema();
        account.setId(Long.valueOf(Long.parseLong(siteId)));
        if (account.fill()) {
            map.put("userName", account.getEmail());
            long expireDate = account.getExpiredtime().getTime();
            if (new Date().getTime() > expireDate) {
                finalResult = "\u8be5\u7528\u6237\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u8054\u7cfbVMS\u4ea7\u54c1\u5546!";
            }
        } else {
            finalResult = "\u4e0d\u5b58\u5728\u6b64\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e\u4f60\u7684\u7528\u6237\u4fe1\u606f!";
        }
        map.put("finalResult", finalResult);
        return map;
    }

    public static boolean isUserAuthenticated(String token) {
        boolean isAuthenticated = false;
        if (StringUtil.isNotEmpty((String)token)) {
            DataTable dt = new QueryBuilder("select * from scms_partner_authenticate where token='" + token + "'").executeDataTable();
            if (dt == null || dt.getRowCount() == 0) {
                isAuthenticated = false;
            } else {
                String date = dt.getString(0, "expiredate");
                if (StringUtil.isEmpty((String)date)) {
                    isAuthenticated = false;
                } else {
                    String status = dt.getString(0, "status");
                    if (status.equals("1")) {
                        isAuthenticated = true;
                    } else if (status.equals("0")) {
                        isAuthenticated = false;
                    }
                }
            }
        }
        return isAuthenticated;
    }

    public String getInterfacesTypes(String contentid) {
        String interfacesTypes = "";
        String pushlog = "select distinct partnerCode from scms_pushloginfo where  contentID= " + contentid + " AND Operation='" + "VOD" + "' AND STATUS=" + 1;
        QueryBuilder pushQb = new QueryBuilder(pushlog);
        DataTable pushDt = pushQb.executeDataTable();
        if (pushDt != null && pushDt.getRowCount() > 0) {
            interfacesTypes = pushDt.getString(0, "partnerCode");
            for (int k = 1; k < pushDt.getRowCount(); ++k) {
                String partnerCode = pushDt.getString(k, "partnerCode");
                interfacesTypes = interfacesTypes + "," + partnerCode;
            }
        }
        return interfacesTypes;
    }

    public String getInterfacesCDNTypes(String contentid) {
        String interfacesTypes = "";
        String pushlog = "select distinct partnerCode from scms_pushloginfo where  contentID= " + contentid + " AND Operation='" + "VOD" + "' AND STATUS=" + 1;
        QueryBuilder pushQb = new QueryBuilder(pushlog);
        DataTable pushDt = pushQb.executeDataTable();
        if (pushDt != null && pushDt.getRowCount() > 0) {
            for (int k = 0; k < pushDt.getRowCount(); ++k) {
                String partnerCode = pushDt.getString(k, "partnerCode");
                if (!"ChinaCache".equals(partnerCode) && !"FastWeb".equals(partnerCode) && !"Letv".equals(partnerCode)) continue;
                interfacesTypes = StringUtil.isEmpty((String)interfacesTypes) ? partnerCode : interfacesTypes + "," + partnerCode;
            }
        }
        return interfacesTypes;
    }

    public Map getCatalogPathAndIds(Map map, String catalogId) throws Exception {
        SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
        catalog.setID(catalogId);
        if (catalog.fill()) {
            String catalogAllPath = (String)map.get("catalogAllPath");
            String catalogAllIds = (String)map.get("catalogAllIds");
            if ("0".equals(catalog.getParentID())) {
                catalogAllPath = catalog.getName() + "@" + catalogAllPath;
                catalogAllIds = catalog.getID() + "@" + catalogAllIds;
            } else {
                if (StringUtil.isEmpty((String)catalogAllPath) || StringUtil.isEmpty((String)catalogAllIds)) {
                    catalogAllPath = catalog.getName();
                    catalogAllIds = String.valueOf(catalog.getID());
                } else {
                    catalogAllPath = catalog.getName() + "@" + catalogAllPath;
                    catalogAllIds = catalog.getID() + "@" + catalogAllIds;
                }
                map.put("catalogAllPath", catalogAllPath);
                map.put("catalogAllIds", catalogAllIds);
                return this.getCatalogPathAndIds(map, String.valueOf(catalog.getParentID()));
            }
        }
        return map;
    }

    public JSONArray getCatalogPathAndIds(JSONArray ja, long catalogId) {
        JSONArray ja2 = new JSONArray();
        try {
            JSONObject jo = new JSONObject();
            SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
            catalog.setID(catalogId);
            if (catalog.fill()) {
                jo.put((Object)"catalogId", (Object)catalog.getID());
                jo.put((Object)"catalogName", (Object)catalog.getName());
                jo.put((Object)"treeLevel", (Object)catalog.getTreeLevel());
                ja.add((Object)jo);
                if (!"0".equals(catalog.getParentID())) {
                    return this.getCatalogPathAndIds(ja, catalog.getParentID());
                }
            }
            for (int i = ja.size() - 1; i >= 0; --i) {
                ja2.add(ja.get(i));
            }
            return ja2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ja2;
        }
    }

    public JSONArray getFtpVodAddress(String playUrl, SCMS_Interfaces_manageSchema interfaces) {
        JSONArray result = new JSONArray();
        try {
            JSONObject partnerKeyJo;
            String partnerKey = interfaces.getPartnerKey();
            if (StringUtil.isNotEmpty((String)partnerKey) && (partnerKeyJo = JSONObject.fromObject((Object)partnerKey)).has("ftpFullAddress") && StringUtil.isNotEmpty((String)partnerKeyJo.getString("ftpFullAddress"))) {
                JSONObject jo = JSONObject.fromObject((Object)playUrl);
                String ftpFullAddress = partnerKeyJo.getString("ftpFullAddress");
                String host = jo.getString("host");
                JSONArray urls = jo.getJSONArray("urls");
                for (int i = 0; i < urls.size(); ++i) {
                    String ftpUrl = ftpFullAddress + StringUtil.replaceAllToSlant((String)(host + urls.getString(i)));
                    result.add((Object)ftpUrl);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = new JSONArray();
        }
        return result;
    }

    public JSONArray getFtpAudioAddress(String playUrl, SCMS_Interfaces_manageSchema interfaces) {
        JSONArray result = new JSONArray();
        try {
            JSONObject partnerKeyJo;
            String partnerKey = interfaces.getPartnerKey();
            if (StringUtil.isNotEmpty((String)partnerKey) && (partnerKeyJo = JSONObject.fromObject((Object)partnerKey)).has("ftpFullAddress") && StringUtil.isNotEmpty((String)partnerKeyJo.getString("ftpFullAddress"))) {
                JSONObject jo = JSONObject.fromObject((Object)playUrl);
                String ftpFullAddress = partnerKeyJo.getString("ftpFullAddress");
                String host = jo.getString("host");
                JSONArray urls = jo.getJSONArray("clips").getJSONObject(0).getJSONArray("urls");
                for (int i = 0; i < urls.size(); ++i) {
                    String ftpUrl = ftpFullAddress + StringUtil.replaceAllToSlant((String)(host + urls.getString(i)));
                    result.add((Object)ftpUrl);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = new JSONArray();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getNoticePlayUrl(String valueOf, String playUrl, String siteId, int audiolib, int importNosoftlinkHasalias) {
        JSONObject result = new JSONObject();
        boolean playUrlflag = true;
        try {
            JSONObject playURL = JSONObject.fromObject((Object)playUrl);
            if (playURL != null) {
                playURL.put((Object)"subPath", (Object)(SiteUtil.getAlias((String)siteId) + playURL.getString("host")));
                playURL.put((Object)"host", (Object)(SiteUtil.getDomainPreByKey((String)siteId, (String)"audioDomain", (boolean)true) + playURL.getString("host")));
            }
            result = playURL;
        }
        catch (Exception e) {
            e.printStackTrace();
            playUrlflag = false;
        }
        finally {
            if (playUrlflag) {
                result.put((Object)"isSuccess", (Object)"1");
                result.put((Object)"message", (Object)"\u64ad\u51faURL\u4fe1\u606f\u83b7\u53d6\u6210\u529f!");
            } else {
                result.put((Object)"isSuccess", (Object)"0");
                result.put((Object)"message", (Object)"\u64ad\u51faURL\u4fe1\u606f\u6682\u65f6\u4e0d\u53ef\u7528!");
            }
        }
        return result;
    }
}

