/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.channel;

import com.chinamcloud.common.result.ResultDTO;
import com.chinamcloud.common.storage.dto.FileStorageDTO;
import com.chinamcloud.common.storage.util.FileStorageUtil;
import com.chinamcloud.common.storage.util.PathUtil;
import com.chinamcloud.vms.util.PathCommonUtil;
import com.google.common.collect.Lists;
import com.sobey.bsp.cms.pub.PubFun;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.cms.site.SetPrivUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.Page;
import com.sobey.bsp.framework.SiteConfig;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.common.util.FormatDateUtil;
import com.sobey.bsp.framework.controls.DataGridAction;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.FileUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.Application;
import com.sobey.bsp.platform.UserLog;
import com.sobey.bsp.plugin.util.DateUtil;
import com.sobey.bsp.schema.SCMS_ChannelsSchema;
import com.sobey.bsp.schema.SCMS_ChannelsSet;
import com.sobey.bsp.util.StringsUtil;
import com.sobey.cms.interfaces.ms3.PushMS3InterfacesImpl;
import com.sobey.cms.util.NewInterfacesMethod;
import com.sobey.scms.channel.ChannelActList;
import com.sobey.scms.channel.ChannelConfig;
import com.sobey.scms.channel.util.ChannelLibUtil;
import com.sobey.scms.contentinfo.DemandMediaCommon;
import com.sobey.scms.virtualchannel.VirtualChannelActList;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.axis.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChannelLib
extends Page {
    private static final Logger log = LoggerFactory.getLogger(ChannelLib.class);

    public static void dgChannelDataBind(DataGridAction dga) {
        String sql = "select ID,name,mediaType from scms_channels where mediaType in  (8,15)";
        DataTable dt = new QueryBuilder(sql).executeDataTable();
        dga.dataTable2JSON(dt);
    }

    public static void dg1DataBind(DataGridAction dga) {
        ChannelLibUtil.checkChExpreDate((long)Application.getCurrentSiteID());
        String channelType = (String)dga.getParams().get((Object)"type");
        String name = (String)dga.getParams().get((Object)"name");
        String channelIds = "";
        String RoleCode = PubFun.getRoleCodeByUserName((String)User.getUserName());
        String roleSql = "select * from scms_privilege where OwnerType='R' and Owner='" + RoleCode + "' and PrivType='channel'";
        DataTable roleDt = new QueryBuilder(roleSql).executeDataTable();
        if (roleDt != null && roleDt.getRowCount() > 0) {
            for (int i = 0; i < roleDt.getRowCount(); ++i) {
                channelIds = channelIds + "'" + roleDt.getString(i, "id") + "',";
            }
            channelIds = channelIds.substring(0, channelIds.length() - 1);
        }
        String sortString = StringUtil.isNotEmpty((String)dga.getParam("_ZVING_SORTSTRING")) ? dga.getParam("_ZVING_SORTSTRING") : "";
        StringBuilder condition = new StringBuilder();
        String sql = "select  operation,'' as resultStatus,resultCode,operationDate, '' as playerUrl, '' as shortName,id,imageURL,mediaType,name,createtime,expireddate,createUser,status,'' as ctype,'' as publish,'' as hasActList, '' as ctime,'' as exdate,'' as cstatus, '' as OutputTerminals, '' as OutputStream, timeShift, timeShiftDate, '' as host, '' as timeServer from scms_channels where 1=1";
        String countSql = "select count(*) from scms_channels  where 1=1 ";
        String startDate = dga.getParam("startDate");
        String endDate = dga.getParam("endDate");
        if (StringUtil.isNotEmpty((String)startDate)) {
            condition.append(" and date(createtime) >= '" + startDate + "'");
        }
        if (StringUtil.isNotEmpty((String)endDate)) {
            condition.append(" and date(createtime) <= '" + endDate + "'");
        }
        if (StringUtil.isNotEmpty((String)channelType)) {
            if (8 == Integer.parseInt(channelType)) {
                String type = "(8)";
                condition.append(" and mediaType in " + type);
                countSql = countSql + " and mediaType in " + type;
            } else {
                condition.append(" and mediaType= " + channelType);
                countSql = countSql + " and mediaType= " + channelType;
            }
        }
        sql = sql + condition.toString();
        if (StringUtil.isNotEmpty((String)name)) {
            sql = sql + " and name like '%" + name + "%'";
            countSql = countSql + " and name like '%" + name + "%'";
        }
        if (StringUtil.isNotEmpty((String)channelIds)) {
            sql = sql + " and id in (" + channelIds + ")";
            countSql = countSql + " and id in (" + channelIds + ")";
        }
        sql = sql + " order by " + sortString + "createtime desc";
        DataTable dt = new QueryBuilder(sql).executePagedDataTable(dga.getPageSize(), dga.getPageIndex());
        String alias = Application.getCurrentSiteAlias();
        String staticFileDomain = SiteUtil.getStaticFileDomainBySiteId((long)Application.getCurrentSiteID());
        String host = staticFileDomain + alias + "/liveChannel";
        String timeServer = Config.getValue((String)"vms.hosts.address") + "/getSystemTime";
        String currentDate = FormatDateUtil.format2DateByFormat((Date)new Date(), (String)"yyyy-MM-dd");
        DataTable configDT = null;
        StringBuilder terminals = null;
        StringBuilder outputStream = null;
        ArrayList<String> typeList = null;
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String relativeUrl;
            String id = dt.getString(i, "id");
            String playerUrl = "mr://j:" + ChannelLibUtil.getUrlJSONArrayByType((String)id, (long)Application.getCurrentSiteID(), (int)Integer.parseInt(channelType), (String)"PC", (boolean)false);
            int status = dt.getInt(i, "status");
            String resultCode = dt.getString(i, "resultCode");
            String cid = dt.getString(i, "id");
            String channelName = dt.getString(i, "name");
            dt.set(i, "shortName", (Object)DemandMediaCommon.controlMediaTitleLength((String)channelName));
            if (status == 0) {
                dt.set(i, "cstatus", (Object)"\u53d1\u5e03");
            } else {
                dt.set(i, "cstatus", (Object)"\u64a4\u9500");
            }
            if (StringUtil.isEmpty((String)resultCode)) {
                dt.set(i, "resultStatus", (Object)"\u65e0\u64cd\u4f5c");
            } else if ("1".equals(resultCode)) {
                dt.set(i, "resultStatus", (Object)"<font color=\"blue\">\u6210\u529f</font>");
            } else {
                dt.set(i, "resultStatus", (Object)"<font color=\"red\">\u5931\u8d25</font>");
            }
            DataTable actList = new QueryBuilder("select id from scms_actlist  where cid='" + cid + "' and playtime like '%" + currentDate + "%'").executeDataTable();
            if (actList != null && actList.getRowCount() != 0) {
                dt.set(i, "hasActList", (Object)"true");
            } else {
                dt.set(i, "hasActList", (Object)"false");
            }
            configDT = new QueryBuilder("select type, fullurl, formatinfo from scms_channelconfig  where cid='" + cid + "'").executeDataTable();
            if (configDT != null && configDT.getRowCount() > 0) {
                String type;
                int j;
                terminals = new StringBuilder();
                outputStream = new StringBuilder();
                typeList = new ArrayList<String>();
                HashMap<String, StringBuilder> formatMap = new HashMap<String, StringBuilder>();
                StringBuilder pcFormat = new StringBuilder();
                StringBuilder iosFormat = new StringBuilder();
                StringBuilder androidFormat = new StringBuilder();
                for (j = 0; j < configDT.getRowCount(); ++j) {
                    type = configDT.getString(j, "type");
                    String fullurl = configDT.getString(j, "fullurl");
                    String formatInfo = configDT.getString(j, "formatinfo");
                    String showFormatInfo = "";
                    showFormatInfo = formatInfo.length() > 8 ? formatInfo.substring(0, 8) + "..." : formatInfo;
                    String liveDomain = "";
                    if (type.equalsIgnoreCase("pc")) {
                        liveDomain = (String)SiteConfig.getValue((Long)Application.getCurrentSiteID(), (Object)"livePcDomain");
                        pcFormat.append("<span class='outputstream-pc'  title='" + liveDomain + fullurl + "'>" + showFormatInfo + "</span>");
                    } else if (type.equalsIgnoreCase("android")) {
                        liveDomain = (String)SiteConfig.getValue((Long)Application.getCurrentSiteID(), (Object)"liveIosDomain");
                        androidFormat.append("<span class='outputstream-android'  title='" + liveDomain + fullurl + "'>" + showFormatInfo + "</span>");
                    } else if (type.equalsIgnoreCase("ios")) {
                        liveDomain = (String)SiteConfig.getValue((Long)Application.getCurrentSiteID(), (Object)"liveAndroidDomain");
                        iosFormat.append("<span class='outputstream-ios'  title='" + liveDomain + fullurl + "'>" + showFormatInfo + "</span>");
                    }
                    if (!(!typeList.contains(type) && type.equals("PC") || !typeList.contains(type) && type.equals("IOS")) && (typeList.contains(type) || !type.equals("ANDROID"))) continue;
                    typeList.add(type);
                }
                formatMap.put("PC", pcFormat);
                formatMap.put("IOS", iosFormat);
                formatMap.put("ANDROID", androidFormat);
                for (j = 0; j < typeList.size(); ++j) {
                    type = typeList.get(j).toString();
                    String src = "";
                    src = type.equalsIgnoreCase("pc") ? "images/computer.png" : (type.equalsIgnoreCase("ios") ? "images/iosPhone.png" : "images/androidPhone.png");
                    terminals.append("<span class='device-icon'> <img class='terminal-" + type + "' src='" + src + "' style='margin-left: 5px;'>" + " <div class='device-defi'>" + "\t\t<div class='device-defi-inner'>" + formatMap.get(type).toString() + "" + "     </div>" + " \t<div class='arial'></div>" + " </div></span>");
                }
                dt.set(i, "OutputTerminals", (Object)terminals.toString());
                dt.set(i, "OutputStream", (Object)outputStream.toString());
            }
            if (StringUtil.isNotEmpty((String)(relativeUrl = dt.getString(i, "imageURL")))) {
                String absoluteUrl = SiteUtil.getImageDomainBySiteId((long)Application.getCurrentSiteID()) + alias + relativeUrl;
                dt.set(i, "imageURL", (Object)absoluteUrl);
            } else {
                dt.set(i, "imageURL", (Object)"../../Default/images/channeldefault.JPG");
            }
            dt.set(i, "ctime", (Object)dt.getString(i, "createtime"));
            SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd");
            String nowStr = formatter1.format(DateUtil.parseDate((String)dt.getString(i, "expireddate")));
            dt.set(i, "exdate", (Object)nowStr);
            dt.set(i, "host", (Object)host);
            dt.set(i, "playerUrl", (Object)StringsUtil.esUrl((String)playerUrl));
            dt.set(i, "timeServer", (Object)timeServer);
        }
        dga.setTotal(new QueryBuilder(countSql));
        dga.dataTable2JSON(dt);
    }

    public static Mapx initChannels(Mapx params) {
        String id = params.getString((Object)"id");
        String type = params.getString((Object)"type");
        if (StringUtils.isEmpty((String)id)) {
            params.put((Object)"imgurl", (Object)"../../Default/images/channeldefault.JPG");
            if (StringUtil.isNotEmpty((String)type)) {
                int mediaType = Integer.parseInt(type);
                String liveType = "";
                if (mediaType == 8) {
                    liveType = "\u7535\u89c6\u76f4\u64ad";
                } else if (mediaType == 15) {
                    liveType = "\u5e7f\u64ad\u76f4\u64ad";
                }
                params.put((Object)"liveType", (Object)liveType);
                params.put((Object)"mediaType", mediaType);
            }
            return params;
        }
        String sql = "select id,imageURL,mediaType,name,expireddate,timeshift,timeshiftdate,info from scms_channels where id='" + id + "'";
        DataTable dt = new QueryBuilder(sql).executeDataTable();
        Mapx map = new Mapx();
        String alias = Application.getCurrentSiteAlias();
        for (int i = 0; i < dt.getRowCount(); ++i) {
            for (int j = 0; j < dt.getColCount(); ++j) {
                String columnName = dt.getDataColumn(j).getColumnName();
                if (columnName.equals("expireddate")) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    String exdate = format.format(DateUtil.parse((String)dt.getString(i, j)));
                    map.put((Object)"exdate", (Object)exdate);
                } else if (columnName.equals("mediaType")) {
                    int mediaType = dt.getInt(i, j);
                    String liveType = "";
                    if (mediaType == 8) {
                        liveType = "\u7535\u89c6\u76f4\u64ad";
                    } else if (mediaType == 15) {
                        liveType = "\u5e7f\u64ad\u76f4\u64ad";
                    }
                    map.put((Object)"liveType", (Object)liveType);
                } else if (columnName.equals("timeshift")) {
                    String tShift = dt.getString(i, j).equals("1") ? "\u662f" : "\u5426";
                    map.put((Object)"tShift", (Object)tShift);
                } else if (columnName.equals("imageURL")) {
                    String relativeUrl = dt.getString(i, j);
                    String absoluteUrl = null;
                    if (StringUtil.isNotEmpty((String)relativeUrl)) {
                        absoluteUrl = SiteUtil.getImageDomainBySiteId((long)Application.getCurrentSiteID()) + alias + relativeUrl;
                        map.put((Object)"relativeUrl", (Object)relativeUrl);
                        map.put((Object)"absoluteUrl", (Object)absoluteUrl);
                        continue;
                    }
                    map.put((Object)"absoluteUrl", (Object)"../../Default/images/channeldefault.JPG");
                    map.put((Object)"relativeUrl", (Object)"");
                    continue;
                }
                map.put((Object)columnName, dt.get(i, j));
            }
        }
        return map;
    }

    public void publish() {
        String publishType;
        String id = this.$V("id");
        ResultDTO booleanResultDTO = this.checkParameter(id, publishType = this.$V("status"));
        if (!booleanResultDTO.isSuccess()) {
            this.Response.setStatus(0);
            this.Response.setMessage(booleanResultDTO.getDescription());
            return;
        }
        Integer oldStatus = 0;
        Integer newStatus = 0;
        if ("online".equals(publishType)) {
            newStatus = 1;
        } else if ("offline".equals(publishType)) {
            oldStatus = 1;
            newStatus = 0;
        }
        QueryBuilder updateSql = new QueryBuilder();
        updateSql.setSQL("update SCMS_Channels set status=" + newStatus + ", PublishDate=now() where id='" + id + "' and status=" + oldStatus);
        updateSql.executeNoQuery();
        long siteId = new QueryBuilder("select id from scms_site").executeLong();
        VirtualChannelActList.updataVchannerStatus((long)siteId, (String)id, (String)newStatus.toString(), (int)0);
        try {
            ChannelLib.generateLivePlayerFile((String)id, (int)newStatus, (long)siteId);
            if (newStatus == 1) {
                ChannelActList.generateLiveWeekActListFile((Calendar)Calendar.getInstance(), (String)id, (long)Application.getCurrentSiteID());
            }
            this.Response.setMessage((newStatus == 1 ? "\u53d1\u5e03" : "\u64a4\u9500") + "\u64cd\u4f5c\u6210\u529f!");
            this.Response.setStatus(1);
        }
        catch (Throwable e) {
            this.Response.setStatus(0);
            this.Response.setMessage("\u76f4\u64ad\u53d1\u5e03\u9047\u5230\u5f02\u5e38!");
            log.error("\u76f4\u64ad\u53d1\u5e03\u9047\u5230\u5f02\u5e38", e);
        }
    }

    private ResultDTO<Boolean> checkParameter(String id, String publishType) {
        int configCount;
        if (StringUtil.isEmpty((String)id) || StringUtil.isEmpty((String)publishType)) {
            return ResultDTO.fail((String)"\u53c2\u6570\u4f20\u9012\u4e0d\u5b8c\u6574");
        }
        ArrayList publishTypeList = Lists.newArrayList((Object[])new String[]{"online", "offline"});
        if (!publishTypeList.contains(publishType)) {
            return ResultDTO.fail((String)"\u4e0d\u652f\u6301\u7684\u53d1\u5e03\u7c7b\u578b");
        }
        boolean isExpired = this.judgeIsExpired(id);
        if (isExpired) {
            return ResultDTO.fail((String)"\u8be5\u76f4\u64ad\u5df2\u8fc7\u671f!");
        }
        if ("online".equals(publishType) && (configCount = new QueryBuilder("select count(*) from SCMS_Channelconfig where showFlag=1 and cid='" + id + "'").executeInt()) == 0) {
            return ResultDTO.fail((String)"\u8be5\u9891\u9053\u6ca1\u6709\u76f4\u64ad\u6d41\uff0c\u8bf7\u6dfb\u52a0\u81f3\u5c11\u4e00\u4e2a\u540e\u5728\u53d1\u5e03");
        }
        return ResultDTO.successfy((Object)true);
    }

    private boolean judgeIsExpired(String id) {
        SCMS_ChannelsSchema scms_channelsSchema = new SCMS_ChannelsSchema();
        scms_channelsSchema.setId(id);
        if (scms_channelsSchema.fill()) {
            Date expiredDate = scms_channelsSchema.getExpiredDate();
            Date now = new Date();
            if (expiredDate != null && now.getTime() > expiredDate.getTime()) {
                return true;
            }
        }
        return false;
    }

    public void add() {
        String name = this.$V("name").trim();
        try {
            String relativeUrl = this.$V("filedata");
            String id = this.$V("id").trim();
            String timemove = this.$V("timeMove");
            String dayNum = this.$V("dayNum");
            if (timemove.equals("0")) {
                dayNum = "0";
            }
            JSONArray configItems = JSONArray.fromObject((Object)this.$V("configItems"));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date();
            String userId = User.getUserName();
            SCMS_ChannelsSchema channel = new SCMS_ChannelsSchema();
            if (StringUtil.isEmpty((String)id)) {
                id = UUID.randomUUID().toString().replaceAll("-", "");
            }
            channel.setId(id);
            if (channel.fill()) {
                this.Response.setStatus(0);
                this.Response.setMessage("\u65b0\u5efa\u7684\u76f4\u64ad\u6d41ID\u5df2\u7ecf\u5b58\u5728,\u8bf7\u4e0d\u8981\u521b\u5efa\u76f8\u540cID\u7684\u76f4\u64ad\u9891\u9053");
                return;
            }
            channel.setName(name);
            channel.setMediaType(Integer.valueOf(Integer.parseInt(this.$V("type"))));
            channel.setImageURL(relativeUrl);
            channel.setCreateUser(userId);
            channel.setInfo(this.$V("info"));
            channel.setCreateTime(now);
            channel.setTimeShift(Integer.valueOf(Integer.parseInt(timemove)));
            channel.setTimeShiftDate(Integer.valueOf(Integer.parseInt(dayNum)));
            channel.setStatus(Integer.valueOf(0));
            if ("".equals(this.$V("exdate"))) {
                channel.setExpiredDate(null);
            } else {
                channel.setExpiredDate(format.parse(this.$V("exdate")));
            }
            Transaction trans = new Transaction();
            trans.add((Schema)channel, 1);
            ChannelConfig.saveChannelConfigs((JSONArray)configItems, (String)id, (Transaction)trans);
            String rolecode = PubFun.getRoleCodeByUserName((String)User.getUserName());
            SetPrivUtil.setChannelPriv((Transaction)trans, (String)rolecode, (String)id);
            if (!"admin".equals(rolecode)) {
                SetPrivUtil.setChannelPriv((Transaction)trans, (String)"admin", (String)id);
            }
            if (trans.commit()) {
                if (StringUtil.isNotEmpty((String)relativeUrl)) {
                    this.Response.setMessage("\u65b0\u589e\u9891\u9053\u6210\u529f!");
                } else {
                    this.Response.setMessage("\u65b0\u589e\u9891\u9053\u6210\u529f! \u8bf7\u6839\u636e\u9700\u8981 \u4e0a\u4f20\u53f0\u6807");
                }
                UserLog.log((String)"Channel", (String)"CreateChannel", (String)("\u65b0\u5efa\u76f4\u64ad\u9891\u9053" + name + "\u6210\u529f"), (String)this.Request.getClientIP());
                return;
            }
            UserLog.log((String)"Channel", (String)"CreateChannel", (String)("\u65b0\u5efa\u76f4\u64ad\u9891\u9053" + name + "\u5931\u8d25"), (String)this.Request.getClientIP());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Response.setStatus(0);
            this.Response.setMessage("\u64cd\u4f5c\u6570\u636e\u5e93\u65f6\u53d1\u751f\u9519\u8bef!");
            UserLog.log((String)"Channel", (String)"CreateChannel", (String)("\u65b0\u5efa\u76f4\u64ad\u9891\u9053" + name + "\u5931\u8d25"), (String)this.Request.getClientIP());
        }
    }

    public void save() {
        String id = this.$V("id");
        String name = this.$V("name");
        String info = this.$V("info");
        String timemove = this.$V("timeMove");
        String dayNum = this.$V("dayNum");
        String relativeUrl = this.$V("filedata");
        String type = this.$V("type").trim();
        String exdate = this.$V("exdate");
        JSONArray configItems = JSONArray.fromObject((Object)this.$V("configItems"));
        try {
            SCMS_ChannelsSchema channel = new SCMS_ChannelsSchema();
            channel.setId(id);
            channel.fill();
            channel.setName(name);
            channel.setImageURL(relativeUrl);
            channel.setMediaType(Integer.valueOf(Integer.parseInt(type)));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            channel.setExpiredDate(format.parse(exdate));
            channel.setInfo(info);
            channel.setTimeShift(Integer.valueOf(Integer.parseInt(timemove)));
            if (timemove.equals("0")) {
                channel.setTimeShiftDate(Integer.valueOf(0));
            } else {
                channel.setTimeShiftDate(Integer.valueOf(Integer.parseInt(dayNum)));
            }
            Transaction trans = new Transaction();
            trans.add((Schema)channel, 2);
            ChannelConfig.saveChannelConfigs((JSONArray)configItems, (String)id, (Transaction)trans);
            if (trans.commit()) {
                this.Response.setMessage("\u7f16\u8f91\u4fdd\u5b58\u76f4\u64ad\u9891\u9053\u6210\u529f!");
                UserLog.log((String)"Channel", (String)"UpdateChannel", (String)("\u7f16\u8f91\u76f4\u64ad\u9891\u9053" + name + "\u6210\u529f"), (String)this.Request.getClientIP());
                this.Response.setStatus(1);
                return;
            }
            UserLog.log((String)"Channel", (String)"UpdateChannel", (String)("\u7f16\u8f91\u76f4\u64ad\u9891\u9053" + name + "\u5931\u8d25"), (String)this.Request.getClientIP());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Response.setStatus(0);
            this.Response.setMessage("\u64cd\u4f5c\u6570\u636e\u5e93\u53d1\u751f\u9519\u8bef!");
            e.printStackTrace();
            UserLog.log((String)"Channel", (String)"UpdateChannel", (String)("\u7f16\u8f91\u76f4\u64ad\u9891\u9053" + name + "\u5931\u8d25"), (String)this.Request.getClientIP());
        }
    }

    public void delete() {
        String ids = this.$V("ids");
        String[] newIds = ids.split(",");
        StringBuffer sb = new StringBuffer();
        ArrayList<String> chhannelIdList = new ArrayList<String>();
        for (int i = 0; i < newIds.length; ++i) {
            PushMS3InterfacesImpl interfaces = new PushMS3InterfacesImpl();
            interfaces.delete(newIds[i]);
            chhannelIdList.add(newIds[i]);
            newIds[i] = i < newIds.length - 1 ? "'" + newIds[i] + "'," : "'" + newIds[i] + "'";
            sb.append(newIds[i]);
        }
        ids = sb.toString();
        Transaction trans = new Transaction();
        try {
            QueryBuilder qb = new QueryBuilder("delete from SCMS_Actlist where cid in (" + ids + ")");
            trans.add(qb);
            qb = new QueryBuilder("delete from SCMS_Channelconfig where cid in (" + ids + ")");
            trans.add(qb);
            qb = new QueryBuilder("delete from SCMS_Channels where id in (" + ids + ")");
            trans.add(qb);
            qb = new QueryBuilder("delete from scms_privilege where id in (" + ids + ")");
            trans.add(qb);
            if (trans.commit()) {
                UserLog.log((String)"Channel", (String)"DeleteChannel", (String)("\u5220\u9664ID\u4e3a: " + ids + " \u7684\u76f4\u64ad\u9891\u9053\u6210\u529f"), (String)this.Request.getClientIP());
                this.deleteStaticalDir(Application.getCurrentSiteAlias(), newIds);
                this.Response.setMessage("\u5220\u9664\u76f4\u64ad\u9891\u9053\u6210\u529f");
                this.Response.setStatus(1);
                for (int i = 0; i < chhannelIdList.size(); ++i) {
                    VirtualChannelActList.updataVchannerStatus((long)Application.getCurrentSiteID(), (String)chhannelIdList.get(i).toString(), (String)"0", (int)0);
                }
                return;
            }
            UserLog.log((String)"Channel", (String)"DeleteChannel", (String)("\u5220\u9664ID\u4e3a: " + ids + " \u7684\u76f4\u64ad\u9891\u9053\u5931\u8d25"), (String)this.Request.getClientIP());
        }
        catch (Exception e) {
            e.printStackTrace();
            UserLog.log((String)"Channel", (String)"DeleteChannel", (String)("\u5220\u9664ID\u4e3a: " + ids + " \u7684\u76f4\u64ad\u9891\u9053\u5931\u8d25"), (String)this.Request.getClientIP());
            this.Response.setStatus(0);
            this.Response.setMessage("\u64cd\u4f5c\u6570\u636e\u5e93\u65f6\u53d1\u751f\u9519\u8bef!");
        }
    }

    public void addOrCancelOrDelChannel() {
        String cid = this.$V("cid");
        SCMS_ChannelsSchema channel = new SCMS_ChannelsSchema();
        channel.setId(cid);
        if (channel.fill()) {
            String operation = this.$V("operation");
            PushMS3InterfacesImpl ms3 = new PushMS3InterfacesImpl();
            if ("addChannel".equals(operation)) {
                ms3.publish(cid);
            } else if ("deleteChannel".equals(operation)) {
                ms3.delete(cid);
            } else if ("cancelChannel".equals(operation)) {
                ms3.cancel(cid);
            } else {
                this.Response.setStatus(0);
                this.Response.setMessage("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5339\u914d");
            }
            this.Response.setStatus(1);
            this.Response.setMessage(operation + "\u64cd\u4f5c\u64cd\u4f5c\u5b8c\u6210!");
        } else {
            this.Response.setStatus(0);
            this.Response.setMessage("\u9891\u9053\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
    }

    public void deleteStaticalDir(String alias, String[] channelIds) {
        String linuxStaticFileDir = Config.getValue((String)"linuxStaticFileDir") + "/" + alias + "/liveChannel";
        if (channelIds != null) {
            for (int j = 0; j < channelIds.length; ++j) {
                String palyBills = linuxStaticFileDir + "/" + channelIds[j];
                String[] path = new String[]{linuxStaticFileDir + "/PC/" + channelIds[j], linuxStaticFileDir + "/IOS/" + channelIds[j], linuxStaticFileDir + "/ANDROID/" + channelIds[j]};
                FileUtil.delete((String)palyBills);
                for (int i = 0; i < path.length; ++i) {
                    FileUtil.delete((String)(path[i] + ".json"));
                    FileUtil.delete((String)(path[i] + ".jsonp"));
                }
            }
        }
    }

    public static void generateLivePlayerFile(String cid, int status, long siteId) {
        if (StringUtil.isEmpty((String)cid)) {
            return;
        }
        try {
            SCMS_ChannelsSchema scms_channelsSchema = new SCMS_ChannelsSchema();
            scms_channelsSchema.setId(cid);
            if (!scms_channelsSchema.fill()) {
                return;
            }
            int mediaType = 0;
            mediaType = 8 == scms_channelsSchema.getMediaType() ? scms_channelsSchema.getMediaType() : 15;
            Map map = ChannelLib.builderMapForStaticFile((String)cid, (int)status, (long)siteId, (int)mediaType);
            ChannelLib.writeToStaticalDir((Map)map, (int)mediaType, (long)siteId, (String)cid);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u9759\u6001\u6587\u4ef6\u9047\u5230\u5f02\u5e38", (Throwable)e);
        }
    }

    private static JSONObject builderPCJSONObjectByAudioChannel(JSONObject tempJSONObject, JSONArray pcAddressJSONArray) {
        JSONObject pcJSONObject = JSONObject.fromObject((Object)tempJSONObject);
        pcJSONObject.put((Object)"C_Address", (Object)("mr://j:" + pcAddressJSONArray.toString()));
        return pcJSONObject;
    }

    private static JSONObject builderTempJsonObjectByAudioChannel(SCMS_ChannelsSchema scms_channelsSchema) {
        JSONObject tempJSONObject = new JSONObject();
        tempJSONObject.put((Object)"ColumnId", null);
        tempJSONObject.put((Object)"C_ImgURL", (Object)scms_channelsSchema.getImageURL());
        tempJSONObject.put((Object)"C_LowRateAud", (Object)"");
        tempJSONObject.put((Object)"C_Name", (Object)scms_channelsSchema.getName());
        tempJSONObject.put((Object)"C_IsGood", (Object)0);
        tempJSONObject.put((Object)"C_Brief", (Object)scms_channelsSchema.getInfo());
        tempJSONObject.put((Object)"C_Type", (Object)3);
        tempJSONObject.put((Object)"C_Id", (Object)scms_channelsSchema.getId());
        tempJSONObject.put((Object)"C_PublishTime", (Object)FormatDateUtil.format2DateByFormat((Date)scms_channelsSchema.getPublishDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        tempJSONObject.put((Object)"A_Name", (Object)"");
        return tempJSONObject;
    }

    private static Map builderMapForStaticFile(String cid, int status, long siteId, int mediaType) {
        SCMS_ChannelsSet scms_channelsSet = ChannelLib.getScms_channelsSet((Integer)mediaType);
        JSONObject curPCJSONObject = null;
        JSONObject curIOSJSONObject = null;
        JSONObject curANDROIDJSONObject = null;
        JSONArray pcAllJSONArray = new JSONArray();
        JSONArray androidAllJSONArray = new JSONArray();
        JSONArray iosAllJSONArray = new JSONArray();
        SCMS_ChannelsSchema scms_channelsSchema = null;
        for (int i = 0; i < scms_channelsSet.size(); ++i) {
            JSONArray androidAddressJSONArray;
            JSONArray iosAddressJSONArray;
            scms_channelsSchema = scms_channelsSet.get(i);
            String id = scms_channelsSchema.getId();
            JSONObject tempJSONObject = ChannelLib.builderTempJsonObject((long)siteId, (Integer)mediaType, (SCMS_ChannelsSchema)scms_channelsSchema);
            JSONArray pcAddressJSONObject = ChannelLibUtil.getUrlJSONArrayByType((String)id, (long)siteId, (int)scms_channelsSchema.getMediaType(), (String)"PC", (boolean)false);
            if (pcAddressJSONObject != null) {
                JSONObject pcJSONObject = ChannelLib.builderPCJsonObject((Integer)mediaType, (String)id, (JSONObject)tempJSONObject, (JSONArray)pcAddressJSONObject);
                pcAllJSONArray.add((Object)pcJSONObject);
                if (id.equals(cid) && status == 1) {
                    curPCJSONObject = JSONObject.fromObject((Object)pcJSONObject);
                }
            }
            if ((iosAddressJSONArray = ChannelLibUtil.getUrlJSONArrayByType((String)id, (long)siteId, (int)scms_channelsSchema.getMediaType(), (String)"IOS", (boolean)false)) != null) {
                JSONObject iosJSONObject = ChannelLib.getMobileJSONObject((JSONObject)tempJSONObject, (JSONArray)iosAddressJSONArray);
                iosAllJSONArray.add((Object)iosJSONObject);
                if (id.equals(cid) && status == 1) {
                    curIOSJSONObject = JSONObject.fromObject((Object)iosJSONObject);
                }
            }
            if ((androidAddressJSONArray = ChannelLibUtil.getUrlJSONArrayByType((String)id, (long)siteId, (int)scms_channelsSchema.getMediaType(), (String)"ANDROID", (boolean)false)) == null) continue;
            JSONObject androidJSONObject = ChannelLib.getMobileJSONObject((JSONObject)tempJSONObject, (JSONArray)androidAddressJSONArray);
            androidAllJSONArray.add((Object)androidJSONObject);
            if (!id.equals(cid) || status != 1) continue;
            curANDROIDJSONObject = JSONObject.fromObject((Object)androidJSONObject);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pc", pcAllJSONArray);
        map.put("ios", iosAllJSONArray);
        map.put("android", androidAllJSONArray);
        map.put("pc_jo", curPCJSONObject);
        map.put("ios_jo", curIOSJSONObject);
        map.put("android_jo", curANDROIDJSONObject);
        return map;
    }

    private static JSONObject builderPCJsonObject(Integer mediaType, String id, JSONObject tempJSONObject, JSONArray pcAddressJSONObject) {
        JSONObject pcJSONObject = null;
        pcJSONObject = 8 == mediaType ? ChannelLib.builderPCJSONObjectByChannel((String)id, (JSONObject)tempJSONObject, (JSONArray)pcAddressJSONObject) : ChannelLib.builderPCJSONObjectByAudioChannel((JSONObject)tempJSONObject, (JSONArray)pcAddressJSONObject);
        return pcJSONObject;
    }

    private static JSONObject builderTempJsonObject(long siteId, Integer mediaType, SCMS_ChannelsSchema scms_channelsSchema) {
        JSONObject tempJSONObject = null;
        tempJSONObject = 8 == mediaType ? ChannelLib.builderTempJsonObjectByChannel((long)siteId, (SCMS_ChannelsSchema)scms_channelsSchema) : ChannelLib.builderTempJsonObjectByAudioChannel((SCMS_ChannelsSchema)scms_channelsSchema);
        return tempJSONObject;
    }

    private static JSONObject getMobileJSONObject(JSONObject tempJSONObject, JSONArray addressJSONArray) {
        JSONObject jsonObject = JSONObject.fromObject((Object)tempJSONObject);
        jsonObject.put((Object)"C_Address", (Object)addressJSONArray);
        return jsonObject;
    }

    private static JSONObject builderPCJSONObjectByChannel(String id, JSONObject tempJSONObject, JSONArray pcPlayerUrlJSONArray) {
        JSONObject pcJSONObject = JSONObject.fromObject((Object)tempJSONObject);
        JSONObject pcAddressJSONObject = ChannelLib.getPCAddressJsonObject((String)id, (JSONArray)pcPlayerUrlJSONArray);
        pcJSONObject.put((Object)"C_Address", (Object)("mr://j:" + pcAddressJSONObject.toString()));
        return pcJSONObject;
    }

    private static JSONObject getPCAddressJsonObject(String id, JSONArray pcPlayerUrlJSONArray) {
        JSONObject pcAddressJSONObject = new JSONObject();
        pcAddressJSONObject.put((Object)"playerUrl", (Object)pcPlayerUrlJSONArray);
        pcAddressJSONObject.put((Object)"status", (Object)1);
        pcAddressJSONObject.put((Object)"catalogId", (Object)id);
        return pcAddressJSONObject;
    }

    private static JSONObject builderTempJsonObjectByChannel(long siteId, SCMS_ChannelsSchema scms_channelsSchema) {
        JSONObject tempJSONObject = new JSONObject();
        String channelImgUrl = NewInterfacesMethod.getChannelImageURL((Long)siteId, (String)scms_channelsSchema.getImageURL());
        tempJSONObject.put((Object)"imagePath", (Object)channelImgUrl);
        tempJSONObject.put((Object)"C_Name", (Object)scms_channelsSchema.getName());
        tempJSONObject.put((Object)"C_Brief", (Object)scms_channelsSchema.getInfo());
        tempJSONObject.put((Object)"C_Id", (Object)scms_channelsSchema.getId());
        tempJSONObject.put((Object)"C_PublishTime", (Object)FormatDateUtil.format2DateByFormat((Date)scms_channelsSchema.getPublishDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        return tempJSONObject;
    }

    private static SCMS_ChannelsSet getScms_channelsSet(Integer mediaType) {
        QueryBuilder queryBuilder = new QueryBuilder();
        queryBuilder.setSQL("where status=1 and mediaType=" + mediaType + " order by createtime asc");
        return new SCMS_ChannelsSchema().query(queryBuilder);
    }

    public static void writeToStaticalDir(Map map, int mediaType, long siteId, String channelId) {
        try {
            ArrayList terminalList = Lists.newArrayList((Object[])new String[]{"pc", "ios", "android"});
            String alias = new QueryBuilder("select alias from scms_site").executeString();
            boolean isSupportOSSStorage = SiteUtil.isSupportOSSStorage((long)siteId);
            String ossBucketName = SiteUtil.getOssBucketName((Long)siteId);
            for (String terminal : terminalList) {
                JSONArray curJSONArray;
                String thirdStorageParentPath = ChannelLib.getThirdStorageParentPath((String)alias, (String)terminal);
                String localStorageParentPath = PathCommonUtil.builderPathByLinuxStaticFileDir((String)thirdStorageParentPath);
                JSONObject curJSONObject = (JSONObject)map.get(terminal + "_jo");
                FileStorageDTO fileStorageDTO = null;
                if (curJSONObject != null && StringUtil.isNotEmpty((String)curJSONObject.toString())) {
                    String saveFileNameByJson = channelId + ".json";
                    fileStorageDTO = FileStorageDTO.builder().isSupportOSSStorage(isSupportOSSStorage).ossBucketName(ossBucketName).thirdStorageParentPath(thirdStorageParentPath).localStorageParentPath(localStorageParentPath).saveFileName(saveFileNameByJson).build();
                    FileStorageUtil.saveFile((FileStorageDTO)fileStorageDTO, (String)curJSONObject.toString());
                    String saveFileNameIsJsonp = channelId + ".jsonp";
                    String textContentIsJsonp = "callback_" + channelId + "(" + curJSONObject.toString() + ")";
                    fileStorageDTO = FileStorageDTO.builder().isSupportOSSStorage(isSupportOSSStorage).ossBucketName(ossBucketName).thirdStorageParentPath(thirdStorageParentPath).localStorageParentPath(localStorageParentPath).saveFileName(saveFileNameIsJsonp).build();
                    FileStorageUtil.saveFile((FileStorageDTO)fileStorageDTO, (String)textContentIsJsonp);
                }
                if ((curJSONArray = (JSONArray)map.get(terminal)) == null || curJSONArray.isEmpty()) continue;
                String saveFileNameByJson = ChannelLib.getSaveFileNameByJson((int)mediaType);
                fileStorageDTO = FileStorageDTO.builder().isSupportOSSStorage(isSupportOSSStorage).ossBucketName(ossBucketName).thirdStorageParentPath(thirdStorageParentPath).localStorageParentPath(localStorageParentPath).saveFileName(saveFileNameByJson).build();
                FileStorageUtil.saveFile((FileStorageDTO)fileStorageDTO, (String)curJSONArray.toString());
                String saveFileNameIsJsonp = ChannelLib.getSaveFileNameIsJsonp((int)mediaType);
                String textContentIsJsonp = "channels_jsonpCallback(" + curJSONArray.toString() + ")";
                fileStorageDTO = FileStorageDTO.builder().isSupportOSSStorage(isSupportOSSStorage).ossBucketName(ossBucketName).thirdStorageParentPath(thirdStorageParentPath).localStorageParentPath(localStorageParentPath).saveFileName(saveFileNameIsJsonp).build();
                FileStorageUtil.saveFile((FileStorageDTO)fileStorageDTO, (String)textContentIsJsonp);
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u5b58\u50a8\u9047\u5230\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private static String getSaveFileNameIsJsonp(int mediaType) {
        String saveFileNameIsJsonp = null;
        saveFileNameIsJsonp = 8 == mediaType ? "videoAll.jsonp" : "audioAll.jsonp";
        return saveFileNameIsJsonp;
    }

    private static String getSaveFileNameByJson(int mediaType) {
        String saveFileNameByJson = null;
        saveFileNameByJson = 8 == mediaType ? "videoAll.json" : "audioAll.json";
        return saveFileNameByJson;
    }

    private static String getThirdStorageParentPath(String alias, String terminal) {
        return PathUtil.builderPath((String[])new String[]{alias, "/liveChannel/", terminal.toUpperCase()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAllChannels() {
        JSONObject jo = new JSONObject();
        JSONArray ja = new JSONArray();
        String type = this.$V("type");
        try {
            String sql = "select id,name,status from scms_channels where mediaType = '" + type + "' order by createtime desc";
            DataTable dt = new QueryBuilder(sql).executeDataTable();
            if (dt != null && dt.getRowCount() > 0) {
                for (int i = 0; i < dt.getRowCount(); ++i) {
                    JSONObject item = new JSONObject();
                    item.put((Object)"id", (Object)dt.getString(i, "id"));
                    item.put((Object)"name", (Object)dt.getString(i, "name"));
                    item.put((Object)"status", (Object)dt.getString(i, "status"));
                    ja.add((Object)item);
                }
            }
            this.Response.setStatus(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Response.setStatus(0);
        }
        finally {
            jo.put((Object)"actList", (Object)ja);
            this.Response.setMessage(jo.toString());
        }
    }

    public static JSONObject getliveDownloadUrl(String cid, long siteId, String liveStreamId) {
        JSONObject result = new JSONObject();
        JSONArray ja = new JSONArray();
        DataTable dt = new QueryBuilder("select streamSource,width,height,fileTypeId, formatInfo,Fullurl from scms_channelconfig where downloadCutFlag=1  and cid = '" + cid + "';").executeDataTable();
        if (dt != null && dt.getRowCount() > 0) {
            for (int i = 0; i < dt.getRowCount(); ++i) {
                JSONObject jo = new JSONObject();
                String title = dt.getString(i, "formatInfo");
                String fileTypeId = dt.getString(i, "fileTypeId");
                String[] fileTypeIds = fileTypeId.split("_");
                String fullurl = dt.getString(i, "Fullurl");
                String url = "";
                int streamSource = dt.getInt(i, "streamSource");
                url = 2 == streamSource ? fullurl : SiteConfig.getValue((Long)siteId, (Object)"liveDownloadDomain") + fullurl;
                long width = dt.getLong(i, "width");
                long height = dt.getLong(i, "height");
                jo.put((Object)"width", (Object)width);
                jo.put((Object)"height", (Object)height);
                jo.put((Object)"title", (Object)title);
                jo.put((Object)"url", (Object)url);
                jo.put((Object)"codec", (Object)fileTypeIds[0]);
                jo.put((Object)"bitRate", (Object)fileTypeIds[1]);
                jo.put((Object)"fileType", (Object)fileTypeIds[2]);
                ja.add((Object)jo);
            }
        }
        result.put((Object)"downloadCutUrl", (Object)ja);
        JSONObject jo = new JSONObject();
        DataTable dtOne = new QueryBuilder("select width,height, fileTypeId, formatInfo,Fullurl from scms_channelconfig where id=" + Long.parseLong(liveStreamId)).executeDataTable();
        if (dt != null && dtOne.getRowCount() > 0) {
            for (int i = 0; i < dtOne.getRowCount(); ++i) {
                String title = dtOne.getString(i, "formatInfo");
                String fileTypeId = dtOne.getString(i, "fileTypeId");
                String[] fileTypeIds = fileTypeId.split("_");
                String fullurl = SiteConfig.getValue((Long)siteId, (Object)"liveDownloadDomain") + dtOne.getString(i, "Fullurl");
                long width = dtOne.getLong(i, "width");
                long height = dtOne.getLong(i, "height");
                jo.put((Object)"width", (Object)width);
                jo.put((Object)"height", (Object)height);
                jo.put((Object)"title", (Object)title);
                jo.put((Object)"url", (Object)fullurl);
                jo.put((Object)"codec", (Object)fileTypeIds[0]);
                jo.put((Object)"bitRate", (Object)fileTypeIds[1]);
                jo.put((Object)"fileType", (Object)fileTypeIds[2]);
            }
        }
        result.put((Object)"quickCutUrl", (Object)jo);
        return result;
    }
}

