/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.contentinfo;

import com.sobey.bsp.cms.pub.PubFun;
import com.sobey.bsp.cms.site.Catalog;
import com.sobey.bsp.framework.Page;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.controls.DataGridAction;
import com.sobey.bsp.framework.controls.TreeAction;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.Filter;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.Application;
import com.sobey.bsp.plugin.util.DateUtil;
import com.sobey.bsp.schema.SCMS_MediaCutSchema;
import com.sobey.bsp.threadmanager.MediaCutRecordThread;
import com.sobey.bsp.threadmanager.ThreadPoolManager;
import com.sobey.bsp.threadmanager.ThreadTask;
import com.sobey.scms.contentinfo.DemandMediaCommon;
import com.sobey.scms.contentinfo.interfaces.util.ContentUtil;
import com.sobey.scms.trasncode.MPCCall;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DemandMediaCutLib
extends Page {
    private static final Logger log = LoggerFactory.getLogger(DemandMediaCutLib.class);

    public static void audioTreeDataBindAdd(TreeAction ta) {
        String SiteID = String.valueOf(Application.getCurrentSiteID());
        DataTable dt = null;
        Mapx params = ta.getParams();
        String parentID = params.getString((Object)"parentId");
        String type = ta.getParams().getString((Object)"type");
        if (StringUtil.isEmpty((String)parentID)) {
            parentID = "0";
        }
        QueryBuilder qb = new QueryBuilder("SELECT ID,PARENTID,TREELEVEL,NAME,SINGLEFLAG,INNERCODE,TYPE FROM SCMS_CATALOG WHERE TYPE = ? AND SITEID = ? AND PARENTID =? ORDER BY ORDERFLAG ");
        qb.add(6);
        qb.add((Object)SiteID);
        qb.add((Object)parentID);
        dt = qb.executeDataTable();
        ta.setRootText("\u97f3\u9891\u5fae\u7f16");
        if (StringUtil.isNotEmpty((String)type) && "1".equals(type)) {
            ta.setRootText("");
        }
        dt = dt.filter((Filter)new /* Unavailable Anonymous Inner Class!! */);
        ta.bindData(dt);
    }

    public static void videoTreeDataBindAdd(TreeAction ta) {
        String SiteID = String.valueOf(Application.getCurrentSiteID());
        DataTable dt = null;
        Mapx params = ta.getParams();
        String parentID = params.getString((Object)"parentId");
        String type = ta.getParams().getString((Object)"type");
        if (StringUtil.isEmpty((String)parentID)) {
            parentID = "0";
        }
        QueryBuilder qb = new QueryBuilder("SELECT ID,PARENTID,TREELEVEL,NAME,SINGLEFLAG,INNERCODE,TYPE FROM SCMS_CATALOG WHERE TYPE = ? AND SITEID = ? AND PARENTID =? ORDER BY ORDERFLAG ");
        qb.add(5);
        qb.add((Object)SiteID);
        qb.add((Object)parentID);
        dt = qb.executeDataTable();
        ta.setRootText("\u89c6\u9891\u5fae\u7f16");
        if (StringUtil.isNotEmpty((String)type) && "1".equals(type)) {
            ta.setRootText("");
        }
        dt = dt.filter((Filter)new /* Unavailable Anonymous Inner Class!! */);
        ta.bindData(dt);
    }

    public static void dg1DataBind(DataGridAction dataGridAction) {
        String keyword = dataGridAction.getParam("Keyword");
        String searchDate = dataGridAction.getParam("SearchDate");
        String mediaType = dataGridAction.getParam("mediaType");
        String categoryID = dataGridAction.getParam("CatalogID");
        if (StringUtil.isEmpty((String)categoryID)) {
            dataGridAction.setTotal(0);
            dataGridAction.dataTable2JSON(new DataTable());
            return;
        }
        String roleName = PubFun.getRoleCodeByUserName((String)User.getUserName());
        String catalogIds = Catalog.getCatalogIDSByParentIDs((String)categoryID, (String)roleName, (int)Integer.parseInt(mediaType));
        if (StringUtil.isEmpty((String)catalogIds)) {
            catalogIds = categoryID;
        }
        String sqlCondition = DemandMediaCutLib.getSqlCondition((String)keyword, (String)searchDate, (String)mediaType, (String)catalogIds);
        QueryBuilder queryBuilderCount = DemandMediaCutLib.getQueryBuilderCountSql((String)sqlCondition);
        dataGridAction.setTotal(queryBuilderCount);
        QueryBuilder queryBuilderList = DemandMediaCutLib.getQueryBuilderListSql((String)sqlCondition);
        DataTable dataTable = DemandMediaCutLib.getDataTable((DataGridAction)dataGridAction, (String)mediaType, (QueryBuilder)queryBuilderList);
        dataGridAction.dataTable2JSON(dataTable);
    }

    private static DataTable getDataTable(DataGridAction dataGridAction, String mediaType, QueryBuilder queryBuilderList) {
        DataTable dataTable = queryBuilderList.executePagedDataTable(dataGridAction.getPageSize(), dataGridAction.getPageIndex());
        String mediaTypeName = DemandMediaCutLib.getMediaTypeName((String)mediaType);
        try {
            for (int i = 0; i < dataTable.getRowCount(); ++i) {
                int status = dataTable.getInt(i, "status");
                String message = DemandMediaCutLib.getMessage((int)status, (String)mediaTypeName);
                if (0 == status) {
                    String afresh = "<a href='#' style='display:none;padding:4px 12px;' class='button01' onmouseout=\"hiddenButton(this)\" onclick=\"afreshStatus('" + dataTable.getString(i, "id") + "','" + status + "')\">\u91cd\u7f6e</a><div class='progressView'>";
                    dataTable.set(i, "afreshStatus", (Object)afresh);
                }
                dataTable.set(i, "status", (Object)message);
                dataTable.set(i, "title1", (Object)DemandMediaCommon.controlMediaTitleLength((String)dataTable.getString(i, "title")));
                String info = dataTable.getString(i, "info");
                JSONObject jsonObject = JSONObject.fromObject((Object)info);
                dataTable.set(i, "info", (Object)URLEncoder.encode(jsonObject.toString(), "UTF-8"));
                Long programeLength = jsonObject.getLong("programeLength");
                dataTable.set(i, "programeLength", (Object)com.sobey.bsp.framework.utility.DateUtil.getTimeStr((long)(programeLength / 1000L)).replaceAll(":", "'"));
                dataTable.set(i, "opUser", (Object)ContentUtil.getRealNameByMediafrom((int)10, (String)dataTable.getString(i, "opUser")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4e91\u7f16\u8f91\u76f4\u64ad\u52a0\u8f7d\u6570\u636e\u9047\u5230\u5f02\u5e38", (Throwable)e);
        }
        return dataTable;
    }

    private static String getMediaTypeName(String mediaType) {
        String mediaTypeName = "\u89c6\u9891";
        mediaTypeName = String.valueOf(5).equals(mediaType) ? "\u89c6\u9891" : "\u97f3\u9891";
        return mediaTypeName;
    }

    private static String getMessage(int status, String mediaTypeName) {
        String message = "\u5f02\u5e38\u4fe1\u606f";
        switch (status) {
            case 0: {
                message = "\u6536\u5f55\u5931\u8d25";
                break;
            }
            case 1: {
                message = "\u6210\u529f";
                break;
            }
            case 3: {
                message = mediaTypeName + "\u4e0b\u8f7d\u4e2d...";
                break;
            }
            case 9: {
                message = "\u7b49\u5f85\u6267\u884c";
                break;
            }
            case 5: {
                message = mediaTypeName + "\u5408\u6210\u4e2d...";
                break;
            }
            case 2: {
                message = mediaTypeName + "\u8f6c\u7801\u4e2d...";
                break;
            }
            default: {
                message = "\u5f02\u5e38\u4fe1\u606f";
            }
        }
        return message;
    }

    private static QueryBuilder getQueryBuilderListSql(String sqlCondition) {
        QueryBuilder queryBuilderList = new QueryBuilder("select '' AS programeLength, '' AS 'title1',a.ContentSourceId, a.id,a.title,'' as afreshStatus,a.status,a.opUser,a.addTime,a.filepath,a.info from  scms_mediacut a");
        queryBuilderList.appendSQLPart(" where 1=1");
        queryBuilderList.appendSQLPart(sqlCondition);
        queryBuilderList.appendSQLPart(" order by a.ID desc");
        return queryBuilderList;
    }

    private static QueryBuilder getQueryBuilderCountSql(String sqlCondition) {
        QueryBuilder queryBuilderCountSql = new QueryBuilder("select count(id)  from scms_mediacut a");
        queryBuilderCountSql.appendSQLPart(" where 1=1");
        queryBuilderCountSql.appendSQLPart(sqlCondition);
        return queryBuilderCountSql;
    }

    private static String getSqlCondition(String keyword, String searchDate, String mediaType, String catalogIds) {
        StringBuilder sqlConditionStringBuilder = new StringBuilder();
        if (StringUtil.isNotEmpty((String)searchDate)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date();
            int day = Integer.parseInt(searchDate);
            if (day == 0) {
                sqlConditionStringBuilder.append(" AND a.ADDTIME like '%" + format.format(now) + "%' ");
            } else if (day == -1) {
                sqlConditionStringBuilder.append(" AND a.ADDTIME like '%" + format.format(DateUtil.decreaseDay((Date)now, (int)1)) + "%' ");
            } else if (day == 3) {
                sqlConditionStringBuilder.append(" AND a.ADDTIME > '" + format.format(DateUtil.decreaseDay((Date)now, (int)3)) + "' ");
                sqlConditionStringBuilder.append(" AND a.ADDTIME <= '" + format.format(now) + " 23:59:59' ");
            } else if (day == 7) {
                sqlConditionStringBuilder.append(" AND a.ADDTIME > '" + format.format(DateUtil.decreaseDay((Date)now, (int)7)) + "' ");
                sqlConditionStringBuilder.append(" AND a.ADDTIME <= '" + format.format(now) + " 23:59:59' ");
            }
        }
        if (StringUtil.isEmpty((String)mediaType)) {
            mediaType = String.valueOf(5);
        }
        sqlConditionStringBuilder.append(" AND a.TYPE = " + mediaType + " ");
        sqlConditionStringBuilder.append(" AND a.catalogId in (" + catalogIds + ") ");
        if (StringUtil.isNotEmpty((String)keyword)) {
            sqlConditionStringBuilder.append(" AND a.TITLE LIKE '%" + keyword + "%' ");
        }
        return sqlConditionStringBuilder.toString();
    }

    public void afreshStatus() {
        String rid = this.$V("rid");
        try {
            SCMS_MediaCutSchema vr = new SCMS_MediaCutSchema();
            vr.setId(Long.valueOf(Long.parseLong(rid)));
            if (vr.fill() && vr.getStatus() == 0) {
                vr.setStatus(Integer.valueOf(9));
                Transaction tac = new Transaction();
                tac.add((Schema)vr, 2);
                if (tac.commit()) {
                    MediaCutRecordThread th = new MediaCutRecordThread(vr);
                    ThreadPoolManager.getInstance().addTask((ThreadTask)th);
                    this.Response.setStatus(1);
                    this.Response.setMessage("\u91cd\u7f6e\u6210\u529f\uff01");
                    return;
                }
            }
            this.Response.setStatus(0);
            this.Response.setMessage("\u64cd\u4f5c\u5931\u8d25,\u672a\u627e\u5230\u62c6\u6761\u6570\u636e");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Response.setStatus(0);
            this.Response.setMessage("\u64cd\u4f5c\u5931\u8d25,\u8bf7\u91cd\u8bd5");
        }
    }

    public static void logDataBind(DataGridAction dga) {
        String contentid = (String)dga.getParams().get((Object)"id");
        String sql = "SELECT * FROM scms_mediacutlog WHERE CONTENTID=? ORDER BY ID DESC";
        if (dga.getTotal() == 0) {
            String sql2 = "SELECT COUNT(*) FROM scms_mediacutlog WHERE CONTENTID=?";
            dga.setTotal(new QueryBuilder(sql2, (Object)contentid));
        }
        DataTable dt = new QueryBuilder(sql, (Object)contentid).executePagedDataTable(dga.getPageSize(), dga.getPageIndex());
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String realname = ContentUtil.getRealNameByMediafrom((int)10, (String)dt.getString(i, "AddUser"));
            dt.set(i, "AddUser", (Object)realname);
        }
        dga.dataTable2JSON(dt);
    }

    public void getRecordStatus() {
        try {
            String rids = this.$V("rids");
            String type = this.$V("mediaType");
            String message = "\u64cd\u4f5c\u9519\u8bef\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5";
            String[] ridArray = null;
            if (!StringUtil.isNotEmpty((String)rids)) {
                this.Response.setStatus(0);
                this.Response.setMessage("\u9875\u9762\u6570\u636e\u83b7\u53d6\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
                return;
            }
            ridArray = rids.split(",");
            String mediaSourceTableName = "scms_contentinfo";
            if (type.equals("6")) {
                mediaSourceTableName = "scms_audioinfo";
            }
            for (String rid : ridArray) {
                message = "\u72b6\u6001\u83b7\u53d6\u9519\u8bef";
                SCMS_MediaCutSchema vr = new SCMS_MediaCutSchema();
                vr.setId(Long.valueOf(Long.parseLong(rid)));
                if (!vr.fill()) continue;
                try {
                    String ContentSourceId = vr.getContentSourceId();
                    String status = "1";
                    String videStatus = new QueryBuilder("SELECT STATUS  FROM " + mediaSourceTableName + " WHERE ContentSourceId='" + ContentSourceId + "'").executeString();
                    if (StringUtil.isNotEmpty((String)videStatus)) {
                        String sql;
                        if ("3".equals(videStatus) || "8".equals(videStatus)) {
                            sql = "UPDATE scms_mediacut SET status=0 where ContentSourceId='" + ContentSourceId + "'";
                            new QueryBuilder(sql).executeNoQuery();
                            status = "0";
                        } else if ("2".equals(videStatus)) {
                            sql = "UPDATE scms_mediacut SET status=2 where ContentSourceId='" + ContentSourceId + "'";
                            new QueryBuilder(sql).executeNoQuery();
                            status = "2";
                        } else {
                            sql = "UPDATE scms_mediacut SET status=1 where ContentSourceId='" + ContentSourceId + "'";
                            new QueryBuilder(sql).executeNoQuery();
                        }
                    } else {
                        status = vr.getStatus() + "";
                    }
                    switch (Integer.parseInt(status)) {
                        case 0: {
                            message = "\u5931\u8d25";
                            break;
                        }
                        case 1: {
                            message = "\u6210\u529f";
                            break;
                        }
                        case 3: {
                            message = "\u89c6\u9891\u4e0b\u8f7d\u4e2d...";
                            break;
                        }
                        case 9: {
                            message = "\u7b49\u5f85\u5f55\u5236";
                            break;
                        }
                        case 5: {
                            Map map = MPCCall.getTranscodeProgress((String)vr.getContentSourceId(), (boolean)false);
                            for (String key : map.keySet()) {
                                message = "\u89c6\u9891\u5408\u6210\u4e2d" + (String)map.get(key);
                            }
                            break;
                        }
                        case 2: {
                            Map map1 = MPCCall.getTranscodeProgress((String)vr.getContentSourceId(), (boolean)false);
                            for (String key : map1.keySet()) {
                                message = "\u89c6\u9891\u8f6c\u7801\u4e2d" + (String)map1.get(key);
                            }
                            break;
                        }
                        default: {
                            message = "\u5f02\u5e38\u4fe1\u606f";
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.Response.put((Object)rid, (Object)message);
            }
            this.Response.setStatus(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Response.setMessage("\u64cd\u4f5c\u5f02\u5e38");
            this.Response.setStatus(0);
        }
    }

    public void del() {
        try {
            String[] ridArray;
            Transaction ta = new Transaction();
            String rid = this.$V("ids");
            boolean flag = true;
            for (String rrid : ridArray = rid.split(",")) {
                SCMS_MediaCutSchema vrc = new SCMS_MediaCutSchema();
                vrc.setId(Long.valueOf(Long.parseLong(rrid)));
                if (!vrc.fill() || vrc.getStatus() <= 1 || vrc.getStatus() == 9) continue;
                flag = false;
            }
            if (flag) {
                String delSql = "delete from scms_mediacut where id in (" + rid + ")";
                String delLogSql = "delete from scms_mediacutlog where ContentId in (" + rid + ")";
                ta.add(new QueryBuilder(delSql));
                ta.add(new QueryBuilder(delLogSql));
                if (ta.commit()) {
                    this.Response.setStatus(1);
                    this.Response.setMessage("\u5220\u9664\u6210\u529f");
                    return;
                }
            } else {
                this.Response.setStatus(1);
                this.Response.setMessage("\u5220\u9664\u5931\u8d25,\u6709\u6536\u5f55\u8ba1\u5212\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u4e0d\u80fd\u5220\u9664");
                return;
            }
            this.Response.setStatus(0);
            this.Response.setMessage("\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Response.setStatus(0);
            this.Response.setMessage("\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
    }

    public void editSave() {
        block4: {
            try {
                Transaction ta = new Transaction();
                SCMS_MediaCutSchema vr = new SCMS_MediaCutSchema();
                vr.setId(Long.valueOf(Long.parseLong(this.$V("id"))));
                if (vr.fill()) {
                    ta.add((Schema)vr, 2);
                    if (ta.commit()) {
                        this.Response.setStatus(1);
                        this.Response.setMessage("\u4fee\u6539\u6210\u529f");
                        return;
                    }
                    break block4;
                }
                this.Response.setStatus(0);
                this.Response.setMessage("\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u6761\u8ba1\u5212\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.Response.setStatus(0);
                this.Response.setMessage("\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
            }
        }
    }

    public static String CnUpperCaser(String intStr) {
        StringBuilder CaserBuilder = new StringBuilder();
        HashMap<String, String> CnUpperCaserMap = new HashMap<String, String>();
        CnUpperCaserMap.put("1", "\u4e00");
        CnUpperCaserMap.put("2", "\u4e8c");
        CnUpperCaserMap.put("3", "\u4e09");
        CnUpperCaserMap.put("4", "\u56db");
        CnUpperCaserMap.put("5", "\u4e94");
        CnUpperCaserMap.put("6", "\u516d");
        CnUpperCaserMap.put("7", "\u4e03");
        try {
            if (intStr.indexOf(",") != -1) {
                String[] intStrArray = intStr.split(",");
                for (int i = 0; i < intStrArray.length; ++i) {
                    if (!StringUtil.isNotEmpty((String)intStrArray[i])) continue;
                    if (i > 0) {
                        CaserBuilder.append(",");
                    }
                    CaserBuilder.append((String)CnUpperCaserMap.get(intStrArray[i]));
                }
            } else {
                CaserBuilder.append((String)CnUpperCaserMap.get(intStr));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CaserBuilder.toString();
    }

    public static String formatDuring(long mss) {
        String rhours = "";
        String rminutes = "";
        String rseconds = "";
        long hours = mss % 86400000L / 3600000L;
        long minutes = mss % 3600000L / 60000L;
        long seconds = mss % 60000L / 1000L;
        rhours = hours + "";
        rminutes = minutes + "";
        rseconds = seconds + "";
        if (hours < 10L) {
            rhours = "0" + hours;
        }
        if (minutes < 10L) {
            rminutes = "0" + minutes;
        }
        if (seconds < 10L) {
            rseconds = "0" + seconds;
        }
        return rhours + ":" + rminutes + ":" + rseconds;
    }
}

