/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.contentinfo;

import com.sobey.bsp.cms.dataservice.ColumnUtil;
import com.sobey.bsp.cms.pub.PubFun;
import com.sobey.bsp.cms.site.Catalog;
import com.sobey.bsp.framework.Page;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.common.util.FormatDateUtil;
import com.sobey.bsp.framework.controls.DataGridAction;
import com.sobey.bsp.framework.controls.TreeAction;
import com.sobey.bsp.framework.data.DataRow;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.Filter;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.Application;
import com.sobey.bsp.platform.UserLog;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.plugin.util.DateUtil;
import com.sobey.bsp.schema.SCMS_RecycleSchema;
import com.sobey.bsp.schema.SCMS_SeriesInfoLogSchema;
import com.sobey.bsp.schema.SCMS_SeriesSchema;
import com.sobey.scms.contentinfo.interfaces.util.ImageUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class DemandSeriesLib
extends Page {
    public static void treeDataBindAdd(TreeAction ta) {
        String SiteID = String.valueOf(Application.getCurrentSiteID());
        DataTable dt = null;
        Mapx params = ta.getParams();
        String parentID = params.getString((Object)"parentId");
        String type = ta.getParams().getString((Object)"type");
        if (StringUtil.isEmpty((String)parentID)) {
            parentID = "0";
        }
        QueryBuilder qb = new QueryBuilder("select ID,ParentID,TreeLevel,Name,SingleFlag,InnerCode,Type from SCMS_Catalog Where Type = ? and SiteID = ? and parentId =? order by orderflag ");
        qb.add(7);
        qb.add((Object)SiteID);
        qb.add((Object)parentID);
        dt = qb.executeDataTable();
        ta.setRootText("\u5f71\u89c6\u5267\u96c6");
        if (StringUtil.isNotEmpty((String)type) && "1".equals(type)) {
            ta.setRootText("");
        }
        dt = dt.filter((Filter)new /* Unavailable Anonymous Inner Class!! */);
        ta.bindData(dt);
    }

    public static void dg2DataBind(DataGridAction dga) {
        StringBuffer condition = new StringBuffer();
        QueryBuilder qb = new QueryBuilder();
        String name = dga.getParam("Name");
        String searchDay = dga.getParam("searchDay");
        String categoryID = dga.getParam("CatalogID");
        String publishType = dga.getParam("publishType");
        if (StringUtil.isEmpty((String)categoryID)) {
            dga.setTotal(0);
            dga.dataTable2JSON(null);
            return;
        }
        String roleName = PubFun.getRoleCodeByUserName((String)User.getUserName());
        String catalogids = Catalog.getCatalogIDSByParentIDs((String)categoryID, (String)roleName, (int)7);
        if (StringUtil.isEmpty((String)catalogids)) {
            catalogids = categoryID;
        }
        if (StringUtil.isNotEmpty((String)name)) {
            condition.append(" AND C.TITLE LIKE '%" + name.trim() + "%' ");
        }
        if (StringUtil.isNotEmpty((String)searchDay)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date();
            int day = Integer.parseInt(searchDay);
            if (day == 0) {
                condition.append(" AND C.CREATETIME LIKE '%" + format.format(now) + "%' ");
            } else if (day == -1) {
                condition.append(" AND C.CREATETIME LIKE '%" + format.format(DateUtil.decreaseDay((Date)now, (int)1)) + "%' ");
            } else if (day == 3) {
                condition.append(" AND C.CREATETIME > '" + format.format(DateUtil.decreaseDay((Date)now, (int)3)) + "' ");
                condition.append(" AND C.CREATETIME <= '" + format.format(now) + " 23:59:59' ");
            } else if (day == 7) {
                condition.append(" AND C.CREATETIME > '" + format.format(DateUtil.decreaseDay((Date)now, (int)7)) + "' ");
                condition.append(" AND C.CREATETIME <= '" + format.format(now) + " 23:59:59' ");
            }
        }
        if (StringUtil.isNotEmpty((String)publishType) && !"0".equals(publishType)) {
            condition.append(" AND C.STATUS =" + publishType);
        }
        String sql = "select C.hitCount,C.total,C.subtitle,C.KeyFrame,C.seriesSourceId,C.seriesid,C.TITLE,'' as 'title1',  C.tag, C.createtime,C.modifytime, C.creator as 'CreatorName', C.status,'' as StatusName,'' as imgSource, C.seriesprogramlength, C.catalogId, C.catalogInnerCode  from scms_series C where C.status!=4 and C.catalogid in (" + catalogids + ")" + condition;
        String countSql = "select count(C.seriesid) from scms_series C WHERE C.status!=4 AND C.catalogid in (" + catalogids + ")" + condition;
        qb.setSQL(countSql);
        dga.setTotal(qb);
        qb.setSQL(sql + " ORDER BY C.CREATETIME DESC");
        DataTable dt = qb.executePagedDataTable(dga.getPageSize(), dga.getPageIndex());
        if (dt == null || dt.getRowCount() < 1) {
            dga.dataTable2JSON(dt);
            return;
        }
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String seriesid = dt.getString(i, "seriesid");
            String statusName = "";
            int status = dt.getInt(i, "status");
            if (status == 0) {
                statusName = "<b>\u5f85\u53d1\u5e03</b><a href='javascript:void(0)' onclick='publish(1," + seriesid + ")' class='uploadVideo button01' style='display:none;padding:3px 9px;'>\u53d1\u5e03</a>";
            } else if (status == 1) {
                statusName = "<b>\u5df2\u53d1\u5e03</b><a href='javascript:void(0)' onclick='unpublish(0," + seriesid + ")' class='uploadVideo button01' style='display:none;padding:3px 9px;'>\u64a4\u9500\u53d1\u5e03</a>";
            }
            dt.set(i, "StatusName", (Object)statusName);
            String keyFrame = dt.getString(i, "KeyFrame");
            if (StringUtil.isNotEmpty((String)keyFrame)) {
                String imageHttpPre = ImageUtil.getImageDomainAndAlias((long)Application.getCurrentSiteID(), (boolean)true);
                dt.set(i, "imgSource", (Object)(imageHttpPre + keyFrame));
            } else {
                dt.set(i, "imgSource", (Object)"../../Icons/vmsseriesdefault.JPG");
            }
            dt.set(i, "seriesprogramlength", (Object)com.sobey.bsp.framework.utility.DateUtil.getTimeStr((long)dt.getLong(i, "seriesprogramlength")));
            String title2 = dt.getString(i, "title");
            if (StringUtil.isNotEmpty((String)title2)) {
                if (title2.length() > 12) {
                    title2 = title2.substring(0, 12) + "...";
                }
                dt.set(i, "title1", (Object)title2);
            }
            String realname = dt.getString(i, "CreatorName");
            realname = User.getRealName((String)realname);
            dt.set(i, "CreatorName", (Object)realname);
        }
        dga.dataTable2JSON(dt);
    }

    public void delete() {
        String ids = this.$V("IDs");
        ArrayList<String> seriesIds = new ArrayList<String>();
        if (!StringUtil.checkID((String)ids)) {
            this.Response.setStatus(0);
            this.Response.setMessage("\u9519\u8bef\u7684\u53c2\u6570!");
            return;
        }
        for (String element : ids.split(",")) {
            seriesIds.add(element);
        }
        String[] name = new String[seriesIds.size()];
        try {
            int i;
            String dateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            Transaction trans = new Transaction();
            String contentDelSql = "UPDATE SCMS_SERIES SET STATUS=4,modifyTime='" + dateString + "' WHERE SERIESID IN (" + ids + ")";
            String userName = User.getUserName();
            String contentSelectSql = "SELECT SERIESID,TITLE,CATALOGID,DESCRIPTION,STATUS FROM SCMS_SERIES  WHERE SERIESID IN (" + ids + ")";
            QueryBuilder qb = new QueryBuilder(contentSelectSql);
            DataTable dt = qb.executeDataTable();
            for (i = 0; i < dt.getRowCount(); ++i) {
                SCMS_RecycleSchema recycle = new SCMS_RecycleSchema();
                recycle.setCatalogID(Long.valueOf(dt.getLong(i, "catalogId")));
                recycle.setID(NoUtil.getMaxID((String)"recyleid"));
                recycle.setTitle(dt.getString(i, "title"));
                recycle.setDescription(dt.getString(i, "DESCRIPTION"));
                recycle.setAssignmentType(String.valueOf(7));
                recycle.setCreateTime(dateString);
                recycle.setCreateName(userName);
                recycle.setContentid(dt.getString(i, "SERIESID"));
                recycle.setStatus(dt.getString(i, "status"));
                recycle.setSiteid(Application.getCurrentSiteID());
                trans.add((Schema)recycle, 1);
                name[i] = dt.getString(i, "title");
            }
            trans.add(new QueryBuilder(contentDelSql));
            if (trans.commit()) {
                trans.clear();
                Date date = new Date();
                for (int i2 = 0; i2 < seriesIds.size(); ++i2) {
                    SCMS_SeriesInfoLogSchema log = new SCMS_SeriesInfoLogSchema();
                    log.setID(NoUtil.getMaxID((String)"SeriesInfoLogId"));
                    log.setContentId((String)seriesIds.get(i2));
                    log.setAction("DELETE");
                    log.setActionDetail("\u7535\u89c6\u5267\u5220\u9664,\u5b58\u5165\u56de\u6536\u7ad9");
                    log.setAddTime(date);
                    log.setAddUser(User.getRealName());
                    trans.add((Schema)log, 1);
                    UserLog.log((String)"Series", (String)"DeleteSeries", (String)("\u7535\u89c6\u5267" + name[i2] + "\u5220\u9664\u6210\u529f\uff0c\u653e\u5165\u56de\u6536\u7ad9"), (String)this.Request.getClientIP());
                }
                trans.commit();
                this.Response.setStatus(1);
                this.Response.setMessage("\u64cd\u4f5c\u6210\u529f!");
            } else {
                this.Response.setStatus(0);
                this.Response.setMessage("\u64cd\u4f5c\u5931\u8d25!");
                for (i = 0; i < name.length; ++i) {
                    UserLog.log((String)"Series", (String)"DeleteSeries", (String)("\u7535\u89c6\u5267" + name[i] + "\u5220\u9664\u5931\u8d25"), (String)this.Request.getClientIP());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Response.setStatus(0);
            this.Response.setMessage("\u64cd\u4f5c\u6570\u636e\u5e93\u65f6\u53d1\u751f\u9519\u8bef!");
            for (int i = 0; i < name.length; ++i) {
                UserLog.log((String)"Series", (String)"DeleteSeries", (String)("\u7535\u89c6\u5267" + name[i] + "\u5220\u9664\u5931\u8d25"), (String)this.Request.getClientIP());
            }
        }
    }

    public static Mapx getSeriesInfo(Mapx params) {
        Mapx map = new Mapx();
        String seriesId = params.getString((Object)"contentid");
        String catalogid = params.getString((Object)"cid");
        String format = "yyyy-MM-dd HH:mm:ss";
        DataTable dt = new QueryBuilder("select C.seriesId,C.Tag, C.seriesProgramLength, c.status, c.Catalogid, C.SeriesName, C.subTitle, C.publishDate, C.broadcastTime, C.shootCatagory, C.producingArea, C.shootTime, C.mainPlayer,  C.director, C.writer, C.compere, C.interviewee, C.reporter, C.title, C.otherTitle,  C.createTime, C.modifyTime, C.total, C.description, C.content, C.keyFrame,  C.copyrights, C.authorizationCount, C.authorizationUser, C.authorizationType, C.authorizationArea,  C.authorizationStartTime, C.authorizationEndTime, C.copyrightsStatement, C.authorizationInfomation, C.seriesInfo  from scms_series C  where C.seriesId in ('" + seriesId + "')").executeDataTable();
        DataRow dr = dt.getDataRow(0);
        map.put((Object)"ContentID", (Object)dr.getString("seriesId"));
        if (StringUtil.isEmpty((String)dr.getString("seriesProgramLength"))) {
            map.put((Object)"seriesProgramLength", (Object)"");
        } else {
            map.put((Object)"seriesProgramLength", (Object)com.sobey.bsp.framework.utility.DateUtil.getTimeStr((long)Long.valueOf(dr.getString("seriesProgramLength"))));
        }
        map.put((Object)"tag", (Object)dr.getString("Tag"));
        map.put((Object)"seriesName", (Object)dr.getString("seriesName"));
        map.put((Object)"subTitle", (Object)dr.getString("subTitle"));
        map.put((Object)"shootCatagory", (Object)dr.getString("shootCatagory"));
        map.put((Object)"producingArea", (Object)dr.getString("producingArea"));
        map.put((Object)"shootTime", (Object)dr.getString("shootTime"));
        map.put((Object)"mainPlayer", (Object)dr.getString("mainPlayer"));
        map.put((Object)"director", (Object)dr.getString("director"));
        map.put((Object)"writer", (Object)dr.getString("writer"));
        map.put((Object)"compere", (Object)dr.getString("compere"));
        map.put((Object)"interviewee", (Object)dr.getString("interviewee"));
        map.put((Object)"reporter", (Object)dr.getString("reporter"));
        map.put((Object)"title", (Object)dr.getString("title"));
        map.put((Object)"otherTitle", (Object)dr.getString("otherTitle"));
        map.put((Object)"total", (Object)dr.getString("total"));
        map.put((Object)"description", (Object)dr.getString("description"));
        map.put((Object)"Catalogid", (Object)dr.getString("Catalogid"));
        map.put((Object)"content", (Object)dr.getString("content"));
        try {
            String catalog = new QueryBuilder("select name from scms_catalog where \tid=" + dr.getString("Catalogid") + "").executeString();
            map.put((Object)"catalog", (Object)catalog);
            if (StringUtil.isNotEmpty((String)catalog) && catalog.length() > 6) {
                map.put((Object)"shortCatalog", (Object)(catalog.substring(0, 6) + "..."));
            } else {
                map.put((Object)"shortCatalog", (Object)catalog);
            }
            if (dr.getDate("publishDate") != null) {
                map.put((Object)"publishDate", (Object)FormatDateUtil.format2DateByFormat((Date)dr.getDate("publishDate"), (String)format));
            }
            if (dr.getDate("broadcastTime") != null) {
                map.put((Object)"broadcastTime", (Object)FormatDateUtil.format2DateByFormat((Date)dr.getDate("broadcastTime"), (String)format));
            }
            if (dr.getDate("createTime") != null) {
                map.put((Object)"createTime", (Object)FormatDateUtil.format2DateByFormat((Date)dr.getDate("createTime"), (String)format));
            }
            if (dr.getDate("modifyTime") != null) {
                map.put((Object)"modifyTime", (Object)FormatDateUtil.format2DateByFormat((Date)dr.getDate("modifyTime"), (String)format));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            DataTable columns = ColumnUtil.getColumn((String)String.valueOf(Application.getCurrentSiteID()));
            DataTable columnValues = ColumnUtil.getColumnValue((long)3L, (long)dr.getLong("seriesId"));
            String columnHtml = ColumnUtil.getHtml((DataTable)columns, (DataTable)columnValues);
            map.put((Object)"CustomColumns", (Object)columnHtml);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String keyFrame = dr.getString("keyFrame");
        if (StringUtil.isNotEmpty((String)keyFrame)) {
            String imageHttpPre = ImageUtil.getImageDomainAndAlias((long)Application.getCurrentSiteID(), (boolean)true);
            map.put((Object)"keyFrame", (Object)(imageHttpPre + keyFrame));
            map.put((Object)"imgUrl", (Object)keyFrame);
        } else {
            map.put((Object)"keyFrame", (Object)"../../Icons/vmsseriesdefault.JPG");
            map.put((Object)"imgUrl", (Object)"");
        }
        map.put((Object)"copyrights", (Object)dr.getString("copyrights"));
        map.put((Object)"authorizationCount", (Object)dr.getString("authorizationCount"));
        map.put((Object)"authorizationUser", (Object)dr.getString("authorizationUser"));
        map.put((Object)"authorizationType", (Object)dr.getString("authorizationType"));
        map.put((Object)"authorizationArea", (Object)dr.getString("authorizationArea"));
        map.put((Object)"copyrightsStatement", (Object)dr.getString("copyrightsStatement"));
        map.put((Object)"authorizationInfomation", (Object)dr.getString("authorizationInfomation"));
        try {
            if (dr.getDate("authorizationStartTime") != null && dr.getDate("authorizationEndTime") != null) {
                map.put((Object)"authorizationStartTime", (Object)FormatDateUtil.format2DateByFormat((Date)dr.getDate("authorizationStartTime"), (String)"yyyy-MM-dd"));
                map.put((Object)"authorizationEndTime", (Object)FormatDateUtil.format2DateByFormat((Date)dr.getDate("authorizationEndTime"), (String)"yyyy-MM-dd"));
            }
        }
        catch (Exception ep) {
            ep.printStackTrace();
        }
        String seriesInfo = dr.getString("seriesInfo");
        if (StringUtil.isNotEmpty((String)seriesInfo)) {
            JSONArray jsonArray = JSONArray.fromObject((Object)seriesInfo);
            StringBuilder sb = new StringBuilder();
            map.put((Object)"totalSeriesPart", jsonArray.size());
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jo = jsonArray.getJSONObject(i);
                if (jo.isEmpty()) continue;
                String seriesPart = "\u7b2c" + jo.getString("partId") + "\u96c6";
                String contentId = jo.getString("contentId");
                String seriesName = jo.getString("title");
                String partiId = jo.getString("partId");
                if (seriesName.length() > 10) {
                    seriesName = seriesName.substring(0, 10);
                    seriesName = seriesName + "...";
                }
                sb.append("<div class='item' id='item" + partiId + "'><input type='text' name='hiddenSeriesContentId' value='" + contentId + "'  class='hiddenSeriesContent' style='display: none;' /><table width='100%' cellpadding='0' cellspacing='0' class='tvBox'>");
                sb.append("<tr><td width='40' valign='middle' align='center'><span class='add'></span></td><td width='62'><input class='inp num SeriesNum inputtext' type='text' value='" + seriesPart + "'></td>" + "<td><div class='tvChose'><div class='addSeriesbtnBox' style='width:100%;'><div class='btn' style='font-size:13px;width:45px;'>\u89c6\u9891 </div><div style='color:black;margin:3px 0 0 0px;text-align:left;text-indent:60px;' id='editAddVideoTitle'>" + seriesName + "</div></div><input class='inp inputtext' type='text' style='width: 100%;'></div></td>" + "<td width='62'><input class='inp num programLength_name inputtext' type='text' value='" + jo.getString("videoProLength") + "' style=''></td><td width='40' valign='middle' align='center'><span class='dele'></span></td></tr>");
                sb.append("</table><div class='videoGallery'  style='display:none;'><table width='100%' cellpadding='0' cellspacing='0' class='in'><tr><td width='30' align='center' valign='middle' class='title'><span>\u89c6\u9891\u5e93</span></td><td valign='top'><div style='padding-left:8px;'><div class='listBox'><ul></ul></div><div class='tvSearch'><span class='fl'>\u5206\u7c7b\uff1a</span><div class='fr searchBox' style='width: 212px;margin:0 3px 0 0;'><input type='text' style='width: 150px;border-radius: 13px 0 0 13px;float: left;' id='seriesEditSearchVideo' class='focus' name='' value=''  /><input type='button' onClick='changeCatalog(this)' id='Submitbutton'  name=''  value=''/></div></div></td></tr></table></div></div>");
            }
            map.put((Object)"seriesInfo", (Object)sb.toString());
        }
        return map;
    }

    public void saveEditSeriesInfo() {
        String series = this.$V("series");
        JSONObject seriesObj = null;
        if (StringUtil.isNotEmpty((String)series)) {
            seriesObj = JSONObject.fromObject((Object)series);
            JSONObject basicObj = seriesObj.getJSONObject("basicInfo");
            String contentId = basicObj.getString("contentId");
            JSONObject copyRight = seriesObj.getJSONObject("copyRight");
            JSONArray seriesArray = seriesObj.getJSONArray("seriesInfo");
            String keyFrame = seriesObj.getString("keyFrame");
            String format = "yyyy-MM-dd HH:mm:ss";
            SCMS_SeriesSchema seriesInfo = new SCMS_SeriesSchema();
            seriesInfo.setSeriesid(Long.valueOf(Long.parseLong(contentId)));
            String title = basicObj.getString("title");
            if (seriesInfo.fill()) {
                Transaction trans = new Transaction();
                seriesInfo.setSeriesname(basicObj.getString("title"));
                seriesInfo.setTitle(basicObj.getString("title"));
                seriesInfo.setSubtitle(basicObj.getString("subTitle"));
                seriesInfo.setTag(basicObj.getString("tag"));
                seriesInfo.setTitle(title);
                seriesInfo.setOthertitle(basicObj.getString("otherTitle"));
                if (StringUtil.isNotEmpty((String)basicObj.getString("broadcastTime"))) {
                    seriesInfo.setBroadcasttime(FormatDateUtil.parseDateByFormat((String)basicObj.getString("broadcastTime"), (String)format));
                }
                seriesInfo.setShootcatagory(basicObj.getString("shootCatagory"));
                seriesInfo.setProducingarea(basicObj.getString("producingArea"));
                seriesInfo.setShoottime(basicObj.getString("shootTime"));
                seriesInfo.setMainplayer(basicObj.getString("mainPlayer"));
                seriesInfo.setDirector(basicObj.getString("director"));
                seriesInfo.setWriter(basicObj.getString("writer"));
                seriesInfo.setCompere(basicObj.getString("compere"));
                seriesInfo.setInterviewee(basicObj.getString("interviewee"));
                seriesInfo.setReporter(basicObj.getString("reporter"));
                JSONArray json = JSONArray.fromObject((Object)seriesArray);
                long prolength = 0L;
                for (int i = 0; i < json.size(); ++i) {
                    JSONObject jo = json.getJSONObject(i);
                    if (!StringUtil.isNotEmpty((String)jo.getString("videoProLength"))) continue;
                    prolength += Long.valueOf(com.sobey.bsp.framework.utility.DateUtil.getTotalSecond((String)jo.getString("videoProLength"))).longValue();
                }
                seriesInfo.setSeriesprogramlength(String.valueOf(prolength));
                String content = basicObj.getString("content");
                content = content.length() > 1000 ? content.substring(0, 997) + "..." : content;
                seriesInfo.setContent(content);
                if (StringUtil.isEmpty((String)basicObj.getString("createTime"))) {
                    seriesInfo.setCreatetime(new Date());
                } else {
                    seriesInfo.setCreatetime(FormatDateUtil.parseDateByFormat((String)basicObj.getString("createTime"), (String)format));
                }
                seriesInfo.setModifytime(new Date());
                seriesInfo.setTotal(basicObj.getString("total"));
                seriesInfo.setDescription(basicObj.getString("description"));
                seriesInfo.setSiteid(Long.valueOf(Application.getCurrentSiteID()));
                if (StringUtil.isNotEmpty((String)keyFrame)) {
                    seriesInfo.setKeyframe(keyFrame);
                }
                seriesInfo.setCopyrights(copyRight.getString("copyrights"));
                seriesInfo.setAuthorizationcount(copyRight.getString("authorizationCount"));
                seriesInfo.setAuthorizationarea(copyRight.getString("authorizationArea"));
                seriesInfo.setAuthorizationtype(copyRight.getString("authorizationType"));
                seriesInfo.setAuthorizationuser(copyRight.getString("authorizationUser"));
                if (StringUtil.isNotEmpty((String)copyRight.getString("authorizationStartTime"))) {
                    seriesInfo.setAuthorizationstarttime(FormatDateUtil.parseDateByFormat((String)copyRight.getString("authorizationStartTime"), (String)"yyyy-MM-dd"));
                }
                if (StringUtil.isNotEmpty((String)copyRight.getString("authorizationEndTime"))) {
                    seriesInfo.setAuthorizationendtime(FormatDateUtil.parseDateByFormat((String)copyRight.getString("authorizationEndTime"), (String)"yyyy-MM-dd"));
                }
                seriesInfo.setAuthorizationinfomation(copyRight.getString("authorizationInfomation"));
                seriesInfo.setCopyrightsstatement(copyRight.getString("copyrightsStatement"));
                long catalogid = 0L;
                if (basicObj.has("catalog")) {
                    catalogid = new QueryBuilder("select id from scms_catalog where  id='" + basicObj.getString("catalog") + "' and siteid=" + Application.getCurrentSiteID() + "").executeLong();
                } else if (basicObj.has("catalogid")) {
                    catalogid = Long.parseLong(basicObj.getString("catalogid"));
                }
                String catalogInnerCode = new QueryBuilder("select InnerCode from scms_catalog  where id=" + catalogid + "").executeString();
                seriesInfo.setCatalogid(catalogid + "");
                seriesInfo.setCatalogInnerCode(catalogInnerCode);
                seriesInfo.setSeriesinfo(seriesArray.toString());
                trans.add((Schema)seriesInfo, 2);
                try {
                    if (trans.commit()) {
                        this.Response.setStatus(1);
                        this.Response.setMessage("\u7f16\u8f91\u7535\u89c6\u5267\u6210\u529f");
                        trans.clear();
                        Date date = new Date();
                        ArrayList<String> seriesIds = new ArrayList<String>();
                        seriesIds.add(contentId);
                        SCMS_SeriesInfoLogSchema log = new SCMS_SeriesInfoLogSchema();
                        log.setID(NoUtil.getMaxID((String)"ContentInfoLogId"));
                        log.setContentId(contentId);
                        log.setAction("UPDATE");
                        log.setActionDetail("\u7535\u89c6\u5267\u7f16\u8f91\u66f4\u65b0");
                        log.setAddTime(date);
                        log.setAddUser(User.getRealName());
                        trans.add((Schema)log, 1);
                        trans.commit();
                        UserLog.log((String)"Series", (String)"UpdateSeries", (String)("\u4fee\u6539\u5267\u96c6" + title + "\u6210\u529f"), (String)this.Request.getClientIP());
                        return;
                    }
                    UserLog.log((String)"Series", (String)"UpdateSeries", (String)("\u4fee\u6539\u5267\u96c6" + title + "\u5931\u8d25"), (String)this.Request.getClientIP());
                }
                catch (Exception e) {
                    this.Response.setStatus(0);
                    this.Response.setMessage("\u64cd\u4f5c\u6570\u636e\u5e93\u51fa\u9519");
                    UserLog.log((String)"Series", (String)"UpdateSeries", (String)("\u4fee\u6539\u5267\u96c6" + title + "\u5931\u8d25"), (String)this.Request.getClientIP());
                }
            } else {
                this.Response.setStatus(0);
                this.Response.setMessage("\u7535\u89c6\u5267\u7f16\u8f91\u4fdd\u5b58\u5931\u8d25");
                UserLog.log((String)"Series", (String)"UpdateSeries", (String)("\u4fee\u6539\u5267\u96c6" + title + "\u5931\u8d25"), (String)this.Request.getClientIP());
            }
        }
    }

    public static void logDataBind(DataGridAction dga) {
        String contentid = (String)dga.getParams().get((Object)"contentid");
        String sql = "SELECT * FROM SCMS_SERIESINFOLOG WHERE SERIESID=? ORDER BY ID DESC";
        if (dga.getTotal() == 0) {
            String sql2 = "SELECT COUNT(*) FROM SCMS_SERIESINFOLOG WHERE SERIESID=?";
            dga.setTotal(new QueryBuilder(sql2, (Object)contentid));
        }
        DataTable dt = new QueryBuilder(sql, (Object)contentid).executePagedDataTable(dga.getPageSize(), dga.getPageIndex());
        dga.dataTable2JSON(dt);
    }

    public void saveSeriesInfo() {
        String series = this.$V("series");
        JSONObject seriesObj = null;
        if (StringUtil.isNotEmpty((String)series)) {
            seriesObj = JSONObject.fromObject((Object)series);
            JSONObject basicObj = seriesObj.getJSONObject("basicInfo");
            JSONObject copyRight = seriesObj.getJSONObject("copyRight");
            JSONArray seriesArray = seriesObj.getJSONArray("seriesInfo");
            String keyFrame = seriesObj.getString("keyFrame");
            String format = "yyyy-MM-dd HH:mm:ss";
            Long seriesId = NoUtil.getMaxID((String)"SeriesID");
            SCMS_SeriesSchema seriesInfo = new SCMS_SeriesSchema();
            seriesInfo.setSeriesid(seriesId);
            String title = basicObj.getString("title");
            if (!seriesInfo.fill()) {
                Transaction trans = new Transaction();
                seriesInfo.setSeriessourceid(UUID.randomUUID().toString().replaceAll("-", ""));
                seriesInfo.setSeriesname(basicObj.getString("title"));
                seriesInfo.setCreator(User.getUserName());
                seriesInfo.setTag(basicObj.getString("tag"));
                seriesInfo.setStatus(Long.valueOf(0L));
                seriesInfo.setOrderflag(Long.valueOf(new Date().getTime()));
                seriesInfo.setSubtitle(basicObj.getString("subTitle"));
                seriesInfo.setTitle(title);
                if (StringUtil.isNotEmpty((String)basicObj.getString("broadcastTime"))) {
                    seriesInfo.setBroadcasttime(FormatDateUtil.parseDateByFormat((String)basicObj.getString("broadcastTime"), (String)format));
                }
                seriesInfo.setOthertitle(basicObj.getString("otherTitle"));
                seriesInfo.setShootcatagory(basicObj.getString("shootCatagory"));
                seriesInfo.setProducingarea(basicObj.getString("producingArea"));
                seriesInfo.setShoottime(basicObj.getString("shootTime"));
                seriesInfo.setMainplayer(basicObj.getString("mainPlayer"));
                seriesInfo.setDirector(basicObj.getString("director"));
                seriesInfo.setWriter(basicObj.getString("writer"));
                seriesInfo.setCompere(basicObj.getString("compere"));
                seriesInfo.setInterviewee(basicObj.getString("interviewee"));
                seriesInfo.setReporter(basicObj.getString("reporter"));
                JSONArray json = JSONArray.fromObject((Object)seriesArray);
                long prolength = 0L;
                for (int i = 0; i < json.size(); ++i) {
                    JSONObject jo = json.getJSONObject(i);
                    if (!StringUtil.isNotEmpty((String)jo.getString("videoProLength"))) continue;
                    prolength += Long.valueOf(com.sobey.bsp.framework.utility.DateUtil.getTotalSecond((String)jo.getString("videoProLength"))).longValue();
                }
                seriesInfo.setSeriesprogramlength(String.valueOf(prolength));
                String content = basicObj.getString("content");
                content = content.length() > 1000 ? content.substring(0, 997) + "..." : content;
                seriesInfo.setContent(content);
                if (StringUtil.isEmpty((String)basicObj.getString("createTime"))) {
                    seriesInfo.setCreatetime(new Date());
                } else {
                    seriesInfo.setCreatetime(FormatDateUtil.parseDateByFormat((String)basicObj.getString("createTime"), (String)format));
                }
                seriesInfo.setModifytime(new Date());
                seriesInfo.setTotal(basicObj.getString("total"));
                seriesInfo.setDescription(basicObj.getString("description"));
                seriesInfo.setSiteid(Long.valueOf(Application.getCurrentSiteID()));
                if (StringUtil.isNotEmpty((String)keyFrame)) {
                    int idx = keyFrame.indexOf("/upload/Image/default/");
                    if (idx != -1) {
                        keyFrame = keyFrame.substring(idx);
                    }
                    seriesInfo.setKeyframe(keyFrame);
                }
                long catalogid = 0L;
                if (basicObj.has("catalog")) {
                    catalogid = new QueryBuilder("select id from scms_catalog where  id='" + basicObj.getString("catalog") + "' and siteid=" + Application.getCurrentSiteID() + "").executeLong();
                } else if (basicObj.has("catalogid")) {
                    catalogid = Long.parseLong(basicObj.getString("catalogid"));
                }
                String catalogInnerCode = new QueryBuilder("select InnerCode from scms_catalog  where id=" + catalogid).executeString();
                seriesInfo.setCatalogid(catalogid + "");
                seriesInfo.setCatalogInnerCode(catalogInnerCode);
                seriesInfo.setCopyrights(copyRight.getString("copyrights"));
                seriesInfo.setAuthorizationcount(copyRight.getString("authorizationCount"));
                seriesInfo.setAuthorizationarea(copyRight.getString("authorizationArea"));
                seriesInfo.setAuthorizationtype(copyRight.getString("authorizationType"));
                seriesInfo.setAuthorizationuser(copyRight.getString("authorizationUser"));
                if (StringUtil.isNotEmpty((String)copyRight.getString("authorizationStartTime"))) {
                    seriesInfo.setAuthorizationstarttime(FormatDateUtil.parseDateByFormat((String)copyRight.getString("authorizationStartTime"), (String)"yyyy-MM-dd"));
                }
                if (StringUtil.isNotEmpty((String)copyRight.getString("authorizationEndTime"))) {
                    seriesInfo.setAuthorizationendtime(FormatDateUtil.parseDateByFormat((String)copyRight.getString("authorizationEndTime"), (String)"yyyy-MM-dd"));
                }
                seriesInfo.setAuthorizationinfomation(copyRight.getString("authorizationInfomation"));
                seriesInfo.setCopyrightsstatement(copyRight.getString("copyrightsStatement"));
                seriesInfo.setSeriesinfo(seriesArray.toString());
                trans.add((Schema)seriesInfo, 1);
                try {
                    if (trans.commit()) {
                        trans.clear();
                        ArrayList<String> seriesIds = new ArrayList<String>();
                        seriesIds.add(String.valueOf(seriesId));
                        this.Response.setStatus(1);
                        this.Response.setMessage("\u65b0\u5efa\u7535\u89c6\u5267\u6210\u529f");
                        UserLog.log((String)"Series", (String)"CreateSeries", (String)("\u65b0\u5efa\u7535\u89c6\u5267" + title + "\u6210\u529f"), (String)this.Request.getClientIP());
                        Date date = new Date();
                        SCMS_SeriesInfoLogSchema log = new SCMS_SeriesInfoLogSchema();
                        log.setID(NoUtil.getMaxID((String)"SeriesInfoLogId"));
                        log.setContentId(String.valueOf(seriesId));
                        log.setAction("INSERT");
                        log.setActionDetail("\u65b0\u5efa\u7535\u89c6\u5267\u6210\u529f");
                        log.setAddTime(date);
                        log.setAddUser(User.getRealName());
                        trans.add((Schema)log, 1);
                        trans.commit();
                    }
                }
                catch (Exception e) {
                    this.Response.setStatus(0);
                    this.Response.setMessage("\u64cd\u4f5c\u6570\u636e\u5e93\u51fa\u9519");
                    UserLog.log((String)"Series", (String)"CreateSeries", (String)("\u65b0\u5efa\u7535\u89c6\u5267" + title + "\u5931\u8d25"), (String)this.Request.getClientIP());
                }
            } else {
                this.Response.setStatus(0);
                this.Response.setMessage("\u7535\u89c6\u5267\u5df2\u5b58\u5728");
                UserLog.log((String)"Series", (String)"CreateSeries", (String)("\u65b0\u5efa\u7535\u89c6\u5267" + title + "\u5931\u8d25"), (String)this.Request.getClientIP());
            }
        }
    }

    public void publish() {
        String type = this.$V("type");
        String seriesId = this.$V("seriesId");
        ArrayList<String> seriesIds = new ArrayList<String>();
        seriesIds.add(seriesId);
        Transaction trans = new Transaction();
        SCMS_SeriesSchema seriesInfo = new SCMS_SeriesSchema();
        seriesInfo.setSeriesid(Long.valueOf(seriesId));
        if (seriesInfo.fill()) {
            if ("1".equals(type)) {
                Date publishDate = new Date();
                seriesInfo.setPublishdate(publishDate);
                seriesInfo.setStatus(Long.valueOf(1L));
            } else {
                seriesInfo.setPublishdate(null);
                seriesInfo.setStatus(Long.valueOf(0L));
            }
        }
        trans.add((Schema)seriesInfo, 2);
        if (trans.commit()) {
            this.Response.setStatus(1);
            this.Response.setMessage("\u64cd\u4f5c\u6210\u529f");
        } else {
            this.Response.setStatus(0);
            this.Response.setMessage("\u64cd\u4f5c\u5931\u8d25");
        }
    }
}

