/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.contentinfo;

import com.chinamclound.vms.constant.InterfaceNoticeTypeEnum;
import com.sobey.bsp.framework.Page;
import com.sobey.bsp.framework.controls.DataGridAction;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.notice.PushPlatform;
import com.sobey.bsp.platform.Application;
import com.sobey.bsp.plugin.util.DateUtil;
import com.sobey.bsp.schema.SCMS_CatalogSchema;
import com.sobey.bsp.schema.SCMS_Interfaces_manageSchema;
import com.sobey.cms.interfaces.push.domain.ResultInfo;
import com.sobey.cms.interfaces.push.util.PushUtil;
import com.sobey.scms.contentinfo.DemandMediaCommon;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class DemandVideoPushLib
extends Page {
    public void catalogPush() {
        String catalogId = this.$V("catalogId");
        String interfaceID = this.$V("interfaceIDs");
        String operation = this.$V("operation");
        String[] interfaceIDs = interfaceID.split(",");
        Long siteId = Application.getCurrentSiteID();
        if (StringUtil.isEmpty((String)catalogId)) {
            return;
        }
        SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
        catalog.setID(catalogId);
        if (catalog.fill()) {
            String innerCode = catalog.getInnerCode();
            QueryBuilder countQB = new QueryBuilder();
            String countSql = "SELECT count(contentid) FROM SCMS_CONTENTINFO C WHERE C.STATUS=1  AND C.CatalogInnerCode LIKE '" + innerCode + "%'";
            countQB.setSQL(countSql);
            double total = Long.valueOf(countQB.executeLong()).doubleValue();
            int pages = Double.valueOf(Math.ceil(total / 10.0)).intValue();
            String sql = "SELECT C.CONTENTID FROM SCMS_CONTENTINFO C WHERE C.STATUS=1 AND C.CatalogInnerCode LIKE '" + innerCode + "%' order by createtime";
            for (int k = 0; k < pages; ++k) {
                QueryBuilder qb = new QueryBuilder(sql.toString());
                DataTable dt = qb.executePagedDataTable(10, k);
                if (dt == null || dt.getRowCount() <= 0) continue;
                String[] contentID = new String[dt.getRowCount()];
                for (int i = 0; i < dt.getRowCount(); ++i) {
                    contentID[i] = dt.getString(i, "CONTENTID");
                }
                for (int j = 0; j < interfaceIDs.length; ++j) {
                    SCMS_Interfaces_manageSchema interfaces = new SCMS_Interfaces_manageSchema();
                    interfaces.setID(Long.valueOf(Long.parseLong(interfaceIDs[j])));
                    if (!interfaces.fill()) continue;
                    PushPlatform.mediaPushPlatform((String[])contentID, (Long)siteId, (String)operation, (String)interfaces.getPartnerCode(), null);
                }
            }
            this.Response.setMessage("\u4efb\u52a1\u6dfb\u52a0\u6210\u529f\uff01");
        }
    }

    public void activePushVideo() {
        String contentID = this.$V("contentIDs");
        String interfaceID = this.$V("interfaceIDs");
        String operation = this.$V("operation");
        Long siteId = Application.getCurrentSiteID();
        String[] interfaceIDs = interfaceID.split(",");
        String message = "";
        for (int i = 0; i < interfaceIDs.length; ++i) {
            SCMS_Interfaces_manageSchema scmsInterfacesManageSchema = new SCMS_Interfaces_manageSchema();
            scmsInterfacesManageSchema.setID(Long.valueOf(Long.parseLong(interfaceIDs[i])));
            if (!scmsInterfacesManageSchema.fill()) continue;
            ResultInfo result = PushPlatform.mediaPushPlatform((String[])contentID.split(","), (Long)siteId, (String)operation, (String)scmsInterfacesManageSchema.getPartnerCode(), (Long)scmsInterfacesManageSchema.getID());
            message = message + scmsInterfacesManageSchema.getPartnerName() + ":" + result.getMessage() + "<br/>";
        }
        this.Response.setMessage(message);
    }

    public void dg2DataBind(DataGridAction dga) {
        DataTable dt = this.videoSearchFromDB(dga);
        if (dt == null || dt.getRowCount() < 1) {
            dga.dataTable2JSON(new DataTable());
            return;
        }
        dt.insertColumn("pushCDNMsg", (Object)new String());
        dt.insertColumn("pushCMSMsg", (Object)new String());
        dt.insertColumn("TITLE1", (Object)new String());
        dt.insertColumn("IMGSOURCE", (Object)new String());
        dt.insertColumn("LENGTH", (Object)new String());
        String baseDir = "/image/" + Application.getCurrentSiteAlias();
        String contentids = "";
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String contentid = dt.getString(i, "CONTENTID");
            contentids = i == 0 ? contentids + contentid : contentids + "," + contentid;
        }
        String sql = "select t1.contentID, t1.status, t2.partnerName, t2.partnerCode, t2.noticeType from scms_pushstatus t1, scms_interfaces_manage t2 where t1.interfacesID=t2.ID and t1.contentID in (" + contentids + ") order by interfacesID";
        QueryBuilder qb = new QueryBuilder(sql);
        DataTable pushDT = qb.executeDataTable();
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String contentid = dt.getString(i, "CONTENTID");
            String keyFrame = dt.getString(i, "KeyFrame");
            String imgSource = "";
            imgSource = StringUtil.isNotEmpty((String)keyFrame) ? baseDir + keyFrame : "../Video/images/vmsdefault1.jpg";
            imgSource = imgSource.replace("\\", "/");
            dt.set(i, "imgSource", (Object)imgSource);
            long prop2 = dt.getLong(i, "ProgramLength");
            dt.set(i, "length", prop2);
            dt.set(i, "ProgramLength", (Object)com.sobey.bsp.framework.utility.DateUtil.getTimeStr((long)(prop2 / 1000L)).replaceAll(":", "'"));
            String title2 = dt.getString(i, "TITLE");
            dt.set(i, "TITLE", (Object)title2);
            dt.set(i, "title1", (Object)DemandMediaCommon.controlMediaTitleLength((String)title2));
            StringBuffer pushCDNMsg = new StringBuffer();
            StringBuffer pushCMSMsg = new StringBuffer();
            for (int j = 0; j < pushDT.getRowCount(); ++j) {
                String contentid2 = pushDT.getString(j, "contentID");
                if (!contentid.equals(contentid2)) continue;
                int status = pushDT.getInt(j, "status");
                String partnerName = pushDT.getString(j, "partnerName");
                String partnerCode = pushDT.getString(j, "partnerCode");
                int noticeType = pushDT.getInt(j, "noticeType");
                if (noticeType == 1) {
                    if (0 == status) {
                        pushCMSMsg.append("<span class=\"state_red \">" + partnerName + "</span>");
                        continue;
                    }
                    if (2 == status) {
                        pushCMSMsg.append("<span class=\"state_green \">" + partnerName + "</span>");
                        continue;
                    }
                    if (1 != status) continue;
                    if ("LetvCMS".equals(partnerCode)) {
                        pushCMSMsg.append("<span class=\"state_gray \">" + partnerName + "</span>");
                        continue;
                    }
                    pushCMSMsg.append("<span class=\"state_gray \">" + partnerName + "</span>");
                    continue;
                }
                if (noticeType != 0) continue;
                if (0 == status) {
                    pushCDNMsg.append("<span class=\"state_red \">" + partnerName + "</span>");
                    continue;
                }
                if (2 == status) {
                    pushCDNMsg.append("<span class=\"state_green \">" + partnerName + "</span>");
                    continue;
                }
                if (1 != status) continue;
                pushCDNMsg.append("<span class=\"state_gray \">" + partnerName + "</span>");
            }
            dt.set(i, "pushCDNMsg", (Object)pushCDNMsg);
            dt.set(i, "pushCMSMsg", (Object)pushCMSMsg);
        }
        dga.dataTable2JSON(dt);
    }

    public void pushDataBind(DataGridAction dga) {
        String contentId = this.$V("contentId");
        String noticeType = this.$V("noticeType");
        String interfaceSql = "select ID,partnerName from scms_interfaces_manage WHERE status='1' and noticeType='" + noticeType + "'";
        DataTable dt = new QueryBuilder(interfaceSql).executeDataTable();
        dt.insertColumn("operation", (Object)new String());
        dt.insertColumn("status", (Object)new String());
        dt.insertColumn("message", (Object)new String());
        String interfacesIDs = "";
        for (int i = 0; dt != null && i < dt.getRowCount(); ++i) {
            interfacesIDs = i == 0 ? interfacesIDs + dt.getString(i, "ID") : interfacesIDs + "," + dt.getString(i, "ID");
        }
        if (StringUtil.isEmpty((String)interfacesIDs)) {
            dga.dataTable2JSON(new DataTable());
            return;
        }
        QueryBuilder qb = new QueryBuilder("select InterfacesID, Operation, status from scms_pushstatus where InterfacesID in (" + interfacesIDs + ") and contentId=" + contentId);
        DataTable dt1 = qb.executeDataTable();
        for (int i = 0; dt != null && i < dt.getRowCount(); ++i) {
            long interfacesId = dt.getLong(i, "ID");
            String operation = "";
            int contentStatus = -1;
            for (int j = 0; dt1 != null && j < dt1.getRowCount(); ++j) {
                long interfacesId2 = dt1.getLong(j, "InterfacesID");
                if (interfacesId != interfacesId2) continue;
                operation = dt1.getString(j, "Operation");
                contentStatus = dt1.getInt(j, "Status");
            }
            dt.set(i, "operation", (Object)PushUtil.getPushOperation((String)operation));
            dt.set(i, "status", (Object)PushUtil.getPushStatus((int)contentStatus));
            dt.set(i, "message", (Object)("<a style='color:#004EFF;' href='javascript:void(0);' onclick='getPushMsg(this,\"" + interfacesId + "\")' >\u67e5\u770b\u8be6\u60c5</a>"));
        }
        dga.dataTable2JSON(dt);
    }

    public void getAllPushPlatform(DataGridAction dga) {
        String noticeType = this.$V("noticeType");
        String interfaceSql = "select ID,partnerName from scms_interfaces_manage WHERE status='1' and noticeType='" + noticeType + "'";
        DataTable dt = new QueryBuilder(interfaceSql).executeDataTable();
        dga.dataTable2JSON(dt);
    }

    public void getAllInterface() {
        JSONArray ja = new JSONArray();
        String interfaceSql = "select ID,partnerName from scms_interfaces_manage WHERE status='1' ";
        DataTable dt = new QueryBuilder(interfaceSql).executeDataTable();
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String id = dt.getString(i, "ID");
            String partnerName = dt.getString(i, "partnerName");
            JSONObject jo = new JSONObject();
            jo.put((Object)"id", (Object)id);
            jo.put((Object)"partnerName", (Object)partnerName);
            ja.add((Object)jo);
        }
        this.Response.setMessage(ja.toString());
    }

    private DataTable videoSearchFromDB(DataGridAction dga) {
        StringBuffer condition = new StringBuffer();
        StringBuffer conditionLeftJoin = new StringBuffer();
        QueryBuilder qb = new QueryBuilder();
        String name = dga.getParam("Name");
        String searchDay = dga.getParam("searchDay");
        String orderFlied = dga.getParam("orderFlied");
        String[] orderFlieds = orderFlied.split(",");
        String categoryID = dga.getParam("CatalogID");
        String publishType = dga.getParam("publishType");
        String interfacesId = dga.getParam("interfacesId");
        String operation = dga.getParam("operation");
        String innerCode = dga.getParam("innerCode");
        if (StringUtil.isEmpty((String)categoryID)) {
            dga.setTotal(0);
            dga.dataTable2JSON(new DataTable());
            return null;
        }
        if (StringUtil.isNotEmpty((String)name)) {
            condition.append(" and C.TITLE like ? ");
            qb.add((Object)("%" + name.trim() + "%"));
        }
        if (StringUtil.isNotEmpty((String)searchDay)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date();
            int day = Integer.parseInt(searchDay);
            if (day == 0) {
                condition.append(" AND CREATETIME LIKE '%" + format.format(now) + "%' ");
            } else if (day == -1) {
                condition.append(" AND CREATETIME LIKE '%" + format.format(DateUtil.decreaseDay((Date)now, (int)1)) + "%' ");
            } else if (day == 3) {
                condition.append(" AND DATE(C.CREATETIME) > '" + format.format(DateUtil.decreaseDay((Date)now, (int)3)) + "' ");
                condition.append(" AND DATE(C.CREATETIME) <= '" + format.format(now) + " 23:59:59' ");
            } else if (day == 7) {
                condition.append(" AND DATE(C.CREATETIME) > '" + format.format(DateUtil.decreaseDay((Date)now, (int)7)) + "' ");
                condition.append(" AND DATE(C.CREATETIME) <= '" + format.format(now) + " 23:59:59' ");
            }
        }
        StringBuffer sb = new StringBuffer();
        if (StringUtil.isNotEmpty((String)interfacesId) && !"-1".equals(interfacesId)) {
            sb.append(" AND interfacesID=" + interfacesId);
        }
        if (StringUtil.isNotEmpty((String)operation) && !"all".equals(operation)) {
            sb.append(" AND operation='" + operation + "'");
        }
        if (StringUtil.isNotEmpty((String)operation)) {
            sb.append(" AND Status=" + publishType);
        }
        conditionLeftJoin.append(" JOIN (select DISTINCT contentID from scms_pushstatus where 1=1 " + sb.toString() + ") t1 on C.ContentID = t1.contentID ");
        String sql = "";
        String countSql = "";
        sql = "SELECT C.CREATORNAME, C.CREATETIME, C.CATALOGID, C.TITLE, C.CONTENTID, C.ProgramLength,C.KeyFrame FROM SCMS_CONTENTINFO C " + conditionLeftJoin + " WHERE  C.STATUS!=4 AND C.STATUS!=3 AND C.STATUS!=7 " + condition;
        countSql = "SELECT count(C.CONTENTID) from SCMS_CONTENTINFO C  " + conditionLeftJoin + " WHERE C.STATUS!=4 AND C.STATUS!=3 AND C.STATUS!=7 " + condition;
        qb.setSQL(countSql);
        dga.setTotal(qb);
        qb.setSQL(sql + " ORDER BY C." + orderFlieds[0] + " " + orderFlieds[1]);
        DataTable dt = qb.executePagedDataTable(dga.getPageSize(), dga.getPageIndex());
        return dt;
    }

    public void updateRetryNum() {
        String beginTime = this.$V("beginTime");
        String endTime = this.$V("endTime");
        String interfacesIDs = this.$V("interfacesIDs");
        int retryNum = Integer.valueOf(this.$V("retryNum"));
        QueryBuilder qb = new QueryBuilder("update scms_pushloginfo set pushNum=" + (3 - retryNum) + " where beginTime>='" + beginTime + "' and beginTime<='" + endTime + "' and interfacesID in (" + interfacesIDs + ") and operation='" + "VOD" + "' and status=" + 0);
        Transaction trans = new Transaction();
        trans.add(qb);
        if (trans.commit()) {
            this.Response.setMessage("\u91cd\u8bd5\u6b21\u6570\u8bbe\u7f6e\u6210\u529f\uff01");
        } else {
            this.Response.setMessage("\u91cd\u8bd5\u6b21\u6570\u8bbe\u7f6e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
    }

    public void getPushMsg() {
        String interfaceId = this.$V("interfaceId");
        String contentid = this.$V("contentid");
        SCMS_Interfaces_manageSchema scmsInterfacesManageSchema = new SCMS_Interfaces_manageSchema();
        scmsInterfacesManageSchema.setID(Long.valueOf(Long.parseLong(interfaceId)));
        if (!scmsInterfacesManageSchema.fill()) {
            this.Response.setMessage("\u67e5\u8be2\u63a5\u53e3\u4fe1\u606f\u5931\u8d25");
            return;
        }
        String message = "";
        int noticeType = scmsInterfacesManageSchema.getNoticeType();
        if (InterfaceNoticeTypeEnum.CMS.getIndex() == noticeType || InterfaceNoticeTypeEnum.VIDEO_BACK.getIndex() == noticeType) {
            QueryBuilder qb = new QueryBuilder("select InterfacesID, Operation, Status, message, beginTime, endTime from scms_pushloginfo where InterfacesID=" + interfaceId + " and contentId=" + contentid);
            DataTable dt1 = qb.executeDataTable();
            for (int j = 0; dt1 != null && j < dt1.getRowCount(); ++j) {
                String beginTime = dt1.getString(j, "beginTime");
                String endTime = dt1.getString(j, "endTime");
                String msg = dt1.getString(j, "message");
                if (msg.contains("\u5b57\u5178\u503c\u4e0d\u6b63\u786e")) {
                    msg = "\u548cVRS\u6570\u636e\u5b57\u6bb5\u4e0d\u5339\u914d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u66f4\u65b0\u6570\u636e\u5b57\u5178";
                } else if (msg.contains("\u5c42\u7ea7\u4e0d\u6b63\u786e")) {
                    msg = "\u8bf7\u5c06\u89c6\u9891\u5148\u8f6c\u79fb\u5230\u7b2c\u4e09\u7ea7\u680f\u76ee\u4e0b\u518d\u63a8\u9001";
                } else if (msg.contains("\u3010interfacesTypes\u3011\u5c5e\u6027\u5fc5\u586b")) {
                    msg = "\u8bf7\u5148\u5b8c\u6210CDN\u5206\u53d1";
                } else if (msg.contains("\u5c5e\u6027\u5fc5\u586b")) {
                    msg = "\u8bf7\u5b8c\u5584\u7f16\u76ee\u4fe1\u606f";
                }
                message = message + msg + "\uff08" + beginTime + "\u2014" + endTime + "\uff09" + "<br/>";
            }
        } else if (0 == noticeType) {
            String sql = "select t1.InterfacesID, t1.Operation, t1.message, t1.Status, t1.beginTime, t1.endTime, t2.bitrate from scms_pushloginfo t1, scms_video t2 where t1.videoid=t2.ID and t1.InterfacesID=" + interfaceId + " and t1.ContentID=" + contentid;
            QueryBuilder qb = new QueryBuilder(sql);
            DataTable dt2 = qb.executeDataTable();
            for (int j = 0; dt2 != null && j < dt2.getRowCount(); ++j) {
                String bitrate = dt2.getString(j, "bitrate");
                if ("1081P".equalsIgnoreCase(bitrate)) {
                    bitrate = "1080P";
                } else if ("1080P".equalsIgnoreCase(bitrate)) {
                    bitrate = "\u8d85\u6e05\uff08720p\uff09";
                } else if ("720P".equalsIgnoreCase(bitrate)) {
                    bitrate = "\u9ad8\u6e05\uff08540p\uff09";
                } else if ("480P".equalsIgnoreCase(bitrate)) {
                    bitrate = "\u6807\u6e05\uff08360p\uff09";
                } else if ("128k".equalsIgnoreCase(bitrate)) {
                    bitrate = "\u97f3\u9891\uff08128k\uff09";
                }
                String msg = dt2.getString(j, "message");
                String videoStatus = PushUtil.getPushStatus((int)dt2.getInt(j, "Status"));
                String beginTime = dt2.getString(j, "beginTime");
                String endTime = dt2.getString(j, "endTime");
                message = message + bitrate + "\uff1a" + videoStatus + "\uff1b" + msg + "\uff08" + beginTime + "\u2014" + endTime + "\uff09" + "<br/>";
            }
        }
        if (StringUtil.isEmpty((String)message)) {
            message = "\u6682\u65e0\u65e5\u5fd7\u4fe1\u606f";
        }
        this.Response.setMessage(message);
    }
}

