/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.contentinfo;

import com.chinamcloud.common.storage.util.PathUtil;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.Page;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.DateUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.Application;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_ContentInfoLogSchema;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.scms.contentinfo.interfaces.impl.CatalogInterfaceImpl;
import com.sobey.scms.contentinfo.interfaces.util.ContentUtil;
import com.sobey.scms.search.ContentSearchMediator;
import com.sobey.scms.trasncode.MPCCall;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import sun.misc.BASE64Decoder;

public class QuickDemoltion
extends Page {
    public static Mapx initInfo(Mapx params) {
        String contentid = params.getString((Object)"contentid");
        String catalogid = params.getString((Object)"catalogid");
        catalogid = catalogid == null ? params.getString((Object)"cid") : catalogid;
        SCMS_ContentinfoSchema contentinfo = new SCMS_ContentinfoSchema();
        contentinfo.setContentID(contentid);
        long siteid = Application.getCurrentSiteID();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT c.ContentID,c.Title,c.ProgramLength,c.KeyFrame,c.status,c.contentSourceId,c.catalogid,c.inpoint,c.outpoint,cl.Name as catalogName,'' as statusName   FROM scms_contentinfo c,scms_catalog cl  where c.status!=4 and cl.ID=c.catalogid  and c.parentContentID = ?");
        QueryBuilder qb = new QueryBuilder(sb.toString());
        qb.add((Object)contentid);
        DataTable quickDt = qb.executeDataTable();
        ContentUtil.setDetailWorkflowStatus((DataTable)quickDt, (String)"STATUSNAME");
        String baseDir = "";
        StringBuffer quickListHtmlStr = new StringBuffer("<div class=\"zxct-list-num\">\uff08\u8be5\u89c6\u9891\u5df2\u6709" + quickDt.getRowCount() + "\u6761\u62c6\u6761\u5185\u5bb9\uff09</div>");
        if (quickDt.getRowCount() > 0) {
            baseDir = baseDir + "/image/" + Application.getCurrentSiteAlias();
        }
        for (int i = 0; i < quickDt.getRowCount(); ++i) {
            JSONObject jo;
            JSONArray ja;
            String title = quickDt.getString(i, "title");
            String pl = quickDt.getString(i, "ProgramLength");
            String keyFrame = quickDt.getString(i, "KeyFrame");
            String contentSourceId = quickDt.getString(i, "contentSourceId");
            int status = quickDt.getInt(i, "status");
            String conId = quickDt.getString(i, "contentid");
            Long programeLength = Long.parseLong(pl);
            Long inPoint = quickDt.getLong(i, "inpoint");
            Long outPoint = quickDt.getLong(i, "outPoint");
            String imgSource = "";
            imgSource = StringUtil.isNotEmpty((String)keyFrame) ? ((ja = (jo = JSONObject.fromObject((Object)keyFrame)).getJSONArray("keyFrames")).isEmpty() ? "../Video/images/vmsdefault1.jpg" : baseDir + ja.getString(0)) : "../Video/images/vmsdefault1.jpg";
            String showLength = DateUtil.getTimeStr((long)(programeLength / 1000L)).replaceAll(":", "'");
            String showStatusValue = "";
            if (status == 2) {
                try {
                    String progresNum = "0%";
                    Map pro = MPCCall.getTranscodeProgress((String)contentSourceId, (boolean)false);
                    if (pro.keySet().size() > 0) {
                        progresNum = (String)pro.get(contentSourceId);
                    }
                    showStatusValue = showLength + "<div id=\"" + contentSourceId + "_info\" inPoint=" + inPoint + "  outPoint=" + outPoint + " statusValue=\"" + status + "\" class=\"transcoding\">\uff08" + "\u6b63\u5728\u8f6c\u7801" + progresNum + "\uff09" + "<div style='display:none' id='" + contentSourceId + "_hiddenPoint'>0</div></div>";
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                String stautsName = quickDt.getString(i, "statusName");
                showStatusValue = showLength + "<div id=\"" + contentSourceId + "_info\" inPoint=" + inPoint + "  outPoint=" + outPoint + "  statusValue=\"" + status + "\" >\uff08" + stautsName + "\uff09</div>";
            }
            String afreshTranscode = "";
            if (status == 3 || status == 8) {
                afreshTranscode = "<a href=\"javascript:afreshTranscode('" + contentSourceId + "','" + status + "')\" class=\"uploadVideo button01\">\u91cd\u65b0\u8f6c\u7801</a>";
            }
            String catalogName = quickDt.getString(i, "catalogName");
            quickListHtmlStr.append("<div class=\"zxct-list\">");
            quickListHtmlStr.append("\t<div class=\"slideBox zxct-l-in\">");
            quickListHtmlStr.append("\t\t<div class=\"zxct-l-img\">");
            quickListHtmlStr.append("         <img src=\"" + imgSource + "\" width=\"120\" height=\"90\" alt=\"\">");
            quickListHtmlStr.append(" \t\t</div>");
            quickListHtmlStr.append("\t\t<div class=\"zxct-l-txt\">");
            quickListHtmlStr.append(" \t\t\t<p><B>" + title + "</B></p>");
            quickListHtmlStr.append(showStatusValue);
            quickListHtmlStr.append("\t\t\t<p>\u680f\u76ee\uff1a" + catalogName + "</p>");
            quickListHtmlStr.append("\t\t</div>");
            quickListHtmlStr.append(" \t\t<div style=\"clear:both;\"></div>");
            quickListHtmlStr.append("       <div class=\"zxct-l-btns\">");
            quickListHtmlStr.append(afreshTranscode);
            quickListHtmlStr.append("           <a href=\"javascript:deleteCurrent('" + conId + "','" + title + "','" + contentSourceId + "')\" class=\"uploadVideo button01\">\u5220\u9664\u6587\u4ef6</a>");
            quickListHtmlStr.append("\t\t</div>");
            quickListHtmlStr.append("\t</div>");
            quickListHtmlStr.append("</div>");
        }
        if (contentinfo.fill()) {
            params = contentinfo.toMapx();
            params.put((Object)"quickDemoltionListInfo", (Object)quickListHtmlStr);
        }
        return params;
    }

    public void save() {
        try {
            long siteId;
            String path;
            String contentSourceId;
            String beginPoint = this.$V("beginPoint");
            String endPoint = this.$V("endPoint");
            String quickTitle = this.$V("quickTitle");
            String transcodeGroupId = this.$V("transcodeGroupId");
            String catalogId = this.$V("catalogId");
            String contentId = this.$V("contentId");
            String img = this.$V("keyFrame");
            Date now = new Date();
            String keyFrame = this.uploadImg(img);
            JSONArray ja = new JSONArray();
            ja.add((Object)keyFrame);
            JSONObject jobject = new JSONObject();
            jobject.put((Object)"keyFrames", (Object)ja);
            keyFrame = jobject.toString();
            SCMS_ContentinfoSchema contentinfo = new SCMS_ContentinfoSchema();
            contentinfo.setContentID(contentId);
            Long contentid = NoUtil.getMaxID((String)"ContentID");
            if (contentinfo.fill()) {
                contentSourceId = UUID.randomUUID().toString().replaceAll("-", "");
                Long programeLength = Long.parseLong(endPoint) - Long.parseLong(beginPoint);
                programeLength = programeLength / 10L / 1000L;
                path = contentinfo.getPath();
                siteId = contentinfo.getSiteid();
                String videourl = StringUtil.replaceAllToSlant((String)path);
                JSONObject jo = new JSONObject();
                jo.put((Object)"videourl", (Object)videourl);
                jo.put((Object)"transcodeid", (Object)transcodeGroupId);
                jo.put((Object)"catalogid", (Object)catalogId);
                jo.put((Object)"filename", (Object)quickTitle);
                jo.put((Object)"contentSourceId", (Object)contentSourceId);
                jo.put((Object)"filesize", (Object)0);
                String json = jo.toString();
                contentinfo.setContentID(contentid);
                contentinfo.setContentSourceId(contentSourceId);
                contentinfo.setCreateTime(now);
                contentinfo.setCreatorName(User.getUserName());
                contentinfo.setSourceSystemID(Integer.valueOf(5));
                contentinfo.setSourceSystemName(json);
                contentinfo.setTitle(quickTitle);
                contentinfo.setDescription("");
                contentinfo.setTag("");
                contentinfo.setProgramLength(programeLength.toString());
                contentinfo.setKeyFrame(keyFrame);
                contentinfo.setWorkflowId(null);
                contentinfo.setModifyTime(now);
                contentinfo.setModifyUser(User.getUserName());
                contentinfo.setStatus(Long.valueOf(2L));
                contentinfo.setCatalogid(catalogId);
                CatalogInterfaceImpl catalog = new CatalogInterfaceImpl();
                contentinfo.setCatalogInnerCode(catalog.getCatalogInnerCode(Long.parseLong(catalogId)));
                contentinfo.setTranscodeid(Integer.valueOf(Integer.parseInt(transcodeGroupId)));
                contentinfo.setIsSourceVideo(Integer.valueOf(0));
                contentinfo.setPointMessage("");
                contentinfo.setTsPlayUrl("");
                contentinfo.setStyleTypes("");
                contentinfo.setBitrates("");
                contentinfo.setContentPath("");
                contentinfo.setInpoint(Long.valueOf(Long.parseLong(beginPoint)));
                contentinfo.setOutpoint(Long.valueOf(Long.parseLong(endPoint)));
                contentinfo.setParentContentID(Long.valueOf(Long.parseLong(contentId)));
                SCMS_ContentInfoLogSchema log = new SCMS_ContentInfoLogSchema();
                log.setID(NoUtil.getMaxID((String)"ContentInfoLogId"));
                log.setContentId(contentId);
                log.setAction("INSERT");
                log.setActionDetail("\u89c6\u9891\u5feb\u7f16\u62c6\u6761");
                log.setAddTime(now);
                log.setAddUser(User.getRealName());
                Transaction transaction = new Transaction();
                transaction.add((Schema)contentinfo, 1);
                transaction.add((Schema)log, 1);
                if (!transaction.commit()) {
                    this.Response.setStatus(0);
                    this.Response.setMessage("\u62c6\u6761\u8fc7\u7a0b\u4e2d\u63d0\u4ea4\u6570\u636e\u4fdd\u5b58\u51fa\u73b0\u9519\u8bef");
                    return;
                }
            } else {
                this.Response.setStatus(0);
                this.Response.setMessage("\u62c6\u6761\u9519\u8bef");
                return;
            }
            JSONObject transInfo = new JSONObject();
            transInfo.put((Object)"path", (Object)path);
            transInfo.put((Object)"transcodeGroupId", (Object)transcodeGroupId);
            transInfo.put((Object)"contentSourceId", (Object)contentSourceId);
            transInfo.put((Object)"quickTitle", (Object)quickTitle);
            transInfo.put((Object)"siteId", (Object)siteId);
            transInfo.put((Object)"inPoint", (Object)beginPoint);
            transInfo.put((Object)"outPoint", (Object)endPoint);
            this.Response.setStatus(1);
            this.Response.setMessage(transInfo.toString());
            ContentSearchMediator.publishVideo2Search((String)String.valueOf(contentid), (String)SiteUtil.getAlias((long)siteId), (long)siteId);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Response.setStatus(0);
            this.Response.setMessage("\u62c6\u6761\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef");
        }
    }

    public void transcodeAfterSave() {
        String siteId = this.$V("siteId");
        String path = this.$V("path");
        String winVideoUploadDir = Config.getValue((String)"winVideoUploadDir").replace("\\", "/");
        String mdnPath = SiteUtil.getAlias((String)siteId);
        path = winVideoUploadDir + mdnPath + path;
        if (StringUtil.isNotEmpty((String)path)) {
            path = StringUtil.replaceAllToBack_Slant((String)path);
            path = path.replaceAll("\\\\", "/");
        }
        String transcodeGroupId = this.$V("transcodeGroupId");
        String contentSourceId = this.$V("contentSourceId");
        String quickTitle = this.$V("quickTitle");
        String inPoint = this.$V("inPoint");
        String outPoint = this.$V("outPoint");
        System.out.println("--------------------  \u5feb\u901f\u62c6\u6761\u5f00\u59cb\u8f6c\u7801\uff1a ");
        try {
            MPCCall.generateXml((String)path, (String)transcodeGroupId, (String)contentSourceId, (String)quickTitle, (long)Long.parseLong(siteId), (String)inPoint, (String)outPoint);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String uploadImg(String img) {
        SimpleDateFormat formatStr = new SimpleDateFormat("yyyy/MM/dd/");
        String filePath = StringUtil.replaceAllToSlant((String)Config.getValue((String)"linuxImageDir"));
        if (filePath.lastIndexOf("/") != filePath.length() - 1) {
            filePath = filePath + "/";
        }
        String path = PathUtil.builderPath((String[])new String[]{"/upload/Image/static/", formatStr.format(new Date())});
        filePath = PathUtil.builderPath((String[])new String[]{filePath, Application.getCurrentSiteAlias(), path});
        Long imageId = NoUtil.getMaxID((String)"ImageID");
        String keyFrame = "";
        if (StringUtil.isNotEmpty((String)img) && img.indexOf("data:image/jpg;base64") > -1) {
            String fileName = UUID.randomUUID().toString() + "_" + imageId + ".jpg";
            BASE64Decoder decoder = new BASE64Decoder();
            img = img.substring(img.indexOf("data:image/jpg;base64,") + "data:image/jpg;base64,".length());
            try {
                byte[] bytes = decoder.decodeBuffer(img);
                for (int j = 0; j < bytes.length; ++j) {
                    if (bytes[j] >= 0) continue;
                    int n = j;
                    bytes[n] = (byte)(bytes[n] + 256);
                }
                File file = new File(filePath);
                if (!file.exists()) {
                    file.mkdirs();
                }
                FileOutputStream out = new FileOutputStream(filePath + fileName);
                ((OutputStream)out).write(bytes);
                out.flush();
                ((OutputStream)out).close();
                BufferedImage bimage = ImageIO.read(new File(PathUtil.builderPath((String[])new String[]{filePath, fileName})));
                bimage.flush();
                keyFrame = path + fileName;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return keyFrame;
    }
}

