/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.contentinfo;

import com.sobey.bsp.framework.Page;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.DateUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.Application;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_VideoRecordLogSchema;
import com.sobey.bsp.schema.SCMS_VideoRecordSchema;
import com.sobey.bsp.threadmanager.ThreadPoolManager;
import com.sobey.bsp.threadmanager.ThreadTask;
import com.sobey.bsp.threadmanager.VideoRecordThread;
import com.sobey.scms.contentinfo.DemandMediaCommon;
import com.sobey.scms.contentinfo.interfaces.impl.ScreenshotImageInterfaceImpl;
import com.sobey.scms.contentinfo.interfaces.util.ContentUtil;
import com.sobey.scms.contentinfo.interfaces.util.ImageUtil;
import com.sobey.scms.trasncode.MPCCall;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class RecordQuickDeomltionLib
extends Page {
    public void Add() {
        String title = this.$V("title");
        String contentId = this.$V("contentId");
        String description = this.$V("description");
        String times = this.$V("times");
        String catalogId = this.$V("catalogId");
        String transcodeId = this.$V("transcodeId");
        String keyFrame = this.$V("keyFrame");
        try {
            SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            Transaction ta = new Transaction();
            new JSONArray();
            JSONArray ja = JSONArray.fromObject((Object)times);
            for (int i = 0; i < ja.size(); ++i) {
                JSONObject joitems = (JSONObject)ja.get(i);
                if (sdf.parse(formatDate.format(date) + " " + joitems.getString("startTime")).getTime() < sdf.parse(formatDate.format(date) + " " + joitems.getString("endTime")).getTime()) continue;
                this.Response.setStatus(0);
                this.Response.setMessage("\u62c6\u6761\u5931\u8d25\uff0c\u7247\u6bb5\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4");
                return;
            }
            String contentSourceId = UUID.randomUUID().toString().replaceAll("-", "");
            SCMS_VideoRecordSchema vr = new SCMS_VideoRecordSchema();
            if (StringUtil.isNotEmpty((String)keyFrame)) {
                ScreenshotImageInterfaceImpl ssii = new ScreenshotImageInterfaceImpl();
                JSONObject imageinfo = ssii.saveScreenshotImage(contentSourceId, Application.getCurrentSiteID(), 5, keyFrame, 9);
                vr.setPic(imageinfo.getString("imageUrl"));
            } else {
                vr.setPic("");
            }
            vr.setId(Long.valueOf(NoUtil.getMaxID((String)"VideoRecordID")));
            vr.setTitle(ContentUtil.getTitle((String)title, (int)5, (int)0));
            vr.setContentSourceId(contentSourceId);
            vr.setIsloop(0);
            vr.setStatus(9);
            vr.setContentID(Long.valueOf(Long.parseLong(contentId)));
            vr.setAddTime(date);
            vr.setModifyTime(date);
            vr.setOpUser(User.getUserName());
            vr.setIsauto(1);
            vr.setType(5);
            vr.setClassify("");
            vr.setFilepath("");
            vr.setSiteid(Application.getCurrentSiteID() + "");
            vr.setIsPublish(Integer.valueOf(1));
            vr.setExecutTime(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
            vr.setCatalogid(catalogId);
            vr.setTranscodeid(Integer.valueOf(Integer.parseInt(transcodeId)));
            vr.setDescription(description);
            vr.setTimes(ja.toString());
            ta.add((Schema)vr, 1);
            SCMS_VideoRecordLogSchema log = new SCMS_VideoRecordLogSchema();
            log.setID(NoUtil.getMaxID((String)"VideoRecordLogId"));
            log.setContentId(vr.getId().longValue());
            log.setAction("INSERT");
            log.setActionDetail("\u65b0\u5efa\u62c6\u6761\u8ba1\u5212");
            log.setAddTime(new Date());
            log.setAddUser(User.getRealName());
            ta.add((Schema)log, 1);
            if (ta.commit()) {
                this.Response.setStatus(1);
                this.Response.setMessage(vr.getId() + "");
                VideoRecordThread th = new VideoRecordThread(vr);
                ThreadPoolManager.getInstance().addTask((ThreadTask)th);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Response.setStatus(0);
            this.Response.setMessage("\u62c6\u6761\u8ba1\u5212\u65b0\u589e\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        this.Response.setStatus(0);
        this.Response.setMessage("\u4fdd\u5b58\u5931\u8d25");
    }

    public void getQuickDeomltions() {
        try {
            String cid = this.$V("contentid");
            QueryBuilder qb = new QueryBuilder("SELECT ID,title,status,catalogid,ContentSourceId,pic,times,executTime  FROM scms_videorecord WHERE ContentID = ?  ORDER BY ID desc");
            qb.add((Object)cid);
            DataTable dt = qb.executeDataTable();
            JSONArray ja = new JSONArray();
            JSONObject items = new JSONObject();
            SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (dt != null && dt.getRowCount() > 0) {
                for (int i = 0; i < dt.getRowCount(); ++i) {
                    items.clear();
                    String images = dt.getString(i, "pic");
                    if (StringUtil.isNotEmpty((String)images)) {
                        String imageHttpPre = ImageUtil.getImageDomainAndAlias((long)Application.getCurrentSiteID(), (boolean)true);
                        images = imageHttpPre + images;
                    } else {
                        images = "../Video/images/liveDefault.jpg";
                    }
                    new JSONArray();
                    JSONArray timeArray = JSONArray.fromObject((Object)dt.getString(i, "times"));
                    String progamLength = "00:00:00";
                    long frams = 0L;
                    for (int j = 0; j < timeArray.size(); ++j) {
                        try {
                            JSONObject item = timeArray.getJSONObject(j);
                            long timeStart = formatDate.parse(dt.getString(i, "executTime") + " " + item.getString("startTime")).getTime() - formatDate.parse(dt.getString(i, "executTime") + " " + "00:00:00").getTime();
                            long timeEnd = formatDate.parse(dt.getString(i, "executTime") + " " + item.getString("endTime")).getTime() - formatDate.parse(dt.getString(i, "executTime") + " " + "00:00:00").getTime();
                            frams += timeEnd - timeStart;
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    String catalogName = new QueryBuilder("SELECT Name from scms_catalog where id=" + dt.getString(i, "catalogid") + " ").executeString();
                    if (catalogName.length() > 7) {
                        catalogName = catalogName.substring(0, 7) + "...";
                    }
                    progamLength = DateUtil.getTimeStr((long)(frams / 1000L));
                    items.put((Object)"progamLength", (Object)progamLength);
                    items.put((Object)"image", (Object)images);
                    items.put((Object)"id", (Object)dt.getString(i, "ID"));
                    items.put((Object)"title", (Object)dt.getString(i, "title"));
                    items.put((Object)"subtitle", (Object)DemandMediaCommon.controlMediaTitleLength((String)dt.getString(i, "title")));
                    items.put((Object)"ContentSourceId", (Object)dt.getString(i, "ContentSourceId"));
                    items.put((Object)"catalogName", (Object)catalogName);
                    ja.add((Object)items);
                }
            }
            this.Response.setStatus(1);
            this.Response.setMessage(ja.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Response.setStatus(0);
            this.Response.setMessage("\u6570\u636e\u5904\u7406\u5f02\u5e38");
        }
    }

    public void getRecordStatus() {
        try {
            String rids = this.$V("rids");
            String message = "\u64cd\u4f5c\u9519\u8bef\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5";
            String[] ridArray = null;
            if (!StringUtil.isNotEmpty((String)rids)) {
                this.Response.setStatus(0);
                this.Response.setMessage("\u9875\u9762\u6570\u636e\u83b7\u53d6\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
                return;
            }
            ridArray = rids.split(",");
            for (String rid : ridArray) {
                message = "\u72b6\u6001\u83b7\u53d6\u9519\u8bef";
                SCMS_VideoRecordSchema vr = new SCMS_VideoRecordSchema();
                vr.setId(Long.valueOf(Long.parseLong(rid)));
                if (!vr.fill() || vr.getIsloop() == 1) continue;
                try {
                    String ContentSourceId = vr.getContentSourceId();
                    String status = "1";
                    String videStatus = new QueryBuilder("SELECT STATUS  FROM scms_contentinfo WHERE ContentSourceId='" + ContentSourceId + "'").executeString();
                    if (StringUtil.isNotEmpty((String)videStatus)) {
                        String sql;
                        if ("3".equals(videStatus) || "8".equals(videStatus)) {
                            sql = "UPDATE scms_videorecord SET status=0 where ContentSourceId='" + ContentSourceId + "'";
                            new QueryBuilder(sql).executeNoQuery();
                            status = "0";
                        } else if ("2".equals(videStatus)) {
                            sql = "UPDATE scms_videorecord SET status=2 where ContentSourceId='" + ContentSourceId + "'";
                            new QueryBuilder(sql).executeNoQuery();
                            status = "2";
                        } else {
                            sql = "UPDATE scms_videorecord SET status=1 where ContentSourceId='" + ContentSourceId + "'";
                            new QueryBuilder(sql).executeNoQuery();
                        }
                    } else {
                        status = vr.getStatus() + "";
                    }
                    switch (Integer.parseInt(status)) {
                        case 0: {
                            message = "\u62c6\u6761\u5931\u8d25";
                            break;
                        }
                        case 1: {
                            message = "\u62c6\u6761\u6210\u529f";
                            break;
                        }
                        case 3: {
                            message = "\u89c6\u9891\u4e0b\u8f7d\u4e2d...";
                            break;
                        }
                        case 9: {
                            message = "\u7b49\u5f85\u5f55\u5236";
                            break;
                        }
                        case 5: {
                            Map map = MPCCall.getTranscodeProgress((String)vr.getContentSourceId(), (boolean)true);
                            for (String key : map.keySet()) {
                                message = "\u89c6\u9891\u5408\u6210\u4e2d" + (String)map.get(key);
                            }
                            break;
                        }
                        case 2: {
                            Map map1 = MPCCall.getTranscodeProgress((String)vr.getContentSourceId(), (boolean)true);
                            for (String key : map1.keySet()) {
                                message = "\u89c6\u9891\u8f6c\u7801\u4e2d" + (String)map1.get(key);
                            }
                            break;
                        }
                        default: {
                            message = "\u5f02\u5e38\u4fe1\u606f";
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.Response.put((Object)rid, (Object)message);
            }
            this.Response.setStatus(1);
        }
        catch (Exception e) {
            this.Response.setMessage("\u64cd\u4f5c\u5f02\u5e38");
            this.Response.setStatus(0);
        }
    }

    public void del() {
        try {
            String[] ridArray;
            Transaction ta = new Transaction();
            String rid = this.$V("ids");
            boolean flag = true;
            for (String rrid : ridArray = rid.split(",")) {
                SCMS_VideoRecordSchema vrc = new SCMS_VideoRecordSchema();
                vrc.setId(Long.valueOf(Long.parseLong(rrid)));
                if (!vrc.fill() || vrc.getStatus() <= 1 || vrc.getStatus() == 9) continue;
                flag = false;
            }
            if (flag) {
                String delSql = "delete from scms_videorecord where id in (" + rid + ")";
                String delLogSql = "delete from scms_videorecordlog where ContentId in (" + rid + ")";
                ta.add(new QueryBuilder(delSql));
                ta.add(new QueryBuilder(delLogSql));
                if (ta.commit()) {
                    this.Response.setStatus(1);
                    this.Response.setMessage("\u5220\u9664\u6210\u529f");
                    return;
                }
            } else {
                this.Response.setStatus(1);
                this.Response.setMessage("\u5220\u9664\u5931\u8d25,\u6709\u62c6\u6761\u8ba1\u5212\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u4e0d\u80fd\u5220\u9664");
                return;
            }
            this.Response.setStatus(0);
            this.Response.setMessage("\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.Response.setStatus(0);
            this.Response.setMessage("\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
    }
}

