/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.contentinfo.interfaces.impl;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.common.result.ResultDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageFileUploadDTO;
import com.chinamcloud.common.storage.util.FileStorageUtil;
import com.chinamcloud.common.storage.util.PathUtil;
import com.chinamcloud.common.storage.util.ThirdStorageFileUtil;
import com.chinamcloud.vms.util.PathCommonUtil;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.utility.FileUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.bsp.util.ImageHelper;
import com.sobey.scms.contentinfo.interfaces.ScreenshotImageInterface;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScreenshotImageInterfaceImpl
implements ScreenshotImageInterface {
    private static final Logger log = LoggerFactory.getLogger(ScreenshotImageInterfaceImpl.class);

    public JSONObject saveScreenshotImage(SCMS_ContentinfoSchema scms_contentinfoSchema, long siteId, int mediaType, String keyFrameData) throws Exception {
        Long imgNum = this.getImgNum(scms_contentinfoSchema.getImgNum());
        scms_contentinfoSchema.setImgNum(Long.valueOf(imgNum + 1L));
        String contentSourceId = scms_contentinfoSchema.getContentSourceId();
        Date createTime = scms_contentinfoSchema.getCreateTime();
        return this.saveImageZoomAndCentered(siteId, keyFrameData, imgNum, contentSourceId, createTime);
    }

    private JSONObject saveImageZoomAndCentered(long siteId, String keyFrameData, Long imgNum, String contentSourceId, Date createTime) {
        try {
            boolean isSupportOSSStorage = SiteUtil.isSupportOSSStorage((long)siteId);
            String dateDir = new SimpleDateFormat("yyyy/MM/dd/").format(createTime);
            String middlePath = this.getUrlPath(contentSourceId, dateDir);
            String thirdStorageParentPath = this.getThirdStorageParentPath(middlePath, siteId);
            String localStorageParentPath = PathCommonUtil.builderPathByLinuxImageDir((String)thirdStorageParentPath);
            String saveImageName = imgNum.toString() + "_640_400.jpg";
            byte[] imageBytes = this.getImageBytes(keyFrameData);
            File file = null;
            if (isSupportOSSStorage) {
                file = ScreenshotImageInterfaceImpl.writeImageZoomAndCenteredToLocalFile((String)System.getProperty("java.io.tmpdir"), (String)saveImageName, (byte[])imageBytes);
                ThirdStorageFileUploadDTO thirdStorageFileUploadDTO = FileStorageUtil.builderSimpleThirdStorageFileUploadDTO((String)SiteUtil.getOssBucketName((Long)siteId), (String)thirdStorageParentPath, (String)saveImageName);
                ResultDTO thirdStorageSimpleUploadResultDTOResultDTO = ThirdStorageFileUtil.simpleUploadByFilePath((ThirdStorageFileUploadDTO)thirdStorageFileUploadDTO, (String)file.getAbsolutePath());
                if (!thirdStorageSimpleUploadResultDTOResultDTO.isSuccess()) {
                    log.error("\u4e0a\u4f20\u5230\u4e91\u5b58\u50a8\u5931\u8d25:{}", (Object)thirdStorageSimpleUploadResultDTOResultDTO.getDescription());
                    throw new RuntimeException("\u4e0a\u4f20\u5230\u4e91\u5b58\u50a8\u5931\u8d25");
                }
            } else {
                file = ScreenshotImageInterfaceImpl.writeImageZoomAndCenteredToLocalFile((String)localStorageParentPath, (String)saveImageName, (byte[])imageBytes);
            }
            String url = PathUtil.builderPath((String[])new String[]{middlePath, saveImageName});
            JSONObject jsonObject = this.builderJsonObject(url, file);
            FileStorageUtil.deleteFileByCondition((File)file, (boolean)isSupportOSSStorage);
            log.info("\u540e\u53f0\u622a\u56fe\u5904\u7406\u6210\u529f\uff1a{}", (Object)JSON.toJSONString((Object)jsonObject, (boolean)true));
            return jsonObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u622a\u56fe\u5904\u7406\u8fc7\u7a0b\u4e2d\u9047\u5230\u5f02\u5e38:", (Throwable)e);
            throw new RuntimeException("\u622a\u56fe\u5904\u7406\u8fc7\u7a0b\u4e2d\u9047\u5230\u5f02\u5e38");
        }
    }

    private JSONObject builderJsonObject(String urlPath, File file) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(file);
        Raster raster = bufferedImage.getData();
        Rectangle rectangle = raster.getBounds();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"imageUrl", (Object)urlPath);
        jsonObject.put((Object)"width", (Object)String.valueOf(rectangle.width));
        jsonObject.put((Object)"height", (Object)String.valueOf(rectangle.height));
        return jsonObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File writeImageZoomAndCenteredToLocalFile(String storageParentPath, String fileName, byte[] imageBytes) {
        File parentFile = new File(storageParentPath);
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        String tempImageName = UUID.randomUUID().toString() + ".jpg";
        String tempImagePath = PathUtil.builderPath((String[])new String[]{storageParentPath, tempImageName});
        try (FileOutputStream outputStream = new FileOutputStream(tempImagePath);){
            ((OutputStream)outputStream).write(imageBytes);
            outputStream.flush();
            BufferedImage bufferedImage = ImageIO.read(new File(tempImagePath));
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            if ((double)width * 1.0 / 640.0 > (double)height * 1.0 / 400.0) {
                ImageHelper.zoomImage((String)tempImagePath, (String)tempImagePath, (int)((int)Math.ceil((double)width * (400.0 / (double)height))), (int)400);
            } else if ((double)width * 1.0 / 640.0 < (double)height * 1.0 / 400.0) {
                ImageHelper.zoomImage((String)tempImagePath, (String)tempImagePath, (int)640, (int)((int)Math.ceil((double)height * (640.0 / (double)width))));
            } else {
                ImageHelper.zoomImage((String)tempImagePath, (String)tempImagePath, (int)640, (int)400);
            }
            ImageHelper.cutCenterImage((String)tempImagePath, (String)PathUtil.builderPath((String[])new String[]{storageParentPath, fileName}), (int)640, (int)400);
            FileStorageUtil.deleteFileByCondition((File)new File(tempImagePath), (boolean)true);
            File file = new File(PathUtil.builderPath((String[])new String[]{storageParentPath, fileName}));
            return file;
        }
        catch (FileNotFoundException e) {
            log.error("\u5199\u6587\u4ef6\u9047\u5230\u6587\u4ef6\u6ca1\u627e\u5230\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u5199\u6587\u4ef6\u9047\u5230\u6587\u4ef6\u6ca1\u627e\u5230\u5f02\u5e38");
        }
        catch (IOException e) {
            log.error("\u5199\u6587\u4ef6\u9047\u5230IO\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u5199\u6587\u4ef6\u9047\u5230IO\u5f02\u5e38");
        }
        catch (Exception e) {
            log.error("\u5199\u6587\u4ef6\u9047\u5230\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u5199\u6587\u4ef6\u9047\u5230\u5f02\u5e38");
        }
    }

    private String getUrlPath(String contentSourceId, String dateDir) {
        return PathUtil.builderPathEndSlash((String[])new String[]{"/upload/Image/default/", dateDir, contentSourceId});
    }

    private String getThirdStorageParentPath(String middlePath, long siteId) {
        return PathUtil.builderPath((String[])new String[]{SiteUtil.getAlias((long)siteId), middlePath});
    }

    private Long getImgNum(Long imgNum) {
        if (imgNum == null || imgNum == 0L) {
            imgNum = 9L;
        }
        return imgNum;
    }

    private byte[] getImageBytes(String keyFrameData) throws IOException {
        if (StringUtil.isNotEmpty((String)keyFrameData) && keyFrameData.indexOf("data:image/jpg;base64,") > -1) {
            keyFrameData = keyFrameData.substring(keyFrameData.indexOf("data:image/jpg;base64,") + "data:image/jpg;base64,".length());
        }
        return FileUtil.getBytesByBASE64Decoder((String)keyFrameData);
    }

    public JSONObject saveScreenshotImage(String contentSourceId, long siteId, int mediaType, String keyFrameData, int imgNum) throws Exception {
        return this.saveImageZoomAndCentered(siteId, keyFrameData, new Long(imgNum), contentSourceId, new Date());
    }
}

