/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.contentinfo.interfaces.util;

import com.sobey.bsp.cms.pub.PubFun;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.cms.site.Catalog;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.controls.DataGridAction;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.Application;
import com.sobey.bsp.plugin.util.DateUtil;
import com.sobey.scms.contentinfo.interfaces.util.MediaSearchFromDB;
import com.sobey.scms.search.ContentSearchMediator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class MediaAdvanceSearch {
    private static Logger logger = Logger.getLogger(MediaAdvanceSearch.class);

    public static DataTable videoAdvanceSearch(DataGridAction dga) {
        StringBuffer condition = new StringBuffer();
        QueryBuilder qb = new QueryBuilder();
        String categoryID = dga.getParam("CatalogID");
        if (StringUtil.isEmpty((String)categoryID)) {
            dga.setTotal(0);
            dga.dataTable2JSON(new DataTable());
            return null;
        }
        String name = dga.getParam("Name");
        String searchDay = dga.getParam("searchDay");
        String orderFlied = dga.getParam("orderFlied");
        String[] orderFlieds = orderFlied.split(",");
        String roleName = PubFun.getRoleCodeByUserName((String)User.getUserName());
        String catalogids = Catalog.getCatalogIDSByParentIDs((String)categoryID, (String)roleName, (int)5);
        String publishType = dga.getParam("publishType");
        String contentType = String.valueOf(5);
        String subTitle = dga.getParam("subTitle");
        String creatorName = dga.getParam("creatorName");
        String searchTimeRangeType = dga.getParam("searchTimeRangeType");
        if (StringUtil.isEmpty((String)catalogids)) {
            catalogids = categoryID;
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (StringUtil.isNotEmpty((String)catalogids)) {
            String[] catIds = catalogids.split(",");
            BoolQueryBuilder catIdBuilder = QueryBuilders.boolQuery();
            for (String catId : catIds) {
                catIdBuilder.should((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.termQuery((String)"catalogId", (String)catId));
            }
            queryBuilder.must((org.elasticsearch.index.query.QueryBuilder)catIdBuilder);
        }
        if (StringUtil.isNotEmpty((String)name)) {
            queryBuilder.must((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.queryString((String)name).field("title"));
        }
        if (StringUtil.isNotEmpty((String)subTitle)) {
            queryBuilder.must((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.queryString((String)subTitle).field("subTitle"));
        }
        if (StringUtil.isNotEmpty((String)creatorName)) {
            String[] userEmail = SiteUtil.getEmailByUserName((String)creatorName);
            BoolQueryBuilder userNameBuilder = QueryBuilders.boolQuery();
            if (userEmail != null && userEmail.length > 0) {
                for (int i = 0; i < userEmail.length; ++i) {
                    userNameBuilder.should((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.queryString((String)userEmail[i]).field("creatorName"));
                }
            }
            queryBuilder.must((org.elasticsearch.index.query.QueryBuilder)userNameBuilder);
        }
        if (StringUtil.isNotEmpty((String)publishType) && !"-2".equals(publishType)) {
            queryBuilder.must((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.termQuery((String)"status", (String)publishType));
        }
        String startTimeStr = dga.getParam("startTime");
        String endTimeStr = dga.getParam("endTime");
        if (StringUtil.isNotEmpty((String)searchTimeRangeType)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                RangeQueryBuilder rangeQuery = null;
                if (StringUtil.isNotEmpty((String)startTimeStr)) {
                    Date startTime = format.parse(startTimeStr);
                    startTime = format.parse(startTimeStr);
                    rangeQuery = QueryBuilders.rangeQuery((String)searchTimeRangeType).from(startTime.getTime());
                }
                if (StringUtil.isNotEmpty((String)startTimeStr)) {
                    Date endTime = format.parse(endTimeStr);
                    if (rangeQuery == null) {
                        rangeQuery = QueryBuilders.rangeQuery((String)searchTimeRangeType);
                    }
                    rangeQuery.to(endTime.getTime());
                }
                if (rangeQuery != null) {
                    queryBuilder.must(rangeQuery);
                }
            }
            catch (ParseException e) {
                logger.error((Object)"\u65f6\u95f4\u8303\u56f4\u641c\u7d22\u7684\u641c\u7d22\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e!", (Throwable)e);
            }
        } else if (StringUtil.isNotEmpty((String)searchDay) && !"1".equals(searchDay)) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            Date now = calendar.getTime();
            int day = Integer.parseInt(searchDay);
            long from = now.getTime();
            if (day == -1) {
                from = DateUtil.decreaseDay((Date)now, (int)1).getTime();
            } else if (day == 3) {
                from = DateUtil.decreaseDay((Date)now, (int)3).getTime();
            } else if (day == 7) {
                from = DateUtil.decreaseDay((Date)now, (int)7).getTime();
            }
            queryBuilder.must((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.rangeQuery((String)"createTime").gte(from));
        }
        if (StringUtil.isNotEmpty((String)contentType)) {
            queryBuilder.must((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.termQuery((String)"type", (String)contentType));
        }
        queryBuilder.mustNot((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.termQuery((String)"status", (String)"4"));
        queryBuilder.mustNot((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.termQuery((String)"status", (String)"7"));
        FieldSortBuilder sortBuilder = null;
        if (orderFlieds.length > 1) {
            sortBuilder = SortBuilders.fieldSort((String)orderFlieds[0]);
            if ("asc".equalsIgnoreCase(orderFlieds[1])) {
                sortBuilder.order(SortOrder.ASC);
            } else {
                sortBuilder.order(SortOrder.DESC);
            }
        }
        long total = 0L;
        if (queryBuilder.hasClauses()) {
            SearchResponse response = ContentSearchMediator.search((String)Application.getCurrentSiteAlias(), (org.elasticsearch.index.query.QueryBuilder)queryBuilder, (SortBuilder)sortBuilder, (int)(dga.getPageIndex() * dga.getPageSize()), (int)dga.getPageSize());
            if (response != null) {
                SearchHits hits = response.getHits();
                total = hits.getTotalHits();
                if (0L != total) {
                    for (SearchHit hit : hits) {
                        condition.append("'" + hit.getId() + "'").append(",");
                    }
                }
            } else {
                return MediaSearchFromDB.videoSearchFromDB((DataGridAction)dga);
            }
        }
        if (condition.length() > 0) {
            condition.deleteCharAt(condition.length() - 1);
        }
        String sql = "";
        DataTable dt = null;
        if (StringUtil.isNotEmpty((String)condition.toString())) {
            sql = "SELECT isSourceVideo, *,'' as 'sourceName','' AS 'TITLE1',  '' AS CONTENTTYPE,'' AS SERIESICON,'' AS STATUSNAME,'' AS TELEPLAY,'' AS IMGSOURCE,'' AS LENGTH ,'' AS classifyTypeValue, STYLETYPES, '' AS VIDEOFORMAT,'' AS PROGRESS,'' AS AFRESHTRANSCODE  FROM SCMS_CONTENTINFO C WHERE  C.CONTENTSOURCEID IN (" + condition + ") order by field(C.CONTENTSOURCEID," + condition + ")";
            dga.setTotal((int)total);
            qb.setSQL(sql);
            dt = qb.executeDataTable();
        }
        return dt;
    }

    public static DataTable audioAdvanceSearch(DataGridAction dga) {
        String CatalogID = dga.getParam("CatalogID");
        String name = dga.getParam("Name");
        String searchDay = dga.getParam("SearchDate");
        String orderFlied = dga.getParam("orderFlied");
        String[] orderFlieds = orderFlied.split(",");
        String roleName = PubFun.getRoleCodeByUserName((String)User.getUserName());
        String catalogids = Catalog.getCatalogIDSByParentIDs((String)CatalogID, (String)roleName, (int)6);
        String publishType = dga.getParam("publishType");
        String contentType = String.valueOf(6);
        String subTitle = dga.getParam("subTitle");
        String creatorName = dga.getParam("creatorName");
        String searchTimeRangeType = dga.getParam("searchTimeRangeType");
        if (StringUtil.isEmpty((String)CatalogID)) {
            CatalogID = dga.getParams().getString((Object)"Cookie.Resource.LastAudioLib");
            if (StringUtil.isEmpty((String)CatalogID) || "null".equals(CatalogID)) {
                CatalogID = "0";
            }
            dga.getParams().put((Object)"CatalogID", (Object)CatalogID);
            dga.setTotal(0);
            dga.dataTable2JSON(null);
            return null;
        }
        QueryBuilder qb = new QueryBuilder();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (StringUtil.isNotEmpty((String)publishType) && !"-2".equals(publishType)) {
            queryBuilder.must((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.termQuery((String)"status", (String)publishType));
        }
        if (StringUtil.isNotEmpty((String)CatalogID)) {
            String[] catIds = catalogids.split(",");
            BoolQueryBuilder catIdBuilder = QueryBuilders.boolQuery();
            for (String catId : catIds) {
                catIdBuilder.should((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.termQuery((String)"catalogId", (String)catId));
            }
            queryBuilder.must((org.elasticsearch.index.query.QueryBuilder)catIdBuilder);
        }
        if (StringUtil.isNotEmpty((String)name)) {
            queryBuilder.must((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.queryString((String)name).field("title"));
        }
        if (StringUtil.isNotEmpty((String)subTitle)) {
            queryBuilder.must((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.queryString((String)subTitle).field("subTitle"));
        }
        if (StringUtil.isNotEmpty((String)creatorName)) {
            String[] userEmail = SiteUtil.getEmailByUserName((String)creatorName);
            BoolQueryBuilder userNameBuilder = QueryBuilders.boolQuery();
            if (userEmail != null && userEmail.length > 0) {
                for (int i = 0; i < userEmail.length; ++i) {
                    userNameBuilder.should((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.queryString((String)userEmail[i]).field("creatorName"));
                }
            }
            queryBuilder.must((org.elasticsearch.index.query.QueryBuilder)userNameBuilder);
        }
        String startTimeStr = dga.getParam("startTime");
        String endTimeStr = dga.getParam("endTime");
        if (StringUtil.isNotEmpty((String)searchTimeRangeType)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                RangeQueryBuilder rangeQuery = null;
                if (StringUtil.isNotEmpty((String)startTimeStr)) {
                    Date startTime = format.parse(startTimeStr);
                    rangeQuery = QueryBuilders.rangeQuery((String)searchTimeRangeType).from(startTime.getTime());
                }
                if (StringUtil.isNotEmpty((String)startTimeStr)) {
                    Date endTime = format.parse(endTimeStr);
                    if (rangeQuery == null) {
                        rangeQuery = QueryBuilders.rangeQuery((String)searchTimeRangeType);
                    }
                    rangeQuery.to(endTime.getTime());
                }
                if (rangeQuery != null) {
                    queryBuilder.must(rangeQuery);
                }
            }
            catch (ParseException e) {
                logger.error((Object)"\u65f6\u95f4\u8303\u56f4\u641c\u7d22\u7684\u641c\u7d22\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e!", (Throwable)e);
            }
        } else if (StringUtil.isNotEmpty((String)searchDay) && !"1".equals(searchDay)) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            Date now = calendar.getTime();
            int day = Integer.parseInt(searchDay);
            long from = now.getTime();
            if (day == -1) {
                from = DateUtil.decreaseDay((Date)now, (int)1).getTime();
            } else if (day == 3) {
                from = DateUtil.decreaseDay((Date)now, (int)3).getTime();
            } else if (day == 7) {
                from = DateUtil.decreaseDay((Date)now, (int)7).getTime();
            }
            queryBuilder.must((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.rangeQuery((String)"createTime").gte(from));
        }
        if (StringUtil.isNotEmpty((String)contentType)) {
            queryBuilder.must((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.termQuery((String)"type", (String)contentType));
        }
        queryBuilder.mustNot((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.termQuery((String)"status", (long)4L));
        queryBuilder.mustNot((org.elasticsearch.index.query.QueryBuilder)QueryBuilders.termQuery((String)"status", (long)7L));
        FieldSortBuilder sortBuilder = null;
        if (orderFlieds.length > 1) {
            sortBuilder = SortBuilders.fieldSort((String)orderFlieds[0]);
            if ("asc".equalsIgnoreCase(orderFlieds[1])) {
                sortBuilder.order(SortOrder.ASC);
            } else {
                sortBuilder.order(SortOrder.DESC);
            }
        }
        StringBuffer condition = new StringBuffer();
        long total = 0L;
        if (queryBuilder.hasClauses()) {
            SearchResponse response = ContentSearchMediator.search((String)Application.getCurrentSiteAlias(), (org.elasticsearch.index.query.QueryBuilder)queryBuilder, (SortBuilder)sortBuilder, (int)(dga.getPageIndex() * dga.getPageSize()), (int)dga.getPageSize());
            if (response != null) {
                SearchHits hits = response.getHits();
                total = hits.getTotalHits();
                if (0L != total) {
                    for (SearchHit hit : hits) {
                        condition.append("'" + hit.getId() + "'").append(",");
                    }
                }
            } else {
                return MediaSearchFromDB.audioSearchFromDB((DataGridAction)dga);
            }
        }
        if (condition.length() > 0) {
            condition.deleteCharAt(condition.length() - 1);
        }
        DataTable dt = null;
        if (StringUtil.isNotEmpty((String)condition.toString())) {
            String sql = "select  '' as title1,A.workflowid,A.contentSourceId,A.KEYFRAME,A.SourceSystemID,A.modifyTime, A.CatalogInnerCode, A.CatalogId, '' AS IMGSOURCE,'' AS audioFormat,'' as statusName,'' as afreshTranscode,A.status,A.title,A.tag,A.id,A.CreateTime,A.CreatorName from SCMS_AudioInfo A where A.CONTENTSOURCEID IN (" + condition + ") order by field(A.CONTENTSOURCEID," + condition + ")";
            dga.setTotal((int)total);
            qb.setSQL(sql);
            dt = qb.executeDataTable();
        }
        return dt;
    }
}

