/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.contentinfo.interfaces.util;

import com.sobey.bsp.cms.pub.PubFun;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.cms.site.Catalog;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.controls.DataGridAction;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.plugin.util.DateUtil;
import com.sobey.scms.contentinfo.interfaces.util.ContentUtil;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MediaSearchFromDB {
    public static DataTable videoSearchFromDB(DataGridAction dga) {
        StringBuffer condition = new StringBuffer();
        QueryBuilder qb = new QueryBuilder();
        String name = dga.getParam("Name");
        String searchDay = dga.getParam("searchDay");
        String orderFlied = dga.getParam("orderFlied");
        String[] orderFlieds = orderFlied.split(",");
        String categoryID = dga.getParam("CatalogID");
        String creatorName = dga.getParam("creatorName");
        String subTitle = dga.getParam("subTitle");
        if (StringUtil.isEmpty((String)categoryID)) {
            dga.setTotal(0);
            dga.dataTable2JSON(new DataTable());
            return null;
        }
        String roleName = PubFun.getRoleCodeByUserName((String)User.getUserName());
        String catalogids = Catalog.getCatalogIDSByParentIDs((String)categoryID, (String)roleName, (int)5);
        String publishType = dga.getParam("publishType");
        String contentType = dga.getParam("Type");
        if (StringUtil.isEmpty((String)catalogids)) {
            catalogids = categoryID;
        }
        if (StringUtil.isNotEmpty((String)name)) {
            condition.append(" and C.TITLE like ? ");
            qb.add((Object)("%" + name.trim() + "%"));
        }
        if (StringUtil.isNotEmpty((String)subTitle)) {
            condition.append(" and C.subTitle like ? ");
            qb.add((Object)("%" + subTitle.trim() + "%"));
        }
        if (StringUtil.isNotEmpty((String)creatorName)) {
            String[] userEmail = SiteUtil.getEmailByUserName((String)creatorName);
            if (userEmail != null && userEmail.length > 0) {
                StringBuilder nameSb = new StringBuilder();
                for (int i = 0; i < userEmail.length; ++i) {
                    String username = userEmail[i];
                    if (StringUtil.isEmpty((String)username)) continue;
                    if (StringUtil.isNotEmpty((String)nameSb.toString())) {
                        nameSb.append(",");
                    }
                    nameSb.append("'").append(username).append("'");
                }
                if (StringUtil.isNotEmpty((String)nameSb.toString())) {
                    condition.append(" and C.CreatorName in (" + nameSb.toString() + ") ");
                }
            } else {
                condition.append(" and C.CreatorName ='" + creatorName + "'");
            }
        }
        if (StringUtil.isNotEmpty((String)publishType) && !"-2".equals(publishType)) {
            condition.append(" AND C.STATUS =" + publishType);
        }
        if (StringUtil.isNotEmpty((String)searchDay)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date();
            int day = Integer.parseInt(searchDay);
            if (day == 0) {
                condition.append(" AND CREATETIME LIKE '%" + format.format(now) + "%' ");
            } else if (day == -1) {
                condition.append(" AND CREATETIME LIKE '%" + format.format(DateUtil.decreaseDay((Date)now, (int)1)) + "%' ");
            } else if (day == 3) {
                condition.append(" AND DATE(C.CREATETIME) > '" + format.format(DateUtil.decreaseDay((Date)now, (int)3)) + "' ");
                condition.append(" AND DATE(C.CREATETIME) <= '" + format.format(now) + " 23:59:59' ");
            } else if (day == 7) {
                condition.append(" AND DATE(C.CREATETIME) > '" + format.format(DateUtil.decreaseDay((Date)now, (int)7)) + "' ");
                condition.append(" AND DATE(C.CREATETIME) <= '" + format.format(now) + " 23:59:59' ");
            }
        }
        if (StringUtil.isNotEmpty((String)contentType)) {
            condition.append(" AND C.TYPE =" + contentType);
        }
        String sql = "";
        String countSql = "";
        sql = "SELECT classifyType,workflowId,isSourceVideo,ContentID,parentContentID,Title,ProgramLength,status,ContentSourceId,modifyTime,CreatorName,createtime,Tag,Description,subTitle,catalogid,CatalogInnerCode,SourceSystemID,bitrates,KeyFrame ,'' as 'sourceName','' AS 'TITLE1', '' AS 'HITCOUNTALL', '' AS CONTENTTYPE,'' AS SERIESICON,'' AS STATUSNAME,'' AS TELEPLAY,'' AS IMGSOURCE,'' AS classifyTypeValue, '' AS LENGTH ,STYLETYPES, '' AS VIDEOFORMAT,'' AS PROGRESS,'' AS AFRESHTRANSCODE,'' AS videoPlayCount  FROM SCMS_CONTENTINFO C WHERE  C.STATUS!=4 AND C.STATUS!=7 AND C.CATALOGID IN (" + catalogids + ")" + condition;
        countSql = "SELECT count(C.CONTENTID) from SCMS_CONTENTINFO C  WHERE C.STATUS!=4 AND C.STATUS!=7 AND C.CATALOGID IN (" + catalogids + ")" + condition;
        qb.setSQL(countSql);
        dga.setTotal(qb);
        qb.setSQL(sql + " ORDER BY C." + orderFlieds[0] + " " + orderFlieds[1]);
        DataTable dt = qb.executePagedDataTable(dga.getPageSize(), dga.getPageIndex());
        ContentUtil.setDetailWorkflowStatus((DataTable)dt, (String)"STATUSNAME");
        return dt;
    }

    public static DataTable audioSearchFromDB(DataGridAction dga) {
        String publishType = dga.getParam("publishType");
        String CatalogID = dga.getParam("CatalogID");
        String searchDay = dga.getParam("SearchDate");
        String orderFlied = dga.getParam("orderFlied");
        String[] orderFlieds = orderFlied.split(",");
        if (StringUtil.isEmpty((String)CatalogID)) {
            CatalogID = dga.getParams().getString((Object)"Cookie.Resource.LastAudioLib");
            if (StringUtil.isEmpty((String)CatalogID) || "null".equals(CatalogID)) {
                CatalogID = "0";
            }
            dga.getParams().put((Object)"CatalogID", (Object)CatalogID);
            dga.setTotal(0);
            dga.dataTable2JSON(null);
            return null;
        }
        String Name = dga.getParam("Name");
        QueryBuilder qb = new QueryBuilder();
        StringBuffer conditions = new StringBuffer();
        conditions.append(" and A.Status!=4 and A.status != 7");
        if (StringUtil.isNotEmpty((String)CatalogID)) {
            String roleName = PubFun.getRoleCodeByUserName((String)User.getUserName());
            String catalogids = Catalog.getCatalogIDSByParentIDs((String)CatalogID, (String)roleName, (int)6);
            if (StringUtil.isEmpty((String)catalogids)) {
                catalogids = CatalogID;
            }
            conditions.append(" and A.CatalogID in (" + catalogids + ")");
        }
        if (StringUtil.isNotEmpty((String)Name)) {
            conditions.append(" and A.TITLE like ?");
            qb.add((Object)("%" + Name.trim() + "%"));
        }
        if (StringUtil.isNotEmpty((String)publishType) && !"-2".equals(publishType)) {
            conditions.append(" and A.status =" + publishType);
        }
        if (StringUtil.isNotEmpty((String)searchDay)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date();
            int day = Integer.parseInt(searchDay);
            if (day == 0) {
                conditions.append(" AND A.CREATETIME LIKE '%" + format.format(now) + "%' ");
            } else if (day == -1) {
                conditions.append(" AND A.CREATETIME LIKE '%" + format.format(DateUtil.decreaseDay((Date)now, (int)1)) + "%' ");
            } else if (day == 3) {
                conditions.append(" AND A.CREATETIME > '" + format.format(DateUtil.decreaseDay((Date)now, (int)3)) + "' ");
                conditions.append(" AND A.CREATETIME <= '" + format.format(now) + " 23:59:59' ");
            } else if (day == 7) {
                conditions.append(" AND A.CREATETIME > '" + format.format(DateUtil.decreaseDay((Date)now, (int)7)) + "' ");
                conditions.append(" AND A.CREATETIME <= '" + format.format(now) + " 23:59:59' ");
            }
        }
        qb.setSQL("select count(id) from  SCMS_AudioInfo A where 1=1  " + conditions);
        dga.setTotal(qb);
        qb.setSQL("select  '' as title1,A.workflowid,A.contentSourceId,A.KEYFRAME,A.fromStyle,A.modifyTime, A.CatalogInnerCode, A.CatalogId, '' AS IMGSOURCE,'' AS audioFormat,'' as statusName,'' as afreshTranscode,A.status,A.title,A.tag,A.id,A.CreateTime,A.CreatorName from SCMS_AudioInfo A where  A.STATUS<>'7' " + conditions + " order by A." + orderFlieds[0] + " " + orderFlieds[1]);
        DataTable dt = qb.executePagedDataTable(dga.getPageSize(), dga.getPageIndex());
        return dt;
    }
}

