/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.player;

import com.chinamcloud.common.storage.util.PathUtil;
import com.chinamcloud.vms.business.player.PlayerParams;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.schema.SCMS_PlayerSchema;
import com.sobey.bsp.util.BeyondUtil;
import com.sobey.scms.player.PlayerConstant;
import com.sobey.scms.player.util.PlayerParamMethod;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class PlayerParamFXJson {
    private String siteName;
    String playerLocation = "";
    PlayerParamMethod playerParamMethod = null;

    public PlayerParamFXJson(String siteName, long siteId, SCMS_PlayerSchema schema) {
        this.siteName = siteName;
        String staticFileDomain = SiteUtil.getStaticFileDomainBySiteId((long)siteId);
        this.playerLocation = schema.getType() == 6 || schema.getType() == 15 ? PathUtil.builderPath((String[])new String[]{staticFileDomain, siteName, "/media/audio/player"}) : PathUtil.builderPath((String[])new String[]{staticFileDomain, siteName, "/media/video/player"});
        this.playerParamMethod = new PlayerParamMethod(siteName, siteId, schema);
    }

    public String playerWriteToJson(long siteId, SCMS_PlayerSchema scms_playerSchema, boolean newPlayer) {
        JSONObject js = new JSONObject();
        JSONObject params = this.createParamsList(scms_playerSchema);
        js.put((Object)"paramslist", (Object)params);
        if (17 != scms_playerSchema.getType()) {
            JSONArray plugins = this.createPluginslist(siteId, scms_playerSchema);
            if (null == plugins || plugins.isEmpty()) {
                params.put((Object)"plugin", (Object)false);
                js.put((Object)"paramslist", (Object)params);
            }
            js.put((Object)"pluginslist", (Object)plugins);
        }
        JSONObject paramsConfig = PlayerParams.builderPlayerStaticFileConfig((String)scms_playerSchema.getConfigInfo(), (int)scms_playerSchema.getType(), (boolean)newPlayer);
        js.put((Object)"paramsConfig", (Object)paramsConfig);
        String jsString = js.toString();
        jsString = jsString.replaceAll("@", "");
        return jsString;
    }

    public JSONObject createParamsList(SCMS_PlayerSchema schema) {
        Long siteId = schema.getSiteId();
        String vms_login_url = Config.getValue((String)"vms.hosts.address");
        String timeServer = vms_login_url + "/getSystemTime";
        JSONObject paramsList = new JSONObject();
        String jsonHost = SiteUtil.getStaticFileDomainBySiteId((long)siteId) + this.siteName;
        try {
            String streamType = "";
            String seekParam = "";
            String skinPath = "/skins/" + schema.getSkin() + ".swf";
            if (5 == schema.getType()) {
                jsonHost = jsonHost + "/" + PlayerConstant.FileName[0];
                seekParam = PlayerConstant.seekParam[0];
                streamType = PlayerConstant.streamType[0];
            } else if (8 == schema.getType() || 15 == schema.getType()) {
                jsonHost = jsonHost + "/" + PlayerConstant.FileName[1];
                seekParam = PlayerConstant.seekParam[1];
                streamType = PlayerConstant.streamType[1];
            } else if (16 == schema.getType()) {
                jsonHost = jsonHost + "/" + PlayerConstant.FileName[2];
                seekParam = PlayerConstant.seekParam[0];
                streamType = PlayerConstant.streamType[2];
            } else if (6 == schema.getType()) {
                jsonHost = jsonHost + "/" + PlayerConstant.FileName[3];
                seekParam = PlayerConstant.seekParam[0];
                streamType = PlayerConstant.streamType[3];
            } else if (17 == schema.getType()) {
                jsonHost = jsonHost + "/" + PlayerConstant.FileName[5];
                seekParam = PlayerConstant.seekParam[1];
                streamType = PlayerConstant.streamType[4];
            }
            String skintype = schema.getSkin();
            if ("classic_blue".equals(skintype)) {
                paramsList.put((Object)"skinType", (Object)"1");
            } else if ("classic_grey".equals(skintype)) {
                paramsList.put((Object)"skinType", (Object)"2");
            } else if ("classic_green".equals(skintype)) {
                paramsList.put((Object)"skinType", (Object)"3");
            } else if ("classic_orange".equals(skintype)) {
                paramsList.put((Object)"skinType", (Object)"4");
            } else if ("blackphantom_black".equals(skintype)) {
                paramsList.put((Object)"skinType", (Object)"5");
            }
            paramsList.put((Object)"language", (Object)schema.getLanguage());
            paramsList.put((Object)"playerId", (Object)schema.getGuid());
            paramsList.put((Object)"streamType", (Object)streamType);
            paramsList.put((Object)"logging", (Object)true);
            paramsList.put((Object)"logLevel", (Object)"all");
            paramsList.put((Object)"logFilter", (Object)"*");
            paramsList.put((Object)"volume", (Object)80);
            paramsList.put((Object)"loop", (Object)false);
            paramsList.put((Object)"smoothing", (Object)true);
            paramsList.put((Object)"autoPlay", (Object)(schema.getAutoFlag() == 1 ? 1 : 0));
            paramsList.put((Object)"autoLoad", (Object)true);
            paramsList.put((Object)"skin", (Object)(this.playerLocation + skinPath));
            paramsList.put((Object)"bufferTime", (Object)5);
            paramsList.put((Object)"configable", (Object)true);
            paramsList.put((Object)"initMedia", null);
            paramsList.put((Object)"host", (Object)jsonHost);
            String alias = SiteUtil.getAlias((long)schema.getSiteId());
            if (StringUtil.isNotEmpty((String)schema.getPlayerBackGroundUrl()) && !schema.getPlayerBackGroundUrl().contains("FirstLoadingLogo")) {
                String playerBackGroundUrl = SiteUtil.getImageDomainBySiteId((long)siteId) + alias + schema.getPlayerBackGroundUrl();
                paramsList.put((Object)"playerBackground", (Object)playerBackGroundUrl);
            } else {
                paramsList.put((Object)"playerBackground", (Object)"");
            }
            if (17 == schema.getType()) {
                paramsList.put((Object)"plugin", (Object)false);
            } else {
                paramsList.put((Object)"plugin", (Object)true);
                paramsList.put((Object)"nonDisplay", (Object)"spectrum");
                paramsList.put((Object)"seekParam", (Object)seekParam);
                paramsList.put((Object)"timeServer", (Object)timeServer);
                paramsList.put((Object)"programchanggehost", (Object)SiteUtil.getDomainPreByKey((String)String.valueOf(schema.getSiteId()), (String)"videoDomain", (boolean)false));
            }
            if (15 == schema.getType() || 6 == schema.getType()) {
                paramsList.put((Object)"audioOnly", (Object)true);
                if (1 == schema.getShowCorrugatedBoxFlag()) {
                    paramsList.put((Object)"isSpectrum", (Object)true);
                } else {
                    paramsList.put((Object)"isSpectrum", (Object)false);
                }
            } else {
                paramsList.put((Object)"audioOnly", (Object)false);
                paramsList.put((Object)"isshowcontrol", (Object)(schema.getIsshowcontrolFlag() == 1 ? 1 : 0));
            }
            paramsList.put((Object)"isUrlStatic", (Object)true);
            paramsList.put((Object)"EncryptUrl", (Object)(schema.getGuardFlag() == 1 ? 1 : 0));
            paramsList.put((Object)"EncryptionSwf", (Object)"UrlEncryptorProvider.swf");
            paramsList.put((Object)"EncryptionServer", null);
            if (schema.getPlayerBufferFlag() == 1) {
                paramsList.put((Object)"loadinglogo", (Object)PathUtil.builderPath((String[])new String[]{SiteUtil.getImageDomainBySiteId((long)siteId), this.siteName + schema.getPlayerBufferUrl()}));
            }
            paramsList.put((Object)"isfullscreen", (Object)true);
            paramsList.put((Object)"ispause", (Object)true);
            if (17 == schema.getType()) {
                paramsList.put((Object)"ispause", (Object)false);
            }
        }
        catch (JSONException e) {
            LogUtil.error((Object)"\u7ec4\u88c5paramsList\u53c2\u6570\u4e0b\u7684json\u6570\u636e\u9519\u8bef");
            e.printStackTrace();
        }
        return paramsList;
    }

    public JSONArray createPluginslist(long siteId, SCMS_PlayerSchema scms_playerSchema) {
        BeyondUtil beyond;
        JSONObject wartermarkUrlJson;
        String wartermarkUrl;
        JSONArray pluginsList = new JSONArray();
        if (scms_playerSchema.getIsCountFlag() == 1 && SiteUtil.isSupportPlayCount((long)scms_playerSchema.getSiteId())) {
            JSONObject countPlugin = new JSONObject();
            countPlugin = this.playerParamMethod.createCountPlugin(countPlugin, scms_playerSchema);
            pluginsList.add((Object)countPlugin);
        }
        if (scms_playerSchema.getOnliveFlag() == 1) {
            JSONObject ILinePlugin = new JSONObject();
            ILinePlugin = this.playerParamMethod.createILinePlugin(ILinePlugin, scms_playerSchema);
            pluginsList.add((Object)ILinePlugin);
        }
        if (scms_playerSchema.getHideScreenShotFlag() == 1) {
            JSONObject screenshotPlugin = new JSONObject();
            screenshotPlugin = this.playerParamMethod.createScreenshotPlugin(screenshotPlugin, scms_playerSchema);
            pluginsList.add((Object)screenshotPlugin);
        }
        if (scms_playerSchema.getFormatFlag() == 1) {
            JSONObject multiratePlugin = new JSONObject();
            multiratePlugin = this.playerParamMethod.createMultiratePlugin(multiratePlugin, scms_playerSchema);
            pluginsList.add((Object)multiratePlugin);
        }
        if (StringUtils.isNotEmpty((String)(wartermarkUrl = (wartermarkUrlJson = JSONObject.fromObject((Object)scms_playerSchema.getWartermarkUrl())).getString("wartermarkUrl")))) {
            JSONObject logoPlugin = new JSONObject();
            logoPlugin = this.playerParamMethod.createLogoPlugin(logoPlugin, scms_playerSchema);
            pluginsList.add((Object)logoPlugin);
        }
        if (scms_playerSchema.getPlayerLogoFlag() == 1) {
            JSONObject playerLogoPlugin = new JSONObject();
            playerLogoPlugin = this.playerParamMethod.createPlayerLogoPlugin(playerLogoPlugin, scms_playerSchema);
            pluginsList.add((Object)playerLogoPlugin);
        }
        if (5 == scms_playerSchema.getType() && 0 != scms_playerSchema.getPointMode()) {
            JSONObject pointMessagePlugin = new JSONObject();
            pointMessagePlugin = this.playerParamMethod.createPointMessagePlugin(pointMessagePlugin, siteId, scms_playerSchema);
            pluginsList.add((Object)pointMessagePlugin);
        }
        if (StringUtil.isNotEmpty((String)scms_playerSchema.getCodes()) || scms_playerSchema.getDomainType() == 0 && StringUtil.isNotEmpty((String)scms_playerSchema.getDomainString()) || scms_playerSchema.getDomainType() == 1 && StringUtil.isNotEmpty((String)scms_playerSchema.getUnDomainString())) {
            JSONObject IPlimitPlugin = new JSONObject();
            IPlimitPlugin = this.playerParamMethod.createIPlimitPlugin(IPlimitPlugin, scms_playerSchema);
            pluginsList.add((Object)IPlimitPlugin);
        }
        if ((beyond = new BeyondUtil()).getPlayControlFlag().equals("1")) {
            JSONObject playControlPlugin = new JSONObject();
            playControlPlugin = this.playerParamMethod.createPlayControlPlugin(playControlPlugin, beyond);
            pluginsList.add((Object)playControlPlugin);
        }
        return pluginsList;
    }
}

