/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.player.interfaces.impl;

import com.chinamcloud.common.storage.dto.FileStorageDTO;
import com.chinamcloud.common.storage.util.FileStorageUtil;
import com.chinamcloud.common.storage.util.PathUtil;
import com.chinamcloud.vms.util.PathCommonUtil;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.SiteConfig;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.FileUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.schema.SCMS_PlayerSchema;
import com.sobey.scms.player.Html5ParamWriteToJson;
import com.sobey.scms.player.PlayerConstant;
import com.sobey.scms.player.PlayerParamFXJson;
import com.sobey.scms.player.PlayerParamWriteToJson;
import com.sobey.scms.player.interfaces.PlayerOperateInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerOperateImpl
implements PlayerOperateInterface {
    private static final Logger log = LoggerFactory.getLogger(PlayerOperateImpl.class);

    public boolean delPlayer(String ids, String alias) {
        try {
            String[] id = ids.split(",");
            Transaction trans = new Transaction();
            ArrayList<SCMS_PlayerSchema> schemas = new ArrayList<SCMS_PlayerSchema>();
            for (int i = 0; i < id.length; ++i) {
                SCMS_PlayerSchema schema = new SCMS_PlayerSchema();
                schema.setId(Long.valueOf(Long.parseLong(id[i])));
                if (!schema.fill() || schema.getDefaultFlag() != null && schema.getDefaultFlag() != 0) continue;
                schemas.add(schema);
                trans.add((Schema)schema, 3);
            }
            if (trans.commit()) {
                String filePath = PathUtil.builderPath((String[])new String[]{Config.getValue((String)"linuxStaticFileDir"), alias, "/media/playerJson/"});
                for (int i = 0; i < schemas.size(); ++i) {
                    SCMS_PlayerSchema schema = (SCMS_PlayerSchema)schemas.get(i);
                    filePath = this.getFilePathByType(filePath, schema);
                    String playerParamjsonFileName = PathUtil.builderPath((String[])new String[]{filePath, schema.getGuid() + "_PlayerParamProfile.json"});
                    String playerParamjsonFXFileName = PathUtil.builderPath((String[])new String[]{filePath, schema.getGuid() + "_PlayerParamFXProfile.json"});
                    String playerJsFileName = PathUtil.builderPath((String[])new String[]{filePath, schema.getGuid() + ".js"});
                    FileUtil.delete((String)playerParamjsonFileName);
                    FileUtil.delete((String)playerParamjsonFXFileName);
                    FileUtil.delete((String)playerJsFileName);
                }
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String getFilePathByType(String filePath, SCMS_PlayerSchema schema) {
        Integer type = schema.getType();
        if (5 == type) {
            filePath = PathUtil.builderPathEndSlash((String[])new String[]{filePath, PlayerConstant.FileName[0]});
        } else if (8 == type) {
            filePath = PathUtil.builderPathEndSlash((String[])new String[]{filePath, PlayerConstant.FileName[1]});
        } else if (16 == type) {
            filePath = PathUtil.builderPathEndSlash((String[])new String[]{filePath, PlayerConstant.FileName[2]});
        } else if (6 == type) {
            filePath = PathUtil.builderPathEndSlash((String[])new String[]{filePath, PlayerConstant.FileName[3]});
        } else if (15 == type) {
            filePath = PathUtil.builderPathEndSlash((String[])new String[]{filePath, PlayerConstant.FileName[4]});
        } else if (17 == type) {
            filePath = PathUtil.builderPathEndSlash((String[])new String[]{filePath, PlayerConstant.FileName[5]});
        }
        return filePath;
    }

    public void writePlayerStaticFile(SCMS_PlayerSchema scms_playerSchema, long siteId, String alias) {
        try {
            boolean isSupportOSSStorage = SiteUtil.isSupportOSSStorage((long)siteId);
            String ossBucketName = SiteUtil.getOssBucketName((Long)siteId);
            int type = scms_playerSchema.getType();
            String thirdStorageParentPath = this.builderThirdStorageParentPath(alias, type);
            String localStorageParentPath = PathCommonUtil.builderPathByLinuxStaticFileDir((String)thirdStorageParentPath);
            String newThirdStorageParentPath = this.builderNewThirdStorageParentPath(alias, type);
            String newLocalStorageParentPath = PathCommonUtil.builderPathByLinuxStaticFileDir((String)newThirdStorageParentPath);
            PlayerParamWriteToJson playerParamWriteToJson = new PlayerParamWriteToJson(alias, siteId, scms_playerSchema);
            String playerParamProfileContent = playerParamWriteToJson.playerWriteToJson(siteId, scms_playerSchema, false);
            String playerParamProfileFileName = scms_playerSchema.getGuid() + "_PlayerParamProfile.json";
            FileStorageDTO fileStorageDTO = FileStorageDTO.builder().isSupportOSSStorage(isSupportOSSStorage).ossBucketName(ossBucketName).thirdStorageParentPath(thirdStorageParentPath).localStorageParentPath(localStorageParentPath).saveFileName(playerParamProfileFileName).build();
            FileStorageUtil.saveFile((FileStorageDTO)fileStorageDTO, (String)playerParamProfileContent);
            String newPlayerParamProfileContent = playerParamWriteToJson.playerWriteToJson(siteId, scms_playerSchema, true);
            fileStorageDTO = FileStorageDTO.builder().isSupportOSSStorage(isSupportOSSStorage).ossBucketName(ossBucketName).thirdStorageParentPath(newThirdStorageParentPath).localStorageParentPath(newLocalStorageParentPath).saveFileName(playerParamProfileFileName).build();
            FileStorageUtil.saveFile((FileStorageDTO)fileStorageDTO, (String)newPlayerParamProfileContent);
            PlayerParamFXJson playerParamFXJson = new PlayerParamFXJson(alias, siteId, scms_playerSchema);
            String playerParamFXProfileContent = playerParamFXJson.playerWriteToJson(siteId, scms_playerSchema, false);
            String playerParamFXProfileFileName = scms_playerSchema.getGuid() + "_PlayerParamFXProfile.json";
            fileStorageDTO = FileStorageDTO.builder().isSupportOSSStorage(isSupportOSSStorage).ossBucketName(ossBucketName).thirdStorageParentPath(thirdStorageParentPath).localStorageParentPath(localStorageParentPath).saveFileName(playerParamFXProfileFileName).build();
            FileStorageUtil.saveFile((FileStorageDTO)fileStorageDTO, (String)playerParamFXProfileContent);
            String newPlayerParamFXProfileContent = playerParamFXJson.playerWriteToJson(siteId, scms_playerSchema, true);
            fileStorageDTO = FileStorageDTO.builder().isSupportOSSStorage(isSupportOSSStorage).ossBucketName(ossBucketName).thirdStorageParentPath(newThirdStorageParentPath).localStorageParentPath(newLocalStorageParentPath).saveFileName(playerParamFXProfileFileName).build();
            FileStorageUtil.saveFile((FileStorageDTO)fileStorageDTO, (String)newPlayerParamFXProfileContent);
            String html5Content = this.builderHtml5Content(siteId, alias, scms_playerSchema);
            String html5SaveFileName = scms_playerSchema.getGuid() + "_Html5ParamProfile.jsonp";
            fileStorageDTO = FileStorageDTO.builder().isSupportOSSStorage(isSupportOSSStorage).ossBucketName(ossBucketName).thirdStorageParentPath(thirdStorageParentPath).localStorageParentPath(localStorageParentPath).saveFileName(html5SaveFileName).build();
            FileStorageUtil.saveFile((FileStorageDTO)fileStorageDTO, (String)html5Content);
            fileStorageDTO = FileStorageDTO.builder().isSupportOSSStorage(isSupportOSSStorage).ossBucketName(ossBucketName).thirdStorageParentPath(newThirdStorageParentPath).localStorageParentPath(newLocalStorageParentPath).saveFileName(html5SaveFileName).build();
            FileStorageUtil.saveFile((FileStorageDTO)fileStorageDTO, (String)html5Content);
            Map contentMap = this.builderContentMap(siteId, alias, scms_playerSchema);
            String saveFileName = scms_playerSchema.getGuid() + ".js";
            fileStorageDTO = FileStorageDTO.builder().isSupportOSSStorage(isSupportOSSStorage).ossBucketName(ossBucketName).thirdStorageParentPath(thirdStorageParentPath).localStorageParentPath(localStorageParentPath).saveFileName(saveFileName).build();
            FileStorageUtil.saveFile((FileStorageDTO)fileStorageDTO, (String)((String)contentMap.get("content")));
            fileStorageDTO = FileStorageDTO.builder().isSupportOSSStorage(isSupportOSSStorage).ossBucketName(ossBucketName).thirdStorageParentPath(newThirdStorageParentPath).localStorageParentPath(newLocalStorageParentPath).saveFileName(saveFileName).build();
            FileStorageUtil.saveFile((FileStorageDTO)fileStorageDTO, (String)((String)contentMap.get("newContent")));
        }
        catch (Exception e) {
            log.error("\u64ad\u653e\u5668\u6a21\u677f\u4fdd\u5b58\u9047\u5230\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private String builderHtml5Content(long siteId, String alias, SCMS_PlayerSchema scms_playerSchema) {
        Html5ParamWriteToJson html5ParamWriteToJson = new Html5ParamWriteToJson();
        JSONObject html5JsonObject = html5ParamWriteToJson.Html5PluginParam(siteId, alias, scms_playerSchema);
        return "success_jsonpCallback(" + html5JsonObject.toString() + ")";
    }

    private Map<String, String> builderContentMap(long siteId, String alias, SCMS_PlayerSchema scms_playerSchema) {
        int type = scms_playerSchema.getType();
        String playerLocation = PathUtil.builderPath((String[])new String[]{SiteUtil.getStaticFileDomainBySiteId((long)siteId), alias});
        String html5FullLocation = PathUtil.builderPath((String[])new String[]{playerLocation, "/media/html5/player"});
        String commonFilePath = PathUtil.builderPath((String[])new String[]{playerLocation, "/media/playerJson"});
        String jsonHost = this.builderJsonHost(playerLocation, type);
        String playerFullLocation = this.builderPlayerFullLocation(playerLocation, type);
        String jsonSource = this.builderJsonSource(playerLocation, type, false);
        String playerParamJsonSource = PathUtil.builderPath((String[])new String[]{jsonSource, scms_playerSchema.getGuid() + "_PlayerParamProfile.json"});
        String playerParamFXJsonSource = PathUtil.builderPath((String[])new String[]{jsonSource, scms_playerSchema.getGuid() + "_PlayerParamFXProfile.json"});
        String html5ParamJsonpSource = this.builderHtml5ParamJsonpSource(scms_playerSchema.getGuardFlag(), scms_playerSchema.getGuid(), jsonSource);
        String siteHost = Config.getValue((String)"vms.hosts.address");
        String shareHost = SiteConfig.getValue((Long)siteId, (Object)"shareHost").toString();
        String getJsonServletHost = PathUtil.builderPath((String[])new String[]{siteHost, "/GetJson"});
        String getSystemTimeServletHost = PathUtil.builderPath((String[])new String[]{siteHost, "/getSystemTime"});
        int hasAreaLimitFlag = StringUtil.isNotEmpty((String)scms_playerSchema.getCodes()) ? 1 : 0;
        String path = this.getPath(type);
        String content = FileUtil.getFileDataByBR((String)path);
        content = content.replaceAll("@#player.playerlocalcation}", playerFullLocation).replaceAll("@#player.html5Localcation}", html5FullLocation).replaceAll("@#player.playerJsonlocalcation}", commonFilePath).replaceAll("@#player.width}", String.valueOf(scms_playerSchema.getWidth())).replaceAll("@#player.height}", String.valueOf(scms_playerSchema.getHeight())).replaceAll("@#player.flashContentId}", scms_playerSchema.getGuid()).replaceAll("@#player.siteid}", String.valueOf(siteId)).replaceAll("@#player.siteHost}", siteHost).replaceAll("@#player.shareHost}", shareHost).replaceAll("@#player.jsonHost}", jsonHost).replaceAll("@#player.isShowLivePlayList}", scms_playerSchema.getIsShowLivePlayList() == 1 ? "true" : "false").replaceAll("@#player.getJsonServlet}", getJsonServletHost).replaceAll("@#player.getSystemTimeServlet}", getSystemTimeServletHost).replaceAll("@#player.playerParamFXProfile}", playerParamFXJsonSource).replaceAll("@#player.playerParamProfile}", playerParamJsonSource).replaceAll("@#player.domainType}", String.valueOf(scms_playerSchema.getDomainType())).replaceAll("@#player.domainString}", scms_playerSchema.getDomainString()).replaceAll("@#player.hasAreaFlag}", String.valueOf(hasAreaLimitFlag)).replaceAll("@#player.unDomainString}", scms_playerSchema.getUnDomainString()).replaceAll("@#player.mediaType}", String.valueOf(type)).replaceAll("@#player.Html5Plugin}", html5ParamJsonpSource).replaceAll("@#player.language}", scms_playerSchema.getLanguage() == null ? "Chinese" : scms_playerSchema.getLanguage());
        String newPath = this.getNewPath(type);
        String newContent = FileUtil.getFileDataByBR((String)newPath);
        String newPlayerJsonSource = this.builderJsonSource(playerLocation, type, false);
        String newPlayerParamJsonSource = PathUtil.builderPath((String[])new String[]{newPlayerJsonSource, scms_playerSchema.getGuid() + "_PlayerParamProfile.json"});
        String newPlayerParamFXJsonSource = PathUtil.builderPath((String[])new String[]{newPlayerJsonSource, scms_playerSchema.getGuid() + "_PlayerParamFXProfile.json"});
        String newHtml5ParamJsonpSource = this.builderHtml5ParamJsonpSource(scms_playerSchema.getGuardFlag(), scms_playerSchema.getGuid(), newPlayerJsonSource);
        newContent = newContent.replaceAll("@#player.playerlocalcation}", playerFullLocation).replaceAll("@#player.html5Localcation}", html5FullLocation).replaceAll("@#player.playerJsonlocalcation}", commonFilePath).replaceAll("@#player.width}", String.valueOf(scms_playerSchema.getWidth())).replaceAll("@#player.height}", String.valueOf(scms_playerSchema.getHeight())).replaceAll("@#player.flashContentId}", scms_playerSchema.getGuid()).replaceAll("@#player.siteid}", String.valueOf(siteId)).replaceAll("@#player.siteHost}", siteHost).replaceAll("@#player.shareHost}", shareHost).replaceAll("@#player.jsonHost}", jsonHost).replaceAll("@#player.isShowLivePlayList}", scms_playerSchema.getIsShowLivePlayList() == 1 ? "true" : "false").replaceAll("@#player.getJsonServlet}", getJsonServletHost).replaceAll("@#player.getSystemTimeServlet}", getSystemTimeServletHost).replaceAll("@#player.playerParamFXProfile}", newPlayerParamFXJsonSource).replaceAll("@#player.playerParamProfile}", newPlayerParamJsonSource).replaceAll("@#player.domainType}", String.valueOf(scms_playerSchema.getDomainType())).replaceAll("@#player.domainString}", scms_playerSchema.getDomainString()).replaceAll("@#player.hasAreaFlag}", String.valueOf(hasAreaLimitFlag)).replaceAll("@#player.unDomainString}", scms_playerSchema.getUnDomainString()).replaceAll("@#player.mediaType}", String.valueOf(type)).replaceAll("@#player.Html5Plugin}", newHtml5ParamJsonpSource).replaceAll("@#player.language}", scms_playerSchema.getLanguage() == null ? "Chinese" : scms_playerSchema.getLanguage());
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("content", content);
        contentMap.put("newContent", newContent);
        return contentMap;
    }

    private String builderHtml5ParamJsonpSource(Integer guardFlag, String guid, String jsonSource) {
        if (0 == guardFlag) {
            return "";
        }
        return jsonSource + "/" + guid + "_Html5ParamProfile.jsonp";
    }

    private String builderNewThirdStorageParentPath(String alias, int type) {
        String thirdStorageParentPath = "";
        if (5 == type) {
            thirdStorageParentPath = PathUtil.builderPathEndSlash((String[])new String[]{alias, "/media/playerJson/", PlayerConstant.NewFileName[0]});
        } else if (8 == type) {
            thirdStorageParentPath = PathUtil.builderPathEndSlash((String[])new String[]{alias, "/media/playerJson/", PlayerConstant.NewFileName[1]});
        } else if (16 == type) {
            thirdStorageParentPath = PathUtil.builderPathEndSlash((String[])new String[]{alias, "/media/playerJson/", PlayerConstant.NewFileName[2]});
        } else if (6 == type) {
            thirdStorageParentPath = PathUtil.builderPathEndSlash((String[])new String[]{alias, "/media/playerJson/", PlayerConstant.NewFileName[3]});
        } else if (15 == type) {
            thirdStorageParentPath = PathUtil.builderPathEndSlash((String[])new String[]{alias, "/media/playerJson/", PlayerConstant.NewFileName[4]});
        }
        return thirdStorageParentPath;
    }

    private String builderThirdStorageParentPath(String alias, int type) {
        String thirdStorageParentPath = "";
        if (5 == type) {
            thirdStorageParentPath = PathUtil.builderPathEndSlash((String[])new String[]{alias, "/media/playerJson/", PlayerConstant.FileName[0]});
        } else if (8 == type) {
            thirdStorageParentPath = PathUtil.builderPathEndSlash((String[])new String[]{alias, "/media/playerJson/", PlayerConstant.FileName[1]});
        } else if (16 == type) {
            thirdStorageParentPath = PathUtil.builderPathEndSlash((String[])new String[]{alias, "/media/playerJson/", PlayerConstant.FileName[2]});
        } else if (6 == type) {
            thirdStorageParentPath = PathUtil.builderPathEndSlash((String[])new String[]{alias, "/media/playerJson/", PlayerConstant.FileName[3]});
        } else if (15 == type) {
            thirdStorageParentPath = PathUtil.builderPathEndSlash((String[])new String[]{alias, "/media/playerJson/", PlayerConstant.FileName[4]});
        } else if (17 == type) {
            thirdStorageParentPath = PathUtil.builderPathEndSlash((String[])new String[]{alias, "/media/playerJson/", PlayerConstant.FileName[5]});
        }
        return thirdStorageParentPath;
    }

    private String builderJsonSource(String playerLocation, int type, boolean newPlayer) {
        String[] fileName = null;
        fileName = newPlayer ? PlayerConstant.NewFileName : PlayerConstant.FileName;
        String jsonSourcePath = "";
        if (5 == type) {
            jsonSourcePath = PathUtil.builderPath((String[])new String[]{playerLocation, "/media/playerJson/", fileName[0]});
        } else if (8 == type) {
            jsonSourcePath = PathUtil.builderPath((String[])new String[]{playerLocation, "/media/playerJson/", fileName[1]});
        } else if (16 == type) {
            jsonSourcePath = PathUtil.builderPath((String[])new String[]{playerLocation, "/media/playerJson/", fileName[2]});
        } else if (6 == type) {
            jsonSourcePath = PathUtil.builderPath((String[])new String[]{playerLocation, "/media/playerJson/", fileName[3]});
        } else if (15 == type) {
            jsonSourcePath = PathUtil.builderPath((String[])new String[]{playerLocation, "/media/playerJson/", fileName[4]});
        }
        return jsonSourcePath;
    }

    private String builderPlayerFullLocation(String playerLocation, int type) {
        String playerFullPath = "";
        if (5 == type || 8 == type || 16 == type || 17 == type) {
            playerFullPath = PathUtil.builderPath((String[])new String[]{playerLocation, "/media/video/player"});
        } else if (6 == type || 15 == type) {
            playerFullPath = PathUtil.builderPath((String[])new String[]{playerLocation, "/media/audio/player"});
        }
        return playerFullPath;
    }

    private String getNewPath(int type) {
        String newPath = "";
        if (5 == type) {
            newPath = Thread.currentThread().getContextClassLoader().getResource("video-player-resource.js").getPath();
        } else if (8 == type) {
            newPath = Thread.currentThread().getContextClassLoader().getResource("videolive-player-resource.js").getPath();
        } else if (16 == type) {
            newPath = Thread.currentThread().getContextClassLoader().getResource("virLive-player-resource.js").getPath();
        } else if (6 == type) {
            newPath = Thread.currentThread().getContextClassLoader().getResource("audio-player-resource.js").getPath();
        } else if (15 == type) {
            newPath = Thread.currentThread().getContextClassLoader().getResource("audiolive-player-resource.js").getPath();
        }
        return newPath;
    }

    private String getPath(int type) {
        String path = "";
        if (5 == type || 8 == type || 16 == type || 17 == type) {
            path = Thread.currentThread().getContextClassLoader().getResource("video-player.js").getPath();
        } else if (6 == type || 15 == type) {
            path = Thread.currentThread().getContextClassLoader().getResource("audio-player.js").getPath();
        }
        return path;
    }

    private String builderJsonHost(String playerLocation, int type) {
        String jsonHostPath = "";
        if (5 == type) {
            jsonHostPath = PathUtil.builderPath((String[])new String[]{playerLocation, "/vod"});
        } else if (8 == type) {
            jsonHostPath = PathUtil.builderPath((String[])new String[]{playerLocation, "/liveChannel"});
        } else if (16 == type) {
            jsonHostPath = PathUtil.builderPath((String[])new String[]{playerLocation, "/virtualChannel"});
        } else if (6 == type) {
            jsonHostPath = PathUtil.builderPath((String[])new String[]{playerLocation, "/audio"});
        } else if (15 == type) {
            jsonHostPath = PathUtil.builderPath((String[])new String[]{playerLocation, "/liveChannel"});
        } else if (17 == type) {
            jsonHostPath = PathUtil.builderPath((String[])new String[]{playerLocation, "/deviceChannel"});
        }
        return jsonHostPath;
    }
}

