/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.player.util;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.schema.SCMS_PlayerSchema;
import com.sobey.bsp.util.BeyondUtil;
import com.sobey.bsp.util.StringsUtil;
import com.sobey.scms.contentinfo.interfaces.util.ContentConstant;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class PlayerParamMethod {
    private String siteName;
    private Long siteId;
    String playerLocation = "";
    private String commonPluginLocation = "";
    private String customPluginLocation = "";
    private String customColorPluginLocation = "";

    public PlayerParamMethod(String siteName, long siteId, SCMS_PlayerSchema schema) {
        String[] skinArray = schema.getSkin().split("_");
        this.siteName = siteName;
        this.siteId = schema.getSiteId();
        String staticFileDomain = SiteUtil.getStaticFileDomainBySiteId((long)siteId);
        this.playerLocation = 6 == schema.getType() || 15 == schema.getType() ? staticFileDomain + siteName + "/media/audio/player" : staticFileDomain + siteName + "/media/video/player";
        this.commonPluginLocation = this.playerLocation + "/plugins" + "/common";
        this.customPluginLocation = this.playerLocation + "/plugins/" + skinArray[0];
        this.customColorPluginLocation = this.customPluginLocation + "/" + skinArray[1];
    }

    public JSONObject createILinePlugin(JSONObject iLinePlugin, SCMS_PlayerSchema schema) {
        try {
            iLinePlugin.put((Object)"source", (Object)(this.commonPluginLocation + "/ILinePlugin.swf"));
        }
        catch (JSONException e) {
            LogUtil.error((Object)"\u7ec4\u88c5iLinePlugin\u63d2\u4ef6\u53c2\u6570\u4e0b\u7684json\u6570\u636e\u9519\u8bef");
            e.printStackTrace();
        }
        return iLinePlugin;
    }

    public JSONObject createIPlimitPlugin(JSONObject iPlimitPlugin, SCMS_PlayerSchema schema) {
        try {
            iPlimitPlugin.put((Object)"source", (Object)(this.commonPluginLocation + "/IPlimitPlugin.swf"));
            iPlimitPlugin.put((Object)"ValCallBack", (Object)"isPlayByDomain");
            iPlimitPlugin.put((Object)"prompt", (Object)"\u5bf9\u4e0d\u8d77\uff01\u60a8\u7684\u7f51\u7edc\u6216\u5730\u57df\u4e0d\u5728\u8be5\u8282\u76ee\u64ad\u653e\u670d\u52a1\u8303\u56f4\u4e4b\u5185\uff01");
        }
        catch (JSONException e) {
            LogUtil.error((Object)"\u7ec4\u88c5iPlimitPlugin\u63d2\u4ef6\u53c2\u6570\u4e0b\u7684json\u6570\u636e\u9519\u8bef");
            e.printStackTrace();
        }
        return iPlimitPlugin;
    }

    public JSONObject createPointMessagePlugin(JSONObject pointMessagePlugin, long siteId, SCMS_PlayerSchema schema) {
        try {
            String host = SiteUtil.getStaticFileDomainBySiteId((long)siteId) + this.siteName + ContentConstant.vodStaticFileDir[4];
            pointMessagePlugin.put((Object)"source", (Object)(this.customPluginLocation + "/PointMessagePlugin.swf"));
            pointMessagePlugin.put((Object)"host", (Object)host);
            pointMessagePlugin.put((Object)"mode", (Object)schema.getPointMode());
            pointMessagePlugin.put((Object)"callback", (Object)"getPointMessageData");
        }
        catch (JSONException e) {
            LogUtil.error((Object)"\u7ec4\u88c5pointMessagePlugin\u63d2\u4ef6\u53c2\u6570\u4e0b\u7684json\u6570\u636e\u9519\u8bef");
            e.printStackTrace();
        }
        return pointMessagePlugin;
    }

    public JSONObject createPlayerLogoPlugin(JSONObject playerLogoPlugin, SCMS_PlayerSchema schema) {
        String src = SiteUtil.getImageDomainBySiteId((long)this.siteId) + this.siteName + schema.getPlayerLogoUrl();
        try {
            playerLogoPlugin.put((Object)"source", (Object)(this.customPluginLocation + "/RightLogoPlugin.swf"));
            playerLogoPlugin.put((Object)"src", (Object)src);
            playerLogoPlugin.put((Object)"link", (Object)schema.getPlayerLogoLink());
        }
        catch (JSONException e) {
            LogUtil.error((Object)"\u7ec4\u88c5playerLogoPlugin\u63d2\u4ef6\u53c2\u6570\u4e0b\u7684json\u6570\u636e\u9519\u8bef");
            e.printStackTrace();
        }
        return playerLogoPlugin;
    }

    public JSONObject createRecPlugin(JSONObject recPlugin, SCMS_PlayerSchema schema) {
        String json = "";
        try {
            recPlugin.put((Object)"source", (Object)(this.customPluginLocation + "/RecPlugin.swf"));
            recPlugin.put((Object)"callback", (Object)"6");
            recPlugin.put((Object)"host", (Object)json);
        }
        catch (JSONException e) {
            LogUtil.error((Object)"\u7ec4\u88c5recPlugin\u63d2\u4ef6\u53c2\u6570\u4e0b\u7684json\u6570\u636e\u9519\u8bef");
            e.printStackTrace();
        }
        return recPlugin;
    }

    public JSONObject createAdPlugin(JSONObject adPlugin, SCMS_PlayerSchema schema) {
        try {
            adPlugin.put((Object)"source", (Object)(this.customPluginLocation + "/AdPlugin.swf"));
            adPlugin.put((Object)"rc", (Object)"1");
            adPlugin.put((Object)"blockLoading", (Object)"true");
            adPlugin.put((Object)"callback", (Object)"getadData");
            adPlugin.put((Object)"blockPlaying", (Object)"true");
        }
        catch (JSONException e) {
            LogUtil.error((Object)"\u7ec4\u88c5adPlugin\u63d2\u4ef6\u53c2\u6570\u4e0b\u7684json\u6570\u636e\u9519\u8bef");
            e.printStackTrace();
        }
        return adPlugin;
    }

    public JSONObject createSpeedDetectPlugin(JSONObject speedDetectPlugin, SCMS_PlayerSchema schema) {
        try {
            speedDetectPlugin.put((Object)"source", (Object)(this.commonPluginLocation + "/SpeedDetectPlugin.swf"));
            speedDetectPlugin.put((Object)"threshold", (Object)"2");
            speedDetectPlugin.put((Object)"count", (Object)"1");
            speedDetectPlugin.put((Object)"repeat", (Object)"true");
            speedDetectPlugin.put((Object)"existmessage", (Object)"<span color=\"#ffffff\">\u5f53\u524d\u7f51\u7edc\u73af\u5883\u6709\u70b9\u7cdf\u7cd5\uff0c\u5efa\u8bae\u5148\u6682\u505c\u4e00\u4f1a\u518d\u64ad\u653e\u89c2\u770b\uff01</span>");
            speedDetectPlugin.put((Object)"delaytime", (Object)"0");
            speedDetectPlugin.put((Object)"message", (Object)"<span color=\"#ffffff\">\u5f53\u524d\u7f51\u7edc\u73af\u5883\u6709\u70b9\u7cdf\u7cd5\uff0c\u5efa\u8bae\u5148\u6682\u505c\u4e00\u4f1a\u518d\u64ad\u653e\u89c2\u770b\uff01</span>");
        }
        catch (JSONException e) {
            LogUtil.error((Object)"\u7ec4\u88c5speedDetectPlugin\u63d2\u4ef6\u53c2\u6570\u4e0b\u7684json\u6570\u636e\u9519\u8bef");
            e.printStackTrace();
        }
        return speedDetectPlugin;
    }

    public JSONObject createCountPlugin(JSONObject countPlugin, SCMS_PlayerSchema schema) {
        String cmsCountHost = Config.getValue((String)"cmsCountHost");
        cmsCountHost = StringUtil.isEmpty((String)cmsCountHost) ? "" : StringsUtil.esUrl((String)cmsCountHost);
        try {
            countPlugin.put((Object)"source", (Object)(this.commonPluginLocation + "/CountPlugin.swf"));
            countPlugin.put((Object)"host", (Object)Config.getValue((String)"vms.countServer.address"));
            countPlugin.put((Object)"cmsCountHost", (Object)cmsCountHost);
        }
        catch (JSONException e) {
            LogUtil.error((Object)"\u7ec4\u88c5countPlugin\u63d2\u4ef6\u53c2\u6570\u4e0b\u7684json\u6570\u636e\u9519\u8bef");
            e.printStackTrace();
        }
        return countPlugin;
    }

    public JSONObject createScreenshotPlugin(JSONObject screenshotPlugin, SCMS_PlayerSchema schema) {
        try {
            String host = Config.getValue((String)"vms.hosts.address") + "/ScreenShot";
            String imageaddress = StringUtil.replaceAllToSlant((String)(Config.getValue((String)"linuxImageDir") + this.siteName + "/upload/Image/out/"));
            String imageHttpUrl = SiteUtil.getImageDomainBySiteId((long)this.siteId) + this.siteName + "/upload/Image/out/";
            screenshotPlugin.put((Object)"source", (Object)(this.customPluginLocation + "/ScreenshotPlugin.swf"));
            screenshotPlugin.put((Object)"host", (Object)host);
            screenshotPlugin.put((Object)"imageaddress", (Object)imageaddress);
            screenshotPlugin.put((Object)"sharehost", (Object)imageHttpUrl);
            if (1 == schema.getHideScreenShotFlag()) {
                screenshotPlugin.put((Object)"isHide", (Object)"true");
            } else {
                screenshotPlugin.put((Object)"isHide", (Object)"false");
            }
            screenshotPlugin.put((Object)"callback", (Object)"picShare");
        }
        catch (JSONException e) {
            LogUtil.error((Object)"\u7ec4\u88c5screenshotPlugin\u63d2\u4ef6\u53c2\u6570\u4e0b\u7684json\u6570\u636e\u9519\u8bef");
            e.printStackTrace();
        }
        return screenshotPlugin;
    }

    public JSONObject createLogoPlugin(JSONObject logoPlugin, SCMS_PlayerSchema schema) {
        JSONObject wartermarkUrlJson = JSONObject.fromObject((Object)schema.getWartermarkUrl());
        String wartermarkUrl = wartermarkUrlJson.getString("wartermarkUrl");
        String imageUrl = SiteUtil.getImageDomainBySiteId((long)this.siteId) + this.siteName + wartermarkUrl;
        float width = Float.valueOf(schema.getWidth().intValue()).floatValue();
        float height = Float.valueOf(schema.getHeight().intValue()).floatValue();
        float markHeight = Float.valueOf(wartermarkUrlJson.getString("markHeight")).floatValue();
        float markWidth = Float.valueOf(wartermarkUrlJson.getString("markWidth")).floatValue();
        float widthPercent = height / 300.0f;
        float heightPercent = width / 360.0f;
        if (widthPercent > heightPercent) {
            markHeight = markHeight * heightPercent / 1.0f;
            markWidth = markWidth * heightPercent / 1.0f;
        } else {
            markHeight = markHeight * widthPercent / 1.0f;
            markWidth = markWidth * widthPercent / 1.0f;
        }
        float vertical = Float.valueOf(wartermarkUrlJson.getString("vertical")).floatValue();
        float horizontal = Float.valueOf(wartermarkUrlJson.getString("horizontal")).floatValue();
        float horizontalPercent = horizontal / (width - markWidth);
        float verticalPercent = vertical / (height - markHeight);
        try {
            logoPlugin.put((Object)"source", (Object)(this.customPluginLocation + "/LogoPlugin.swf"));
            logoPlugin.put((Object)"ImgUrl", (Object)imageUrl);
            logoPlugin.put((Object)"ImgX", (Object)Float.valueOf(horizontalPercent));
            logoPlugin.put((Object)"ImgY", (Object)Float.valueOf(verticalPercent));
            logoPlugin.put((Object)"ImgHeight", (Object)wartermarkUrlJson.getString("markHeight"));
            logoPlugin.put((Object)"ImgWidth", (Object)wartermarkUrlJson.getString("markWidth"));
            logoPlugin.put((Object)"Align", (Object)"l");
        }
        catch (JSONException e) {
            LogUtil.error((Object)"\u7ec4\u88c5logoPlugin\u63d2\u4ef6\u53c2\u6570\u4e0b\u7684json\u6570\u636e\u9519\u8bef");
            e.printStackTrace();
        }
        return logoPlugin;
    }

    public JSONObject createMultiratePlugin(JSONObject multiratePlugin, SCMS_PlayerSchema schema) {
        try {
            if (6 == schema.getType() || 15 == schema.getType()) {
                multiratePlugin.put((Object)"source", (Object)(this.customColorPluginLocation + "/MultiratePlugin.swf"));
            } else {
                multiratePlugin.put((Object)"source", (Object)(this.customPluginLocation + "/SettingPlugin.swf"));
            }
            if (5 == schema.getType()) {
                multiratePlugin.put((Object)"selectedRate", (Object)schema.getFormatValue());
            }
        }
        catch (JSONException e) {
            LogUtil.error((Object)"\u7ec4\u88c5SettingPlugin\u63d2\u4ef6\u53c2\u6570\u4e0b\u7684json\u6570\u636e\u9519\u8bef");
            e.printStackTrace();
        }
        return multiratePlugin;
    }

    public JSONObject createPlayListPlugin(JSONObject playListPlugin, SCMS_PlayerSchema schema) {
        try {
            playListPlugin.put((Object)"source", (Object)(this.customPluginLocation + "/PanelPlugin.swf"));
            playListPlugin.put((Object)"callback", (Object)"isShowPlayList");
        }
        catch (JSONException e) {
            LogUtil.error((Object)"\u7ec4\u88c5playListPlugin\u63d2\u4ef6\u53c2\u6570\u4e0b\u7684json\u6570\u636e\u9519\u8bef");
            e.printStackTrace();
        }
        return playListPlugin;
    }

    public JSONObject createPlayControlPlugin(JSONObject playControlPlugin, BeyondUtil beyond) {
        try {
            playControlPlugin.put((Object)"source", (Object)(this.customPluginLocation + "/MembersPlugin.swf"));
            playControlPlugin.put((Object)"limitTime", (Object)Long.parseLong(beyond.getlimitTime()));
            playControlPlugin.put((Object)"prompt", (Object)beyond.getMessage());
            playControlPlugin.put((Object)"Parameters", (Object)beyond.getBeyondJson());
        }
        catch (JSONException e) {
            LogUtil.error((Object)"\u7ec4\u88c5playControlPlugin\u63d2\u4ef6\u53c2\u6570\u4e0b\u7684json\u6570\u636e\u9519\u8bef");
            e.printStackTrace();
        }
        return playControlPlugin;
    }
}

