/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.recycle;

import com.chinamcloud.common.storage.dto.FileDeleteDTO;
import com.chinamcloud.common.storage.dto.FileDeleteResultDTO;
import com.chinamcloud.common.storage.util.FileStorageUtil;
import com.chinamcloud.common.storage.util.PathUtil;
import com.chinamcloud.vms.business.statistics.impl.DefaultStorageStatisticsImpl;
import com.chinamcloud.vms.util.PathCommonUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.Page;
import com.sobey.bsp.framework.SiteConfig;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.controls.DataGridAction;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.Application;
import com.sobey.bsp.platform.UserLog;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.plugin.util.DateUtil;
import com.sobey.bsp.schema.SCMS_AudioInfoLogSchema;
import com.sobey.bsp.schema.SCMS_ContentInfoLogSchema;
import com.sobey.bsp.schema.SCMS_SeriesInfoLogSchema;
import com.sobey.scms.contentinfo.DemandAudioLib;
import com.sobey.scms.contentinfo.DemandMediaCommon;
import com.sobey.scms.contentinfo.DemandVideoLib;
import com.sobey.scms.contentinfo.interfaces.util.ContentConstant;
import com.sobey.scms.search.ContentSearchMediator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class AssignmentLib
extends Page {
    private static final Logger log = LoggerFactory.getLogger(AssignmentLib.class);

    public static void dgDataBind(DataGridAction dga) {
        StringBuffer condition = new StringBuffer();
        QueryBuilder qb = new QueryBuilder();
        String title = dga.getParam("title");
        String createName = dga.getParam("createName");
        String searchDay = dga.getParam("searchDay");
        String status = dga.getParam("status");
        String mediaType = dga.getParam("mediaType");
        condition.append(" and r.siteid=" + Application.getCurrentSiteID());
        if (StringUtil.isNotEmpty((String)title)) {
            condition.append(" and r.TITLE like '%" + title.trim() + "%' ");
        }
        if (StringUtil.isNotEmpty((String)createName)) {
            condition.append(" and r.createName like '%" + createName.trim() + "%' ");
        }
        if (StringUtil.isNotEmpty((String)searchDay)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date();
            int day = Integer.parseInt(searchDay);
            if (day == 0) {
                condition.append(" AND r.CREATETIME LIKE '%" + format.format(now) + "%' ");
            } else if (day == -1) {
                condition.append(" AND r.CREATETIME LIKE '%" + format.format(DateUtil.decreaseDay((Date)now, (int)1)) + "%' ");
            } else if (day == 3) {
                condition.append(" AND r.CREATETIME > '" + format.format(DateUtil.decreaseDay((Date)now, (int)3)) + "' ");
                condition.append(" AND r.CREATETIME <= '" + format.format(now) + " 23:59:59' ");
            } else if (day == 7) {
                condition.append(" AND r.CREATETIME > '" + format.format(DateUtil.decreaseDay((Date)now, (int)7)) + "' ");
                condition.append(" AND r.CREATETIME <= '" + format.format(now) + " 23:59:59' ");
            }
        }
        if (StringUtil.isNotEmpty((String)status) && !status.equals("-2")) {
            condition.append(" AND r.status = '" + status + "'");
        }
        if (StringUtil.isNotEmpty((String)mediaType) && !mediaType.equals("-2")) {
            condition.append(" AND r.assignMentType = '" + mediaType + "'");
        }
        condition.append(" order by r.createtime desc");
        String sql = "select r.*,'' as type,'' as title1,'' as titleV,c.name as catalogName from scms_recycle r,scms_catalog c where 1=1 and r.catalogId = c.id";
        String countSql = "SELECT count(r.id) from scms_recycle r where 1=1 " + condition;
        qb.setSQL(countSql);
        dga.setTotal(qb);
        sql = StringUtil.isNotEmpty((String)dga.getSortString()) ? sql + dga.getSortString() : sql + condition;
        qb.setSQL(sql);
        DataTable dt = qb.executePagedDataTable(dga.getPageSize(), dga.getPageIndex());
        if (dt == null || dt.getRowCount() < 1) {
            dga.dataTable2JSON(dt);
            return;
        }
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String type = dt.getString(i, "assignmentType");
            String catalogName = dt.getString(i, "catalogName");
            String string = catalogName = catalogName.length() > 12 ? catalogName.substring(0, 12) + "..." : catalogName;
            if (null != type && "5".equals(type)) {
                dt.set(i, "type", (Object)"\u89c6\u9891");
            } else if (null != type && "6".equals(type)) {
                dt.set(i, "type", (Object)"\u97f3\u9891");
            } else if (null != type && "7".equals(type)) {
                dt.set(i, "type", (Object)"\u7535\u89c6\u5267");
            }
            String title2 = dt.getString(i, "TITLE");
            dt.set(i, "titleV", (Object)title2);
            dt.set(i, "title1", (Object)DemandMediaCommon.controlMediaTitleLength((String)title2));
            String realname = dt.getString(i, "createName");
            String statusV = dt.getString(i, "status");
            realname = User.getRealName((String)realname);
            dt.set(i, "createName", (Object)realname);
            dt.set(i, "catalogName", (Object)catalogName);
            if ("-1".equals(statusV)) {
                dt.set(i, "status", (Object)"\u521d\u7a3f");
                continue;
            }
            if ("0".equals(statusV)) {
                dt.set(i, "status", (Object)"\u5f85\u53d1\u5e03");
                continue;
            }
            if ("1".equals(statusV)) {
                dt.set(i, "status", (Object)"\u5df2\u53d1\u5e03");
                continue;
            }
            if ("2".equals(statusV)) {
                dt.set(i, "status", (Object)"\u6b63\u5728\u8f6c\u7801");
                continue;
            }
            if ("3".equals(statusV)) {
                dt.set(i, "status", (Object)"\u8f6c\u7801\u5931\u8d25 ");
                continue;
            }
            if ("4".equals(statusV)) {
                dt.set(i, "status", (Object)"\u56de\u6536\u7ad9");
                continue;
            }
            if ("5".equals(statusV)) {
                dt.set(i, "status", (Object)"\u6d41\u8f6c\u4e2d");
                continue;
            }
            if ("6".equals(statusV)) {
                dt.set(i, "status", (Object)"\u91cd\u65b0\u7f16\u8f91");
                continue;
            }
            if ("7".equals(statusV)) {
                dt.set(i, "status", (Object)"\u6b63\u5728\u4e0a\u4f20");
                continue;
            }
            if ("8".equals(statusV)) {
                dt.set(i, "status", (Object)"\u53d6\u6d88\u8f6c\u7801");
                continue;
            }
            if ("9".equals(statusV)) {
                dt.set(i, "status", (Object)"\u53d1\u5e03\u4e2d");
                continue;
            }
            if ("10".equals(statusV)) {
                dt.set(i, "status", (Object)"\u53d1\u5e03\u5931\u8d25");
                continue;
            }
            if ("11".equals(statusV)) {
                dt.set(i, "status", (Object)"\u64a4\u9500\u4e2d");
                continue;
            }
            if (!"12".equals(statusV)) continue;
            dt.set(i, "status", (Object)"\u64a4\u9500\u5931\u8d25");
        }
        dga.dataTable2JSON(dt);
    }

    public void deleteAll() {
        QueryBuilder qb = new QueryBuilder("select contentid,id,assignMentType from scms_recycle");
        DataTable dt = qb.executeDataTable();
        String videoIDs = "";
        String seriesIDs = "";
        String audioIDs = "";
        String ids = "";
        if (dt != null && dt.getRowCount() > 0) {
            for (int i = 0; i < dt.getRowCount(); ++i) {
                int assignMentType = dt.getInt(i, "assignMentType");
                String contentId = dt.getString(i, "contentId");
                String id = dt.getString(i, "id");
                if (5 == assignMentType) {
                    videoIDs = videoIDs + "," + contentId;
                } else if (6 == assignMentType) {
                    audioIDs = audioIDs + "," + contentId;
                } else if (7 == assignMentType) {
                    seriesIDs = seriesIDs + "," + contentId;
                }
                ids = ids + "," + id;
            }
        }
        if (StringUtil.isNotEmpty((String)videoIDs)) {
            videoIDs = videoIDs.substring(1);
        }
        if (StringUtil.isNotEmpty((String)audioIDs)) {
            audioIDs = audioIDs.substring(1);
        }
        if (StringUtil.isNotEmpty((String)seriesIDs)) {
            seriesIDs = seriesIDs.substring(1);
        }
        if (StringUtil.isNotEmpty((String)ids)) {
            ids = ids.substring(1);
        }
        this.delete(videoIDs, seriesIDs, audioIDs, ids);
    }

    private void delete(String videoIDs, String seriesIDs, String audioIDs, String ids) {
        Map videoMap = new HashMap();
        Map audioMap = new HashMap();
        try {
            Transaction transaction = new Transaction();
            if (StringUtil.isNotEmpty((String)videoIDs)) {
                videoMap = this.deleteVideo(transaction, videoIDs);
                this.deletePushlog(transaction, videoIDs);
            }
            if (StringUtil.isNotEmpty((String)seriesIDs)) {
                this.deleteSeries(transaction, seriesIDs);
            }
            if (StringUtil.isNotEmpty((String)audioIDs)) {
                audioMap = this.deleteAudio(transaction, audioIDs);
            }
            if (StringUtil.isNotEmpty((String)ids)) {
                this.deleteRecycle(transaction, ids);
            }
            if (transaction.commit()) {
                if (StringUtil.isNotEmpty((String)videoIDs)) {
                    AssignmentLib.deleteVideoFile((String)String.valueOf(Application.getCurrentSiteID()), videoMap);
                }
                if (StringUtil.isNotEmpty((String)audioIDs)) {
                    AssignmentLib.deleteAudioFile((String)String.valueOf(Application.getCurrentSiteID()), audioMap);
                }
                this.Response.setStatus(1);
                this.Response.setMessage("\u64cd\u4f5c\u6210\u529f!");
                UserLog.log((String)"Recycle", (String)"Delete", (String)"\u5f7b\u5e95\u5220\u9664\u6210\u529f", (String)this.Request.getClientIP());
            } else {
                this.Response.setStatus(0);
                this.Response.setMessage("\u64cd\u4f5c\u5931\u8d25!");
                UserLog.log((String)"Recycle", (String)"Delete", (String)"\u5f7b\u5e95\u5220\u9664\u5931\u8d25", (String)this.Request.getClientIP());
            }
        }
        catch (Exception e) {
            this.Response.setStatus(0);
            this.Response.setMessage("\u64cd\u4f5c\u6570\u636e\u5e93\u65f6\u53d1\u751f\u9519\u8bef!");
            UserLog.log((String)"Recycle", (String)"Delete", (String)"\u5f7b\u5e95\u5220\u9664\u5931\u8d25", (String)this.Request.getClientIP());
            e.printStackTrace();
        }
    }

    public void delete() {
        String ids = this.$V("ids");
        String videoIDs = this.$V("videoIDs");
        String seriesIDs = this.$V("seriesIDs");
        String audioIDs = this.$V("audioIDs");
        this.delete(videoIDs, seriesIDs, audioIDs, ids);
    }

    public static void deleteAudioFile(String siteId, Map audioMap) {
        String[] contentSourceIds = (String[])audioMap.get("contentSourceIds");
        String[] dateStrings = (String[])audioMap.get("dateStrings");
        FileDeleteDTO fileDeleteDTO = AssignmentLib.builderFileDeleteDTOByAudio((String)siteId, (Map)audioMap, (String[])contentSourceIds, (String[])dateStrings);
        FileStorageUtil.deleteFile((FileDeleteDTO)fileDeleteDTO);
        List fileUrlList = (List)audioMap.get("fileUrlList");
        FileDeleteDTO fileDeleteDTOByTranscode = AssignmentLib.builderFileDeleteDTOByTranscode((String)siteId, (List)fileUrlList);
        FileDeleteResultDTO fileDeleteResultDTOByTranscode = FileStorageUtil.deleteFile((FileDeleteDTO)fileDeleteDTOByTranscode);
        AssignmentLib.statisticsAfterDelete((Long)Long.parseLong(siteId), (List)fileDeleteResultDTOByTranscode.getDeleteLocalFileSuccessList());
        String playCountTag = (String)SiteConfig.getValue((Long)Long.parseLong(siteId), (Object)"playCountTag");
        if (StringUtil.isNotEmpty((String)playCountTag) && "1".equals(playCountTag)) {
            AssignmentLib.hbaseDelete((String)siteId, (String[])contentSourceIds);
        }
    }

    private static void hbaseDelete(String siteId, String[] contentSourceIds) {
        List<Object> contentSourceIdList = new ArrayList();
        if (ArrayUtils.isNotEmpty((Object[])contentSourceIds)) {
            contentSourceIdList = Arrays.asList(contentSourceIds);
        }
    }

    private static FileDeleteDTO builderFileDeleteDTOByAudio(String siteId, Map audioMap, String[] contentSourceIds, String[] dateStrings) {
        String alias = SiteUtil.getAlias((String)siteId);
        FileDeleteDTO fileDeleteDTO = AssignmentLib.builderFileDeleteDTO((Long)Long.parseLong(siteId));
        AssignmentLib.fullDeleteFilePathByAudioStaticFile((String[])dateStrings, (String[])contentSourceIds, (Long)Long.parseLong(siteId), (FileDeleteDTO)fileDeleteDTO);
        String[] KeyFrames = (String[])audioMap.get("KeyFrames");
        AssignmentLib.fullDeleteFilePathByAudioKeyFrame((String[])KeyFrames, (String)alias, (FileDeleteDTO)fileDeleteDTO);
        String[] paths = (String[])audioMap.get("paths");
        AssignmentLib.fullDeleteFilePathByAudioPath((String[])paths, (String)alias, (FileDeleteDTO)fileDeleteDTO);
        return fileDeleteDTO;
    }

    private static void statisticsAfterDelete(Long siteId, List<String> deleteLocalFileSuccessList) {
        DefaultStorageStatisticsImpl storageStatistics = new DefaultStorageStatisticsImpl();
        HashSet deleteLocalFileParentSet = Sets.newHashSet();
        for (String deleteLocalFileSuccess : deleteLocalFileSuccessList) {
            deleteLocalFileParentSet.add(deleteLocalFileSuccess.substring(0, deleteLocalFileSuccess.lastIndexOf("/")));
        }
        storageStatistics.statistics(siteId, (Set)deleteLocalFileParentSet);
    }

    private static FileDeleteDTO builderFileDeleteDTOByTranscode(String siteId, List<String> fileUrlList) {
        FileDeleteDTO fileDeleteDTO = AssignmentLib.builderFileDeleteDTO((Long)Long.parseLong(siteId));
        if (CollectionUtils.isEmpty(fileUrlList)) {
            return fileDeleteDTO;
        }
        for (int i = 0; i < fileUrlList.size(); ++i) {
            String fileUrl = fileUrlList.get(i);
            if (!StringUtils.isNotBlank((CharSequence)fileUrl)) continue;
            fileDeleteDTO.getDeleteLocalFilePathList().add(PathUtil.builderPath((String[])new String[]{Config.getValue((String)"linuxVideoDir"), SiteUtil.getAlias((String)siteId), fileUrl.substring(0, fileUrl.lastIndexOf("/"))}));
            fileDeleteDTO.getDeleteThirdFilePathList().add(PathUtil.builderPath((String[])new String[]{SiteUtil.getAlias((String)siteId), fileUrl}));
        }
        return fileDeleteDTO;
    }

    private static void fullDeleteFilePathByAudioPath(String[] paths, String alias, FileDeleteDTO fileDeleteDTO) {
        if (ArrayUtils.isEmpty((Object[])paths)) {
            return;
        }
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (!StringUtils.isNotBlank((CharSequence)path)) continue;
            fileDeleteDTO.getDeleteLocalFilePathList().add(PathUtil.builderPath((String[])new String[]{Config.getValue((String)"linuxVideoUploadDir"), alias, path}));
            fileDeleteDTO.getDeleteThirdFilePathList().add(PathUtil.builderPath((String[])new String[]{alias, path}));
        }
    }

    private static void fullDeleteFilePathByAudioKeyFrame(String[] keyFrames, String alias, FileDeleteDTO fileDeleteDTO) {
        if (ArrayUtils.isEmpty((Object[])keyFrames)) {
            return;
        }
        for (int j = 0; j < keyFrames.length; ++j) {
            String keyFrame = keyFrames[j];
            if (!StringUtil.isNotEmpty((String)keyFrame)) continue;
            fileDeleteDTO.getDeleteLocalFilePathList().add(PathUtil.builderPath((String[])new String[]{Config.getValue((String)"linuxImageDir"), alias, keyFrame.substring(0, keyFrame.lastIndexOf("/"))}));
            fileDeleteDTO.getDeleteThirdFilePathList().add(PathUtil.builderPath((String[])new String[]{alias, keyFrame}));
        }
    }

    private static void fullDeleteFilePathByAudioStaticFile(String[] dateStrings, String[] contentSourceIds, Long siteId, FileDeleteDTO fileDeleteDTO) {
        if (ArrayUtils.isEmpty((Object[])contentSourceIds)) {
            return;
        }
        for (int j = 0; j < contentSourceIds.length; ++j) {
            String dateString = dateStrings[j];
            String contentSourceId = contentSourceIds[j];
            String alias = SiteUtil.getAlias((long)siteId);
            String thirdPCFilePath = PathUtil.builderPath((String[])new String[]{alias, "/audio/pc/", dateString, contentSourceId + ".json"});
            String thirdIOSFilePath = PathUtil.builderPath((String[])new String[]{alias, "/audio/ios/", dateString, contentSourceId + ".jsonp"});
            fileDeleteDTO.getDeleteThirdFilePathList().add(thirdPCFilePath);
            fileDeleteDTO.getDeleteThirdFilePathList().add(thirdIOSFilePath);
            String localPCFilePath = PathCommonUtil.builderPathByLinuxStaticFileDir((String)thirdPCFilePath);
            String localIOSFilePath = PathCommonUtil.builderPathByLinuxStaticFileDir((String)thirdIOSFilePath);
            fileDeleteDTO.getDeleteLocalFilePathList().add(localPCFilePath);
            fileDeleteDTO.getDeleteLocalFilePathList().add(localIOSFilePath);
        }
    }

    public static void deleteVideoFile(String siteId, Map videoMap) {
        String[] contentSourceIds = (String[])videoMap.get("contentSourceIds");
        String[] contentPaths = (String[])videoMap.get("contentPaths");
        String[] sourceSystemNames = (String[])videoMap.get("sourceSystemNames");
        String[] mp4PlayUrls = (String[])videoMap.get("mp4PlayUrls");
        String[] tsPlayUrls = (String[])videoMap.get("tsPlayUrls");
        String[] dateStrings = (String[])videoMap.get("dateStrings");
        String[] paths = (String[])videoMap.get("paths");
        String[] sourceSystemIDS = (String[])videoMap.get("sourceSystemID");
        List imageUrlList = (List)videoMap.get("imageUrlList");
        int[] mediaPathTypes = (int[])videoMap.get("mediaPathTypes");
        if (contentSourceIds != null && contentSourceIds.length > 0) {
            String sourceDir = PathUtil.builderPath((String[])new String[]{Config.getValue((String)"linuxVideoUploadDir"), SiteUtil.getAlias((String)siteId)});
            String linuxVideoDir = Config.getValue((String)"linuxVideoDir");
            FileDeleteDTO fileDeleteDTOByStaticFileAndImage = AssignmentLib.builderFileDeleteDTO((Long)Long.parseLong(siteId));
            FileDeleteDTO fileDeleteDTOByTranscode = AssignmentLib.builderFileDeleteDTO((Long)Long.parseLong(siteId));
            ArrayList deleteVideoSourceFileList = Lists.newArrayList();
            for (int j = 0; j < contentSourceIds.length; ++j) {
                int mediaPathType = mediaPathTypes[j];
                String sourceSystemID = sourceSystemIDS[j];
                String dateString = dateStrings[j];
                String contentSourceId = contentSourceIds[j];
                AssignmentLib.fullDeleteFilePathByVideoSource((String)paths[j], (String)sourceSystemID, (String)sourceDir, (List)deleteVideoSourceFileList);
                AssignmentLib.fullDeleteFilePathByVideoStaticFile((String)contentSourceId, (String)dateString, (Long)Long.parseLong(siteId), (FileDeleteDTO)fileDeleteDTOByStaticFileAndImage);
                AssignmentLib.fullDeleteFilePathByTranscode((String)siteId, (String)contentPaths[j], (String)sourceSystemNames[j], (String)mp4PlayUrls[j], (String)tsPlayUrls[j], (String)linuxVideoDir, (int)mediaPathType, (String)dateString, (String)contentSourceId, (FileDeleteDTO)fileDeleteDTOByTranscode);
            }
            AssignmentLib.fullDeleteFilePathByVideoImage((String)siteId, (List)imageUrlList, (FileDeleteDTO)fileDeleteDTOByStaticFileAndImage);
            FileStorageUtil.deleteLocalFile((List)deleteVideoSourceFileList);
            FileStorageUtil.deleteFile((FileDeleteDTO)fileDeleteDTOByStaticFileAndImage);
            FileDeleteResultDTO fileDeleteResultDTO = FileStorageUtil.deleteFile((FileDeleteDTO)fileDeleteDTOByTranscode);
            List deleteLocalFileSuccessList = fileDeleteResultDTO.getDeleteLocalFileSuccessList();
            AssignmentLib.statisticsAfterDelete((Long)Long.parseLong(siteId), (List)deleteLocalFileSuccessList);
        }
        if (SiteUtil.isSupportPlayCount((long)Long.parseLong(siteId))) {
            AssignmentLib.hbaseDelete((String)siteId, (String[])contentSourceIds);
        }
    }

    private static void fullDeleteFilePathByVideoImage(String siteId, List<String> imageUrlList, FileDeleteDTO fileDeleteDTOByStaticFileAndImage) {
        String alias = SiteUtil.getAlias((String)siteId);
        for (String imageUrl : imageUrlList) {
            fileDeleteDTOByStaticFileAndImage.getDeleteLocalFilePathList().add(PathUtil.builderPath((String[])new String[]{Config.getValue((String)"linuxImageDir"), alias, imageUrl.substring(0, imageUrl.lastIndexOf("/"))}));
            fileDeleteDTOByStaticFileAndImage.getDeleteThirdFilePathList().add(PathUtil.builderPath((String[])new String[]{alias, imageUrl}));
        }
    }

    private static void fullDeleteFilePathByVideoSource(String path, String sourceSystemID, String sourceDir, List<String> deleteVideoSourceFileList) {
        if (!StringUtil.isEmpty((String)path) && !String.valueOf(9).equals(sourceSystemID)) {
            String deletePath = StringUtil.replaceAllToSlant((String)PathUtil.builderPath((String[])new String[]{sourceDir, path}));
            deleteVideoSourceFileList.add(deletePath);
        }
    }

    private static void fullDeleteFilePathByTranscode(String siteId, String contentPath, String sourceSystemName, String mp4PlayUrl, String tsPlayUrl, String linuxVideoDir, int mediaPathType, String dateString, String contentSourceId, FileDeleteDTO fileDeleteDTO) {
        String localStorageParentPath = PathUtil.builderPath((String[])new String[]{linuxVideoDir, SiteUtil.getAlias((String)siteId), contentPath});
        String thirdStorageParentPath = PathUtil.builderPath((String[])new String[]{SiteUtil.getAlias((String)siteId), contentPath});
        if (StringUtil.isEmpty((String)contentPath) && 1 == mediaPathType) {
            String localStorageParentPath2 = PathUtil.builderPathEndSlash((String[])new String[]{linuxVideoDir, SiteUtil.getAlias((String)siteId), "/vod/", dateString, contentSourceId});
            fileDeleteDTO.getDeleteLocalFilePathList().add(localStorageParentPath2);
        } else {
            AssignmentLib.fullDeleteFilePath((String)sourceSystemName, (String)localStorageParentPath, (String)thirdStorageParentPath, (FileDeleteDTO)fileDeleteDTO);
            AssignmentLib.fullDeleteFilePath((String)mp4PlayUrl, (String)localStorageParentPath, (String)thirdStorageParentPath, (FileDeleteDTO)fileDeleteDTO);
            AssignmentLib.fullDeleteFilePath((String)tsPlayUrl, (String)localStorageParentPath, (String)thirdStorageParentPath, (FileDeleteDTO)fileDeleteDTO);
        }
    }

    private static void fullDeleteFilePath(String sourceSystemName, String localStorageParentPath, String thirdStorageParentPath, FileDeleteDTO fileDeleteDTO) {
        if (StringUtil.isEmpty((String)sourceSystemName)) {
            return;
        }
        JSONObject sourceSystemNameJsonObject = JSONObject.fromObject((Object)sourceSystemName);
        JSONArray urlJSONArray = sourceSystemNameJsonObject.getJSONArray("urls");
        for (int i = 0; i < urlJSONArray.size(); ++i) {
            String filePath = urlJSONArray.getString(i);
            if (StringUtils.isBlank((CharSequence)filePath)) continue;
            String localStoragePath = PathUtil.builderPath((String[])new String[]{localStorageParentPath, filePath.substring(0, filePath.lastIndexOf("/"))});
            fileDeleteDTO.getDeleteLocalFilePathList().add(localStoragePath);
            String thirdStoragePath = PathUtil.builderPath((String[])new String[]{thirdStorageParentPath, filePath});
            fileDeleteDTO.getDeleteThirdFilePathList().add(thirdStoragePath);
        }
    }

    private static FileDeleteDTO builderFileDeleteDTO(Long siteId) {
        String ossBucketName = SiteUtil.getOssBucketName((Long)siteId);
        FileDeleteDTO fileDeleteDTO = new FileDeleteDTO();
        fileDeleteDTO.setOssBucketName(ossBucketName);
        fileDeleteDTO.setSupportOSSStorage(SiteUtil.isSupportOSSStorage((long)siteId));
        ArrayList deleteThirdFilePathList = Lists.newArrayList();
        ArrayList deleteLocalFilePathList = Lists.newArrayList();
        fileDeleteDTO.setDeleteThirdFilePathList((List)deleteThirdFilePathList);
        fileDeleteDTO.setDeleteLocalFilePathList((List)deleteLocalFilePathList);
        return fileDeleteDTO;
    }

    private static void fullDeleteFilePathByVideoStaticFile(String contentSourceId, String dateDir, Long siteId, FileDeleteDTO fileDeleteDTO) {
        String alias = SiteUtil.getAlias((long)siteId);
        for (int i = 0; i < ContentConstant.vodStaticFileDir.length; ++i) {
            String thirdStorageParentPath = PathUtil.builderPathEndSlash((String[])new String[]{alias, ContentConstant.vodStaticFileDir[i], dateDir});
            fileDeleteDTO.getDeleteThirdFilePathList().add(thirdStorageParentPath + contentSourceId + ".json");
            fileDeleteDTO.getDeleteThirdFilePathList().add(thirdStorageParentPath + contentSourceId + ".jsonp");
            String localStorageParentPath = PathCommonUtil.builderPathByLinuxStaticFileDir((String)thirdStorageParentPath);
            fileDeleteDTO.getDeleteLocalFilePathList().add(localStorageParentPath + contentSourceId + ".json");
            fileDeleteDTO.getDeleteLocalFilePathList().add(localStorageParentPath + contentSourceId + ".jsonp");
        }
    }

    private void deleteRecycle(Transaction trans, String ids) {
        String recycleDeleteSql = "delete from scms_recycle where id in(" + ids + ")";
        trans.add(new QueryBuilder(recycleDeleteSql));
    }

    private void deletePushlog(Transaction trans, String videoId) {
        String recycleDeleteSql = "delete from scms_pushloginfo where ContentID in(" + videoId + ")";
        trans.add(new QueryBuilder(recycleDeleteSql));
    }

    private Map deleteAudio(Transaction transaction, String audioIDs) {
        String contentSourcerIdsSql = "select A.KeyFrame,A.createtime,A.path,A.id,A.contentSourceId,A.fromStyle,R.status,A.playURL from scms_audioinfo A ,scms_recycle R where A.id in (" + audioIDs + ") AND A.id=R.contentid AND R.assignmentType='" + 6 + "'";
        DataTable dataTable = new QueryBuilder(contentSourcerIdsSql).executeDataTable();
        int rowCount = dataTable.getRowCount();
        String[] contentSourceIds = new String[rowCount];
        String[] contentIds = new String[rowCount];
        String[] status = new String[rowCount];
        String[] sourceSystemID = new String[rowCount];
        String[] paths = new String[rowCount];
        String[] dateStrings = new String[rowCount];
        String[] KeyFrames = new String[rowCount];
        ArrayList playURLList = Lists.newArrayList();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        for (int i = 0; i < dataTable.getRowCount(); ++i) {
            contentSourceIds[i] = dataTable.getString(i, "contentSourceId");
            contentIds[i] = dataTable.getString(i, "id");
            dateStrings[i] = simpleDateFormat.format(dataTable.getDate(i, "createtime"));
            paths[i] = dataTable.getString(i, "path");
            status[i] = dataTable.getString(i, "status");
            KeyFrames[i] = dataTable.getString(i, "KeyFrame");
            sourceSystemID[i] = dataTable.getString(i, "fromStyle");
            playURLList.add(dataTable.getString(i, "playURL"));
        }
        String fileUrlSql = "select FileUrl from scms_audio where AudioInfoId in (" + audioIDs + ")";
        DataTable dt1 = new QueryBuilder(fileUrlSql).executeDataTable();
        ArrayList fileUrlList = Lists.newArrayList();
        for (int i = 0; i < dt1.getRowCount(); ++i) {
            fileUrlList.add(dt1.getString(i, "FileUrl"));
        }
        this.deleteIndatabaseByAudioIds(transaction, audioIDs);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contentIds", contentIds);
        map.put("paths", paths);
        map.put("status", status);
        map.put("dateStrings", dateStrings);
        map.put("contentSourceIds", contentSourceIds);
        map.put("sourceSystemID", sourceSystemID);
        map.put("KeyFrames", KeyFrames);
        map.put("fileUrlList", fileUrlList);
        log.info("\u7ec4\u88c5\u97f3\u9891\u5220\u9664\u6570\u636e:{}", map);
        return map;
    }

    private void deleteIndatabaseByAudioIds(Transaction transaction, String audioIDs) {
        String contentinfoDeleteSql = "delete from scms_audioinfo where id in (" + audioIDs + ")";
        transaction.add(new QueryBuilder(contentinfoDeleteSql));
        String contentinfoLogDeleteSql = "delete from scms_audioinfolog where contentid in (" + audioIDs + ")";
        transaction.add(new QueryBuilder(contentinfoLogDeleteSql));
        String videoDeleteSql = "delete from scms_audio where AudioInfoId in (" + audioIDs + ")";
        transaction.add(new QueryBuilder(videoDeleteSql));
    }

    private Map deleteSeries(Transaction transaction, String seriesIDs) {
        String contentSourcerIdsSql = "select createtime,seriesSourceId from scms_series where seriesid in (" + seriesIDs + ")";
        DataTable dataTable = new QueryBuilder(contentSourcerIdsSql).executeDataTable();
        int rowCount = dataTable.getRowCount();
        String[] contentSourceIds = new String[rowCount];
        String[] dateStrings = new String[rowCount];
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        for (int i = 0; i < dataTable.getRowCount(); ++i) {
            contentSourceIds[i] = dataTable.getString(i, "seriesSourceId");
            dateStrings[i] = simpleDateFormat.format(dataTable.getDate(i, "createtime"));
        }
        this.deleteInDatabaseBySeriesIds(transaction, seriesIDs);
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("contentSourceIds", contentSourceIds);
        map.put("dateStrings", dateStrings);
        return map;
    }

    private void deleteInDatabaseBySeriesIds(Transaction transaction, String seriesIDs) {
        String seriesDeleteSql = "delete from scms_series where seriesid in(" + seriesIDs + ")";
        transaction.add(new QueryBuilder(seriesDeleteSql));
        String seriesInfoDeleteSql = "delete from scms_seriesinfolog where seriesid in(" + seriesIDs + ")";
        transaction.add(new QueryBuilder(seriesInfoDeleteSql));
    }

    private Map deleteVideo(Transaction transaction, String videoIDs) {
        String contentSourcerIdsSql = "select C.isSourceVideo,C.softLinkDir,C.mediaPathType,C.KeyFrame,C.mp4Playurl,C.tsPlayUrl,C.sourceSystemName,C.contentPath,C.createtime,C.path,C.contentid,C.contentSourceId,C.SourceSystemID,R.status from scms_contentinfo C,scms_recycle R where C.contentid in (" + videoIDs + ") AND " + "R.contentid=C.contentid AND R.assignmentType='" + 5 + "'";
        DataTable dataTable = new QueryBuilder(contentSourcerIdsSql).executeDataTable();
        int rowCount = dataTable.getRowCount();
        String[] contentSourceIds = new String[rowCount];
        String[] contentIds = new String[rowCount];
        String[] status = new String[rowCount];
        String[] paths = new String[rowCount];
        String[] dateStrings = new String[rowCount];
        String[] contentPaths = new String[rowCount];
        String[] sourceSystemID = new String[rowCount];
        String[] sourceSystemNames = new String[rowCount];
        String[] tsPlayUrls = new String[rowCount];
        String[] mp4PlayUrls = new String[rowCount];
        int[] mediaPathTypes = new int[rowCount];
        String[] softLinkDirs = new String[rowCount];
        String allContentId = "";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        for (int i = 0; i < dataTable.getRowCount(); ++i) {
            softLinkDirs[i] = dataTable.getString(i, "softLinkDir");
            contentSourceIds[i] = dataTable.getString(i, "contentSourceId");
            contentIds[i] = dataTable.getString(i, "contentid");
            int isSourceVideo = dataTable.getInt(i, "isSourceVideo");
            if (1 == isSourceVideo) {
                allContentId = allContentId + "," + dataTable.getString(i, "contentid");
            }
            paths[i] = dataTable.getString(i, "path");
            dateStrings[i] = simpleDateFormat.format(dataTable.getDate(i, "createtime"));
            status[i] = dataTable.getString(i, "status");
            contentPaths[i] = dataTable.getString(i, "contentPath");
            sourceSystemNames[i] = dataTable.getString(i, "sourceSystemName");
            tsPlayUrls[i] = dataTable.getString(i, "tsPlayUrl");
            mp4PlayUrls[i] = dataTable.getString(i, "mp4PlayUrl");
            sourceSystemID[i] = dataTable.getString(i, "SourceSystemID");
            mediaPathTypes[i] = dataTable.getInt(i, "mediaPathType");
        }
        List imageUrlList = this.getImageUrlList(videoIDs);
        if (StringUtil.isNotEmpty((String)allContentId)) {
            allContentId = allContentId.substring(1);
            String contentinfoUpdateSql = "UPDATE  scms_contentinfo SET PATH='' where sourceRelationId in (" + allContentId + ")";
            transaction.add(new QueryBuilder(contentinfoUpdateSql));
        }
        this.deleteInDatabaseByVideoId(transaction, videoIDs);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contentIds", contentIds);
        map.put("paths", paths);
        map.put("status", status);
        map.put("contentSourceIds", contentSourceIds);
        map.put("contentPaths", contentPaths);
        map.put("dateStrings", dateStrings);
        map.put("sourceSystemID", sourceSystemID);
        map.put("sourceSystemNames", sourceSystemNames);
        map.put("tsPlayUrls", tsPlayUrls);
        map.put("mp4PlayUrls", mp4PlayUrls);
        map.put("mediaPathTypes", mediaPathTypes);
        map.put("softLinkDirs", softLinkDirs);
        map.put("imageUrlList", imageUrlList);
        log.info("\u7ec4\u88c5\u5220\u9664\u89c6\u9891\u7684\u6570\u636e:{}", map);
        return map;
    }

    private List<String> getImageUrlList(String allContentId) {
        ArrayList imageUrlList = Lists.newArrayList();
        DataTable imageInfoDataTable = new QueryBuilder("select url from scms_imageinfo where contentId in (" + allContentId + ")").executeDataTable();
        for (int j = 0; j < imageInfoDataTable.getRowCount(); ++j) {
            imageUrlList.add((String)imageInfoDataTable.get(j).get("url"));
        }
        log.info("\u5f85\u5220\u9664\u7684imageUrlList:{}", (Object)imageUrlList);
        return imageUrlList;
    }

    private void deleteInDatabaseByVideoId(Transaction transaction, String videoIDs) {
        String contentinfoDeleteSql = "delete from scms_contentinfo where contentid in (" + videoIDs + ")";
        transaction.add(new QueryBuilder(contentinfoDeleteSql));
        String contentinfoLogDeleteSql = "delete from scms_contentinfolog where contentid in (" + videoIDs + ")";
        transaction.add(new QueryBuilder(contentinfoLogDeleteSql));
        String videoDeleteSql = "delete from scms_video where contentid in (" + videoIDs + ")";
        transaction.add(new QueryBuilder(videoDeleteSql));
        String imgDeleteSql = "delete from scms_imageinfo where contentId in (" + videoIDs + ")";
        transaction.add(new QueryBuilder(imgDeleteSql));
    }

    public void restore() {
        String ids = this.$V("IDs");
        String videoIDs = this.$V("videoIDs");
        String seriesIDs = this.$V("seriesIDs");
        String audioIDs = this.$V("audioIDs");
        Map videoMap = new HashMap();
        Map audioMap = new HashMap();
        try {
            Transaction transaction = new Transaction();
            if (StringUtil.isNotEmpty((String)videoIDs)) {
                videoMap = this.restoreVideo(transaction, videoIDs);
            }
            if (StringUtil.isNotEmpty((String)seriesIDs)) {
                this.restoreSeries(transaction, seriesIDs);
            }
            if (StringUtil.isNotEmpty((String)audioIDs)) {
                audioMap = this.restoreAudio(transaction, audioIDs);
            }
            if (StringUtil.isNotEmpty((String)ids)) {
                this.deleteRecycle(transaction, ids);
            }
            if (transaction.commit()) {
                transaction.clear();
                if (StringUtil.isNotEmpty((String)videoIDs)) {
                    this.saveLogByVideo(videoIDs, transaction);
                    String[] videoContentIds = (String[])videoMap.get("contentIds");
                    DemandVideoLib.generateStaticVideoFile((String)"1", (String[])videoContentIds, (String)String.valueOf(Application.getCurrentSiteID()));
                }
                if (StringUtil.isNotEmpty((String)seriesIDs)) {
                    this.saveLogBySeries(seriesIDs, transaction);
                }
                if (StringUtil.isNotEmpty((String)audioIDs)) {
                    this.saveLogByAudio(audioIDs, transaction);
                    String[] audioContentIds = (String[])audioMap.get("contentIds");
                    DemandAudioLib.writeStaticFile((String)"1", (String[])audioContentIds, (long)Application.getCurrentSiteID());
                }
                transaction.commit();
                this.Response.setStatus(1);
                this.Response.setMessage("\u64cd\u4f5c\u6210\u529f!");
                UserLog.log((String)"Recycle", (String)"Restore", (String)"\u8fd8\u539f\u6210\u529f", (String)this.Request.getClientIP());
            } else {
                this.Response.setStatus(0);
                this.Response.setMessage("\u64cd\u4f5c\u5931\u8d25!");
                UserLog.log((String)"Recycle", (String)"Restore", (String)"\u8fd8\u539f\u5931\u8d25", (String)this.Request.getClientIP());
            }
        }
        catch (Exception e) {
            this.Response.setStatus(0);
            this.Response.setMessage("\u64cd\u4f5c\u6570\u636e\u5e93\u65f6\u53d1\u751f\u9519\u8bef!");
            UserLog.log((String)"Recycle", (String)"Restore", (String)"\u8fd8\u539f\u5931\u8d25", (String)this.Request.getClientIP());
            log.error("\u56de\u6536\u7ad9\u8fd8\u539f\u6570\u636e\u9047\u5230\u5f02\u5e38:", (Throwable)e);
        }
    }

    private void saveLogByVideo(String videoIDs, Transaction transaction) {
        Date date = new Date();
        String[] contentIds = videoIDs.split(",");
        for (int i = 0; i < contentIds.length; ++i) {
            ContentSearchMediator.publishVideo2Search((String)contentIds[i], (String)Application.getCurrentSiteAlias(), (long)Application.getCurrentSiteID());
            SCMS_ContentInfoLogSchema scms_contentInfoLogSchema = new SCMS_ContentInfoLogSchema();
            scms_contentInfoLogSchema.setID(NoUtil.getMaxID((String)"ContentInfoLogId"));
            scms_contentInfoLogSchema.setContentId(contentIds[i]);
            scms_contentInfoLogSchema.setAction("UPDATE");
            scms_contentInfoLogSchema.setActionDetail("\u89c6\u9891\u5220\u9664\u540e,\u56de\u6536\u7ad9\u8fd8\u539f");
            scms_contentInfoLogSchema.setAddTime(date);
            scms_contentInfoLogSchema.setAddUser(User.getRealName());
            transaction.add((Schema)scms_contentInfoLogSchema, 1);
        }
    }

    private void saveLogBySeries(String seriesIDs, Transaction transaction) {
        Date date = new Date();
        String[] contentIds = seriesIDs.split(",");
        for (int i = 0; i < contentIds.length; ++i) {
            SCMS_SeriesInfoLogSchema scms_seriesInfoLogSchema = new SCMS_SeriesInfoLogSchema();
            scms_seriesInfoLogSchema.setID(NoUtil.getMaxID((String)"SeriesInfoLogId"));
            scms_seriesInfoLogSchema.setContentId(contentIds[i]);
            scms_seriesInfoLogSchema.setAction("UPDATE");
            scms_seriesInfoLogSchema.setActionDetail("\u5267\u96c6\u5220\u9664\u540e,\u56de\u6536\u7ad9\u8fd8\u539f");
            scms_seriesInfoLogSchema.setAddTime(date);
            scms_seriesInfoLogSchema.setAddUser(User.getRealName());
            transaction.add((Schema)scms_seriesInfoLogSchema, 1);
        }
    }

    private void saveLogByAudio(String audioIDs, Transaction transaction) {
        Date date = new Date();
        String[] contentIds = audioIDs.split(",");
        for (int i = 0; i < contentIds.length; ++i) {
            ContentSearchMediator.publishAudio2Search((String)contentIds[i], (String)Application.getCurrentSiteAlias(), (long)Application.getCurrentSiteID());
            SCMS_AudioInfoLogSchema scms_audioInfoLogSchema = new SCMS_AudioInfoLogSchema();
            scms_audioInfoLogSchema.setID(NoUtil.getMaxID((String)"AudioInfoLogId"));
            scms_audioInfoLogSchema.setContentId(contentIds[i]);
            scms_audioInfoLogSchema.setAction("UPDATE");
            scms_audioInfoLogSchema.setActionDetail("\u97f3\u9891\u5220\u9664\u540e,\u56de\u6536\u7ad9\u8fd8\u539f");
            scms_audioInfoLogSchema.setAddTime(date);
            scms_audioInfoLogSchema.setAddUser(User.getRealName());
            transaction.add((Schema)scms_audioInfoLogSchema, 1);
        }
    }

    private Map restoreAudio(Transaction trans, String audioIDs) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        String[] contentIds = null;
        String selectRec = "select status,contentid from scms_recycle where assignmentType=6 and contentid in (" + audioIDs + ")";
        DataTable dataTable = new QueryBuilder(selectRec).executeDataTable();
        if (dataTable != null && dataTable.getRowCount() > 0) {
            String dateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            contentIds = new String[dataTable.getRowCount()];
            for (int i = 0; i < dataTable.getRowCount(); ++i) {
                String status = dataTable.getString(i, "status");
                String contentId = dataTable.getString(i, "contentid");
                if (StringUtil.isNotEmpty((String)status) && "1".equals(status)) {
                    contentIds[i] = contentId;
                }
                String updateSql = "update scms_audioinfo set status='" + status + "',modifyTime='" + dateString + "',modifyUser='" + User.getUserName() + "' where id =" + contentId;
                trans.add(new QueryBuilder(updateSql));
            }
        }
        map.put("contentIds", contentIds);
        return map;
    }

    private Map restoreSeries(Transaction transaction, String seriesIDs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object contentIds = null;
        String selectRec = "select status,contentid from scms_recycle where assignmentType=7 and contentid in (" + seriesIDs + ")";
        DataTable dataTable = new QueryBuilder(selectRec).executeDataTable();
        if (dataTable != null && dataTable.getRowCount() > 0) {
            String dateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            for (int i = 0; i < dataTable.getRowCount(); ++i) {
                String status = dataTable.getString(i, "status");
                String contentId = dataTable.getString(i, "contentid");
                if (StringUtil.isNotEmpty((String)status) && "1".equals(status)) {
                    contentIds[i] = contentId;
                }
                String updateSql = "update scms_series set status='" + status + "',modifyTime='" + dateString + "',modifyUser='" + User.getUserName() + "' where seriesid =" + contentId;
                transaction.add(new QueryBuilder(updateSql));
            }
        }
        map.put("contentIds", contentIds);
        return map;
    }

    private Map restoreVideo(Transaction transaction, String videoIDs) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        String[] contentIds = null;
        String selectRec = "select status,contentid from scms_recycle where assignmentType=5 and contentid in (" + videoIDs + ")";
        DataTable dataTable = new QueryBuilder(selectRec).executeDataTable();
        if (dataTable != null && dataTable.getRowCount() > 0) {
            String dateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            contentIds = new String[dataTable.getRowCount()];
            for (int i = 0; i < dataTable.getRowCount(); ++i) {
                String status = dataTable.getString(i, "status");
                String contentId = dataTable.getString(i, "contentid");
                if (StringUtil.isNotEmpty((String)status) && "1".equals(status)) {
                    contentIds[i] = contentId;
                }
                String updateSql = "update scms_contentinfo set status='" + status + "',modifyTime='" + dateString + "',modifyUser='" + User.getUserName() + "' where contentid =" + contentId;
                transaction.add(new QueryBuilder(updateSql));
            }
        }
        map.put("contentIds", contentIds);
        return map;
    }
}

