/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.search;

import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.utility.StringUtil;
import java.util.List;
import java.util.Map;
import org.apache.axis.utils.StringUtils;
import org.apache.log4j.Logger;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.search.sort.SortBuilder;

public class SearchClient {
    private static Logger logger = Logger.getLogger(SearchClient.class);
    private static Client client;
    private static boolean isInited;

    public static void init() {
        if (!isInited) {
            String bindHost;
            String startMode = Config.getValue((String)"search.start.mode", (String)"0");
            ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
            String httpEnabledStr = Config.getValue((String)"search.http.enable", (String)"1");
            boolean httpEnabled = true;
            if ("0".equals(httpEnabledStr)) {
                httpEnabled = false;
            }
            settings.put("http.enabled", httpEnabled);
            String deleteAllStr = Config.getValue((String)"search.index.delete.all", (String)"0");
            boolean deleteAll = false;
            if ("1".equals(deleteAllStr)) {
                deleteAll = true;
            }
            settings.put("action.disable_delete_all_indices", deleteAll);
            settings.put("cluster.name", Config.getValue((String)"clusterName", (String)"vms"));
            String publishHost = Config.getValue((String)"network.publish_host");
            if (StringUtil.isNotEmpty((String)publishHost)) {
                settings.put("network.publish_host", publishHost);
            }
            if (StringUtil.isNotEmpty((String)(bindHost = Config.getValue((String)"network.bind_host")))) {
                settings.put("network.bind_host", bindHost);
            }
            String networkHost = Config.getValue((String)"network.host");
            if (StringUtil.isNotEmpty((String)bindHost)) {
                settings.put("network.host", networkHost);
            }
            if ("0".equals(startMode)) {
                Node node = null;
                node = settings != null ? NodeBuilder.nodeBuilder().client(true).settings((Settings.Builder)settings).node() : NodeBuilder.nodeBuilder().client(true).node();
                client = node.client();
            } else if ("1".equals(startMode)) {
                String address = Config.getValue((String)"search.transport.client.ip");
                String portStr = Config.getValue((String)"search.transport.client.port");
                int port = 9300;
                if (StringUtils.isEmpty((String)portStr) || StringUtils.isEmpty((String)address)) {
                    logger.error((Object)"\u914d\u7f6e\u4e86Transport\u542f\u52a8\u65b9\u5f0f\uff0c\u4f46\u662f\u672a\u914d\u7f6eTransport\u5730\u5740\u6216\u7aef\u53e3\u53f7\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u65b0\u542f\u52a8\uff01");
                    throw new RuntimeException("\u914d\u7f6e\u4e86Transport\u542f\u52a8\u65b9\u5f0f\uff0c\u4f46\u662f\u672a\u914d\u7f6eTransport\u5730\u5740\u6216\u7aef\u53e3\u53f7\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u65b0\u542f\u52a8\uff01");
                }
                port = Integer.parseInt(portStr);
                client = new TransportClient().addTransportAddress((TransportAddress)new InetSocketTransportAddress(address, port));
            } else if ("2".equals(startMode)) {
                Node node = null;
                node = settings != null ? NodeBuilder.nodeBuilder().settings((Settings.Builder)settings).node() : NodeBuilder.nodeBuilder().node();
                client = node.client();
            }
            isInited = true;
        }
    }

    public static boolean bulkIndex(List<Map<String, Object>> sources, String indexName, String indexType) {
        BulkRequestBuilder bulk = client.prepareBulk();
        for (Map<String, Object> source : sources) {
            bulk.add(client.prepareIndex(indexName, indexType).setSource(source).setId(source.get("id").toString()));
        }
        BulkResponse bulkResponse = (BulkResponse)bulk.execute().actionGet();
        if (bulkResponse.hasFailures()) {
            logger.error((Object)("\u6dfb\u52a0\u6570\u636e\u5230\u641c\u7d22\u5f15\u64ce\u65f6\u5931\u8d25!" + bulkResponse.buildFailureMessage()));
            return false;
        }
        return true;
    }

    public static boolean index(Map<String, Object> source, String indexName, String indexType) {
        try {
            client.prepareIndex(indexName, indexType).setSource(source).setId(source.get("id").toString()).execute().actionGet();
        }
        catch (Exception e) {
            logger.error((Object)("\u6dfb\u52a0id\u4e3a" + source.get("id") + "\u7684\u6570\u636e\u5230\u641c\u7d22\u5f15\u64ce\u65f6\u5931\u8d25!"));
            return false;
        }
        return true;
    }

    public static boolean bulkDelete(List<String> ids, String indexName, String indexType) {
        BulkRequestBuilder bulk = client.prepareBulk();
        for (String id : ids) {
            bulk.add(client.prepareDelete(indexName, indexType, id));
        }
        BulkResponse bulkResponse = (BulkResponse)bulk.execute().actionGet();
        if (bulkResponse.hasFailures()) {
            logger.error((Object)("\u4ece\u641c\u7d22\u5f15\u64ce\u5220\u9664\u6570\u636e\u65f6\u5931\u8d25!" + bulkResponse.buildFailureMessage()));
            return false;
        }
        return true;
    }

    public static boolean delete(String id, String indexName, String indexType) {
        try {
            client.prepareDelete(indexName, indexType, id).execute().actionGet();
        }
        catch (Exception e) {
            logger.error((Object)("\u5220\u9664\u641c\u7d22\u5f15\u64ce\u4e2did\u4e3a" + id + "\u7684\u6570\u636e\u65f6\u5931\u8d25!"));
            return false;
        }
        return true;
    }

    public static SearchResponse search(QueryBuilder queryBuilder, SortBuilder sortBuilder, int from, int size, String indexName, String indexType) {
        try {
            SearchRequestBuilder searchRequestBuilder = client.prepareSearch(new String[]{indexName, indexType}).setFrom(from).setSize(size);
            if (sortBuilder != null) {
                searchRequestBuilder.addSort(sortBuilder);
            }
            if (queryBuilder == null) {
                return null;
            }
            searchRequestBuilder.setQuery(queryBuilder);
            return (SearchResponse)searchRequestBuilder.setQuery(queryBuilder).addSort(sortBuilder).execute().actionGet();
        }
        catch (Exception e) {
            logger.error((Object)("\u5168\u6587\u68c0\u7d22\u5931\u8d25\uff1a" + queryBuilder.toString()), (Throwable)e);
            return null;
        }
    }

    static {
        isInited = false;
    }
}

