/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.trasncode.format;

import com.sobey.bsp.cms.site.EmbConstants;
import com.sobey.bsp.cms.site.Transcode2JSON;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.SchemaSet;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.bsp.schema.SCMS_VideoSchema;
import com.sobey.bsp.schema.SCMS_VideoSet;
import com.sobey.bsp.util.StringsUtil;
import com.sobey.scms.trasncode.format.TransFileFormat;
import com.sobey.scms.trasncode.util.TranscodeUtil;
import com.sobey.scms.trasncode.workflow.GenerateSpecialParamStep;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.dom4j.Node;

public class FLVClipTransFileFormat
implements TransFileFormat {
    public static final int FLV_FORMAT = 1;

    public JSONObject wrapParams2JSON(Map map) {
        int index = Integer.parseInt(map.get("index").toString());
        Transcode2JSON transcode = (Transcode2JSON)map.get("transcode");
        String winDir = map.get("winDir").toString();
        String createTimeDir = map.get("createTimeDir").toString();
        String groupType = (String)map.get("groupType");
        String audioCodeRate = transcode.getAudioCodeRate();
        JSONObject pc = new JSONObject();
        HashMap<String, Object> audioMap = new HashMap<String, Object>();
        try {
            String videoCodeRate = transcode.getVideoCodeRate().substring(0, transcode.getVideoCodeRate().indexOf("Kbps"));
            String mediaType = (transcode.getCodeFormat() + "_" + videoCodeRate + "K_" + "FLV").toLowerCase();
            String sedlPath = winDir + createTimeDir + map.get("contentSourceId");
            String pathFormat = winDir + createTimeDir + map.get("contentSourceId") + "\\" + map.get("contentSourceId") + "_" + mediaType + ".flv";
            videoCodeRate = Integer.parseInt(videoCodeRate) * 1000 + "";
            pc.put((Object)"srcGroupType", (Object)"srcGroupType");
            pc.put((Object)"srcMediaType", (Object)"srcMediaType");
            pc.put((Object)"i", (Object)index);
            pc.put((Object)"groupType", (Object)groupType);
            pc.put((Object)"mediaType", (Object)mediaType);
            pc.put((Object)"sedlPath", (Object)sedlPath);
            pc.put((Object)"pathFormat", (Object)pathFormat);
            pc.put((Object)"fileFormat", EmbConstants.fileFormatMap.get("FLV"));
            pc.put((Object)"videoFormat", EmbConstants.videoFormatMap.get(transcode.getCodeFormat()));
            pc.put((Object)"bitRate", (Object)String.valueOf(Integer.parseInt(videoCodeRate) * 1000));
            pc.put((Object)"frameRate", (Object)transcode.getFrameRate());
            pc.put((Object)"imageWidth", (Object)transcode.getBreadthWidth());
            pc.put((Object)"imageHeight", (Object)transcode.getBreadthHeight());
            pc.put((Object)"widthRatio", (Object)transcode.getBreadthAdapt());
            pc.put((Object)"keyFrameRate", (Object)transcode.getKeyFrameRate());
            pc.put((Object)"audioFormat", EmbConstants.audioFormatMap.get("MP3"));
            pc.put((Object)"assistFormat", (Object)"0");
            audioMap.put("audioCodeRate", audioCodeRate);
            audioMap.put("vbv_buffer", 40);
            audioMap.put("b_aud", 0);
            String basePath = Config.getContextRealPath() + "WEB-INF/classes/template/" + transcode.getCodeFormat() + "-specialParam.vm";
            GenerateSpecialParamStep specialParamStep = new GenerateSpecialParamStep(basePath);
            specialParamStep.wrapParams2JSON(null, audioMap);
            String specialParam = specialParamStep.generateStepXml();
            pc.put((Object)"specialParam", (Object)specialParam);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pc;
    }

    public void parseXml(Map map) {
        List mediaFileList = (List)map.get("mediaFileList");
        Transaction trans = (Transaction)map.get("trans");
        SCMS_ContentinfoSchema contentinfo = (SCMS_ContentinfoSchema)map.get("contentinfo");
        DataTable dtTranscode = (DataTable)map.get("dtTranscode");
        double duration = (Double)map.get("duration");
        String baseDir = (String)map.get("baseDir");
        String styleTypes = StringUtil.isNotEmpty((String)contentinfo.getStyleTypes()) ? contentinfo.getStyleTypes() : "";
        ArrayList<String> pathList = new ArrayList<String>();
        ArrayList<String> typeIdList = new ArrayList<String>();
        try {
            for (int i = 0; i < mediaFileList.size(); ++i) {
                String groupType;
                Node node = (Node)mediaFileList.get(i);
                Node groupTypeNode = node.selectSingleNode("GroupType");
                String string = groupType = groupTypeNode.getText() == null ? "" : groupTypeNode.getText();
                if (!"FLV_OUT".equals(groupType) && !"MP4_OUT".equals(groupType) && !"MP4_PC".equals(groupType)) continue;
                Node mediaTypeNode = node.selectSingleNode("MediaType");
                Node fileNameNode = node.selectSingleNode("FileName");
                String mediaType = mediaTypeNode.getText() == null ? "" : mediaTypeNode.getText();
                String fileName = fileNameNode.getText() == null ? "" : fileNameNode.getText();
                pathList.add(fileName);
                typeIdList.add(mediaType);
            }
            String[] filePaths = new String[pathList.size()];
            String[] fileTypeIds = new String[typeIdList.size()];
            pathList.toArray(filePaths);
            typeIdList.toArray(fileTypeIds);
            TranscodeUtil.getOrderArray((String[])fileTypeIds, (String[])filePaths);
            JSONArray flvUrls = new JSONArray();
            ArrayList<String> flvBitrates = new ArrayList<String>();
            ArrayList<String> flvFormats = new ArrayList<String>();
            SCMS_VideoSet videoSet = new SCMS_VideoSet();
            JSONObject videoBitrates = StringUtil.isNotEmpty((String)contentinfo.getBitrates()) ? JSONObject.fromObject((Object)contentinfo.getBitrates()) : new JSONObject();
            String srcfilename = "";
            int beginIndex = baseDir.length();
            block3: for (int j = 0; j < fileTypeIds.length && null != fileTypeIds[j]; ++j) {
                for (int i = 0; i < dtTranscode.getRowCount(); ++i) {
                    Transcode2JSON transcode = TranscodeUtil.getTranscode2JSON((String)dtTranscode.getString(i, "param"));
                    if (StringUtil.isEmpty((String)transcode.getVideoCodeRate())) continue;
                    String codeRate = transcode.getVideoCodeRate().substring(0, transcode.getVideoCodeRate().indexOf("Kbps"));
                    String mediaType = (transcode.getCodeFormat() + "_" + codeRate + "K_" + transcode.getVideoFileFormat()).toLowerCase();
                    if (!fileTypeIds[j].equalsIgnoreCase(mediaType)) continue;
                    flvFormats.add(dtTranscode.getString(i, "alias"));
                    flvBitrates.add(dtTranscode.getString(i, "name"));
                    String fileUrl = filePaths[j];
                    if (StringUtil.isNotEmpty((String)fileUrl)) {
                        fileUrl = StringUtil.replaceAllToSlant((String)fileUrl);
                        fileUrl = fileUrl.substring(fileUrl.lastIndexOf("/vod/") + "/vod/".length());
                        flvUrls.add((Object)fileUrl);
                    } else {
                        flvUrls.add((Object)"");
                    }
                    String filetypeid = fileTypeIds[j].toLowerCase();
                    SCMS_VideoSchema schema = new SCMS_VideoSchema();
                    schema.setID(NoUtil.getMaxID((String)"VideoID"));
                    schema.setSiteID(contentinfo.getSiteid().longValue());
                    schema.setOrderFlag(new Date().getTime());
                    schema.setAddUser(User.getUserName());
                    schema.setAddTime(new Date());
                    schema.setContentId(contentinfo.getContentID());
                    schema.setContentSourceId(contentinfo.getContentSourceId());
                    schema.setIsOriginal("N");
                    schema.setFileTypeId(filetypeid);
                    srcfilename = StringUtil.replaceAllToSlant((String)filePaths[j]).substring(beginIndex);
                    schema.setSrcFileName(srcfilename);
                    schema.setFileName(srcfilename);
                    schema.setBitrate(dtTranscode.getString(i, "name"));
                    schema.setSuffix(filetypeid.substring(filetypeid.lastIndexOf("_") + 1, filetypeid.length()));
                    schema.setStyleType(Integer.valueOf(1));
                    videoSet.add(schema);
                    continue block3;
                }
            }
            styleTypes = styleTypes + "1,";
            JSONObject flvObj = new JSONObject();
            flvObj.put((Object)"duration", (Object)duration);
            flvObj.put((Object)"title", (Object)StringsUtil.esSpecialNumeric((String)contentinfo.getTitle()));
            flvObj.put((Object)"host", (Object)"/vod/");
            flvObj.put((Object)"sourceType", (Object)"mp4");
            flvObj.put((Object)"urls", (Object)flvUrls);
            flvObj.put((Object)"formats", flvFormats);
            videoBitrates.put((Object)"flvBitrates", flvBitrates);
            contentinfo.setSourceSystemName(flvObj.toString());
            contentinfo.setBitrates(videoBitrates.toString());
            contentinfo.setStyleTypes(styleTypes);
            trans.add((SchemaSet)videoSet, 1);
            map.put("srcFileName", srcfilename);
            System.out.println("PC\u7aef\u6e90\u6587\u4ef6\u8def\u5f84\uff1a" + srcfilename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

