/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.trasncode.format;

import com.sobey.bsp.cms.site.Transcode2JSON;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.SchemaSet;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.bsp.schema.SCMS_VideoSchema;
import com.sobey.bsp.schema.SCMS_VideoSet;
import com.sobey.bsp.util.StringsUtil;
import com.sobey.scms.trasncode.format.TransFileFormat;
import com.sobey.scms.trasncode.util.TranscodeUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.dom4j.Node;

public class MBMediaTransFileFormat
implements TransFileFormat {
    public JSONObject wrapParams2JSON(Map map) {
        return null;
    }

    public void parseXml(Map map) {
        List mediaFileList = (List)map.get("mediaFileList");
        Transaction trans = (Transaction)map.get("trans");
        SCMS_ContentinfoSchema contentinfo = (SCMS_ContentinfoSchema)map.get("contentinfo");
        DataTable dtTranscode = (DataTable)map.get("dtTranscode");
        double duration = (Double)map.get("duration");
        String baseDir = (String)map.get("baseDir");
        String styleTypes = StringUtil.isNotEmpty((String)contentinfo.getStyleTypes()) ? contentinfo.getStyleTypes() : "";
        ArrayList<String> pathList = new ArrayList<String>();
        ArrayList<String> typeIdList = new ArrayList<String>();
        try {
            for (int i = 0; i < mediaFileList.size(); ++i) {
                String groupType;
                Node node = (Node)mediaFileList.get(i);
                Node groupTypeNode = node.selectSingleNode("GroupType");
                String string = groupType = groupTypeNode.getText() == null ? "" : groupTypeNode.getText();
                if (!"MP4_MB".equals(groupType) && !"MP4_CM".equals(groupType)) continue;
                Node mediaTypeNode = node.selectSingleNode("MediaType");
                Node fileNameNode = node.selectSingleNode("FileName");
                String mediaType = mediaTypeNode.getText() == null ? "" : mediaTypeNode.getText();
                String fileName = fileNameNode.getText() == null ? "" : fileNameNode.getText();
                pathList.add(fileName);
                typeIdList.add(mediaType);
            }
            String[] filePaths = new String[pathList.size()];
            String[] fileTypeIds = new String[typeIdList.size()];
            pathList.toArray(filePaths);
            typeIdList.toArray(fileTypeIds);
            TranscodeUtil.getOrderArray((String[])fileTypeIds, (String[])filePaths);
            JSONArray tsUrls = new JSONArray();
            ArrayList<String> tsBitrates = new ArrayList<String>();
            ArrayList<String> tsFormats = new ArrayList<String>();
            SCMS_VideoSet videoSet = new SCMS_VideoSet();
            JSONObject videoBitrates = StringUtil.isNotEmpty((String)contentinfo.getBitrates()) ? JSONObject.fromObject((Object)contentinfo.getBitrates()) : new JSONObject();
            String srcfilename = "";
            int beginIndex = baseDir.length();
            int maxFormatOfDimension = 0;
            block3: for (int j = 0; j < fileTypeIds.length && null != fileTypeIds[j]; ++j) {
                for (int i = 0; i < dtTranscode.getRowCount(); ++i) {
                    String tsFileUrl;
                    Transcode2JSON transcode = TranscodeUtil.getTranscode2JSON((String)dtTranscode.getString(i, "availableParam"));
                    if (!StringUtil.isNotEmpty((String)transcode.getTsCodeRate()) || "1080P\u6682\u65e0\u7801\u7387\u53ef\u9009".equals(transcode.getTsCodeRate())) continue;
                    String codeRate = transcode.getTsCodeRate().substring(0, transcode.getTsCodeRate().indexOf("Kbps"));
                    String mediaType = (transcode.getCodeFormat() + "_" + codeRate + "K_" + transcode.getTsFileFormat()).toLowerCase();
                    if (!fileTypeIds[j].equalsIgnoreCase(mediaType) && !fileTypeIds[j].contains(mediaType)) continue;
                    String[] formatOf_i = fileTypeIds[j].split("_");
                    int formatOf_i_num = Integer.parseInt(formatOf_i[1].substring(0, formatOf_i[1].length() - 1));
                    if (formatOf_i_num > maxFormatOfDimension && formatOf_i_num <= 500) {
                        maxFormatOfDimension = formatOf_i_num;
                        tsFileUrl = filePaths[j];
                        if (StringUtil.isNotEmpty((String)tsFileUrl)) {
                            tsFileUrl = StringUtil.replaceAllToSlant((String)tsFileUrl);
                            tsFileUrl = tsFileUrl.substring(tsFileUrl.lastIndexOf("/vod/") + "/vod/".length());
                        }
                    }
                    tsFormats.add(dtTranscode.getString(i, "alias"));
                    tsBitrates.add(dtTranscode.getString(i, "name"));
                    tsFileUrl = filePaths[j];
                    if (StringUtil.isNotEmpty((String)tsFileUrl)) {
                        tsFileUrl = tsFileUrl.replace("\\", "/");
                        tsFileUrl = tsFileUrl.substring(tsFileUrl.lastIndexOf("/vod/") + 5);
                        tsUrls.add((Object)tsFileUrl);
                    } else {
                        tsUrls.add((Object)"");
                    }
                    String filetypeid = fileTypeIds[j].toLowerCase();
                    SCMS_VideoSchema schema = new SCMS_VideoSchema();
                    schema.setID(NoUtil.getMaxID((String)"VideoID"));
                    schema.setSiteID(contentinfo.getSiteid().longValue());
                    schema.setOrderFlag(new Date().getTime());
                    schema.setAddUser(User.getUserName());
                    schema.setAddTime(new Date());
                    schema.setContentId(contentinfo.getContentID());
                    schema.setContentSourceId(contentinfo.getContentSourceId());
                    schema.setFileTypeId(filetypeid);
                    srcfilename = StringUtil.replaceAllToSlant((String)filePaths[j]).substring(beginIndex);
                    schema.setSrcFileName(srcfilename);
                    schema.setBitrate(dtTranscode.getString(i, "name"));
                    schema.setFileName(srcfilename);
                    schema.setSuffix(srcfilename.substring(srcfilename.lastIndexOf(".") + 1));
                    schema.setStyleType(Integer.valueOf(2));
                    SCMS_VideoSchema androidSchema = (SCMS_VideoSchema)schema.clone();
                    androidSchema.setID(NoUtil.getMaxID((String)"VideoID"));
                    androidSchema.setStyleType(Integer.valueOf(3));
                    videoSet.add(schema);
                    videoSet.add(androidSchema);
                    continue block3;
                }
            }
            styleTypes = styleTypes + "2,3,";
            JSONObject tsObj = new JSONObject();
            tsObj.put((Object)"duration", (Object)duration);
            tsObj.put((Object)"title", (Object)StringsUtil.esSpecialNumeric((String)contentinfo.getTitle()));
            tsObj.put((Object)"host", (Object)"/vod/");
            tsObj.put((Object)"urls", (Object)tsUrls);
            tsObj.put((Object)"formats", tsFormats);
            videoBitrates.put((Object)"tsBitrates", tsBitrates);
            videoBitrates.put((Object)"mp4Bitrates", tsBitrates);
            contentinfo.setTsPlayUrl(tsObj.toString());
            contentinfo.setMp4PlayUrl(tsObj.toString());
            contentinfo.setBitrates(videoBitrates.toString());
            contentinfo.setStyleTypes(styleTypes);
            trans.add((SchemaSet)videoSet, 1);
            map.put("srcFileName", srcfilename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

