/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.trasncode.format;

import com.chinamcloud.vms.util.PathCommonUtil;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.cms.site.Transcode2JSON;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.SchemaSet;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_AudioInfoSchema;
import com.sobey.bsp.schema.SCMS_AudioSchema;
import com.sobey.bsp.schema.SCMS_AudioSet;
import com.sobey.scms.trasncode.format.TransFileFormat;
import com.sobey.scms.trasncode.util.TranscodeUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.dom4j.Node;

public class MP3OssMediaMoveFileFormat
implements TransFileFormat {
    public JSONObject wrapParams2JSON(Map map) {
        int index = Integer.parseInt(map.get("index").toString());
        Transcode2JSON transcode = (Transcode2JSON)map.get("transcode");
        Long siteId = Long.parseLong(map.get("siteId").toString());
        String createTimeDir = map.get("createTimeDir").toString();
        String guid = (String)map.get("contentSourceId");
        JSONObject OSS = new JSONObject();
        try {
            String audioCodeRate = transcode.getAudioCodeRate();
            audioCodeRate = audioCodeRate.replace("Kbps", "");
            String mediaType = ("MP3_" + audioCodeRate + "K_MP3").toLowerCase();
            String pathFormat = PathCommonUtil.builderOssPath((Long)siteId) + SiteUtil.getAlias((long)siteId) + StringUtil.replaceAllToBack_Slant((String)"/vod/") + createTimeDir + guid + "\\" + guid + "_" + mediaType + ".mp3";
            OSS.put((Object)"srcGroupType", (Object)"MP3_OUT");
            OSS.put((Object)"srcMediaType", (Object)mediaType);
            OSS.put((Object)"i", (Object)index);
            OSS.put((Object)"depends", (Object)(index - 1));
            OSS.put((Object)"groupType", (Object)"MP3_OUT_OSS");
            OSS.put((Object)"mediaType", (Object)mediaType);
            OSS.put((Object)"pathFormat", (Object)pathFormat);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return OSS;
    }

    public void parseXml(Map map) {
        List mediaFileList = (List)map.get("mediaFileList");
        Transaction trans = (Transaction)map.get("trans");
        SCMS_AudioInfoSchema audioinfo = (SCMS_AudioInfoSchema)map.get("audioinfo");
        double duration = (Double)map.get("duration");
        long length = (Long)map.get("programlength");
        String addUser = (String)map.get("adduser");
        DataTable dtTranscode = (DataTable)map.get("dtTranscode");
        String contentSourceId = audioinfo.getContentSourceId();
        ArrayList<String> pathList = new ArrayList<String>();
        ArrayList<String> typeIdList = new ArrayList<String>();
        try {
            for (int i = 0; i < mediaFileList.size(); ++i) {
                String groupType;
                Node node = (Node)mediaFileList.get(i);
                Node groupTypeNode = node.selectSingleNode("GroupType");
                String string = groupType = groupTypeNode.getText() == null ? "" : groupTypeNode.getText();
                if (!"MP3_OUT_OSS".equals(groupType)) continue;
                Node mediaTypeNode = node.selectSingleNode("MediaType");
                Node fileNameNode = node.selectSingleNode("FileName");
                String mediaType = mediaTypeNode.getText() == null ? "" : mediaTypeNode.getText();
                String fileName = fileNameNode.getText() == null ? "" : fileNameNode.getText();
                pathList.add(fileName);
                typeIdList.add(mediaType);
            }
            String[] filePaths = new String[pathList.size()];
            String[] fileTypeIds = new String[typeIdList.size()];
            pathList.toArray(filePaths);
            typeIdList.toArray(fileTypeIds);
            TranscodeUtil.getOrderArray((String[])fileTypeIds, (String[])filePaths);
            JSONArray mp3Urls = new JSONArray();
            ArrayList<String> mp3Bitrates = new ArrayList<String>();
            ArrayList<String> formats = new ArrayList<String>();
            String srcFileName = "";
            SCMS_AudioSet audioSet = new SCMS_AudioSet();
            block3: for (int i = 0; i < fileTypeIds.length; ++i) {
                String fileUrl = filePaths[i];
                for (int j = 0; j < dtTranscode.getRowCount(); ++j) {
                    Transcode2JSON transcode = TranscodeUtil.getTranscode2JSON((String)dtTranscode.getString(j, "param"));
                    String codeRate = transcode.getAudioCodeRate().substring(0, transcode.getAudioCodeRate().indexOf("Kbps"));
                    String mediaType = (transcode.getAudioFileFormat() + "_" + codeRate + "K_" + transcode.getAudioFileFormat()).toLowerCase();
                    if (!fileTypeIds[i].equalsIgnoreCase(mediaType) || !StringUtil.isNotEmpty((String)fileUrl)) continue;
                    formats.add(dtTranscode.getString(j, "alias"));
                    mp3Bitrates.add(dtTranscode.getString(j, "name"));
                    fileUrl = StringUtil.replaceAllToSlant((String)fileUrl);
                    fileUrl = fileUrl.substring(fileUrl.lastIndexOf("/vod/") + "/vod/".length());
                    mp3Urls.add((Object)fileUrl);
                    String fileTypeId = fileTypeIds[i].toLowerCase();
                    SCMS_AudioSchema schema = new SCMS_AudioSchema();
                    schema.setID(Long.valueOf(NoUtil.getMaxID((String)"AudioID")));
                    schema.setSiteId(audioinfo.getSiteid());
                    schema.setAddUser(addUser);
                    schema.setAddTime(new Date());
                    schema.setAudioInfoId(audioinfo.getId());
                    schema.setContentSourceId(contentSourceId);
                    schema.setClip("001");
                    schema.setDuration(Long.valueOf(length));
                    schema.setFileTypeId(fileTypeId);
                    srcFileName = StringUtil.replaceAllToSlant((String)("/vod/" + fileUrl));
                    schema.setFileUrl(srcFileName);
                    schema.setBitrate((String)mp3Bitrates.get(j));
                    schema.setSuffix(fileTypeId.substring(fileTypeId.lastIndexOf("_") + 1, fileTypeId.length()));
                    audioSet.add(schema);
                    continue block3;
                }
            }
            JSONObject jo = new JSONObject();
            jo.put((Object)"duration", (Object)duration);
            jo.put((Object)"title", (Object)audioinfo.getTitle());
            jo.put((Object)"host", (Object)"/vod/");
            JSONArray clips = new JSONArray();
            JSONObject clip = new JSONObject();
            clip.put((Object)"duration", (Object)duration);
            clip.put((Object)"index", (Object)"001");
            clip.put((Object)"urls", (Object)mp3Urls);
            clips.add((Object)clip);
            jo.put((Object)"clips", (Object)clips);
            jo.put((Object)"formats", formats);
            audioinfo.setPlayUrl(jo.toString());
            trans.add((SchemaSet)audioSet, 1);
            map.put("srcFileName", srcFileName);
            map.put("prefix", "/vod/");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

