/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.trasncode.format;

import com.sobey.bsp.cms.site.EmbConstants;
import com.sobey.bsp.cms.site.Transcode2JSON;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.SchemaSet;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.bsp.schema.SCMS_VideoSchema;
import com.sobey.bsp.schema.SCMS_VideoSet;
import com.sobey.bsp.util.StringsUtil;
import com.sobey.scms.trasncode.format.TransFileFormat;
import com.sobey.scms.trasncode.util.TranscodeUtil;
import com.sobey.scms.trasncode.workflow.GenerateSpecialParamStep;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.dom4j.Node;

public class MP4ClipTransFileFormat
implements TransFileFormat {
    public static final int MP4_FORMAT = 3;

    public JSONObject wrapParams2JSON(Map map) {
        int index = Integer.parseInt(map.get("index").toString());
        Transcode2JSON transcode = (Transcode2JSON)map.get("transcode");
        JSONObject tsParams = (JSONObject)map.get("tsParams");
        String winDir = map.get("winDir").toString();
        String createTimeDir = map.get("createTimeDir").toString();
        String groupType = (String)map.get("groupType");
        String tsCodeRate = tsParams.getString("tsCodeRate");
        String audioCodeRate = transcode.getAudioCodeRate();
        JSONObject mp4 = new JSONObject();
        HashMap<String, Object> audioMap = new HashMap<String, Object>();
        try {
            tsCodeRate = tsCodeRate.substring(0, tsCodeRate.indexOf("Kbps"));
            String mediaType = (transcode.getCodeFormat() + "_" + tsCodeRate + "K_MP4").toLowerCase();
            String tsBitRate = String.valueOf(Integer.parseInt(tsCodeRate) * 1000);
            String pathFormat = winDir + createTimeDir + map.get("contentSourceId") + "\\" + map.get("contentSourceId") + "_" + mediaType + ".mp4";
            String sedlPath = winDir + createTimeDir + map.get("contentSourceId");
            mp4.put((Object)"srcGroupType", (Object)"srcGroupType");
            mp4.put((Object)"srcMediaType", (Object)"srcMediaType");
            mp4.put((Object)"i", (Object)index);
            mp4.put((Object)"groupType", (Object)groupType);
            mp4.put((Object)"mediaType", (Object)mediaType);
            mp4.put((Object)"sedlPath", (Object)sedlPath);
            mp4.put((Object)"pathFormat", (Object)pathFormat);
            mp4.put((Object)"fileFormat", EmbConstants.fileFormatMap.get("MP4"));
            mp4.put((Object)"videoFormat", EmbConstants.videoFormatMap.get(transcode.getCodeFormat()));
            mp4.put((Object)"bitRate", (Object)tsBitRate);
            mp4.put((Object)"frameRate", (Object)transcode.getFrameRate());
            mp4.put((Object)"imageWidth", (Object)transcode.getBreadthWidth());
            mp4.put((Object)"imageHeight", (Object)transcode.getBreadthHeight());
            mp4.put((Object)"widthRatio", (Object)transcode.getBreadthAdapt());
            mp4.put((Object)"keyFrameRate", (Object)transcode.getKeyFrameRate());
            mp4.put((Object)"audioFormat", EmbConstants.audioFormatMap.get("AAC"));
            mp4.put((Object)"assistFormat", (Object)"0");
            audioMap.put("audioCodeRate", audioCodeRate);
            audioMap.put("vbv_buffer", 40);
            audioMap.put("b_aud", 0);
            String basePath = Config.getContextRealPath() + "WEB-INF/classes/template/" + transcode.getCodeFormat() + "-specialParam.vm";
            GenerateSpecialParamStep specialParamStep = new GenerateSpecialParamStep(basePath);
            specialParamStep.wrapParams2JSON(null, audioMap);
            String specialParam = specialParamStep.generateStepXml();
            mp4.put((Object)"specialParam", (Object)specialParam);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mp4;
    }

    public void parseXml(Map map) {
        List mediaFileList = (List)map.get("mediaFileList");
        Transaction trans = (Transaction)map.get("trans");
        SCMS_ContentinfoSchema contentinfo = (SCMS_ContentinfoSchema)map.get("contentinfo");
        DataTable dtTranscode = (DataTable)map.get("dtTranscode");
        double duration = (Double)map.get("duration");
        String baseDir = (String)map.get("baseDir");
        String styleTypes = StringUtil.isNotEmpty((String)contentinfo.getStyleTypes()) ? contentinfo.getStyleTypes() : "";
        ArrayList<String> pathList = new ArrayList<String>();
        ArrayList<String> typeIdList = new ArrayList<String>();
        try {
            for (int i = 0; i < mediaFileList.size(); ++i) {
                String groupType;
                Node node = (Node)mediaFileList.get(i);
                Node groupTypeNode = node.selectSingleNode("GroupType");
                String string = groupType = groupTypeNode.getText() == null ? "" : groupTypeNode.getText();
                if (!"MP4_OUT".equals(groupType) && !"MP4_CM".equals(groupType)) continue;
                Node mediaTypeNode = node.selectSingleNode("MediaType");
                Node fileNameNode = node.selectSingleNode("FileName");
                String mediaType = mediaTypeNode.getText() == null ? "" : mediaTypeNode.getText();
                String fileName = fileNameNode.getText() == null ? "" : fileNameNode.getText();
                pathList.add(fileName);
                typeIdList.add(mediaType);
            }
            String[] filePaths = new String[pathList.size()];
            String[] fileTypeIds = new String[typeIdList.size()];
            pathList.toArray(filePaths);
            typeIdList.toArray(fileTypeIds);
            TranscodeUtil.getOrderArray((String[])fileTypeIds, (String[])filePaths);
            JSONArray mp4Urls = new JSONArray();
            ArrayList<String> mp4Bitrates = new ArrayList<String>();
            ArrayList<String> mp4Formats = new ArrayList<String>();
            SCMS_VideoSet videoSet = new SCMS_VideoSet();
            JSONObject videoBitrates = StringUtil.isNotEmpty((String)contentinfo.getBitrates()) ? JSONObject.fromObject((Object)contentinfo.getBitrates()) : new JSONObject();
            String srcfilename = "";
            int beginIndex = baseDir.length();
            block3: for (int j = 0; j < fileTypeIds.length && null != fileTypeIds[j]; ++j) {
                for (int i = 0; i < dtTranscode.getRowCount(); ++i) {
                    Transcode2JSON transcode = TranscodeUtil.getTranscode2JSON((String)dtTranscode.getString(i, "param"));
                    if (!StringUtil.isNotEmpty((String)transcode.getTsCodeRate()) || "1080P\u6682\u65e0\u7801\u7387\u53ef\u9009".equals(transcode.getTsCodeRate())) continue;
                    String codeRate = transcode.getTsCodeRate().substring(0, transcode.getTsCodeRate().indexOf("Kbps"));
                    String mp4MediaType = (transcode.getCodeFormat() + "_" + codeRate + "K_" + "mp4").toLowerCase();
                    if (!fileTypeIds[j].equalsIgnoreCase(mp4MediaType)) continue;
                    mp4Formats.add(dtTranscode.getString(i, "alias"));
                    mp4Bitrates.add(dtTranscode.getString(i, "name"));
                    String mp4FileUrl = filePaths[j];
                    if (StringUtil.isNotEmpty((String)mp4FileUrl)) {
                        mp4FileUrl = StringUtil.replaceAllToSlant((String)mp4FileUrl);
                        mp4FileUrl = mp4FileUrl.substring(mp4FileUrl.lastIndexOf("/vod/") + "/vod/".length());
                        mp4Urls.add((Object)mp4FileUrl);
                    } else {
                        mp4Urls.add((Object)"");
                    }
                    String filetypeid = fileTypeIds[j].toLowerCase();
                    SCMS_VideoSchema schema = new SCMS_VideoSchema();
                    schema.setID(NoUtil.getMaxID((String)"VideoID"));
                    schema.setSiteID(contentinfo.getSiteid().longValue());
                    schema.setOrderFlag(new Date().getTime());
                    schema.setAddUser(User.getUserName());
                    schema.setAddTime(new Date());
                    schema.setContentId(contentinfo.getContentID());
                    schema.setContentSourceId(contentinfo.getContentSourceId());
                    schema.setFileTypeId(filetypeid);
                    srcfilename = StringUtil.replaceAllToSlant((String)filePaths[j]).substring(beginIndex);
                    schema.setSrcFileName(srcfilename);
                    schema.setBitrate(dtTranscode.getString(i, "name"));
                    schema.setFileName(srcfilename);
                    schema.setSuffix(filetypeid.substring(filetypeid.lastIndexOf("_") + 1, filetypeid.length()));
                    schema.setStyleType(Integer.valueOf(3));
                    videoSet.add(schema);
                    continue block3;
                }
            }
            styleTypes = styleTypes + "3,";
            JSONObject mp4Obj = new JSONObject();
            mp4Obj.put((Object)"duration", (Object)duration);
            mp4Obj.put((Object)"title", (Object)StringsUtil.esSpecialNumeric((String)contentinfo.getTitle()));
            mp4Obj.put((Object)"host", (Object)"/vod/");
            mp4Obj.put((Object)"urls", (Object)mp4Urls);
            mp4Obj.put((Object)"formats", mp4Formats);
            videoBitrates.put((Object)"mp4Bitrates", mp4Bitrates);
            contentinfo.setMp4PlayUrl(mp4Obj.toString());
            contentinfo.setBitrates(videoBitrates.toString());
            contentinfo.setStyleTypes(styleTypes);
            trans.add((SchemaSet)videoSet, 1);
            map.put("srcFileName", srcfilename);
            System.out.println("MP4\u6e90\u6587\u4ef6\u8def\u5f84\uff1a" + srcfilename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

