/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.trasncode.format;

import com.chinamcloud.vms.util.PathCommonUtil;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.cms.site.Transcode2JSON;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.SchemaSet;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.bsp.schema.SCMS_VideoSchema;
import com.sobey.bsp.schema.SCMS_VideoSet;
import com.sobey.bsp.util.StringsUtil;
import com.sobey.scms.trasncode.format.TransFileFormat;
import com.sobey.scms.trasncode.util.TranscodeUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.dom4j.Node;

public class PCOssMediaMoveFileFormat
implements TransFileFormat {
    public static final int MP4_FORMAT = 1;

    public JSONObject wrapParams2JSON(Map map) {
        int index = Integer.parseInt(map.get("index").toString());
        Transcode2JSON transcode = (Transcode2JSON)map.get("transcode");
        Long siteId = Long.parseLong(map.get("siteId").toString());
        String createTimeDir = map.get("createTimeDir").toString();
        String codeRate = (String)map.get("codeRate");
        String groupType = (String)map.get("groupType");
        String rename = (String)map.get("rename");
        String guid = (String)map.get("contentSourceId");
        JSONObject OSS = new JSONObject();
        try {
            codeRate = codeRate.substring(0, codeRate.indexOf("Kbps"));
            String mediaType = (transcode.getCodeFormat() + "_" + codeRate + "K_MP4").toLowerCase() + rename;
            String pathFormat = PathCommonUtil.builderOssPath((Long)siteId) + SiteUtil.getAlias((long)siteId) + StringUtil.replaceAllToBack_Slant((String)"/vod/") + createTimeDir + guid + "\\" + guid + "_" + mediaType + ".mp4";
            if (StringUtil.isNotEmpty((String)groupType)) {
                String[] groupTypes = groupType.split("_");
                OSS.put((Object)"srcGroupType", (Object)(groupTypes[0] + "_" + groupTypes[1]));
            }
            OSS.put((Object)"srcMediaType", (Object)mediaType);
            OSS.put((Object)"i", (Object)index);
            OSS.put((Object)"depends", (Object)(index - 1));
            OSS.put((Object)"groupType", (Object)groupType);
            OSS.put((Object)"mediaType", (Object)mediaType);
            OSS.put((Object)"pathFormat", (Object)pathFormat);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return OSS;
    }

    public void parseXml(Map map) {
        List mediaFileList = (List)map.get("mediaFileList");
        Transaction trans = (Transaction)map.get("trans");
        SCMS_ContentinfoSchema contentinfo = (SCMS_ContentinfoSchema)map.get("contentinfo");
        DataTable dtTranscode = (DataTable)map.get("dtTranscode");
        double duration = (Double)map.get("duration");
        String styleTypes = StringUtil.isNotEmpty((String)contentinfo.getStyleTypes()) ? contentinfo.getStyleTypes() : "";
        ArrayList<String> pathList = new ArrayList<String>();
        ArrayList<String> typeIdList = new ArrayList<String>();
        try {
            for (int i = 0; i < mediaFileList.size(); ++i) {
                String groupType;
                Node node = (Node)mediaFileList.get(i);
                Node groupTypeNode = node.selectSingleNode("GroupType");
                String string = groupType = groupTypeNode.getText() == null ? "" : groupTypeNode.getText();
                if (!"FLV_OUT_OSS".equals(groupType) && !"MP4_PC_OSS".equals(groupType) && !"MP4_CM_OSS".equals(groupType)) continue;
                Node mediaTypeNode = node.selectSingleNode("MediaType");
                Node fileNameNode = node.selectSingleNode("FileName");
                String mediaType = mediaTypeNode.getText() == null ? "" : mediaTypeNode.getText();
                String fileName = fileNameNode.getText() == null ? "" : fileNameNode.getText();
                pathList.add(fileName);
                typeIdList.add(mediaType);
            }
            String[] filePaths = new String[pathList.size()];
            String[] fileTypeIds = new String[typeIdList.size()];
            pathList.toArray(filePaths);
            typeIdList.toArray(fileTypeIds);
            TranscodeUtil.getOrderArray((String[])fileTypeIds, (String[])filePaths);
            JSONArray pcUrls = new JSONArray();
            ArrayList<String> pcBitrates = new ArrayList<String>();
            ArrayList<String> pcFormats = new ArrayList<String>();
            SCMS_VideoSet videoSet = new SCMS_VideoSet();
            JSONObject videoBitrates = StringUtil.isNotEmpty((String)contentinfo.getBitrates()) ? JSONObject.fromObject((Object)contentinfo.getBitrates()) : new JSONObject();
            String srcFileName = "";
            block3: for (int j = 0; j < fileTypeIds.length && null != fileTypeIds[j]; ++j) {
                for (int i = 0; i < dtTranscode.getRowCount(); ++i) {
                    Transcode2JSON transcode = TranscodeUtil.getTranscode2JSON((String)dtTranscode.getString(i, "availableParam"));
                    if (StringUtil.isEmpty((String)transcode.getVideoCodeRate())) continue;
                    String codeRate = transcode.getVideoCodeRate().substring(0, transcode.getVideoCodeRate().indexOf("Kbps"));
                    String mediaType = (transcode.getCodeFormat() + "_" + codeRate + "K_" + "mp4").toLowerCase();
                    if (!fileTypeIds[j].equalsIgnoreCase(mediaType)) continue;
                    pcFormats.add(dtTranscode.getString(i, "alias"));
                    pcBitrates.add(dtTranscode.getString(i, "name"));
                    String fileUrl = filePaths[j];
                    if (StringUtil.isNotEmpty((String)fileUrl)) {
                        fileUrl = StringUtil.replaceAllToSlant((String)fileUrl);
                        fileUrl = fileUrl.substring(fileUrl.lastIndexOf("/vod/") + "/vod/".length());
                        pcUrls.add((Object)fileUrl);
                    } else {
                        pcUrls.add((Object)"");
                    }
                    String fileTypeId = fileTypeIds[j].toLowerCase();
                    SCMS_VideoSchema schema = new SCMS_VideoSchema();
                    schema.setID(NoUtil.getMaxID((String)"VideoID"));
                    schema.setSiteID(contentinfo.getSiteid().longValue());
                    schema.setOrderFlag(new Date().getTime());
                    schema.setAddUser(User.getUserName());
                    schema.setAddTime(new Date());
                    schema.setContentId(contentinfo.getContentID());
                    schema.setContentSourceId(contentinfo.getContentSourceId());
                    schema.setIsOriginal("N");
                    schema.setFileTypeId(fileTypeId);
                    srcFileName = StringUtil.replaceAllToSlant((String)("/vod/" + fileUrl));
                    schema.setSrcFileName(srcFileName);
                    schema.setFileName(srcFileName);
                    schema.setBitrate(dtTranscode.getString(i, "name"));
                    schema.setSuffix(fileTypeId.substring(fileTypeId.lastIndexOf("_") + 1, fileTypeId.length()));
                    schema.setStyleType(Integer.valueOf(1));
                    videoSet.add(schema);
                    continue block3;
                }
            }
            styleTypes = styleTypes + "1,";
            JSONObject pcObj = new JSONObject();
            pcObj.put((Object)"duration", (Object)duration);
            pcObj.put((Object)"title", (Object)StringsUtil.esSpecialNumeric((String)contentinfo.getTitle()));
            pcObj.put((Object)"host", (Object)"/vod/");
            pcObj.put((Object)"sourceType", (Object)"mp4");
            pcObj.put((Object)"urls", (Object)pcUrls);
            pcObj.put((Object)"formats", pcFormats);
            videoBitrates.put((Object)"flvBitrates", pcBitrates);
            contentinfo.setSourceSystemName(pcObj.toString());
            contentinfo.setBitrates(videoBitrates.toString());
            contentinfo.setStyleTypes(styleTypes);
            trans.add((SchemaSet)videoSet, 1);
            map.put("srcFileName", srcFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

