/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.trasncode.strategy;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.cms.site.EmbConstants;
import com.sobey.bsp.cms.site.Transcode2JSON;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.notice.AutoPush;
import com.sobey.bsp.schema.SCMS_AudioInfoSchema;
import com.sobey.bsp.schema.SCMS_AudioInfoSet;
import com.sobey.bsp.schema.SCMS_TranscodegroupSchema;
import com.sobey.cms.interfaces.tool.impl.ChannelRecordInterfaceImpl;
import com.sobey.cms.interfaces.tool.impl.MediaEditCutInterfaceImpl;
import com.sobey.scms.contentinfo.DemandAudioLib;
import com.sobey.scms.contentinfo.log.DemandMeidaLog;
import com.sobey.scms.search.ContentSearchMediator;
import com.sobey.scms.trasncode.format.MP3TransFileFormat;
import com.sobey.scms.trasncode.strategy.TranscodeStrategy;
import com.sobey.scms.trasncode.util.TranscodeUtil;
import com.sobey.scms.trasncode.workflow.AudioMediaTransStep;
import com.sobey.scms.trasncode.workflow.GenerateAudioHeaderStep;
import com.sobey.scms.trasncode.workflow.GenerateTransTailStep;
import com.sobey.scms.trasncode.workflow.MediaMoveStep;
import com.sobey.scms.trasncode.workflow.TranscodeStepable;
import com.sobey.scms.trasncode.workflow.TranscodeWorkFlow;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class AudioTranscodeStrategy
implements TranscodeStrategy {
    static Logger logger = Logger.getLogger(AudioTranscodeStrategy.class);
    private TranscodeWorkFlow workFlow;
    public static String basePath = Config.getContextRealPath() + "WEB-INF/classes/template/";

    public AudioTranscodeStrategy() {
        ArrayList steps = new ArrayList();
        this.workFlow = new TranscodeWorkFlow(steps);
    }

    public String generateXml(SCMS_TranscodegroupSchema transcodeGroup, Map map) {
        StringBuilder sb = new StringBuilder();
        try {
            GenerateAudioHeaderStep headerStep = new GenerateAudioHeaderStep(basePath + "mpc-audio-header.vm");
            headerStep.wrapParams2JSON(transcodeGroup, map);
            this.workFlow.addStep((TranscodeStepable)headerStep);
            this.addTransSteps(transcodeGroup, map);
            GenerateTransTailStep tailStep = new GenerateTransTailStep(basePath + "mpc-common-tail.vm");
            this.workFlow.addStep((TranscodeStepable)tailStep);
            sb.append(this.workFlow.execute());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public void addTransSteps(SCMS_TranscodegroupSchema transcodeGroup, Map map) {
        try {
            int index = -1;
            Long siteId = Long.parseLong(map.get("siteId").toString());
            String tid = transcodeGroup.getTid();
            DataTable dt = TranscodeUtil.findTranscodeByParentid((String)tid, (long)Long.parseLong(map.get("siteId").toString()), (boolean)false);
            Transcode2JSON transcode = null;
            EmbConstants.initFormatMap();
            String winDir = Config.getValue((String)"winVideoDir") + SiteUtil.getAlias((long)siteId) + "/vod/";
            winDir = StringUtil.replaceAllToBack_Slant((String)winDir);
            map.put("winDir", winDir);
            for (int i = 0; i < dt.getRowCount(); ++i) {
                map.put("index", ++index);
                transcode = TranscodeUtil.getTranscode2JSON((String)dt.getString(i, "param"));
                map.put("transcode", transcode);
                map.put("specialParam", dt.getString(i, "specialParam"));
                AudioMediaTransStep mediaTransStep = new AudioMediaTransStep(basePath + "mpc-audio-trans.vm", 1);
                mediaTransStep.wrapParams2JSON(transcodeGroup, map);
                this.workFlow.addStep((TranscodeStepable)mediaTransStep);
                if (!SiteUtil.isSupportOSSStorage((long)siteId)) continue;
                map.put("index", ++index);
                MediaMoveStep mediaMoveStep = new MediaMoveStep(basePath + "mpc-move-oss.vm", 6);
                mediaMoveStep.wrapParams2JSON(transcodeGroup, map);
                this.workFlow.addStep((TranscodeStepable)mediaMoveStep);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String parseXml(Document doc) {
        Boolean flag = false;
        Node mpcNotify = doc.selectSingleNode("//MPCNotify");
        Node contentType = doc.selectSingleNode("//MPCNotify//TaskInfo//Data//ContentType");
        String contentSourceId = "";
        if (null != mpcNotify) {
            QueryBuilder qb;
            SCMS_AudioInfoSchema audioinfo;
            SCMS_AudioInfoSet audioInfoSet;
            Date date = new Date();
            Node statusNode = mpcNotify.selectSingleNode("//NotifyEvent");
            Node taskIdNode = mpcNotify.selectSingleNode("//TaskGUID");
            int status = 0;
            if (StringUtil.isNotEmpty((String)statusNode.getText())) {
                status = Integer.parseInt(statusNode.getText());
            }
            System.out.print("\u8fd4\u56de\u7684\u72b6\u6001\u503c\u4e3astatus************" + status + "***********\n");
            if (StringUtil.isNotEmpty((String)taskIdNode.getText())) {
                contentSourceId = taskIdNode.getText();
            }
            if ((audioInfoSet = (audioinfo = new SCMS_AudioInfoSchema()).query(qb = new QueryBuilder("where contentsourceid ='" + contentSourceId + "'"))) != null && audioInfoSet.size() > 0) {
                audioinfo = audioInfoSet.get(0);
                try {
                    if (status == 256) {
                        List mediaFile = mpcNotify.selectNodes("MediaFile");
                        if (mediaFile != null && mediaFile.size() > 0) {
                            Long programLength = AudioTranscodeStrategy.getParsedProgramLength((List)mediaFile);
                            double duration = Math.floor(Double.parseDouble(String.valueOf(programLength)) / 1.0E7);
                            long prolength = programLength / 10000L;
                            Transaction trans1 = new Transaction();
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            String parentid = new QueryBuilder("select tid from scms_transcodegroup where id=" + audioinfo.getTranscodeId()).executeString();
                            DataTable dtTranscode = TranscodeUtil.findTranscodeByParentid((String)parentid, (long)audioinfo.getSiteid(), (boolean)false);
                            String baseDir = StringUtil.replaceAllToBack_Slant((String)(Config.getValue((String)"winVideoDir") + SiteUtil.getAlias((long)audioinfo.getSiteid())));
                            audioinfo.setDuration(Long.valueOf(prolength));
                            map.put("trans", trans1);
                            map.put("audioinfo", audioinfo);
                            map.put("mediaFileList", mediaFile);
                            map.put("baseDir", baseDir);
                            map.put("dtTranscode", dtTranscode);
                            map.put("duration", duration);
                            map.put("programlength", prolength);
                            map.put("adduser", audioinfo.getCreatorName());
                            MP3TransFileFormat transFileFormat = null;
                            transFileFormat = new MP3TransFileFormat();
                            transFileFormat.parseXml(map);
                            logger.info((Object)("\u6e90\u6587\u4ef6\u8def\u5f84**********" + map.get("srcFileName")));
                            AudioTranscodeStrategy.saveAndPublish(map);
                            flag = true;
                        }
                    } else if ((status == 8 || status == 2048) && null != contentType && "mp3".equals(contentType.getText())) {
                        Transaction trans = new Transaction();
                        audioinfo.setStatus(Long.valueOf(3L));
                        audioinfo.setModifyTime(date);
                        trans.add((Schema)audioinfo, 2);
                        DemandMeidaLog demandLog = new DemandMeidaLog();
                        demandLog.addAudioinfoLog(trans, audioinfo.getId().longValue(), "UPDATE", "\u97f3\u9891MPC\u8f6c\u7801\u5931\u8d25\u66f4\u65b0", date, "\u4e91\u8f6c\u7801");
                        trans.commit();
                    }
                }
                catch (Exception ex) {
                    if (null != contentType && "mp3".equals(contentType.getText())) {
                        Transaction trans = new Transaction();
                        audioinfo.setStatus(Long.valueOf(3L));
                        audioinfo.setModifyTime(date);
                        trans.add((Schema)audioinfo, 2);
                        DemandMeidaLog demandLog = new DemandMeidaLog();
                        demandLog.addAudioinfoLog(trans, audioinfo.getId().longValue(), "UPDATE", "\u97f3\u9891MPC\u8f6c\u7801\u89e3\u6790\u5931\u8d25", date, "\u4e91\u8f6c\u7801");
                        trans.commit();
                    }
                    ex.printStackTrace();
                }
            }
        }
        if (flag.booleanValue()) {
            ChannelRecordInterfaceImpl.mpcTransCodeCallBack((int)1, (String)contentSourceId);
            MediaEditCutInterfaceImpl.mpcTransCodeCallBack((int)1, (int)6, (String)contentSourceId);
        } else {
            ChannelRecordInterfaceImpl.mpcTransCodeCallBack((int)0, (String)contentSourceId);
            MediaEditCutInterfaceImpl.mpcTransCodeCallBack((int)0, (int)6, (String)contentSourceId);
        }
        return flag != false ? "1" : "0";
    }

    private static Long getParsedProgramLength(List mediaFile) {
        Long programLength = 0L;
        try {
            for (int i = 0; i < mediaFile.size(); ++i) {
                String groupType;
                Node node = (Node)mediaFile.get(i);
                Node groupTypeNode = node.selectSingleNode("GroupType");
                String string = groupType = groupTypeNode.getText() == null ? "" : groupTypeNode.getText();
                if (!"MP3_OUT".equals(groupType)) continue;
                Node inpointNode = node.selectSingleNode("InPoint");
                Node outPointNode = node.selectSingleNode("OutPoint");
                programLength = Long.parseLong(outPointNode.getText()) - Long.parseLong(inpointNode.getText());
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return programLength;
    }

    private static void saveAndPublish(Map map) {
        String statusFlag = "";
        Date date = new Date();
        Transaction trans = (Transaction)map.get("trans");
        SCMS_AudioInfoSchema audioinfo = (SCMS_AudioInfoSchema)map.get("audioinfo");
        try {
            String workFlowId = new QueryBuilder("select WORKFLOWID from scms_site where id='" + audioinfo.getSiteid() + "'").executeString();
            if (StringUtil.isEmpty((String)workFlowId) || "0".equals(workFlowId)) {
                statusFlag = "1";
                audioinfo.setStatus(Long.valueOf(1L));
                audioinfo.setPublishDate(date);
            } else {
                statusFlag = "-1";
                audioinfo.setPublishDate(null);
                audioinfo.setStatus(Long.valueOf(-1L));
            }
            audioinfo.setModifyTime(date);
            trans.add((Schema)audioinfo, 2);
            DemandMeidaLog demandLog = new DemandMeidaLog();
            demandLog.addAudioinfoLog(trans, audioinfo.getId().longValue(), "UPDATE", "\u97f3\u9891MPC\u8f6c\u7801\u6210\u529f\u66f4\u65b0", date, "\u4e91\u8f6c\u7801");
            String[] contentIds = new String[]{audioinfo.getId().toString()};
            if (trans.commit()) {
                ContentSearchMediator.publishAudio2Search((String)audioinfo.getId().toString(), (String)SiteUtil.getAlias((long)audioinfo.getSiteid()), (long)audioinfo.getSiteid());
                DemandAudioLib.writeStaticFile((String)statusFlag, (String[])contentIds, (long)audioinfo.getSiteid(), (String)audioinfo.getPlayUrl());
                if ("1".equals(statusFlag)) {
                    AutoPush.autoPushCDN((String[])contentIds, (Long)audioinfo.getSiteid(), (int)6);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

