/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.scms.trasncode.strategy;

import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.cms.site.SiteDefaultUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.UserLog;
import com.sobey.bsp.schema.SCMS_CatalogSchema;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.bsp.schema.SCMS_ContentinfoSet;
import com.sobey.bsp.schema.SCMS_TranscodegroupSchema;
import com.sobey.scms.contentinfo.log.DemandMeidaLog;
import com.sobey.scms.trasncode.MPCCall;
import com.sobey.scms.trasncode.strategy.TranscodeStrategy;
import com.sobey.scms.trasncode.strategy.impl.CriterionMediaAnalysisInterfaceImpl;
import com.sobey.scms.trasncode.workflow.GenerateTransTailStep;
import com.sobey.scms.trasncode.workflow.GenerateVlengthStep;
import com.sobey.scms.trasncode.workflow.TranscodeStepable;
import com.sobey.scms.trasncode.workflow.TranscodeWorkFlow;
import com.sobey.scms.trasncode.workflow.mediaAnalyse.GenrateHeaderStep;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;

public class MediaAanlyseStrategy
implements TranscodeStrategy {
    static Logger logger = Logger.getLogger(MediaAanlyseStrategy.class);
    private TranscodeWorkFlow workFlow;
    public static String basePath = Config.getContextRealPath() + "WEB-INF/classes/template/";

    public MediaAanlyseStrategy() {
        ArrayList steps = new ArrayList();
        this.workFlow = new TranscodeWorkFlow(steps);
    }

    public String generateXml(SCMS_TranscodegroupSchema transcodeGroup, Map map) {
        StringBuilder sb = new StringBuilder();
        try {
            GenrateHeaderStep headerStep = new GenrateHeaderStep(basePath + "mpc-nosplit-header.vm");
            headerStep.wrapParams2JSON(transcodeGroup, map);
            this.workFlow.addStep((TranscodeStepable)headerStep);
            GenerateVlengthStep vLengthStep = new GenerateVlengthStep(basePath + "mpc-split-vlength.vm");
            vLengthStep.wrapParams2JSON(transcodeGroup, map);
            this.workFlow.addStep((TranscodeStepable)vLengthStep);
            GenerateTransTailStep tailStep = new GenerateTransTailStep(basePath + "mpc-split-tail.vm");
            this.workFlow.addStep((TranscodeStepable)tailStep);
            sb.append(this.workFlow.execute());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public String parseXml(Document doc) {
        Boolean flag = false;
        Node mpcNotify = doc.selectSingleNode("//MPCNotify");
        String contentSourceId = "";
        JSONObject jo = null;
        String siteid = null;
        Node site = doc.selectSingleNode("//MPCNotify//TaskInfo//Data//siteid");
        if (null != site) {
            siteid = site.getText();
        }
        if (null != mpcNotify) {
            CriterionMediaAnalysisInterfaceImpl mediaAnalysis;
            QueryBuilder qb;
            SCMS_ContentinfoSchema contentinfo;
            SCMS_ContentinfoSet contnetinfoSet;
            Node statusNode = mpcNotify.selectSingleNode("//NotifyEvent");
            Node taskIdNode = mpcNotify.selectSingleNode("//TaskGUID");
            int status = 0;
            if (StringUtil.isNotEmpty((String)statusNode.getText())) {
                status = Integer.parseInt(statusNode.getText());
            }
            System.out.print("\u8fd4\u56de\u7684\u72b6\u6001\u503c\u4e3astatus************" + status + "***********\n");
            if (StringUtil.isNotEmpty((String)taskIdNode.getText())) {
                contentSourceId = taskIdNode.getText();
            }
            if ((contnetinfoSet = (contentinfo = new SCMS_ContentinfoSchema()).query(qb = new QueryBuilder("where contentsourceid ='" + contentSourceId + "'"))) != null && contnetinfoSet.size() > 0) {
                contentinfo = contnetinfoSet.get(0);
                Date date = new Date();
                if (status == 256) {
                    List mediaFile = mpcNotify.selectNodes("MediaFile");
                    if (mediaFile != null && mediaFile.size() > 0) {
                        for (int i = 0; i < mediaFile.size(); ++i) {
                            String groupType;
                            Node node = (Node)mediaFile.get(i);
                            Node groupTypeNode = node.selectSingleNode("GroupType");
                            String string = groupType = groupTypeNode.getText() == null ? "" : groupTypeNode.getText();
                            if (!"videoLenth".equals(groupType)) continue;
                            Node fileParamNode = node.selectSingleNode("FileParam");
                            Node VideoFormatNode = fileParamNode.selectSingleNode("VideoFormat");
                            Node ImageWidthNode = fileParamNode.selectSingleNode("ImageWidth");
                            Node ImageHeightNode = fileParamNode.selectSingleNode("ImageHeight");
                            Node fileSizeNode = fileParamNode.selectSingleNode("FileSize");
                            jo = new JSONObject();
                            jo.put((Object)"VideoFormat", (Object)VideoFormatNode.getText());
                            jo.put((Object)"ImageWidth", (Object)ImageWidthNode.getText());
                            jo.put((Object)"ImageHeight", (Object)ImageHeightNode.getText());
                            jo.put((Object)"FileSize", (Object)fileSizeNode.getText());
                            break;
                        }
                        if (null == jo) {
                            return "0";
                        }
                    }
                    flag = true;
                } else if (status == 8 || status == 2048) {
                    Transaction trans = new Transaction();
                    DemandMeidaLog demandLog = new DemandMeidaLog();
                    demandLog.addContentinfoLog(trans, contentinfo.getContentID().longValue(), "UPDATE", "\u89c6\u9891MPC\u4fe1\u606f\u5206\u6790\u5931\u8d25\u66f4\u65b0", date, "\u4e91\u8f6c\u7801");
                    trans.commit();
                }
            }
            String transcodeid = null;
            boolean transcodeFlag = false;
            if (flag.booleanValue() && StringUtil.isNotEmpty((String)(transcodeid = (mediaAnalysis = new CriterionMediaAnalysisInterfaceImpl()).mediaAnalysis(jo)))) {
                transcodeFlag = true;
            }
            if (!transcodeFlag) {
                SCMS_CatalogSchema sc = new SCMS_CatalogSchema();
                sc.setID(Long.valueOf(contentinfo.getCatalogid()).longValue());
                sc.fill();
                transcodeid = null != sc.getTransCodeId() && StringUtil.isNotEmpty((String)String.valueOf(sc.getTransCodeId())) ? String.valueOf(sc.getTransCodeId()) : SiteDefaultUtil.getDefalutTransCodeId((Long)contentinfo.getSiteid(), (int)5);
            }
            try {
                String path = contentinfo.getPath();
                path = StringUtil.replaceAllToBack_Slant((String)path);
                String winDir = Config.getValue((String)"winVideoUploadDir") + SiteUtil.getAlias((String)siteid);
                String videourl = winDir + path;
                MPCCall.generateXml((String)videourl, (String)transcodeid, (String)contentSourceId, (String)contentinfo.getTitle(), (long)contentinfo.getSiteid(), (String)"", (String)"");
            }
            catch (Exception e) {
                e.printStackTrace();
                UserLog.log((String)"Video", (String)"CreateVideo", (String)("\u89c6\u9891" + contentinfo.getTitle() + "\u8f6c\u7801\u5931\u8d25"), (String)"\u63a5\u53e3\u4e0a\u4f20");
            }
        }
        return flag != false ? "1" : "0";
    }
}

